/*
 * Decompiled with CFR 0.152.
 */
package opticalraytracer;

import java.util.ArrayList;
import java.util.Iterator;
import opticalraytracer.ElementBase;
import opticalraytracer.OpticalComponent;
import opticalraytracer.OpticalRayTracer;
import opticalraytracer.Vector;

public final class ElementSpherical
implements ElementBase {
    OpticalRayTracer parent;
    private double srValue = -1.0;
    private double lrValue = -1.0;
    private double bValue = -1.0;
    private double epsilon = 1.0E-8;
    private ArrayList<Vector> points;
    private int pointsSize = 4;

    public ElementSpherical(OpticalRayTracer p) {
        this.parent = p;
        this.points = new ArrayList();
        int i = 0;
        while (i < this.pointsSize) {
            this.points.add(new Vector());
            ++i;
        }
    }

    @Override
    public ArrayList<Vector> getPoints() {
        return this.points;
    }

    private double pa0(double r, double s, double x_1, double y_1) {
        return -(s * s * y_1 + s * x_1 + Math.sqrt(s * s * (r * r * s * s + r * r - s * s * x_1 * x_1 + 2.0 * s * x_1 * y_1 - y_1 * y_1))) / (s * (s * s + 1.0));
    }

    private double pa1(double r, double s, double x_1, double y_1) {
        return -(s * s * y_1 + s * x_1 + Math.sqrt(s * s * (r * r * s * s + r * r - s * s * x_1 * x_1 + 2.0 * s * x_1 * y_1 - y_1 * y_1))) / (s * s + 1.0);
    }

    private double pa2(double r, double s, double x_1, double y_1) {
        return (-s * (s * y_1 + x_1) + Math.sqrt(s * s * (r * r * s * s + r * r - s * s * x_1 * x_1 + 2.0 * s * x_1 * y_1 - y_1 * y_1))) / (s * (s * s + 1.0));
    }

    private double pa3(double r, double s, double x_1, double y_1) {
        return (-s * (s * y_1 + x_1) + Math.sqrt(s * s * (r * r * s * s + r * r - s * s * x_1 * x_1 + 2.0 * s * x_1 * y_1 - y_1 * y_1))) / (s * s + 1.0);
    }

    private double pb(double y, double r, double x_1, double y_1) {
        return -x_1 - Math.sqrt(-(-r + y + y_1) * (r + y + y_1));
    }

    private double pd(double y, double r, double y_1) {
        return -Math.sqrt(-(-r + y + y_1) * (r + y + y_1)) * (y + y_1) / ((-r + y + y_1) * (r + y + y_1));
    }

    @Override
    public void intersections(OpticalComponent oc, boolean leftSide, Vector op1, Vector op2) {
        double s;
        Vector p1;
        Vector tc;
        for (Vector p : this.points) {
            p.assign(Vector.invalidState());
        }
        double angleRadians = oc.angleRadians();
        while (true) {
            Vector thr = new Vector(-oc.signedThickness(leftSide), 0.0).rotate(angleRadians);
            tc = new Vector(oc.xPos(), oc.yPos()).translate(thr);
            p1 = new Vector(op1).translateSub(tc).rotate(-angleRadians);
            Vector p2 = new Vector(op2).translateSub(tc).rotate(-angleRadians);
            s = (p2.y - p1.y) / (p2.x - p1.x);
            if (Math.abs(s) >= this.epsilon) break;
            angleRadians += this.epsilon;
        }
        this.updateFactors(oc, leftSide);
        int len_d2 = this.points.size() / 2;
        int n = 0;
        Iterator<Vector> ic = this.points.iterator();
        double sb = this.bValue;
        while (ic.hasNext()) {
            double sbb = n >= len_d2 ? -sb : sb;
            Vector pt = ic.next();
            pt.x = this.pa0(this.srValue, s, p1.x - sbb, p1.y) + p1.x;
            pt.y = this.pa1(this.srValue, s, p1.x - sbb, p1.y) + p1.y;
            pt = ic.next();
            pt.x = this.pa2(this.srValue, s, p1.x + sbb, p1.y) + p1.x;
            pt.y = this.pa3(this.srValue, s, p1.x + sbb, p1.y) + p1.y;
            n += 2;
        }
        for (Vector p : this.points) {
            p.x = leftSide ^ oc.radiusSign(leftSide) < 0.0 ? (p.x < 0.0 ? Double.NaN : p.x) : (p.x > 0.0 ? Double.NaN : p.x);
            p.assign(p.rotate(angleRadians).translate(tc));
        }
    }

    @Override
    public double lensProfileXforY(OpticalComponent oc, boolean leftSide, double y, double cx) {
        this.updateFactors(oc, leftSide);
        return this.lensProfileXforYCore(oc, leftSide, y, cx);
    }

    public double lensProfileXforYCore(OpticalComponent oc, boolean leftSide, double y, double cx) {
        double x = this.pb(y, this.srValue, cx + this.bValue, 0.0) * oc.radiusSign(leftSide) - oc.thickness();
        if (leftSide) {
            x = -x;
        }
        return x;
    }

    @Override
    public double lensProfileDXforY(OpticalComponent oc, boolean leftSide, boolean entering, double y) {
        this.updateFactors(oc, leftSide);
        double dx = this.pd(y, this.srValue, 0.0) * oc.radiusSign(leftSide);
        if (leftSide) {
            dx = -dx;
        }
        return dx;
    }

    private void updateFactors(OpticalComponent oc, boolean leftSide) {
        double newSR = oc.sphereRadius(leftSide);
        double newLR = oc.lensRadius();
        double newSRA = Math.abs(newSR);
        if (this.srValue != newSR || this.lrValue != newLR) {
            this.bValue = this.pb(newLR, newSRA, 0.0, 0.0);
            this.srValue = newSR;
            this.lrValue = newLR;
        }
    }
}

