/*
 * Decompiled with CFR 0.152.
 */
package opticalraytracer;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import opticalraytracer.OpticalComponent;
import opticalraytracer.OpticalRayTracer;
import opticalraytracer.ProgramValues;

public final class InitializationManager {
    OpticalRayTracer parent;
    ProgramValues programValues;
    String fileSep;
    String appName;
    String userDir;
    String userPath;
    String initPath;

    public InitializationManager(OpticalRayTracer p, ProgramValues pv) {
        this.parent = p;
        this.programValues = pv;
        this.fileSep = System.getProperty("file.separator");
        this.appName = this.parent.getClass().getSimpleName();
        this.userDir = System.getProperty("user.home");
        this.userPath = String.valueOf(this.userDir) + this.fileSep + "." + this.appName;
        this.initPath = String.valueOf(this.userPath) + this.fileSep + this.appName + ".ini";
        this.testMakeDirs(this.userPath);
    }

    protected void setFullConfiguration(String data) {
        if (data != null) {
            String pv = data.replaceFirst("(?is).*?program \\{\\s*(.*?)\\s*\\}.*", "$1");
            this.programValues.setValues(pv);
            this.parent.componentList = new ArrayList();
            String s = "(?is)object \\{\\s*(.*?)\\s*\\}";
            Pattern pat = Pattern.compile(s);
            Matcher m = pat.matcher(data);
            while (m.find()) {
                String v = m.group(1);
                this.parent.makeNewComponent(v, false, 0);
            }
            this.parent.writeProgramControls();
        }
    }

    protected void readConfig() {
        String data = this.readFile(this.initPath);
        this.setFullConfiguration(data);
    }

    protected void readStream(InputStream in) {
        int blockLen = 512;
        int len = 0;
        byte[] bdata = new byte[blockLen];
        StringBuilder data = new StringBuilder();
        do {
            try {
                len = in.read(bdata, 0, blockLen);
                data.append(new String(bdata, 0, len));
            }
            catch (IOException e) {
                e.printStackTrace();
                len = 0;
            }
        } while (len == blockLen);
        if (data.length() > 0) {
            this.setFullConfiguration(data.toString());
        }
    }

    protected void writeConfig(boolean includeHeader) {
        this.writeFile(this.initPath, this.getFullConfiguration(includeHeader));
    }

    protected String getFullConfiguration(boolean includeHeader) {
        StringBuilder sb = new StringBuilder();
        if (includeHeader) {
            sb.append(String.format("# %s\n", this.parent.fullAppName));
            sb.append("# http://arachnoid.com/OpticalRayTracer\n");
            String date = new SimpleDateFormat("yyyy.MM.dd HH:mm:ss z").format(new Date());
            sb.append(String.format("# %s\n\n", date));
        }
        sb.append(String.format("program {\n", new Object[0]));
        sb.append(this.programValues.getValues());
        sb.append(String.format("}\n\n", new Object[0]));
        for (OpticalComponent oc : this.parent.componentList) {
            sb.append(oc.getValues());
            sb.append(this.parent.lineSep);
        }
        return sb.toString();
    }

    private String readFile(String path) {
        String result = null;
        try {
            result = new String(Files.readAllBytes(Paths.get(path, new String[0])), StandardCharsets.UTF_8);
        }
        catch (IOException e) {
            this.parent.setDefaults(true);
        }
        return result;
    }

    private void writeFile(String path, String data) {
        try {
            PrintWriter out = new PrintWriter(path);
            out.write(data);
            out.close();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
    }

    private boolean testMakeDirs(String path) {
        File fpath = new File(path);
        if (fpath.exists()) {
            return false;
        }
        fpath.mkdirs();
        return true;
    }
}

