/*
 * Decompiled with CFR 0.152.
 */
package opticalraytracer;

import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.JButton;
import javax.swing.JOptionPane;
import javax.swing.JTextArea;
import opticalraytracer.Common;
import opticalraytracer.LineData;
import opticalraytracer.OpticalRayTracer;

public final class LineAnalysis {
    OpticalRayTracer parent;
    LineData closestLine;
    double minValue;
    String[] header = new String[]{"From", "To", "Source", "Destination", "DestinationType", "FromX", "FromY", "ToX", "ToY", "DeltaX", "DeltaY", "Magnitude", "BeamAngle", "SurfaceNormalAngle", "WavelengthNM"};
    String[] css = new String[]{"<style type=\"text/css\">", "   body {", "     font-family:monospace;", "   }", "   table {", "     border-collapse:collapse;", "   }", "   table * {", "     border:1px solid gray;", "     white-space:nowrap;", "   }", "   td {", "     text-align:right;", "   }", "   td.lj {", "     text-align:left;", "   }", "   tr:nth-child(even) {", "     background: #ffffff;", "   }", "   tr:nth-child(odd) {", "     background: #f0f0f0;", "   }", "   th {", "     text-align:center;", "     font-weight:bold;", "     background:#c0d0c0;", "   }", "  </style>"};
    String meta = "<meta http-equiv=\"Content-Type\" content=\"text/html; charset=utf-8\"/>\n";

    public LineAnalysis(OpticalRayTracer p) {
        this.parent = p;
    }

    protected String fmtNum(double v) {
        return this.parent.formatNum(v);
    }

    protected String makeRow(LineData ld, String token) {
        StringBuilder sb = new StringBuilder();
        ArrayList<String> array = this.makeRow(ld);
        boolean start = true;
        for (String s : array) {
            if (!start) {
                sb.append(token);
            }
            start = false;
            sb.append(s);
        }
        return sb.toString();
    }

    protected ArrayList<String> makeRow(LineData ld) {
        ArrayList<String> array = new ArrayList<String>();
        array.add(ld.fromEvent);
        array.add(ld.toEvent);
        array.add(ld.from);
        array.add(ld.to);
        array.add(ld.type);
        double[] dArray = ld.numericValues();
        int n = dArray.length;
        int n2 = 0;
        while (n2 < n) {
            double v = dArray[n2];
            array.add(this.parent.formatNum(v));
            ++n2;
        }
        return array;
    }

    protected boolean isRightJust(int n) {
        boolean rj = true;
        if (this.parent.dataTableDisplay.dataTableModel != null) {
            boolean[] rightJust = this.parent.dataTableDisplay.dataTableModel.rightJust;
            if (n >= 0 && n < rightJust.length) {
                rj = rightJust[n];
            }
        }
        return rj;
    }

    protected String createHTMLTable(boolean linefeeds) {
        StringBuilder sb = new StringBuilder();
        sb.append("<tr><th>");
        sb.append(this.makeHeader("</th><th>"));
        sb.append("</th></tr>");
        if (linefeeds) {
            sb.append("\n");
        }
        for (LineData ld : this.parent.rayTraceComputer.lineList) {
            sb.append("<tr>");
            ArrayList<String> sa = this.makeRow(ld);
            int cn = 0;
            for (String s : sa) {
                boolean rj = this.isRightJust(cn);
                String cls = rj ? "" : "class = \"lj\"";
                String ws = Common.wrapTag("td", s, cls, false);
                sb.append(ws);
                ++cn;
            }
            sb.append("</tr>");
            if (!linefeeds) continue;
            sb.append("\n");
        }
        String result = "";
        result = Common.wrapTag("table", sb.toString(), "cellspacing=\"0\" cellpadding=\"2\"", linefeeds);
        result = Common.wrapTag("body", result, "", linefeeds);
        sb = new StringBuilder();
        sb.append("<head>\n");
        sb.append(this.meta);
        String[] stringArray = this.css;
        int n = this.css.length;
        int n2 = 0;
        while (n2 < n) {
            String s = stringArray[n2];
            sb.append(s);
            sb.append("\n");
            ++n2;
        }
        sb.append("</head>\n");
        sb.append(result);
        result = sb.toString();
        result = Common.wrapTag("html", result, "", linefeeds);
        return result;
    }

    protected String makeHTMLTable(boolean linefeeds) {
        this.parent.rayTraceComputer.traceRays(null, true);
        return this.createHTMLTable(linefeeds);
    }

    protected String makeCSVTable() {
        this.parent.rayTraceComputer.traceRays(null, true);
        StringBuilder sb = new StringBuilder();
        sb.append(this.makeHeader("\t"));
        sb.append("\n");
        for (LineData ld : this.parent.rayTraceComputer.lineList) {
            sb.append(this.makeRow(ld, "\t"));
            sb.append("\n");
        }
        return sb.toString();
    }

    protected String makeHeader(String token) {
        StringBuilder sb = new StringBuilder();
        int n = 0;
        int len = this.header.length;
        String[] stringArray = this.header;
        int n2 = this.header.length;
        int n3 = 0;
        while (n3 < n2) {
            String s = stringArray[n3];
            sb.append(s);
            if (++n < len) {
                sb.append(token);
            }
            ++n3;
        }
        return sb.toString();
    }

    protected void nearestLineProperties(double mx, double my) {
        this.closestLine = null;
        this.parent.rayTraceComputer.traceRays(null, true);
        this.minValue = 1.0E9;
        for (LineData ld : this.parent.rayTraceComputer.lineList) {
            this.compare(ld, mx, my);
        }
        if (this.closestLine != null) {
            StringBuilder sb = new StringBuilder();
            sb.append(String.format("%-24s: %13s%13s\n", "Property", "x", "y"));
            sb.append("----------------------------------------------------\n");
            sb.append(String.format("%-24s: {%12s,%12s}\n", "Origin", this.fmtNum(this.closestLine.a.x), this.fmtNum(this.closestLine.a.y)));
            sb.append(String.format("%-24s: {%12s,%12s}\n", "Destination", this.fmtNum(this.closestLine.b.x), this.fmtNum(this.closestLine.b.y)));
            sb.append(String.format("%-24s: {%12s,%12s}\n", "Line length", this.fmtNum(this.closestLine.b.x - this.closestLine.a.x), this.fmtNum(this.closestLine.b.y - this.closestLine.a.y)));
            sb.append(String.format("%-24s: %26s\n", "Magnitude", this.fmtNum(this.closestLine.m)));
            sb.append(String.format("%-24s: %26s\u00b0\n", "Beam Angle", this.fmtNum(this.closestLine.ar)));
            sb.append(String.format("%-24s: %26s\u00b0\n", "Dest. Surface Normal", this.fmtNum(this.closestLine.sa)));
            sb.append(String.format("%-24s: %26s\n", "Wavelength NM", this.fmtNum(this.closestLine.wavelength)));
            sb.append(String.format("%-24s: %26s\n", "From", this.closestLine.fromEvent));
            sb.append(String.format("%-24s: %26s\n", "To", this.closestLine.toEvent));
            sb.append(String.format("%-24s: %26s\n", "Source", this.closestLine.from));
            sb.append(String.format("%-24s: %26s\n", "Destination", this.closestLine.to));
            sb.append(String.format("%-24s: %26s\n", "Destination Type", this.closestLine.type));
            this.showInfoDialog(sb.toString(), "Line Properties");
        } else {
            this.parent.showNotifyMessage("No Nearby Line", "Line Properties");
        }
    }

    protected void showInfoDialog(String message, String title) {
        JTextArea ta = new JTextArea(message);
        JButton copyButton = new JButton("Copy to clipboard");
        copyButton.setToolTipText("Copy this line to the system clipboard as a tab-separated record");
        copyButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                LineAnalysis.this.copyNearestLineToClipboard();
            }
        });
        Object[] content = new Object[]{ta, copyButton};
        ta.setBackground(this.parent.frame.getBackground());
        Font f = new Font("Monospaced", 0, 11);
        ta.setFont(f);
        JOptionPane.showMessageDialog(this.parent.frame, content, String.valueOf(this.parent.appName) + ": " + title, 1);
    }

    protected void copyLineToClipboard(LineData ld) {
        if (ld != null) {
            StringBuilder sb = new StringBuilder();
            sb.append(this.makeHeader("\t"));
            sb.append("\n");
            sb.append(this.makeRow(ld, "\t"));
            sb.append("\n");
            this.parent.clipboardCopyString(sb.toString());
        } else {
            Common.beep();
        }
    }

    protected void copyNearestLineToClipboard() {
        this.copyLineToClipboard(this.closestLine);
    }

    protected void compare(LineData ld, double mx, double my) {
        double lx = Common.xCoordinateOnLine(mx, my, ld.a.x, ld.a.y, ld.b.x, ld.b.y);
        double ly = Common.yCoordinateOnLine(mx, my, ld.a.x, ld.a.y, ld.b.x, ld.b.y);
        double m = Common.distanceToLine(mx, my, ld.a.x, ld.a.y, ld.b.x, ld.b.y);
        if (Common.inBounds(lx, ly, ld.a.x, ld.a.y, ld.b.x, ld.b.y) && this.minValue > m) {
            this.closestLine = ld;
            this.minValue = m;
        }
    }
}

