/*
 * Decompiled with CFR 0.152.
 */
package opticalraytracer;

import java.text.DecimalFormatSymbols;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.Locale;

public final class LocaleHandler {
    static final String localeDecimalSeparator = "" + new DecimalFormatSymbols(Locale.getDefault()).getDecimalSeparator();

    static double getDouble(String s, String decSep) {
        double v = 0.0;
        double pow = 0.0;
        String exp = "";
        try {
            if (s != null) {
                s = s.replaceAll("[.,]", decSep);
                Locale l = Locale.getDefault();
                NumberFormat nf = NumberFormat.getInstance(l);
                s = s.toLowerCase();
                String[] array = (s = s.trim()).split("e");
                if (array.length > 1 && (exp = array[1].trim().replaceAll("\\+", "")).length() > 0) {
                    pow = Double.parseDouble(exp);
                }
                v = nf.parse(array[0]).doubleValue();
                v *= Math.pow(10.0, pow);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return v;
    }

    static int getInt(String s) {
        int v = 0;
        Locale l = Locale.getDefault();
        NumberFormat nf = NumberFormat.getInstance(l);
        try {
            v = nf.parse(s).intValue();
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        return v;
    }

    static String formatDouble(double v, int decimals) {
        Locale l = Locale.getDefault();
        String result = "";
        result = Math.abs(v) >= 0.001 && Math.abs(v) < 1.0E7 ? String.format(l, "%." + decimals + "f", v) : String.format(l, "%." + decimals + "e", v);
        return result;
    }

    static String formatDouble(double v) {
        Locale l = Locale.getDefault();
        String result = "";
        result = Math.abs(v) >= 0.001 ? String.format(l, "%f", v) : String.format(l, "%e", v);
        return result;
    }

    static String formatInt(int v) {
        Locale l = Locale.getDefault();
        return String.format(l, "%d", v);
    }
}

