/*
 * Decompiled with CFR 0.152.
 */
package opticalraytracer;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Polygon;
import java.util.ArrayList;
import java.util.HashSet;
import opticalraytracer.Common;
import opticalraytracer.ComplexInt;
import opticalraytracer.ControlManager;
import opticalraytracer.ElementBase;
import opticalraytracer.ElementHyperbolic;
import opticalraytracer.ElementParabolic;
import opticalraytracer.ElementPlanar;
import opticalraytracer.ElementSpherical;
import opticalraytracer.MyColor;
import opticalraytracer.ObjectValues;
import opticalraytracer.OpticalRayTracer;
import opticalraytracer.ProgramValues;
import opticalraytracer.RayLensIntersection;
import opticalraytracer.RayTraceComputer;
import opticalraytracer.Vector;

public final class OpticalComponent {
    OpticalRayTracer parent;
    ProgramValues programValues;
    RayTraceComputer rayTraceComputer;
    ObjectValues values;
    ArrayList<Vector> opticalTestPolygon;
    ArrayList<Vector> objectDrawingImage;
    ArrayList<Vector> mouseProximityPolygon;
    Vector farFarAway;
    double objectInsideEpsilon;
    double internalThickness = 0.0;
    double leftInsideRadius = 0.0;
    double rightInsideRadius = 0.0;
    double drawCount = 32.0;
    boolean valid = false;
    double leftCenter = 0.0;
    double rightCenter = 0.0;
    private double angleRadians = 0.0;
    private double localSurfaceEpsilon = 0.0;
    static final double maxZValue = 1.0E8;
    private ElementBase[] elements = null;

    public OpticalComponent(OpticalRayTracer p, int function) {
        this.parent = p;
        this.rayTraceComputer = this.parent.rayTraceComputer;
        this.programValues = this.parent.programValues;
        String name = this.nextObjectName(function);
        this.values = new ObjectValues(name);
        this.setObjectSize(function);
        this.valid = true;
        this.setup();
        this.writeObjectControls();
    }

    public OpticalComponent(OpticalRayTracer p, int function, String name) {
        this.parent = p;
        this.rayTraceComputer = this.parent.rayTraceComputer;
        this.programValues = this.parent.programValues;
        this.values = new ObjectValues(name);
        this.renameIfRequired();
        this.setObjectSize(function);
        this.valid = true;
        this.setup();
        this.writeObjectControls();
    }

    public OpticalComponent(OpticalRayTracer p, String data, int function) {
        this.parent = p;
        this.programValues = this.parent.programValues;
        this.rayTraceComputer = this.parent.rayTraceComputer;
        String name = this.nextObjectName(function);
        this.values = new ObjectValues(name);
        this.setObjectSize(function);
        this.valid = this.values.setValues(data);
        this.setup();
        this.writeObjectControls();
    }

    protected void setup() {
        this.elements = new ElementBase[]{new ElementSpherical(this.parent), new ElementParabolic(this.parent), new ElementHyperbolic(this.parent), new ElementPlanar(this.parent)};
        this.reconfigure();
    }

    protected void setObjectSize(int function) {
        this.values.function = function;
        if (function == 1 || function == 2) {
            this.values.leftCurvature = 3;
            this.values.rightCurvature = 3;
            this.values.thickness = 0.1;
        }
    }

    protected String nextObjectName(int function) {
        this.parent.componentNames = new HashSet();
        for (OpticalComponent oc : this.parent.componentList) {
            this.parent.componentNames.add(oc.values.name);
        }
        int n = 1;
        String s = "";
        while (this.nameInUse(s = String.format("%s %d", Common.getObjectType(function), n))) {
            ++n;
        }
        return s;
    }

    protected boolean nameInUse() {
        return this.parent.componentNames.contains(this.values.name);
    }

    protected boolean nameInUse(String s) {
        return this.parent.componentNames.contains(s);
    }

    protected void renameIfRequired() {
        if (this.nameInUse()) {
            this.values.name = this.nextObjectName(this.values.function);
        }
    }

    ElementBase getElement(boolean leftSide) {
        return this.elements[leftSide ? this.values.leftCurvature : this.values.rightCurvature];
    }

    protected double xPos() {
        return this.values.xPos;
    }

    protected double yPos() {
        return this.values.yPos;
    }

    protected double sphereRadius(boolean left) {
        return left ? this.values.leftSphereRadius : this.values.rightSphereRadius;
    }

    protected double lensRadius() {
        return this.values.lensRadius;
    }

    protected double offset(boolean left) {
        return left ? this.leftCenter : this.rightCenter;
    }

    protected double zValue(boolean left) {
        return left ? this.values.leftZValue : this.values.rightZValue;
    }

    protected double thickness() {
        return this.internalThickness;
    }

    protected double signedThickness(boolean left) {
        return left ? -this.internalThickness : this.internalThickness;
    }

    protected double scale(boolean left) {
        return Math.abs(this.sphereRadius(left)) - this.offset(left);
    }

    protected double revScale(boolean left) {
        return Math.abs(this.sphereRadius(left)) + this.offset(left);
    }

    protected double signedScale(boolean left) {
        return this.scale(left) * this.radiusSign(left);
    }

    protected double radiusSign(boolean left) {
        return this.sphereRadius(left) < 0.0 ? -1 : 1;
    }

    protected double sideSign(boolean left) {
        return left ? -1 : 1;
    }

    protected double angleRadians() {
        return this.angleRadians;
    }

    protected boolean isReflector() {
        return this.values.function == 1;
    }

    protected double halfRadius(boolean left) {
        double sr = Math.abs(this.sphereRadius(left));
        double lr = this.lensRadius();
        return sr - Math.sqrt(sr * sr - lr * lr);
    }

    protected void reconfigure() {
        this.localSurfaceEpsilon = this.parent.programValues.surfEpsilon;
        this.farFarAway = new Vector(1000000.0, 1000000.0);
        this.limitPositions();
        this.angleRadians = this.values.angle % 360.0 * (-Math.PI / 180);
        this.values.thickness = Math.max(this.values.thickness, 0.0);
        this.values.ior = Math.max(this.values.ior, 1.0);
        this.values.lensRadius = Math.abs(this.values.lensRadius);
        this.values.rightZValue = Math.min(this.values.rightZValue, 1.0E8);
        this.values.leftZValue = Math.min(this.values.leftZValue, 1.0E8);
        if (this.values.symmetrical) {
            this.values.rightSphereRadius = this.values.leftSphereRadius;
            this.values.rightZValue = this.values.leftZValue;
            this.values.rightCurvature = this.values.leftCurvature;
        }
        double lsr = this.checkRadius(this.values.leftSphereRadius);
        double rsr = this.checkRadius(this.values.rightSphereRadius);
        boolean lch = lsr != this.values.leftSphereRadius;
        boolean rch = rsr != this.values.rightSphereRadius;
        this.parent.leftSphereRadiusTextField.setForeground(lch ? Color.RED : Color.BLACK);
        this.parent.rightSphereRadiusTextField.setForeground(rch ? Color.RED : Color.BLACK);
        this.parent.lensRadiusTextField.setForeground(lch || rch ? Color.RED : Color.BLACK);
        this.values.leftSphereRadius = lsr;
        this.values.rightSphereRadius = rsr;
        this.leftCenter = Math.sqrt(lsr * lsr - this.values.lensRadius * this.values.lensRadius);
        this.rightCenter = Math.sqrt(rsr * rsr - this.values.lensRadius * this.values.lensRadius);
        int leftSign = this.values.leftSphereRadius < 0.0 ? -1 : 1;
        int rightSign = this.values.rightSphereRadius < 0.0 ? -1 : 1;
        this.internalThickness = this.values.thickness / 2.0;
        double leftSurface = (Math.abs(lsr) - this.leftCenter) * (double)leftSign;
        double rightSurface = (Math.abs(rsr) - this.rightCenter) * (double)(-rightSign);
        leftSurface += this.internalThickness;
        rightSurface -= this.internalThickness;
        if (this.values.leftCurvature == 3) {
            leftSurface = this.internalThickness;
        }
        if (this.values.rightCurvature == 3) {
            rightSurface = -this.internalThickness;
        }
        this.values.centerThickness = Math.max(leftSurface - rightSurface, 0.0);
        this.parent.centerThicknessTextField.setText(this.parent.formatNum(this.values.centerThickness));
        double bias = Math.max(rightSurface - leftSurface, 0.0);
        this.internalThickness += bias / 2.0;
        this.internalThickness = Math.max(this.internalThickness, this.parent.programValues.surfEpsilon);
        this.parent.internalThicknessTextField.setText(this.parent.formatNum(this.internalThickness * 2.0));
        this.parent.internalThicknessTextField.setForeground(bias > 0.0 ? Color.RED : Color.BLACK);
        this.parent.thicknessTextField.setForeground(bias > 0.0 ? Color.RED : Color.BLACK);
        this.drawCount = 32.0;
        double leastRadius = Math.min(Math.abs(this.values.leftSphereRadius), Math.abs(this.values.rightSphereRadius));
        double v = 1024.0 * Math.pow(this.values.lensRadius / leastRadius, 3.0);
        this.drawCount = Math.max(this.drawCount, v);
        this.objectInsideEpsilon = this.parent.programValues.surfEpsilon * Math.sqrt(this.values.lensRadius);
        this.opticalTestPolygon = this.createObjectPerimeter((int)this.drawCount, this.objectInsideEpsilon);
        this.objectDrawingImage = this.createObjectPerimeter((int)this.drawCount, 0.0);
        this.mouseProximityPolygon = this.createObjectPerimeter((int)this.drawCount, this.objectInsideEpsilon * 200.0);
    }

    boolean inside(Vector p1, ArrayList<Vector> polygon, double epsilon) {
        double closest = 1.0E9;
        Vector op = null;
        int crossings = 0;
        for (Vector p : polygon) {
            if (op != null) {
                int intersect = Common.linesIntersect(this.farFarAway.x, this.farFarAway.y, p1.x, p1.y, op.x, op.y, p.x, p.y);
                double m = Common.distanceToParallelLine(p, op, p1);
                if (!Double.isNaN(m)) {
                    closest = Math.min(closest, Math.abs(m));
                }
                switch (intersect) {
                    case -1: {
                        return false;
                    }
                    case 1: {
                        ++crossings;
                    }
                }
            }
            op = p;
        }
        boolean inside = crossings & true && closest < epsilon;
        return inside;
    }

    boolean inside(Vector p1, ArrayList<Vector> polygon) {
        if (p1 == null || Double.isNaN(p1.x) || Double.isNaN(p1.y)) {
            return false;
        }
        Vector op = null;
        int crossings = 0;
        for (Vector p : polygon) {
            if (op != null) {
                int intersect = Common.linesIntersect(this.farFarAway.x, this.farFarAway.y, p1.x, p1.y, op.x, op.y, p.x, p.y);
                switch (intersect) {
                    case -1: {
                        return false;
                    }
                    case 1: {
                        ++crossings;
                    }
                }
            }
            op = p;
        }
        boolean inside = crossings & true;
        return inside;
    }

    void showPerimeter(ArrayList<Vector> points) {
        StringBuilder sb = new StringBuilder();
        for (Vector p : points) {
            sb.append(String.format("(%f,%f),", p.x, p.y));
        }
        Common.p(sb.toString());
    }

    ArrayList<Vector> createObjectPerimeter(int segments, double epsilon) {
        ArrayList<Vector> points = new ArrayList<Vector>();
        int j = 0;
        while (j <= 1) {
            double sgn = j == 0 ? 1 : -1;
            int i = 0;
            while (i <= segments) {
                double y = this.values.lensRadius * (2.0 * (double)i / (double)segments - 1.0);
                Vector p = this.lensXforY(y *= sgn, 0.0);
                if (p.x < p.y) {
                    p.x -= epsilon;
                    p.y += epsilon;
                } else {
                    p.x += epsilon;
                    p.y -= epsilon;
                }
                Vector ca = new Vector().rotate(p.x, y, this.angleRadians).translate(this.values.xPos, this.values.yPos);
                Vector cb = new Vector().rotate(p.y, y, this.angleRadians).translate(this.values.xPos, this.values.yPos);
                if (i == 0 && j == 0) {
                    points.add(cb);
                }
                if (j == 0) {
                    points.add(ca);
                } else {
                    points.add(cb);
                }
                ++i;
            }
            ++j;
        }
        return points;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("object {" + this.parent.lineSep);
        sb.append(this.values.getValues());
        sb.append("}" + this.parent.lineSep);
        return sb.toString();
    }

    protected void limitPositions() {
        this.values.xPos = Math.min(this.values.xPos, this.programValues.virtualSpaceSize);
        this.values.xPos = Math.max(this.values.xPos, -this.programValues.virtualSpaceSize);
        this.values.yPos = Math.min(this.values.yPos, this.programValues.virtualSpaceSize);
        this.values.yPos = Math.max(this.values.yPos, -this.programValues.virtualSpaceSize);
    }

    double checkRadius(double v) {
        double sign = v < 0.0 ? -1 : 1;
        v = Math.abs(v);
        v = Math.max(v, this.values.lensRadius);
        return v * sign;
    }

    protected void setValues(String s) {
        this.values.setValues(s);
    }

    protected String getValues() {
        return this.toString();
    }

    double computeSnap(double v) {
        double sign = 1.0;
        if (this.programValues.snapValue != 0.0) {
            sign = v < 0.0 ? -1 : 1;
            v = Math.abs(v);
            double q = this.programValues.snapValue / 2.0;
            double delta = (v + q) % this.programValues.snapValue;
            v = v - delta + q;
        }
        return v * sign;
    }

    void snapToGrid() {
        this.values.yPos = this.computeSnap(this.values.yPos);
        this.values.xPos = this.computeSnap(this.values.xPos);
    }

    protected void writeObjectControls() {
        for (ControlManager cm : this.parent.objectControlList.values()) {
            String tag = cm.getTag();
            String value = this.values.getOneValue(tag);
            cm.setValue(value);
        }
        this.reconfigure();
        this.parent.enableComponentControls(true);
    }

    protected void readObjectControls() {
        for (ControlManager cm : this.parent.objectControlList.values()) {
            String tag = cm.getTag();
            String value = cm.getValue();
            this.values.setOneValue(tag, value);
        }
        this.reconfigure();
        this.parent.enableComponentControls(true);
    }

    Vector profile(boolean leftSide, double ar) {
        double lo = this.values.leftSphereRadius < 0.0 ? -this.leftCenter : this.leftCenter;
        double ro = this.values.rightSphereRadius < 0.0 ? -this.rightCenter : this.rightCenter;
        double x = leftSide ? this.values.xPos - lo + this.internalThickness : this.values.xPos + ro - this.internalThickness;
        Vector v = new Vector(x - this.values.xPos, 0.0).rotate(ar).translate(this.values.xPos, this.values.yPos);
        return v;
    }

    void computeIntersections(RayLensIntersection oldrli, OpticalComponent oc, boolean leftSide, Vector p1, Vector p2) {
        ElementBase element = this.getElement(leftSide);
        element.intersections(oc, leftSide, p1, p2);
    }

    double tangent(boolean leftSide, boolean entering, Vector p, double ar, boolean reflector) {
        Vector rp = p.translate(-this.values.xPos, -this.values.yPos).rotate(-ar);
        double dx = this.getElement(leftSide).lensProfileDXforY(this, leftSide, entering, rp.y);
        return dx;
    }

    void drawLens(Graphics2D g) {
        boolean selected;
        if (this.localSurfaceEpsilon != this.parent.programValues.surfEpsilon) {
            this.reconfigure();
        }
        Polygon p = new Polygon();
        int col = this.programValues.colorLensOutline;
        boolean bl = selected = this.parent.selectedComponent != null && this.parent.selectedComponent == this;
        if (selected) {
            col = this.programValues.colorLensSelected;
        } else if (!this.values.active) {
            col = this.programValues.colorGrid;
        }
        MyColor cc = new MyColor(col, 255);
        g.setColor(cc);
        boolean drawing = false;
        ComplexInt i = new ComplexInt();
        for (Vector pt : this.objectDrawingImage) {
            this.rayTraceComputer.drawScaledLine(pt.x, pt.y, i, g, drawing);
            this.rayTraceComputer.addToPolygon(p, pt.x, pt.y);
            drawing = true;
        }
        cc = new MyColor(col);
        g.setColor(cc);
        g.fillPolygon(p);
    }

    Vector lensXforY(double y, double ccx) {
        double a = this.getElement(true).lensProfileXforY(this, true, y, ccx);
        double b = this.getElement(false).lensProfileXforY(this, false, y, ccx);
        return new Vector(a, b);
    }
}

