/*
 * Decompiled with CFR 0.152.
 */
package opticalraytracer;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.SystemColor;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.BufferedImage;
import java.io.FileWriter;
import java.io.IOException;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Stack;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.LineBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import net.miginfocom.swing.MigLayout;
import opticalraytracer.ColorButton;
import opticalraytracer.Common;
import opticalraytracer.ComplexInt;
import opticalraytracer.ControlManager;
import opticalraytracer.DataTableDisplay;
import opticalraytracer.GraphicDisplay;
import opticalraytracer.ImageTransferable;
import opticalraytracer.InitializationManager;
import opticalraytracer.LineAnalysis;
import opticalraytracer.LocaleHandler;
import opticalraytracer.MyHelpPane;
import opticalraytracer.MyJFrame;
import opticalraytracer.OpticalComponent;
import opticalraytracer.ProgramControl;
import opticalraytracer.ProgramValues;
import opticalraytracer.RayTraceComputer;
import opticalraytracer.Vector;

public final class OpticalRayTracer {
    protected String appName;
    protected String VERSION = "9.6";
    protected String fullAppName;
    double textFieldDoubleSensitivity = 0.1;
    double textFieldIntSensitivity = 1.0;
    double curvatureFactorSensitivity = 0.001;
    ProgramValues programValues;
    NumberFormat numberFormat;
    HashMap<String, ControlManager> objectControlList;
    HashMap<String, ProgramControl> programControlList;
    ArrayList<JRadioButton> typeRadioButtonList;
    ArrayList<JRadioButton> leftCurvatureRadioButtonList;
    ArrayList<JRadioButton> rightCurvatureRadioButtonList;
    Stack<String> undoStack;
    Stack<String> redoStack;
    int undoRedoMaxStack = 128;
    int maxLightRays = 1000;
    InitializationManager initManager;
    BufferedImage image = null;
    int xSize = -1;
    int ySize = -1;
    int xCenter = -1;
    int yCenter = -1;
    OpticalComponent mouseTarget = null;
    OpticalComponent selectedComponent = null;
    ArrayList<OpticalComponent> componentList;
    HashSet<String> componentNames;
    double mousePressX;
    double mousePressY;
    int popupMouseX = -1;
    int popupMouseY = -1;
    int overlappedLensSelector = 0;
    RayTraceComputer rayTraceComputer;
    LineAnalysis lineAnalysis;
    GraphicDisplay gPaneDesign;
    GraphicDisplay gPaneConfigure;
    double lensMinThickness = 1.0E-4;
    boolean undoFlag = true;
    boolean redoFlag = true;
    boolean suppressCombo = false;
    MyHelpPane helpPanel;
    JScrollPane tableScrollPane;
    DataTableDisplay dataTableDisplay;
    MyJFrame frame;
    JTextField leftSphereRadiusTextField;
    JTextField rightSphereRadiusTextField;
    private JTextField leftZTextField;
    private JTextField rightZTextField;
    private JTextField xPosTextField;
    private JTextField yPosTextField;
    JTextField lensRadiusTextField;
    JTextField thicknessTextField;
    private JTextField iorTextField;
    private JTextField dispersionTextField;
    private JTextField angleTextField;
    private JCheckBox symmetricalCheckBox;
    private JCheckBox inverseCheckBox;
    private JCheckBox gridCheckBox;
    private JCheckBox antiAliasCheckBox;
    private JCheckBox showControlsCheckBox;
    private JPanel lensDesignControlPane;
    protected JButton unselectButton;
    private JToolBar colorToolBar;
    private JPanel statusBar;
    JLabel statusLabel;
    private JPanel configurePane;
    private JPanel designPane;
    JTabbedPane tabbedPane;
    private JTextField arrowSizeTextField;
    private JTextField snapValueTextField;
    private JTextField beamWidthTextField;
    private JTextField beamCountTextField;
    private JTextField interactionsTextField;
    private JTextField yStartTextField;
    private JTextField beamOffsetTextField;
    private JTextField dispersionCountTextField;
    private JTextField yEndTextField;
    private JTextField xSourcePlaneTextField;
    private JTextField xTargetPlaneTextField;
    private JCheckBox divergingBeamsCheckBox;
    private JButton redoButton;
    private JButton undoButton;
    private JButton button;
    private JLabel lblSurfaceEpsilon;
    private JTextField interLensEpsilonTextField;
    private JCheckBox activeCheckBox;
    private JButton newMIrrorButton;
    private JRadioButton refractRadioButton;
    private JRadioButton reflectRadioButton;
    private JRadioButton absorbRadioButton;
    protected final ButtonGroup typeButtonGroup = new ButtonGroup();
    private JLabel lblName;
    private JTextField nameTextField;
    private JLabel lblLensEpsilon;
    private JTextField surfaceEpsilonTextField;
    private JPanel tablePane;
    private JPanel tableControlPane;
    private JTextField lineLimitTextField;
    JLabel tableDataLabel;
    private JButton btnCopyHtml;
    private JLabel lblSpaceBoxLimit;
    private JTextField spaceBoxLimitTextField;
    private JPanel helpPane;
    private JLabel lblEffectiveThickness;
    JTextField internalThicknessTextField;
    protected final ButtonGroup leftCurvButtonGroup = new ButtonGroup();
    protected final ButtonGroup rightCurvButtonGroup = new ButtonGroup();
    private JComboBox<String> leftCurvComboBox;
    private JComboBox<String> rightCurvComboBox;
    JTextField centerThicknessTextField;
    private JLabel lblCenterThickness;
    private JButton resetProgramButton;
    String lineSep = System.getProperty("line.separator");

    public OpticalRayTracer(final String[] args) {
        this.undoStack = new Stack();
        this.redoStack = new Stack();
        this.numberFormat = NumberFormat.getNumberInstance();
        this.appName = this.getClass().getSimpleName();
        this.fullAppName = String.valueOf(this.appName) + " " + this.VERSION;
        this.componentList = new ArrayList();
        this.componentNames = new HashSet();
        this.programValues = new ProgramValues();
        this.rayTraceComputer = new RayTraceComputer(this);
        this.lineAnalysis = new LineAnalysis(this);
        this.initialize();
        JRadioButton[] trb = new JRadioButton[]{this.refractRadioButton, this.reflectRadioButton, this.absorbRadioButton};
        this.typeRadioButtonList = new ArrayList<JRadioButton>(Arrays.asList(trb));
        this.gPaneDesign = new GraphicDisplay(this, "design pane", 0);
        this.designPane.add((Component)this.gPaneDesign, 0);
        this.gPaneConfigure = new GraphicDisplay(this, "configure pane", 1);
        this.configurePane.add((Component)this.gPaneConfigure, 0);
        this.frame.addWindowFocusListener(new WindowAdapter(){

            @Override
            public void windowGainedFocus(WindowEvent e) {
                OpticalRayTracer.this.gPaneDesign.requestFocusInWindow();
            }
        });
        this.initManager = new InitializationManager(this, this.programValues);
        this.dataTableDisplay = new DataTableDisplay(this);
        this.dataTableDisplay.setAutoResizeMode(0);
        this.tableScrollPane = new JScrollPane(this.dataTableDisplay, 20, 30);
        this.tableScrollPane.getViewport().setBackground(Color.white);
        this.tableControlPane = new JPanel();
        this.tablePane.add((Component)this.tableScrollPane, "Center");
        this.tablePane.add((Component)this.tableControlPane, "South");
        this.tableControlPane.setLayout(new MigLayout("", "[117px][][][grow][]", "[25px]"));
        JButton copyTableButton = new JButton("Copy Data");
        copyTableButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                OpticalRayTracer.this.copyLineList(false);
            }
        });
        copyTableButton.setIcon(new ImageIcon(OpticalRayTracer.class.getResource("/opticalraytracer/icons/document-save.png")));
        copyTableButton.setToolTipText("Copy a full tab-separated data table to the system clipboard");
        this.tableControlPane.add((Component)copyTableButton, "cell 0 0,alignx left,aligny top");
        this.btnCopyHtml = new JButton("Copy HTML");
        this.btnCopyHtml.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                OpticalRayTracer.this.copyLineList(true);
            }
        });
        this.btnCopyHtml.setToolTipText("Copy a Web-formatted full data table to the system clipboard");
        this.btnCopyHtml.setIcon(new ImageIcon(OpticalRayTracer.class.getResource("/opticalraytracer/icons/text-html.png")));
        this.tableControlPane.add((Component)this.btnCopyHtml, "cell 1 0");
        JLabel lblNewLabel_2 = new JLabel("Line limit:");
        this.tableControlPane.add((Component)lblNewLabel_2, "cell 2 0,alignx trailing");
        this.lineLimitTextField = new JTextField();
        this.lineLimitTextField.setHorizontalAlignment(4);
        this.lineLimitTextField.setToolTipText("A limit to the number of displayed lines (to prevent slow operation).");
        this.tableControlPane.add((Component)this.lineLimitTextField, "cell 3 0");
        this.lineLimitTextField.setColumns(10);
        this.tableDataLabel = new JLabel("");
        this.tableControlPane.add((Component)this.tableDataLabel, "flowx,cell 4 0");
        this.setupOpticalControlFields();
        this.programControlList = new HashMap();
        this.setupProgramControlFields();
        this.setupColorButtons();
        ImageIcon programIcon = new ImageIcon(OpticalRayTracer.class.getResource("/opticalraytracer/icons/OpticalRayTracer.png"));
        this.frame.setIconImage(programIcon.getImage());
        this.frame.setTitle(this.fullAppName);
        this.resetButtonColors();
        this.helpPane = new JPanel();
        this.tabbedPane.addTab("Help", new ImageIcon(OpticalRayTracer.class.getResource("/opticalraytracer/icons/system-help.png")), this.helpPane, "Show the help document");
        this.helpPane.setLayout(new BorderLayout(0, 0));
        this.helpPanel = new MyHelpPane(this, 0);
        this.helpPane.add(this.helpPanel);
        this.tabbedPane.setMnemonicAt(0, 68);
        this.tabbedPane.setMnemonicAt(1, 67);
        this.tabbedPane.setMnemonicAt(2, 84);
        this.tabbedPane.setMnemonicAt(3, 72);
        this.clearSelection();
        this.initManager.readConfig();
        this.frame.setBounds(this.programValues.windowX, this.programValues.windowY, this.programValues.defaultWindowWidth, this.programValues.defaultWindowHeight);
        this.writeProgramControls();
        this.writeElementControls();
        this.resetUndoRedo();
        this.setSelectedComponent(this.programValues.selectedComponent);
        this.tabbedPane.setSelectedIndex(this.programValues.selectedTab);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                OpticalRayTracer.this.processTabChange();
            }
        });
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                OpticalRayTracer.this.processComline(args);
            }
        });
    }

    void p(String s) {
        System.out.println(s);
    }

    void processComline(String[] args) {
        String[] stringArray = args;
        int n = args.length;
        int n2 = 0;
        while (n2 < n) {
            String arg = stringArray[n2];
            String data = null;
            switch (arg) {
                case "-r": {
                    this.initManager.readStream(System.in);
                    this.writeProgramControls();
                    this.writeElementControls();
                    break;
                }
                case "-h": {
                    data = this.lineAnalysis.makeHTMLTable(true);
                    break;
                }
                case "-t": {
                    data = this.lineAnalysis.makeCSVTable();
                    break;
                }
                case "-q": {
                    this.exit();
                    break;
                }
                default: {
                    this.showNotifyMessage(String.format("Don't recognize command-line argument \"%s\".", arg), "Argument Error");
                }
            }
            if (data != null) {
                System.out.println(data);
            }
            ++n2;
        }
    }

    void setupOpticalControlFields() {
        ControlManager[] array = new ControlManager[]{new ControlManager(this.nameTextField, this, "name"), new ControlManager(this.textFieldDoubleSensitivity, 0.0, 1.0E10, this.lensRadiusTextField, this, "lensRadius"), new ControlManager(this.textFieldDoubleSensitivity, 0.0, 1.0E10, this.thicknessTextField, this, "thickness"), new ControlManager(this.textFieldDoubleSensitivity, -1.0E10, 1.0E10, this.leftSphereRadiusTextField, this, "leftSphereRadius"), new ControlManager(this.textFieldDoubleSensitivity, -1.0E10, 1.0E10, this.rightSphereRadiusTextField, this, "rightSphereRadius"), new ControlManager(this.textFieldDoubleSensitivity, 0.0, 1.0E8, this.leftZTextField, this, "leftZValue"), new ControlManager(this.textFieldDoubleSensitivity, 0.0, 1.0E8, this.rightZTextField, this, "rightZValue"), new ControlManager(this.textFieldDoubleSensitivity, -1.0E10, 1.0E10, this.iorTextField, this, "ior"), new ControlManager(this.textFieldDoubleSensitivity, -1.0E10, 1.0E10, this.dispersionTextField, this, "dispersion"), new ControlManager(this.textFieldDoubleSensitivity, -1.0E10, 1.0E10, this.xPosTextField, this, "xPos"), new ControlManager(this.textFieldDoubleSensitivity, -1.0E10, 1.0E10, this.xPosTextField, this, "xPos"), new ControlManager(this.textFieldDoubleSensitivity, -1.0E10, 1.0E10, this.yPosTextField, this, "yPos"), new ControlManager(1.0, -1.0E10, 1.0E10, this.angleTextField, this, "angle"), new ControlManager(this.symmetricalCheckBox, this, "symmetrical"), new ControlManager(this.activeCheckBox, this, "active"), new ControlManager(this.refractRadioButton, this, "function"), new ControlManager(this.reflectRadioButton, this, "function"), new ControlManager(this.absorbRadioButton, this, "function"), new ControlManager(this.leftCurvComboBox, this, "leftCurvature"), new ControlManager(this.rightCurvComboBox, this, "rightCurvature")};
        this.objectControlList = new HashMap();
        ControlManager[] controlManagerArray = array;
        int n = array.length;
        int n2 = 0;
        while (n2 < n) {
            ControlManager cm = controlManagerArray[n2];
            this.objectControlList.put(cm.getTag(), cm);
            ++n2;
        }
    }

    void setupProgramControlFields() {
        ControlManager[] array;
        ControlManager[] controlManagerArray = array = new ControlManager[]{new ControlManager(this.textFieldDoubleSensitivity, -1.0E10, 1.0E10, this.arrowSizeTextField, this, "intersectionArrowSize"), new ControlManager(this.textFieldDoubleSensitivity, 0.0, 1.0E10, this.snapValueTextField, this, "snapValue"), new ControlManager(this.textFieldIntSensitivity, 1.0, 1000.0, this.beamWidthTextField, this, "beamWidth"), new ControlManager(this.textFieldIntSensitivity, 1.0, this.maxLightRays, this.beamCountTextField, this, "beamCount"), new ControlManager(this.textFieldDoubleSensitivity, 0.0, 1.0E10, this.interLensEpsilonTextField, this, "interLensEpsilon"), new ControlManager(this.textFieldDoubleSensitivity, 0.0, 1.0E10, this.surfaceEpsilonTextField, this, "surfEpsilon"), new ControlManager(this.textFieldIntSensitivity, 0.0, 1000.0, this.interactionsTextField, this, "maxIntersections"), new ControlManager(this.textFieldDoubleSensitivity, -1.0E10, 1.0E10, this.yStartTextField, this, "yStartBeamPos"), new ControlManager(this.textFieldDoubleSensitivity, -1.0E10, 1.0E10, this.yEndTextField, this, "yEndBeamPos"), new ControlManager(this.textFieldDoubleSensitivity, -1.0E10, 1.0E10, this.xSourcePlaneTextField, this, "xBeamSourceRefPlane"), new ControlManager(this.textFieldDoubleSensitivity, -1.0E10, 1.0E10, this.xTargetPlaneTextField, this, "xBeamRotationPlane"), new ControlManager(this.textFieldDoubleSensitivity, 0.0, 1.0E10, this.spaceBoxLimitTextField, this, "virtualSpaceSize"), new ControlManager(this.textFieldDoubleSensitivity, -1.0E10, 1.0E10, this.beamOffsetTextField, this, "beamAngle"), new ControlManager(this.textFieldIntSensitivity, 0.0, 1000.0, this.dispersionCountTextField, this, "dispersionBeams"), new ControlManager(this.textFieldIntSensitivity, 0.0, 50000.0, this.lineLimitTextField, this, "tableLineLimit"), new ControlManager(this.inverseCheckBox, this, "inverse"), new ControlManager(this.gridCheckBox, this, "showGrid"), new ControlManager(this.antiAliasCheckBox, this, "antialias"), new ControlManager(this.showControlsCheckBox, this, "showControls"), new ControlManager(this.divergingBeamsCheckBox, this, "divergingSource")};
        int n = array.length;
        int n2 = 0;
        while (n2 < n) {
            ControlManager cm = controlManagerArray[n2];
            this.programControlList.put(cm.getTag(), cm);
            ++n2;
        }
    }

    void setupColorButtons() {
        ColorButton[] array;
        ColorButton[] colorButtonArray = array = new ColorButton[]{new ColorButton(this, "colorBaseline", "X/Y Zero Baseline color"), new ColorButton(this, "colorGrid", "Grid color"), new ColorButton(this, "colorLensOutline", "Lens body color : unselected"), new ColorButton(this, "colorLensSelected", "Lens body color : selected"), new ColorButton(this, "colorHighBackground", "High background color"), new ColorButton(this, "colorLowBackground", "Low background color"), new ColorButton(this, "colorArrow", "Intersection arrow color"), new ColorButton(this, "colorBeam", "Light Beam color"), new ColorButton(this, "colorTerminator", "Ray Termination color"), new ColorButton(this, "colorLightSource", "Light source bar color")};
        int n = array.length;
        int n2 = 0;
        while (n2 < n) {
            ColorButton cb = colorButtonArray[n2];
            this.programControlList.put(cb.getTag(), cb);
            this.colorToolBar.add(cb);
            ++n2;
        }
    }

    int currentTab() {
        return this.tabbedPane.getSelectedIndex();
    }

    void resetButtonColors() {
        for (ProgramControl cb : this.programControlList.values()) {
            cb.reset();
        }
    }

    void setSelectedComponent(OpticalComponent oc) {
        this.selectedComponent = oc;
        this.selectedComponent.writeObjectControls();
        this.tabbedPane.setSelectedIndex(0);
        this.processTabChange();
        this.programValues.selectedComponent = this.getSelectedComponent();
    }

    void setSelectedComponent(int sel) {
        if (sel >= 0 && sel < this.componentList.size()) {
            OpticalComponent oc = this.componentList.get(sel);
            this.setSelectedComponent(oc);
        } else {
            this.clearSelection();
        }
    }

    int getSelectedComponent() {
        int sel = this.componentList.indexOf(this.selectedComponent);
        return sel;
    }

    void clearSelection() {
        this.selectedComponent = null;
        this.programValues.selectedComponent = -1;
        for (ControlManager cm : this.objectControlList.values()) {
            cm.enable(false);
        }
        this.enableTextField(this.internalThicknessTextField, false);
        this.enableTextField(this.centerThicknessTextField, false);
    }

    void enableTextField(JTextField tf, boolean enabled) {
        tf.setEnabled(enabled);
        if (!enabled) {
            tf.setText("(Select a lens)");
        }
    }

    void selectNextObject() {
        if (this.selectedComponent == null) {
            if (this.componentList.size() > 0) {
                this.setSelectedComponent(this.componentList.get(0));
            } else {
                Common.beep();
            }
        } else {
            int n = this.componentList.size();
            int i = 0;
            while (i < n) {
                if (this.componentList.get(i) == this.selectedComponent) {
                    i = (i + 1) % n;
                    this.setSelectedComponent(this.componentList.get(i));
                }
                ++i;
            }
        }
        this.updateGraphicDisplay();
    }

    void updateGraphicDisplay() {
        this.gPaneDesign.updateDisplay();
        this.gPaneConfigure.updateDisplay();
    }

    void enableComponentControls(boolean enabled) {
        for (ControlManager cm : this.objectControlList.values()) {
            cm.enable(enabled);
        }
        this.internalThicknessTextField.setEnabled(enabled);
        this.centerThicknessTextField.setEnabled(enabled);
        if (this.selectedComponent != null) {
            int rc = this.rightCurvComboBox.getSelectedIndex();
            int lc = this.leftCurvComboBox.getSelectedIndex();
            boolean lhp = lc == 3;
            boolean rhp = rc == 3;
            this.leftSphereRadiusTextField.setEnabled(!lhp);
            boolean state = enabled & !this.selectedComponent.values.symmetrical;
            this.rightSphereRadiusTextField.setEnabled(state && !rhp);
            this.rightCurvComboBox.setEnabled(state);
            boolean rhs = rc == 2;
            boolean lhs = lc == 2;
            this.rightZTextField.setEnabled(state && rhs);
            this.leftZTextField.setEnabled(lhs);
        }
    }

    double getDouble(String s) {
        return LocaleHandler.getDouble(s, LocaleHandler.localeDecimalSeparator);
    }

    void readProgramControls() {
        for (ProgramControl cm : this.programControlList.values()) {
            this.programValues.setOneValue(cm.getTag(), cm.getValue());
        }
        this.checkXSourcePlane();
        this.setupSelectedComponent();
    }

    void writeProgramControls() {
        for (ProgramControl cm : this.programControlList.values()) {
            cm.setValue(this.programValues.getOneValue(cm.getTag()));
        }
        this.setupSelectedComponent();
    }

    void setupSelectedComponent() {
        this.lensDesignControlPane.setVisible(this.programValues.showControls);
        if (this.selectedComponent != null) {
            this.selectedComponent.readObjectControls();
        }
        this.enableComponentControls(this.selectedComponent != null);
        this.updateGraphicDisplay();
    }

    void writeElementControls() {
        for (OpticalComponent e : this.componentList) {
            e.writeObjectControls();
        }
    }

    void checkXSourcePlane() {
        double x = this.programValues.xBeamSourceRefPlane;
        if (Math.abs(x) > this.programValues.virtualSpaceSize) {
            this.showNotifyMessage("The X source plane cannot lie outside the\nvirtual space box size -- adjusting value.", "X source outside domain");
            x = Math.max(x, -this.programValues.virtualSpaceSize);
            this.programValues.xBeamSourceRefPlane = x = Math.min(x, this.programValues.virtualSpaceSize);
            this.writeProgramControls();
        }
    }

    void makeNewObjectPopup(boolean moveToRight, double x, double y, int function) {
        OpticalComponent oc = this.makeNewComponent(moveToRight, function);
        Vector p = this.displayToSpace(x, y);
        oc.values.xPos = p.x + this.programValues.xOffset;
        oc.values.yPos = p.y + this.programValues.yOffset;
        oc.reconfigure();
        oc.writeObjectControls();
    }

    void makeNewLensPopup(double x, double y) {
        this.makeNewObjectPopup(false, x, y, 0);
    }

    void makeNewMirrorPopup(double x, double y) {
        this.makeNewObjectPopup(false, x, y, 1);
    }

    public void unSelectLens() {
        this.undoPush();
        this.clearSelection();
        this.updateGraphicDisplay();
    }

    void deleteSelectedLens() {
        if (this.selectedComponent != null) {
            boolean delete = false;
            if (this.programValues.askBeforeDeleting) {
                boolean[] reply = this.showConfirmMessage("Okay to delete " + this.selectedComponent.values.name + "?", "Delete Lens", "In future, delete without asking");
                if (reply[0]) {
                    delete = true;
                }
                if (reply[1]) {
                    this.programValues.askBeforeDeleting = false;
                }
            } else {
                delete = true;
            }
            if (delete) {
                this.componentList.remove(this.selectedComponent);
                this.clearSelection();
                this.updateGraphicDisplay();
            }
        }
    }

    boolean[] showConfirmMessage(String message, String title, String extra) {
        int reply = -1;
        boolean extraReply = false;
        if (extra.length() > 0) {
            JCheckBox checkbox = new JCheckBox(extra);
            Object[] params = new Object[]{message, checkbox};
            reply = JOptionPane.showConfirmDialog(this.frame, params, String.valueOf(this.appName) + ": " + title, 1);
            extraReply = checkbox.isSelected();
        } else {
            reply = JOptionPane.showConfirmDialog(this.frame, message, String.valueOf(this.appName) + ": " + title, 1);
        }
        return new boolean[]{reply == 0, extraReply};
    }

    void showNotifyMessage(String message, String title) {
        JOptionPane.showMessageDialog(this.frame, message, String.valueOf(this.appName) + ": " + title, 1);
    }

    void showNotifyMessageFormatted(String message, String title) {
        JTextArea ta = new JTextArea(message);
        ta.setBackground(this.frame.getBackground());
        Font f = new Font("Monospaced", 0, 11);
        ta.setFont(f);
        JOptionPane.showMessageDialog(this.frame, ta, String.valueOf(this.appName) + ": " + title, 1);
    }

    OpticalComponent makeNewComponent(String data, boolean moveToRight, int function) {
        this.undoPush();
        OpticalComponent oc = this.makeGenericComponent(data, function);
        if (moveToRight && this.componentList.size() > 0) {
            double ox = this.selectedComponent != null ? this.selectedComponent.values.xPos : 0.0;
            for (OpticalComponent v : this.componentList) {
                if (v.values.function == 2) continue;
                ox = Math.max(ox, v.values.xPos);
            }
            oc.values.xPos = ox + 1.0;
            oc.reconfigure();
        }
        this.componentList.add(oc);
        this.selectedComponent = oc;
        oc.snapToGrid();
        this.updateGraphicDisplay();
        return oc;
    }

    OpticalComponent makeNewComponent(boolean moveToRight, int function) {
        return this.makeNewComponent(null, moveToRight, function);
    }

    OpticalComponent makeGenericComponent(String data, int function) {
        return new OpticalComponent(this, data, function);
    }

    OpticalComponent makeGenericComponent(int function) {
        return new OpticalComponent(this, function);
    }

    void setDefaults(boolean newLenses) {
        ProgramValues pv = new ProgramValues();
        String config = pv.getValues();
        this.programValues.setValues(config);
        this.xSize = -1;
        this.ySize = -1;
        this.xCenter = -1;
        this.yCenter = -1;
        this.resetButtonColors();
        if (newLenses) {
            this.componentList = new ArrayList();
            this.makeDefaultObjects(true);
        }
        this.writeProgramControls();
        this.resetUndoRedo();
        this.clearSelection();
    }

    void makeDefaultObjects(boolean update) {
        if (this.componentList.size() == 0) {
            OpticalComponent oc = new OpticalComponent(this, 0);
            oc.values.xPos = 0.0;
            oc.reconfigure();
            this.componentList.add(oc);
            oc = new OpticalComponent(this, 0);
            oc.values.leftSphereRadius = -4.0;
            oc.values.rightSphereRadius = -4.0;
            oc.values.thickness = 1.4;
            oc.values.xPos = 2.0;
            oc.reconfigure();
            this.componentList.add(oc);
            oc = new OpticalComponent(this, 2);
            oc.values.xPos = 30.0;
            oc.values.lensRadius = 10.0;
            oc.values.name = "Terminal Plane";
            oc.reconfigure();
            this.componentList.add(oc);
            oc.snapToGrid();
            this.clearSelection();
            if (update) {
                this.updateGraphicDisplay();
            }
        }
    }

    protected String formatNum(double v) {
        return Double.isNaN(v) ? "-" : LocaleHandler.formatDouble(v, this.programValues.decimalPlaces);
    }

    void clipboardCopyImage() {
        double height = (double)this.gPaneDesign.getHeight() / (double)this.gPaneDesign.getWidth();
        int h = (int)((double)this.programValues.clipboardGraphicXSize * height);
        this.gPaneDesign.rayTraceProcessCore(this.programValues.clipboardGraphicXSize, h, true);
        ImageTransferable imt = new ImageTransferable(this.image);
        Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        clipboard.setContents(imt, null);
    }

    void clipboardCopyFullConfig() {
        String config = this.initManager.getFullConfiguration(true);
        this.setClipboardContents(config);
    }

    void clipboardCopyString(String s) {
        this.setClipboardContents(s);
    }

    void clipboardPasteFullConfig() {
        boolean[] reply;
        String data = this.getClipboardContents();
        if (data != null && (reply = this.showConfirmMessage("Okay to read full configuration (erases all current settings)?", "Read Full Configuration", ""))[0]) {
            this.initManager.setFullConfiguration(data);
            this.writeProgramControls();
        }
    }

    void setClipboardContents(String s) {
        StringSelection stringSelection = new StringSelection(s);
        Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        clipboard.setContents(stringSelection, this.frame);
    }

    String getClipboardContents() {
        String s = null;
        Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        Transferable content = clipboard.getContents(this);
        if (content != null) {
            try {
                s = (String)content.getTransferData(DataFlavor.stringFlavor);
            }
            catch (Exception e) {
                System.out.println("getClipboardContents2: " + e);
            }
        }
        return s;
    }

    void clipboardCutLens() {
        OpticalComponent lens = this.clipboardCopyLens();
        if (lens != null) {
            this.undoPush();
            this.componentList.remove(lens);
            this.clearSelection();
            this.updateGraphicDisplay();
        }
    }

    OpticalComponent clipboardCopyLens() {
        OpticalComponent lens = null;
        if (this.selectedComponent != null) {
            lens = this.selectedComponent;
            this.setClipboardContents(lens.toString());
        }
        return lens;
    }

    void clipboardPasteObject(boolean toMouse) {
        String s = this.getClipboardContents();
        if (s != null && !this.decodeMultiLensString(s)) {
            OpticalComponent newLens = new OpticalComponent(this, s, 0);
            if (newLens.valid) {
                this.undoPush();
                if (toMouse) {
                    Vector p = this.displayToSpace(this.popupMouseX, this.popupMouseY);
                    newLens.values.xPos = p.x + this.programValues.xOffset;
                    newLens.values.yPos = p.y + this.programValues.yOffset;
                }
                this.componentList.add(newLens);
                newLens.snapToGrid();
                this.setSelectedComponent(newLens);
                this.updateGraphicDisplay();
            }
        }
    }

    protected boolean decodeMultiLensString(String data) {
        boolean result = false;
        String s = "(?s)component \\{\\s*(.*?)\\s*\\}";
        Pattern pat = Pattern.compile(s);
        Matcher m = pat.matcher(data);
        while (m.find()) {
            String v = m.group(1);
            this.makeNewComponent(v, false, 0);
            result = true;
        }
        return result;
    }

    void eraseResetAll() {
        boolean[] reply = this.showConfirmMessage("Okay to reset program values and erase optical components\n(resets all entries and setting changes)?", "Reset All", "");
        if (reply[0]) {
            this.setDefaults(true);
        }
    }

    void eraseResetProgram() {
        boolean[] reply = this.showConfirmMessage("Okay to reset program values to defaults\n(preserves entered components)?", "Reset Program", "");
        if (reply[0]) {
            this.setDefaults(false);
        }
    }

    void resetUndoRedo() {
        this.undoStack.clear();
        this.redoStack.clear();
        this.updateUndoRedoButtons();
    }

    void limitUndoRedoStackSize() {
        while (this.undoStack.size() > this.undoRedoMaxStack) {
            this.undoStack.remove(0);
        }
        while (this.redoStack.size() > this.undoRedoMaxStack) {
            this.redoStack.remove(0);
        }
    }

    void undoPush() {
        if (this.undoFlag && this.redoFlag) {
            String current;
            String state = this.initManager.getFullConfiguration(false);
            String string = current = this.undoStack.size() > 0 ? (String)this.undoStack.lastElement() : "";
            if (!current.equals(state)) {
                this.undoStack.push(state);
            }
            this.updateUndoRedoButtons();
            this.limitUndoRedoStackSize();
        }
    }

    void redoPush() {
        if (this.redoFlag) {
            String current;
            String state = this.initManager.getFullConfiguration(false);
            String string = current = this.redoStack.size() > 0 ? (String)this.undoStack.lastElement() : "";
            if (!current.equals(state)) {
                this.redoStack.push(state);
            }
            this.updateUndoRedoButtons();
            this.limitUndoRedoStackSize();
        }
    }

    void undoPop() {
        if (this.undoStack.size() > 0 && this.undoFlag) {
            this.undoFlag = false;
            this.redoPush();
            this.initManager.setFullConfiguration(this.undoStack.pop());
            this.selectedComponent = null;
            this.updateUndoRedoButtons();
            this.undoFlag = true;
            this.updateGraphicDisplay();
            this.setupSelectedComponent();
        } else {
            Common.beep();
        }
    }

    void redoPop() {
        if (this.redoStack.size() > 0 && this.redoFlag) {
            this.undoPush();
            this.redoFlag = false;
            this.initManager.setFullConfiguration(this.redoStack.pop());
            this.selectedComponent = null;
            this.updateUndoRedoButtons();
            this.redoFlag = true;
            this.updateGraphicDisplay();
            this.setupSelectedComponent();
        } else {
            Common.beep();
        }
    }

    void updateUndoRedoButtons() {
        this.redoButton.setEnabled(this.redoStack.size() > 0);
        this.undoButton.setEnabled(this.undoStack.size() > 0);
    }

    void setSelectedLens(OpticalComponent p) {
        this.selectedComponent = p;
        this.setupSelectedComponent();
    }

    protected void copyLineList(boolean html) {
        String data = html ? this.lineAnalysis.makeHTMLTable(true) : this.lineAnalysis.makeCSVTable();
        this.setClipboardContents(data);
    }

    ComplexInt spaceToDisplay(double x, double y) {
        int dx = (int)((x - this.programValues.xOffset) * this.programValues.dispScale * (double)this.ySize + (double)this.xCenter);
        int dy = (int)((double)this.yCenter - (y - this.programValues.yOffset) * this.programValues.dispScale * (double)this.ySize);
        return new ComplexInt(dx, dy);
    }

    Vector displayToSpace(double dx, double dy) {
        double x = (dx - (double)this.xCenter) / (this.programValues.dispScale * (double)this.ySize);
        double y = ((double)this.yCenter - dy) / (this.programValues.dispScale * (double)this.ySize);
        return new Vector(x, y);
    }

    Vector displayToSpaceOffset(Vector p) {
        double x = (p.x - (double)this.xCenter) / (this.programValues.dispScale * (double)this.ySize) + this.programValues.xOffset;
        double y = ((double)this.yCenter - p.y) / (this.programValues.dispScale * (double)this.ySize) + this.programValues.yOffset;
        return new Vector(x, y);
    }

    void writeLog(String data) {
        try {
            String path = String.valueOf(System.getProperty("user.home")) + "/OPticalRayTracerDebugLog.txt";
            FileWriter fw = new FileWriter(path, true);
            fw.write(String.valueOf(data) + "\n");
            fw.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    protected void processTabChange() {
        switch (this.currentTab()) {
            case 2: {
                if (this.dataTableDisplay == null) break;
                this.dataTableDisplay.requestFocus();
                break;
            }
            case 1: {
                if (this.gPaneConfigure == null) break;
                this.gPaneConfigure.acquireFocus();
                break;
            }
            case 0: {
                if (this.gPaneDesign == null) break;
                this.gPaneDesign.acquireFocus();
            }
        }
    }

    public static void main(final String[] args) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                try {
                    OpticalRayTracer window = new OpticalRayTracer(args);
                    window.frame.setVisible(true);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
    }

    protected void exit() {
        this.readProgramControls();
        this.programValues.windowX = this.frame.getX();
        this.programValues.windowY = this.frame.getY();
        this.programValues.defaultWindowWidth = this.frame.getWidth();
        this.programValues.defaultWindowHeight = this.frame.getHeight();
        this.programValues.selectedTab = this.tabbedPane.getSelectedIndex();
        this.helpPanel.onQuit();
        this.initManager.writeConfig(true);
        this.frame.setVisible(false);
        this.frame.dispose();
    }

    private void initialize() {
        this.frame = new MyJFrame();
        this.frame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                OpticalRayTracer.this.exit();
            }
        });
        Dimension minSize = new Dimension(700, 500);
        this.frame.setBounds(100, 100, minSize.width, minSize.height);
        this.frame.setMinimumSize(new Dimension(900, 400));
        this.frame.setPreferredSize(new Dimension(900, 600));
        this.frame.setSize(minSize);
        this.frame.setDefaultCloseOperation(2);
        this.tabbedPane = new JTabbedPane(3);
        this.tabbedPane.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                OpticalRayTracer.this.processTabChange();
            }
        });
        this.tabbedPane.setTabLayoutPolicy(1);
        this.frame.getContentPane().add((Component)this.tabbedPane, "Center");
        this.designPane = new JPanel();
        this.designPane.setToolTipText("");
        this.designPane.setBackground(SystemColor.window);
        this.tabbedPane.addTab("Design", new ImageIcon(OpticalRayTracer.class.getResource("/opticalraytracer/icons/applications-graphics.png")), this.designPane, "Design elements and optical layout");
        this.designPane.setLayout(new BorderLayout(0, 0));
        JPanel controlPane = new JPanel();
        this.designPane.add((Component)controlPane, "South");
        controlPane.setLayout(new BorderLayout(0, 0));
        JToolBar toolBar = new JToolBar(String.valueOf(this.fullAppName) + " Program Controls");
        controlPane.add((Component)toolBar, "North");
        JButton newLensButton = new JButton("");
        newLensButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                OpticalRayTracer.this.makeNewComponent(true, 0);
            }
        });
        newLensButton.setToolTipText("Create new lens to right of existing objects");
        newLensButton.setIcon(new ImageIcon(OpticalRayTracer.class.getResource("/opticalraytracer/icons/document-new.png")));
        toolBar.add(newLensButton);
        JButton resetAllButton = new JButton("");
        resetAllButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                OpticalRayTracer.this.eraseResetAll();
            }
        });
        this.newMIrrorButton = new JButton("");
        this.newMIrrorButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                OpticalRayTracer.this.makeNewComponent(true, 1);
            }
        });
        this.newMIrrorButton.setToolTipText("Create new reflector/absorber to right of existing objects");
        this.newMIrrorButton.setIcon(new ImageIcon(OpticalRayTracer.class.getResource("/opticalraytracer/icons/view-fullscreen.png")));
        toolBar.add(this.newMIrrorButton);
        this.resetProgramButton = new JButton("");
        this.resetProgramButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                OpticalRayTracer.this.eraseResetProgram();
            }
        });
        this.resetProgramButton.setToolTipText("<html>Reset only program values<br/>(asks for confirmation)");
        this.resetProgramButton.setIcon(new ImageIcon(OpticalRayTracer.class.getResource("/opticalraytracer/icons/network-offline.png")));
        toolBar.add(this.resetProgramButton);
        resetAllButton.setToolTipText("<html>Reset everything : program values and optical components<br/>(asks for confirmation)");
        resetAllButton.setIcon(new ImageIcon(OpticalRayTracer.class.getResource("/opticalraytracer/icons/process-stop.png")));
        toolBar.add(resetAllButton);
        JButton copyImageButton = new JButton("");
        copyImageButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                OpticalRayTracer.this.clipboardCopyImage();
            }
        });
        copyImageButton.setToolTipText("Copy workspace graphic image to clipboard");
        copyImageButton.setIcon(new ImageIcon(OpticalRayTracer.class.getResource("/opticalraytracer/icons/applications-multimedia.png")));
        toolBar.add(copyImageButton);
        JButton copyConfigurationButton = new JButton("");
        copyConfigurationButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                OpticalRayTracer.this.clipboardCopyFullConfig();
            }
        });
        copyConfigurationButton.setToolTipText("Copy full configuration to clipboard");
        copyConfigurationButton.setIcon(new ImageIcon(OpticalRayTracer.class.getResource("/opticalraytracer/icons/edit-copy.png")));
        toolBar.add(copyConfigurationButton);
        JButton pasteConfigurationButton = new JButton("");
        pasteConfigurationButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                OpticalRayTracer.this.clipboardPasteFullConfig();
            }
        });
        pasteConfigurationButton.setToolTipText("<html>Paste full configuration from clipboard<br/>(Asks for confirmation)");
        pasteConfigurationButton.setIcon(new ImageIcon(OpticalRayTracer.class.getResource("/opticalraytracer/icons/edit-paste.png")));
        toolBar.add(pasteConfigurationButton);
        this.undoButton = new JButton("");
        this.undoButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                OpticalRayTracer.this.undoPop();
            }
        });
        this.undoButton.setIcon(new ImageIcon(OpticalRayTracer.class.getResource("/opticalraytracer/icons/edit-undo.png")));
        this.undoButton.setToolTipText("Undo most recent action");
        toolBar.add(this.undoButton);
        this.redoButton = new JButton("");
        this.redoButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                OpticalRayTracer.this.redoPop();
            }
        });
        this.redoButton.setToolTipText("Redo most recent undone action");
        this.redoButton.setIcon(new ImageIcon(OpticalRayTracer.class.getResource("/opticalraytracer/icons/edit-redo.png")));
        toolBar.add(this.redoButton);
        this.button = new JButton("");
        this.button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                OpticalRayTracer.this.selectNextObject();
            }
        });
        this.unselectButton = new JButton("");
        this.unselectButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                OpticalRayTracer.this.unSelectLens();
            }
        });
        this.unselectButton.setToolTipText("Clear present selection");
        this.unselectButton.setIcon(new ImageIcon(OpticalRayTracer.class.getResource("/opticalraytracer/icons/edit-clear.png")));
        toolBar.add(this.unselectButton);
        this.button.setToolTipText("Cycle through lens selections");
        this.button.setIcon(new ImageIcon(OpticalRayTracer.class.getResource("/opticalraytracer/icons/view-refresh.png")));
        toolBar.add(this.button);
        this.inverseCheckBox = new JCheckBox("Inverse");
        this.inverseCheckBox.setAlignmentY(0.53f);
        this.inverseCheckBox.setBorder(new CompoundBorder(new LineBorder(new Color(153, 153, 153)), new LineBorder(new Color(238, 238, 238), 8)));
        this.inverseCheckBox.setBorderPainted(true);
        this.inverseCheckBox.setToolTipText("Dark background");
        toolBar.add(this.inverseCheckBox);
        this.gridCheckBox = new JCheckBox("Grid");
        this.gridCheckBox.setAlignmentY(0.53f);
        this.gridCheckBox.setBorderPainted(true);
        this.gridCheckBox.setBorder(new CompoundBorder(new LineBorder(new Color(153, 153, 153)), new LineBorder(new Color(238, 238, 238), 8)));
        this.gridCheckBox.setSelected(true);
        this.gridCheckBox.setToolTipText("Show grid lines");
        toolBar.add(this.gridCheckBox);
        this.antiAliasCheckBox = new JCheckBox("Antialias");
        this.antiAliasCheckBox.setAlignmentY(0.53f);
        this.antiAliasCheckBox.setBorderPainted(true);
        this.antiAliasCheckBox.setBorder(new CompoundBorder(new LineBorder(new Color(153, 153, 153)), new LineBorder(new Color(238, 238, 238), 8)));
        this.antiAliasCheckBox.setSelected(true);
        this.antiAliasCheckBox.setToolTipText("Best appearance, slower drawing");
        toolBar.add(this.antiAliasCheckBox);
        this.showControlsCheckBox = new JCheckBox("Controls");
        this.showControlsCheckBox.setAlignmentY(0.53f);
        this.showControlsCheckBox.setBorderPainted(true);
        this.showControlsCheckBox.setBorder(new CompoundBorder(new LineBorder(new Color(153, 153, 153)), new LineBorder(new Color(238, 238, 238), 8)));
        this.showControlsCheckBox.setSelected(true);
        this.showControlsCheckBox.setToolTipText("Show/hide lens design control panel");
        toolBar.add(this.showControlsCheckBox);
        JButton quitButton = new JButton("");
        quitButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                OpticalRayTracer.this.exit();
            }
        });
        quitButton.setToolTipText("Quit OpticalRayTracer");
        quitButton.setIcon(new ImageIcon(OpticalRayTracer.class.getResource("/opticalraytracer/icons/application-exit.png")));
        toolBar.add(quitButton);
        this.lensDesignControlPane = new JPanel();
        controlPane.add((Component)this.lensDesignControlPane, "Center");
        this.lensDesignControlPane.setLayout(new MigLayout("", "[399px][492px]", "[110px][35px]"));
        JPanel westSubPanel = new JPanel();
        westSubPanel.setToolTipText("Optical element controls");
        westSubPanel.setBorder(new LineBorder(new Color(0, 0, 0)));
        this.lensDesignControlPane.add((Component)westSubPanel, "cell 0 0,alignx left,aligny top");
        westSubPanel.setLayout(new MigLayout("", "[111px][grow][][grow]", "[23px][][][][]"));
        this.lblName = new JLabel("Name");
        westSubPanel.add((Component)this.lblName, "cell 0 0,alignx left");
        this.nameTextField = new JTextField();
        this.nameTextField.setToolTipText("Distinctive names help organize complex optical configurations");
        westSubPanel.add((Component)this.nameTextField, "cell 1 0 3 1,growx");
        this.nameTextField.setColumns(10);
        JLabel lblLensRadius = new JLabel("Radius");
        westSubPanel.add((Component)lblLensRadius, "cell 0 1");
        this.lensRadiusTextField = new JTextField();
        this.lensRadiusTextField.setToolTipText("<html>Center-to-edge radius<br/>(red if value conflict exists)");
        this.lensRadiusTextField.setHorizontalAlignment(4);
        westSubPanel.add((Component)this.lensRadiusTextField, "cell 1 1");
        this.lensRadiusTextField.setColumns(10);
        JLabel lblX = new JLabel("X");
        westSubPanel.add((Component)lblX, "cell 2 2,alignx center");
        JLabel lblPosition = new JLabel("Position");
        westSubPanel.add((Component)lblPosition, "cell 3 1,alignx center");
        JLabel lblThickness = new JLabel("Edge Thickness");
        lblThickness.setHorizontalAlignment(2);
        westSubPanel.add((Component)lblThickness, "cell 0 2,alignx left");
        this.thicknessTextField = new JTextField();
        this.thicknessTextField.setToolTipText("<html>Element edge thickness<br/>(red if value conflict exists)");
        this.thicknessTextField.setHorizontalAlignment(4);
        westSubPanel.add((Component)this.thicknessTextField, "cell 1 2");
        this.thicknessTextField.setColumns(10);
        JLabel lblY = new JLabel("Y");
        westSubPanel.add((Component)lblY, "cell 2 3,alignx center");
        this.xPosTextField = new JTextField();
        westSubPanel.add((Component)this.xPosTextField, "cell 3 2");
        this.xPosTextField.setToolTipText("Lens X (horizontal) coordinate");
        this.xPosTextField.setHorizontalAlignment(4);
        this.xPosTextField.setColumns(10);
        this.lblEffectiveThickness = new JLabel("Effective Thickness");
        this.lblEffectiveThickness.setHorizontalAlignment(2);
        westSubPanel.add((Component)this.lblEffectiveThickness, "cell 0 3,alignx left");
        this.internalThicknessTextField = new JTextField();
        this.internalThicknessTextField.setEditable(false);
        this.internalThicknessTextField.setToolTipText("<html>Element edge thickness after crossover prevention<br/>(red if value conflict exists)");
        this.internalThicknessTextField.setHorizontalAlignment(4);
        this.internalThicknessTextField.setColumns(10);
        westSubPanel.add((Component)this.internalThicknessTextField, "cell 1 3,alignx right");
        this.yPosTextField = new JTextField();
        westSubPanel.add((Component)this.yPosTextField, "cell 3 3");
        this.yPosTextField.setToolTipText("Lens Y (vertical) coordinate");
        this.yPosTextField.setHorizontalAlignment(4);
        this.yPosTextField.setColumns(10);
        this.lblCenterThickness = new JLabel("Center Thickness");
        this.lblCenterThickness.setHorizontalAlignment(2);
        westSubPanel.add((Component)this.lblCenterThickness, "cell 0 4,alignx left");
        this.centerThicknessTextField = new JTextField();
        this.centerThicknessTextField.setToolTipText("Element center thickness (computed)");
        this.centerThicknessTextField.setHorizontalAlignment(4);
        this.centerThicknessTextField.setEditable(false);
        this.centerThicknessTextField.setColumns(10);
        westSubPanel.add((Component)this.centerThicknessTextField, "cell 1 4,growx");
        JPanel lensDesignControlBox = new JPanel();
        lensDesignControlBox.setToolTipText("Optical surface controls");
        lensDesignControlBox.setBorder(new LineBorder(new Color(0, 0, 0)));
        this.lensDesignControlPane.add((Component)lensDesignControlBox, "cell 1 0,grow");
        lensDesignControlBox.setLayout(new MigLayout("", "[][][][][][][]", "[][][][]"));
        this.symmetricalCheckBox = new JCheckBox("Sym");
        lensDesignControlBox.add((Component)this.symmetricalCheckBox, "cell 0 0");
        this.symmetricalCheckBox.setToolTipText("Make lens symmetrical (right and left the same)");
        JLabel lblSphereRadius = new JLabel("Sphere Radius");
        lblSphereRadius.setHorizontalAlignment(2);
        lensDesignControlBox.add((Component)lblSphereRadius, "cell 1 0,alignx center");
        JLabel lblSelectCurvature = new JLabel("Curvature Class");
        lensDesignControlBox.add((Component)lblSelectCurvature, "cell 2 0,alignx center");
        JLabel lblCurvatureFactor = new JLabel("Hyperbolic Factor");
        lblCurvatureFactor.setHorizontalAlignment(0);
        lensDesignControlBox.add((Component)lblCurvatureFactor, "cell 3 0,alignx center");
        JLabel lblLeft = new JLabel("Left");
        lensDesignControlBox.add((Component)lblLeft, "cell 0 1,alignx left");
        this.leftSphereRadiusTextField = new JTextField();
        this.leftSphereRadiusTextField.setToolTipText("<html>Radius of left sphere that constructs this lens<br/>(red if invalid value)");
        this.leftSphereRadiusTextField.setHorizontalAlignment(4);
        lensDesignControlBox.add((Component)this.leftSphereRadiusTextField, "cell 1 1");
        this.leftSphereRadiusTextField.setColumns(10);
        this.leftCurvComboBox = new JComboBox();
        this.leftCurvComboBox.setToolTipText("Left surface curvature class");
        lensDesignControlBox.add(this.leftCurvComboBox, "cell 2 1,alignx center");
        this.leftZTextField = new JTextField();
        this.leftZTextField.setToolTipText("Left hyperbolic curvature factor");
        this.leftZTextField.setHorizontalAlignment(4);
        lensDesignControlBox.add((Component)this.leftZTextField, "cell 3 1");
        this.leftZTextField.setColumns(10);
        JLabel lblRight = new JLabel("Right");
        lensDesignControlBox.add((Component)lblRight, "cell 0 2,alignx left");
        this.rightSphereRadiusTextField = new JTextField();
        this.rightSphereRadiusTextField.setToolTipText("<html>Radius of right sphere that constructs this lens<br/>(red if invalid value)");
        this.rightSphereRadiusTextField.setHorizontalAlignment(4);
        lensDesignControlBox.add((Component)this.rightSphereRadiusTextField, "cell 1 2");
        this.rightSphereRadiusTextField.setColumns(10);
        this.rightCurvComboBox = new JComboBox();
        this.rightCurvComboBox.setToolTipText("Right surface curvature class");
        lensDesignControlBox.add(this.rightCurvComboBox, "cell 2 2,alignx center");
        this.rightZTextField = new JTextField();
        this.rightZTextField.setToolTipText("Right hyperbolic curvature factor");
        this.rightZTextField.setHorizontalAlignment(4);
        lensDesignControlBox.add((Component)this.rightZTextField, "cell 3 2");
        this.rightZTextField.setColumns(10);
        this.activeCheckBox = new JCheckBox("Active");
        lensDesignControlBox.add((Component)this.activeCheckBox, "cell 0 3");
        this.activeCheckBox.setToolTipText("Include this component in the optical calculation");
        this.refractRadioButton = new JRadioButton("Refract");
        lensDesignControlBox.add((Component)this.refractRadioButton, "cell 1 3");
        this.refractRadioButton.setToolTipText("Refract all intersecting rays");
        this.refractRadioButton.setName("");
        this.typeButtonGroup.add(this.refractRadioButton);
        this.reflectRadioButton = new JRadioButton("Reflect");
        lensDesignControlBox.add((Component)this.reflectRadioButton, "cell 2 3");
        this.reflectRadioButton.setToolTipText("Reflect all intersecting rays");
        this.reflectRadioButton.setName("");
        this.typeButtonGroup.add(this.reflectRadioButton);
        this.absorbRadioButton = new JRadioButton("Absorb");
        lensDesignControlBox.add((Component)this.absorbRadioButton, "cell 3 3");
        this.absorbRadioButton.setToolTipText("Absorb all intersecting rays");
        this.absorbRadioButton.setName("");
        this.typeButtonGroup.add(this.absorbRadioButton);
        JPanel lensOptionsControlBox = new JPanel();
        lensOptionsControlBox.setToolTipText("Optical behavior/angle controls");
        lensOptionsControlBox.setBorder(new LineBorder(new Color(0, 0, 0)));
        this.lensDesignControlPane.add((Component)lensOptionsControlBox, "cell 0 1 2 1,growx,aligny top");
        lensOptionsControlBox.setLayout(new MigLayout("", "[][][][][][][][][]", "[]"));
        JLabel lblIor = new JLabel("IOR");
        lensOptionsControlBox.add((Component)lblIor, "cell 0 0");
        this.iorTextField = new JTextField();
        this.iorTextField.setToolTipText("Index of refraction");
        this.iorTextField.setHorizontalAlignment(4);
        lensOptionsControlBox.add((Component)this.iorTextField, "cell 1 0");
        this.iorTextField.setColumns(10);
        JLabel lblDispersion = new JLabel("Abbe number");
        lensOptionsControlBox.add((Component)lblDispersion, "cell 2 0");
        this.dispersionTextField = new JTextField();
        this.dispersionTextField.setToolTipText("Wavelength-dependent property of some media");
        this.dispersionTextField.setHorizontalAlignment(4);
        lensOptionsControlBox.add((Component)this.dispersionTextField, "cell 3 0");
        this.dispersionTextField.setColumns(10);
        JLabel lblAngle = new JLabel("Angle");
        lensOptionsControlBox.add((Component)lblAngle, "cell 4 0");
        this.angleTextField = new JTextField();
        this.angleTextField.setToolTipText("Lens rotation angle");
        this.angleTextField.setHorizontalAlignment(4);
        lensOptionsControlBox.add((Component)this.angleTextField, "cell 5 0");
        this.angleTextField.setColumns(10);
        this.configurePane = new JPanel();
        this.configurePane.setFocusTraversalKeysEnabled(false);
        this.tabbedPane.addTab("Configure", new ImageIcon(OpticalRayTracer.class.getResource("/opticalraytracer/icons/applications-accessories.png")), this.configurePane, "Set global options");
        this.tabbedPane.setDisplayedMnemonicIndexAt(1, 1);
        this.configurePane.setLayout(new BorderLayout(0, 0));
        JPanel controlBox = new JPanel();
        this.configurePane.add((Component)controlBox, "South");
        controlBox.setLayout(new BorderLayout(0, 0));
        this.colorToolBar = new JToolBar(String.valueOf(this.fullAppName) + " Program Colors");
        controlBox.add((Component)this.colorToolBar, "North");
        JPanel programControlPane = new JPanel();
        controlBox.add((Component)programControlPane, "Center");
        programControlPane.setLayout(new MigLayout("", "[][grow][][grow][][grow][][]", "[][][][][]"));
        JLabel lblIntersectionDotSize = new JLabel("Insersection arrow size");
        programControlPane.add((Component)lblIntersectionDotSize, "cell 0 0,alignx trailing");
        this.arrowSizeTextField = new JTextField();
        this.arrowSizeTextField.setToolTipText("These mark each beam interaction");
        this.arrowSizeTextField.setHorizontalAlignment(4);
        programControlPane.add((Component)this.arrowSizeTextField, "cell 1 0");
        this.arrowSizeTextField.setColumns(10);
        JLabel lblSnapValue = new JLabel("Snap-to-grid value");
        programControlPane.add((Component)lblSnapValue, "cell 2 0,alignx trailing");
        this.snapValueTextField = new JTextField();
        this.snapValueTextField.setToolTipText("A nonzero value causes lenses to align themselves to the grid");
        this.snapValueTextField.setHorizontalAlignment(4);
        programControlPane.add((Component)this.snapValueTextField, "cell 3 0");
        this.snapValueTextField.setColumns(10);
        JLabel lblBeamWidth = new JLabel("Beam width");
        programControlPane.add((Component)lblBeamWidth, "cell 4 0,alignx trailing");
        this.beamWidthTextField = new JTextField();
        this.beamWidthTextField.setHorizontalAlignment(4);
        programControlPane.add((Component)this.beamWidthTextField, "cell 5 0");
        this.beamWidthTextField.setColumns(10);
        JLabel lblNewLabel = new JLabel("Light beam Count");
        programControlPane.add((Component)lblNewLabel, "cell 0 1,alignx trailing");
        this.beamCountTextField = new JTextField();
        this.beamCountTextField.setHorizontalAlignment(4);
        programControlPane.add((Component)this.beamCountTextField, "cell 1 1");
        this.beamCountTextField.setColumns(10);
        JLabel lblSourceYStart = new JLabel("Source Y start");
        programControlPane.add((Component)lblSourceYStart, "cell 2 1,alignx trailing");
        this.yStartTextField = new JTextField();
        this.yStartTextField.setHorizontalAlignment(4);
        programControlPane.add((Component)this.yStartTextField, "cell 3 1");
        this.yStartTextField.setColumns(10);
        JLabel lblSourceYEnd = new JLabel("Source Y end");
        programControlPane.add((Component)lblSourceYEnd, "cell 4 1,alignx trailing");
        this.yEndTextField = new JTextField();
        this.yEndTextField.setHorizontalAlignment(4);
        programControlPane.add((Component)this.yEndTextField, "cell 5 1");
        this.yEndTextField.setColumns(10);
        JLabel lblInteractionCount = new JLabel("Maximum interactions");
        programControlPane.add((Component)lblInteractionCount, "cell 0 2,alignx trailing");
        this.interactionsTextField = new JTextField();
        this.interactionsTextField.setToolTipText("Number of interactions per beam");
        this.interactionsTextField.setHorizontalAlignment(4);
        programControlPane.add((Component)this.interactionsTextField, "cell 1 2");
        this.interactionsTextField.setColumns(10);
        JLabel lblXSourcePlane = new JLabel("X source plane");
        programControlPane.add((Component)lblXSourcePlane, "cell 2 2,alignx trailing");
        this.xSourcePlaneTextField = new JTextField();
        this.xSourcePlaneTextField.setHorizontalAlignment(4);
        programControlPane.add((Component)this.xSourcePlaneTextField, "cell 3 2");
        this.xSourcePlaneTextField.setColumns(10);
        JLabel lblXTargetPlane = new JLabel("X beam rotation plane");
        programControlPane.add((Component)lblXTargetPlane, "cell 4 2,alignx trailing");
        this.xTargetPlaneTextField = new JTextField();
        this.xTargetPlaneTextField.setToolTipText("The vertical plane around which the light beams rotate");
        this.xTargetPlaneTextField.setHorizontalAlignment(4);
        programControlPane.add((Component)this.xTargetPlaneTextField, "cell 5 2");
        this.xTargetPlaneTextField.setColumns(10);
        JLabel lblNewLabel_1 = new JLabel("Beam offset angle");
        programControlPane.add((Component)lblNewLabel_1, "cell 0 3,alignx trailing");
        this.beamOffsetTextField = new JTextField();
        this.beamOffsetTextField.setToolTipText("Allows beams to pass at an angle to the horizonal");
        this.beamOffsetTextField.setHorizontalAlignment(4);
        programControlPane.add((Component)this.beamOffsetTextField, "cell 1 3");
        this.beamOffsetTextField.setColumns(10);
        JLabel lblDispersionBeamCount = new JLabel("Dispersion beam count");
        programControlPane.add((Component)lblDispersionBeamCount, "cell 2 3,alignx trailing");
        this.dispersionCountTextField = new JTextField();
        this.dispersionCountTextField.setHorizontalAlignment(4);
        programControlPane.add((Component)this.dispersionCountTextField, "cell 3 3");
        this.dispersionCountTextField.setColumns(10);
        this.lblSurfaceEpsilon = new JLabel("Interlens Epsilon");
        programControlPane.add((Component)this.lblSurfaceEpsilon, "cell 4 3,alignx trailing");
        this.interLensEpsilonTextField = new JTextField();
        this.interLensEpsilonTextField.setToolTipText("This value tells the ray tracer how to distinguish between lens surfaces");
        this.interLensEpsilonTextField.setHorizontalAlignment(4);
        this.interLensEpsilonTextField.setColumns(10);
        programControlPane.add((Component)this.interLensEpsilonTextField, "cell 5 3");
        this.lblLensEpsilon = new JLabel("Surface Epsilon");
        programControlPane.add((Component)this.lblLensEpsilon, "cell 0 4,alignx trailing");
        this.surfaceEpsilonTextField = new JTextField();
        this.surfaceEpsilonTextField.setToolTipText("<html>This value represents an acceptance boundary around<br/>\n objects that allows them to be recognized by the ray tracer");
        this.surfaceEpsilonTextField.setHorizontalAlignment(4);
        programControlPane.add((Component)this.surfaceEpsilonTextField, "cell 1 4");
        this.surfaceEpsilonTextField.setColumns(10);
        this.lblSpaceBoxLimit = new JLabel("Virtual space box size");
        programControlPane.add((Component)this.lblSpaceBoxLimit, "cell 2 4,alignx trailing");
        this.spaceBoxLimitTextField = new JTextField();
        this.spaceBoxLimitTextField.setToolTipText("The space box size (\u00b1) in the X and Y dimensions");
        this.spaceBoxLimitTextField.setHorizontalAlignment(4);
        this.spaceBoxLimitTextField.setColumns(10);
        programControlPane.add((Component)this.spaceBoxLimitTextField, "cell 3 4");
        this.divergingBeamsCheckBox = new JCheckBox("Diverging beams");
        programControlPane.add((Component)this.divergingBeamsCheckBox, "cell 4 4 2 1");
        this.tablePane = new JPanel();
        this.tablePane.setBackground(Color.WHITE);
        this.tabbedPane.addTab("Table", new ImageIcon(OpticalRayTracer.class.getResource("/opticalraytracer/icons/x-office-spreadsheet.png")), this.tablePane, "Show a table of the current traced rays");
        this.tablePane.setLayout(new BorderLayout(0, 0));
        this.statusBar = new JPanel();
        this.statusBar.setBorder(new EmptyBorder(2, 4, 2, 0));
        this.statusBar.setToolTipText("Program status and cursor position");
        this.frame.getContentPane().add((Component)this.statusBar, "South");
        this.statusBar.setLayout(new BorderLayout(0, 0));
        this.statusLabel = new JLabel("Program Status");
        this.statusLabel.setFont(new Font("Courier", 1, 12));
        this.statusLabel.setHorizontalAlignment(2);
        this.statusBar.add(this.statusLabel);
    }
}

