/*
 * Decompiled with CFR 0.152.
 */
package opticalraytracer;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Polygon;
import java.util.ArrayList;
import java.util.Collections;
import opticalraytracer.Common;
import opticalraytracer.ComplexInt;
import opticalraytracer.IntersectionSortComparator;
import opticalraytracer.LineData;
import opticalraytracer.MyColor;
import opticalraytracer.OpticalComponent;
import opticalraytracer.OpticalRayTracer;
import opticalraytracer.ProgramValues;
import opticalraytracer.RayLensIntersection;
import opticalraytracer.Vector;
import opticalraytracer.WavelengthColor;

public final class RayTraceComputer {
    OpticalRayTracer parent;
    ProgramValues programValues;
    ArrayList<LineData> lineList;
    int testCount = 0;
    Vector[] arrowLines;

    public RayTraceComputer(OpticalRayTracer p) {
        this.parent = p;
        this.programValues = p.programValues;
        this.arrowLines = new Vector[]{new Vector(0.0, 0.0), new Vector(-1.0, 0.5), new Vector(-1.0, -0.5)};
    }

    void drawLenses(Graphics2D g) {
        for (OpticalComponent oc : this.parent.componentList) {
            oc.drawLens(g);
        }
    }

    void drawGrid(Graphics2D g) {
        double x;
        int k;
        double y;
        Vector p1 = this.parent.displayToSpaceOffset(new Vector(0.0, 0.0));
        Vector p2 = this.parent.displayToSpaceOffset(new Vector(this.parent.xSize, this.parent.ySize));
        double fact = 2.0;
        double e = Math.log(this.programValues.dispScale * fact) / Math.log(5.0) - 100.0;
        e = e - e % 1.0 + 100.0;
        double step = Math.pow(5.0, -e);
        double xstart = this.gridRound(p1.x, step) - step;
        double xend = p2.x + step;
        double ystart = this.gridRound(p2.y, step) - step;
        double yend = p1.y + step;
        MyColor col = new MyColor(this.programValues.colorGrid);
        g.setColor(col);
        ComplexInt i = new ComplexInt();
        int j = 0;
        while ((y = ystart + (double)j * step) <= yend) {
            k = 0;
            while ((x = xstart + (double)k * step) <= xend) {
                this.drawScaledLine(x, ystart, i, g, false);
                this.drawScaledLine(x, yend, i, g, true);
                ++k;
            }
            ++j;
        }
        j = 0;
        while ((x = xstart + (double)j * step) <= xend) {
            k = 0;
            while ((y = ystart + (double)k * step) <= yend) {
                this.drawScaledLine(xstart, y, i, g, false);
                this.drawScaledLine(xend, y, i, g, true);
                ++k;
            }
            ++j;
        }
    }

    double gridRound(double v, double modulus, boolean roundUp) {
        int sign = v < 0.0 ? -1 : 1;
        v = Math.abs(v);
        if (roundUp) {
            v += modulus;
        }
        v -= v % modulus;
        return v *= (double)sign;
    }

    void fillScaledPoint(Vector p, double radius, Graphics2D g, MyColor col) {
        boolean filled = true;
        radius = Math.abs(radius);
        g.setColor(col);
        ComplexInt ip = this.scalePoint(p);
        int r = (int)radius;
        if (filled) {
            g.fillOval(ip.x - r / 2, ip.y - r / 2, r, r);
        } else {
            g.drawOval(ip.x - r / 2, ip.y - r / 2, r, r);
        }
    }

    void drawArrowhead(Vector a, double angle, double radius, Graphics2D g, Color col) {
        if (a != null) {
            Polygon p = new Polygon();
            Vector[] vectorArray = this.arrowLines;
            int n = this.arrowLines.length;
            int n2 = 0;
            while (n2 < n) {
                Vector op = vectorArray[n2];
                Vector dp = op.scale(radius).rotate(angle).translate(a);
                ComplexInt ip = this.scalePoint(dp);
                p.addPoint(ip.x, ip.y);
                ++n2;
            }
            g.setColor(col);
            g.fillPolygon(p);
        }
    }

    void drawScaledLine(Vector p, ComplexInt op, Graphics2D g, boolean draw) {
        this.drawScaledLine(p.x, p.y, op, g, draw);
    }

    void drawScaledLine(double x, double y, ComplexInt op, Graphics2D g, boolean draw) {
        if (Double.isNaN(x) || Double.isNaN(y)) {
            return;
        }
        y = Math.min(y, this.parent.programValues.virtualSpaceSize);
        y = Math.max(y, -this.parent.programValues.virtualSpaceSize);
        x = Math.min(x, this.parent.programValues.virtualSpaceSize);
        x = Math.max(x, -this.parent.programValues.virtualSpaceSize);
        ComplexInt sp = this.scalePoint(x, y);
        if (draw) {
            g.drawLine(op.x, op.y, sp.x, sp.y);
        }
        op.assign(sp);
    }

    void addToPolygon(Polygon p, double x, double y) {
        ComplexInt p1 = this.scalePoint(x, y);
        p.addPoint(p1.x, p1.y);
    }

    ComplexInt scalePoint(double x, double y) {
        return this.parent.spaceToDisplay(x, y);
    }

    ComplexInt scalePoint(Vector p) {
        return this.parent.spaceToDisplay(p.x, p.y);
    }

    double gridRound(double v, double modulus) {
        return this.gridRound(v, modulus, false);
    }

    void drawBaselines(Graphics2D g) {
        double x1 = 0.0;
        double x2 = this.parent.xSize;
        double y = 0.0;
        Vector p1 = this.parent.displayToSpaceOffset(new Vector(x1, y));
        Vector p2 = this.parent.displayToSpaceOffset(new Vector(x2, y));
        MyColor col = new MyColor(this.programValues.colorBaseline);
        g.setColor(col);
        ComplexInt i = new ComplexInt();
        this.drawScaledLine(p1.x, y, i, g, false);
        this.drawScaledLine(p2.x, y, i, g, true);
        double y2 = this.parent.ySize;
        double x = 0.0;
        p1 = this.parent.displayToSpaceOffset(new Vector(x1, y));
        p2 = this.parent.displayToSpaceOffset(new Vector(x, y2));
        this.drawScaledLine(x, p1.y, i, g, false);
        this.drawScaledLine(x, p2.y, i, g, true);
    }

    public void traceRays(Graphics2D g2d, boolean collectLines) {
        if (collectLines) {
            this.lineList = new ArrayList();
        }
        double xSource = this.programValues.xBeamSourceRefPlane;
        double xTarget = this.programValues.xBeamRotationPlane;
        double ba = -this.programValues.beamAngle * (Math.PI / 180);
        double tba = Math.tan(ba) * (xSource - xTarget);
        double min = this.programValues.yStartBeamPos;
        double max = this.programValues.yEndBeamPos;
        double rmin = min + tba;
        double rmax = max + tba;
        double xs = this.programValues.xBeamSourceRefPlane;
        if (!collectLines) {
            g2d.setColor(new MyColor(this.programValues.colorLightSource));
            ComplexInt i = new ComplexInt();
            this.drawScaledLine(xs, rmin, i, g2d, false);
            this.drawScaledLine(xs, rmax, i, g2d, true);
        }
        if (xSource == xTarget) {
            Common.beep();
            return;
        }
        double count = Math.max(this.programValues.beamCount, 1);
        double topcount = Math.max(this.programValues.beamCount - 1, 1);
        int ray = 0;
        while ((double)ray < count && ray < this.parent.maxLightRays) {
            double y = Common.ntrp(ray, 0.0, topcount, min, max);
            double mya = this.programValues.divergingSource ? 0.0 : y;
            double myb = y;
            mya += tba;
            MyColor term = new MyColor(this.programValues.colorTerminator);
            MyColor pbcol = new MyColor(this.programValues.colorBeam);
            MyColor arrowCol = new MyColor(this.programValues.colorArrow);
            double pbalpha = (double)pbcol.getAlpha() / 255.0;
            if (this.programValues.dispersionBeams > 0) {
                int dbeam = 0;
                while (dbeam < this.programValues.dispersionBeams) {
                    double top = Math.max(this.programValues.dispersionBeams - 1, 1);
                    double h = Common.ntrp(dbeam, 0.0, top, 0.0, 1.0);
                    WavelengthColor cw = new WavelengthColor(h);
                    MyColor colorWavelength = new MyColor(cw.r, cw.g, cw.b, pbalpha);
                    this.traceOneRay(ray, dbeam, xSource, mya, xTarget, myb, g2d, this.parent.componentList, term, colorWavelength, arrowCol, cw.wvl, this.programValues.maxIntersections, collectLines);
                    ++dbeam;
                }
            } else {
                this.traceOneRay(ray, 0, xSource, mya, xTarget, myb, g2d, this.parent.componentList, term, pbcol, arrowCol, 0.0, this.programValues.maxIntersections, collectLines);
            }
            ++ray;
        }
    }

    boolean testIntersection(RayLensIntersection r) {
        return r.dot > 0.0 && r.m > this.parent.programValues.interLensEpsilon;
    }

    void traceOneRay(int ray, int dbeam, double x1, double y1, double x2, double y2, Graphics2D g2d, ArrayList<OpticalComponent> componentList, Color terminalColor, Color beamColor, Color arrowColor, double wavelength, int maxIntersections, boolean collectLines) {
        double initialBeamAngle;
        String oldEvent;
        double airIOR;
        double arrowRadius = this.programValues.intersectionArrowSize / Math.sqrt(this.programValues.dispScale);
        boolean drawing = true;
        ComplexInt op = new ComplexInt();
        double oldAngle = 0.0;
        Vector linea = new Vector(x1, y1);
        Vector lineb = new Vector(x2, y2);
        RayLensIntersection oldrli = null;
        RayLensIntersection rli = null;
        double oldIOR = airIOR = 1.0;
        boolean intersecting = true;
        boolean entering = true;
        boolean reflector = false;
        int rays = 0;
        String newEvent = oldEvent = "Beam Origin";
        oldAngle = initialBeamAngle = Math.atan2(lineb.y - linea.y, lineb.x - linea.x);
        boolean internalReflection = false;
        while (intersecting && rays++ < maxIntersections) {
            ArrayList<RayLensIntersection> intersections = new ArrayList<RayLensIntersection>();
            for (OpticalComponent lens : componentList) {
                if (!lens.values.active) continue;
                int i = 0;
                while (i <= 1) {
                    lens.computeIntersections(oldrli, lens, i == 0, linea, lineb);
                    for (Vector pt : lens.getElement(i == 0).getPoints()) {
                        if (!lens.inside(pt, lens.opticalTestPolygon)) continue;
                        intersections.add(new RayLensIntersection(linea, lineb, wavelength, pt, i == 0, lens));
                    }
                    ++i;
                }
            }
            if (!collectLines) {
                this.drawArrowhead(linea, oldAngle, arrowRadius, g2d, wavelength != 0.0 ? beamColor : arrowColor);
            }
            oldrli = rli;
            rli = null;
            Collections.sort(intersections, new IntersectionSortComparator());
            double n = 0.0;
            double len = intersections.size();
            boolean debugIntersections = false;
            for (RayLensIntersection r : intersections) {
                MyColor cc = null;
                if (debugIntersections) {
                    cc = WavelengthColor.hToRGB(n * len / 2.0);
                    cc = new MyColor(cc.getRGB(), 64);
                    if (this.testIntersection(r)) {
                        if (rli == null) {
                            rli = r;
                            cc = new MyColor(65280);
                        } else {
                            cc = new MyColor(-2130771713);
                        }
                        if (!debugIntersections) break;
                    }
                    if (debugIntersections && !collectLines) {
                        this.fillScaledPoint(r.p, 8.0, g2d, cc);
                    }
                } else if (this.testIntersection(r)) {
                    rli = r;
                    break;
                }
                n += 1.0;
            }
            boolean bl = intersecting = rli != null;
            if (!collectLines) {
                g2d.setColor(beamColor);
            }
            if (intersecting) {
                double n1 = oldIOR;
                double n2 = oldIOR;
                reflector = rli.function == 1;
                internalReflection = false;
                if (!collectLines) {
                    this.drawScaledLine(linea, op, g2d, false);
                    this.drawScaledLine(rli.p, op, g2d, true);
                }
                Vector via = lineb.sub(linea).normalize();
                oldAngle = via.angle();
                double la = rli.lens.angleRadians();
                if (rli.function != 2) {
                    double dx = rli.lens.tangent(rli.leftSide, entering, rli.p, la, reflector);
                    Vector vsa = Vector.polar(Math.atan2(1.0, dx) + 1.5707963267948966).rotate(la);
                    Vector sr = null;
                    if (reflector) {
                        newEvent = "Reflection";
                        sr = Common.computeReflectionAngle(via, vsa);
                    } else {
                        double abbe = rli.lens.values.dispersion;
                        double mediaIOR = wavelength == 0.0 || abbe == 0.0 ? rli.lens.values.ior : WavelengthColor.dispersionIndex(rli.lens.values.ior, wavelength, abbe);
                        n2 = entering ? mediaIOR : airIOR;
                        sr = Common.snell2d(via, vsa, n1, n2);
                        if (!sr.isValid()) {
                            internalReflection = true;
                            newEvent = "Internal Reflection";
                            sr = Common.computeReflectionAngle(via, vsa);
                        } else {
                            newEvent = "Refraction";
                        }
                    }
                    if (collectLines) {
                        this.lineList.add(new LineData(ray, dbeam, wavelength, oldrli, rli, linea, rli.p, vsa.angle(), oldEvent, newEvent));
                    }
                    linea = new Vector(rli.p);
                    lineb = linea.add(sr);
                    if (!reflector && !internalReflection) {
                        entering = !entering;
                        oldIOR = n2;
                    }
                } else {
                    newEvent = "Absorption";
                    if (!collectLines) {
                        this.drawArrowhead(rli.p, oldAngle, arrowRadius, g2d, terminalColor);
                    } else {
                        this.lineList.add(new LineData(ray, dbeam, wavelength, oldrli, rli, linea, rli.p, 0.0, oldEvent, newEvent));
                    }
                    drawing = false;
                    intersecting = false;
                }
            }
            oldEvent = newEvent;
        }
        if (drawing) {
            newEvent = rays >= maxIntersections ? "Maximum Interaction Limit" : "Termination";
            double xq1 = lineb.x - linea.x > 0.0 ? this.programValues.virtualSpaceSize : -this.programValues.virtualSpaceSize;
            double yq1 = Common.ntrp(xq1, linea.x, lineb.x, linea.y, lineb.y);
            double yq2 = lineb.y - linea.y > 0.0 ? this.programValues.virtualSpaceSize : -this.programValues.virtualSpaceSize;
            double xq2 = Common.ntrp(yq2, linea.y, lineb.y, linea.x, lineb.x);
            Vector p = Math.abs(yq1) > Math.abs(xq2) ? new Vector(xq2, yq2) : new Vector(xq1, yq1);
            if (!collectLines) {
                g2d.setColor(beamColor);
                this.drawScaledLine(linea, op, g2d, false);
                this.drawScaledLine(p, op, g2d, true);
                double angle = Math.atan2(p.y - linea.y, p.x - linea.x);
                this.drawArrowhead(p, angle, arrowRadius, g2d, terminalColor);
            } else {
                this.lineList.add(new LineData(ray, dbeam, wavelength, oldrli, rli, linea, p, 0.0, oldEvent, newEvent));
            }
        }
    }
}

