/*
 * Decompiled with CFR 0.152.
 */
package opticalraytracer;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collections;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import opticalraytracer.LocaleHandler;

public class ValueManager {
    String lineSep = System.getProperty("line.separator");

    void p(String s) {
        System.out.println(s);
    }

    protected String getValues() {
        Field[] fields;
        ArrayList<String> list = new ArrayList<String>();
        Field[] fieldArray = fields = this.getClass().getDeclaredFields();
        int n = fields.length;
        int n2 = 0;
        while (n2 < n) {
            Field f = fieldArray[n2];
            String tag = f.getName();
            list.add(String.format("  %-25s = %s%s", tag, this.getOneValue(tag), this.lineSep));
            ++n2;
        }
        Collections.sort(list);
        StringBuilder sb = new StringBuilder();
        for (String s : list) {
            sb.append(s);
        }
        return sb.toString();
    }

    protected String getOneValue(String tag) {
        String result = "";
        try {
            Field f = this.getClass().getDeclaredField(tag);
            Class<?> cls = f.getType();
            result = cls == Double.TYPE ? LocaleHandler.formatDouble(f.getDouble(this)) : (cls == Integer.TYPE ? LocaleHandler.formatInt(f.getInt(this)) : f.get(this).toString());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    public String toString() {
        return this.getValues();
    }

    protected boolean setValues(String s) {
        boolean result = false;
        if (s != null) {
            String[] recs;
            String[] stringArray = recs = s.split("\n");
            int n = recs.length;
            int n2 = 0;
            while (n2 < n) {
                String rec = stringArray[n2];
                rec = rec.trim();
                Pattern p = Pattern.compile("(.*?)\\s*=\\s*(.*)");
                Matcher m = p.matcher(rec);
                if (m.matches() && m.groupCount() == 2) {
                    String key = m.group(1).trim();
                    String value = m.group(2).trim();
                    this.setOneValue(key, value);
                    result = true;
                }
                ++n2;
            }
        }
        return result;
    }

    protected void setOneValue(String tag, String value) {
        try {
            Field f = this.getClass().getDeclaredField(tag);
            Class<?> cls = f.getType();
            if (cls == Boolean.TYPE) {
                f.setBoolean(this, value.matches("(?i).*true.*"));
            } else if (cls == Integer.TYPE) {
                f.setInt(this, LocaleHandler.getInt(value));
            } else if (cls == Double.TYPE) {
                f.setDouble(this, LocaleHandler.getDouble(value, LocaleHandler.localeDecimalSeparator));
            } else if (cls == String.class) {
                f.set(this, value);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

