/***************************************************************************
 *   Copyright (C) 2009 by Paul Lutus                                      *
 *   lutusp@arachnoid.com                                                  *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

package plcalc;

import java.awt.event.*;
import javax.swing.*;

/**
 *
 * @author lutusp
 */
public class BaseConv {

    PLCalcMainPanel parent;
    JTextField controls[];
    int radices[] = {2, 8, 10, 16};
    String entries[] = new String[]{"", "", "", ""};

    public BaseConv(PLCalcMainPanel p) {
        parent = p;
        controls = new JTextField[]{parent.BinaryField, parent.OctalField, parent.DecimalField, parent.HexField};
    }

    public void process(KeyEvent evt, int n) {
        evt.consume();
        int kc = evt.getKeyCode();
        char c = evt.getKeyChar();
        int radix = radices[n];
        String s = entries[n];
        int len = s.length();
        if (kc == KeyEvent.VK_BACK_SPACE) { // backspace
            if (len > 0) {
                s = s.substring(0, len - 1);
            }
        } else {
            s += c;
        }
        String os = s;
        long value = 0;
        boolean fail;
        do {
            fail = false;
            try {
                value = Long.valueOf(s, radix).longValue();
            } catch (NumberFormatException e) {
                fail = true;
                len = s.length();
                if (len > 0) {
                    s = s.substring(0, len - 1);
                }
            }
        } while (fail && s.length() > 0);
        if (!os.equals(s)) {
            parent.setStatus("Radix Error", true);
        } else {
            parent.setStatus("OK", false);
        }
        entries[n] = s;
        // now generate all bases
        for (int i = 0; i < controls.length; i++) {
            String ss = (value > 0) ? Long.toString(value, radices[i]) : "";
            controls[i].setText(ss);
        }
    }
}
