/*
 * Decompiled with CFR 0.152.
 */
import java.util.Collections;
import java.util.TreeMap;
import java.util.Vector;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;

public final class Account {
    static final int TYPE_BANK = 0;
    static final int TYPE_CASH = 1;
    static final int TYPE_CCARD = 2;
    static final int TYPE_INVESTMENT = 3;
    static final int TYPE_ASSET = 4;
    static final int TYPE_LIABILITY = 5;
    static final int TYPE_CLASS = 6;
    static final int TYPE_CATEGORY = 7;
    static final int TYPE_SECURITY = 8;
    static final int TYPE_MEMORIZED = 9;
    static final int TYPE_PRICES = 10;
    static final int PREFIX_ACCOUNT = 0;
    static final int PREFIX_CLASS = 1;
    static final int PREFIX_CATEGORY = 2;
    static final int PREFIX_SECURITY = 3;
    static final int PREFIX_MEMORIZED = 4;
    static final int PREFIX_PRICES = 5;
    public static final String[] accountTagQIF = new String[]{"Bank", "Cash", "CCard", "Invst", "Oth A", "Oth L", "Class", "Cat", "Security", "Memorized", "Prices"};
    public static final String[] accountName = new String[]{"Bank", "Cash", "Credit Card", "Investment", "Asset", "Liability", "Class", "Category", "Security", "MemorizedTransaction", "Prices"};
    static final String[] prefixName = new String[]{"Account", "Class", "Category", "MemorizedTransaction", "Prices"};
    public TreeMap acctQIFData;
    public Vector transactionList;
    public String filePath = "";
    public String db_Name = "";
    public String db_FileName = null;
    public String db_Type = "Bank";
    public String db_SubType = "";
    public int db_CheckNumber = 0;
    public int db_Transactions = 0;
    public String db_Description = "";
    public String db_Security = "";
    public double db_CreditLimit = 0.0;
    public boolean db_OneLineMode = false;
    public boolean db_ShowInList = true;
    public boolean db_IncludeTotalInList = true;
    public int db_DefaultTransactionMode = 0;
    public double db_ShareBalance = 0.0;
    public double db_MostRecentAccountPrice = 0.0;
    public long db_MostRecentAccountPriceDate = 0L;
    public double db_MostRecentPrice = 0.0;
    public long db_MostRecentPriceDate = 0L;
    public double db_Balance = 0.0;
    public long db_StatementBalanceDate = 0L;
    public double db_StatementBalance = 0.0;
    public int db_DefaultAction = 1;
    public int type = -1;
    private boolean fileRead = false;
    private boolean dataChanged = false;
    public AccountDisplay accountDisplay = null;
    int smallestAffectedRow = 0;
    private boolean transactionListUnsorted = true;
    SplitTransaction split = null;
    long mostRecentDate = 0L;
    PLCash parent = null;

    public Account(PLCash pLCash) {
        this.parent = pLCash;
        this.transactionList = new Vector();
    }

    public void setParent(PLCash pLCash) {
        this.parent = pLCash;
    }

    public AccountDisplay getAccountDisplay(final int n) {
        if (this.accountDisplay == null) {
            this.accountDisplay = new AccountDisplay(this, this.parent, n < 0);
        }
        if (n >= 0) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    Account.this.accountDisplay.scrollToTransaction(n, true);
                    Account.this.accountDisplay.tableFocus();
                }
            });
        }
        return this.accountDisplay;
    }

    public AccountDisplay getAccountDisplay() {
        return this.getAccountDisplay(-1);
    }

    public void whenDataChanged() {
        this.refreshTable();
        this.setDataChanged();
    }

    public void setDataChanged() {
        this.dataChanged = true;
    }

    public void clearDataChanged() {
        this.dataChanged = false;
    }

    public void setFileRead() {
        this.fileRead = true;
    }

    public void clearFileRead() {
        this.fileRead = false;
    }

    public void close() {
        this.writeTSV();
        this.transactionList = new Vector();
        this.accountDisplay = null;
        this.fileRead = false;
        this.smallestAffectedRow = 0;
        System.gc();
    }

    public void refreshTable() {
        this.transactionListUnsorted = true;
        this.smallestAffectedRow = 0;
        this.getBalance();
        if (this.accountDisplay != null) {
            this.accountDisplay.setupDisplay();
        }
    }

    public int binarySearch(Transaction transaction) {
        this.getBalance();
        return Collections.binarySearch(this.transactionList, transaction);
    }

    public Transaction getTransaction(int n) {
        this.getBalance();
        if (n >= 0 && n < this.transactionList.size()) {
            return (Transaction)this.transactionList.get(n);
        }
        Transaction transaction = new Transaction(this.parent, this, this.type);
        transaction.balance = this.db_Balance;
        transaction.db_Price = this.db_MostRecentPrice;
        transaction.db_Security = this.db_Security;
        if (this.mostRecentDate != 0L) {
            transaction.setTime(this.mostRecentDate);
        }
        return transaction;
    }

    public void deleteTransaction(Transaction transaction, boolean bl, boolean bl2) {
        this.getBalance();
        if (transaction != null) {
            if (bl2) {
                this.parent.commonCode.deleteExistingLinks(this.parent.accountHandler.dataMap, this, transaction);
            }
            if (this.transactionList.indexOf(transaction) == -1) {
                // empty if block
            }
            this.transactionList.remove(transaction);
            this.setDataChanged();
            if (bl) {
                this.whenDataChanged();
            }
        }
    }

    public void addTransaction(Transaction transaction, boolean bl, boolean bl2) {
        if (this.type == 3 && !bl2) {
            double d = this.db_MostRecentPrice != 0.0 ? this.db_MostRecentPrice : 1.0;
            transaction.db_Shares = transaction.db_Amount / d;
            transaction.db_Price = d;
            transaction.db_Security = this.db_Security;
            transaction.db_Number = transaction.db_Amount < 0.0 ? "SellX" : "BuyX";
        }
        this.getTransactionList().add(transaction);
        long l = transaction.getTime();
        long l2 = this.mostRecentDate = l > 0L ? l : this.mostRecentDate;
        if (bl2) {
            this.parent.commonCode.createRequiredLinks(this.parent.accountHandler.dataMap, this, transaction);
        }
        if (bl) {
            this.whenDataChanged();
        }
        if (this.accountDisplay != null) {
            int n = this.transactionList.indexOf(transaction);
            this.accountDisplay.scrollToTransaction(n, true);
        }
    }

    public int indexOf(Transaction transaction) {
        return this.transactionList.indexOf(transaction);
    }

    public boolean deleteTransactions(Integer[] integerArray, boolean bl) {
        boolean bl2 = false;
        this.getBalance();
        int n = integerArray.length;
        if (n == 0) {
            this.parent.beep();
            return bl2;
        }
        this.parent.beep();
        int n2 = JOptionPane.showConfirmDialog(null, "Okay to delete " + n + " transaction(s)?", "Delete Transactions from " + this.db_Name, 1);
        if (n2 == 0) {
            for (int i = integerArray.length - 1; i >= 0; --i) {
                int n3 = integerArray[i];
                if (bl) {
                    Transaction transaction = (Transaction)this.transactionList.get(n3);
                    this.parent.commonCode.deleteExistingLinks(this.parent.accountHandler.dataMap, this, transaction);
                }
                this.transactionList.remove(n3);
                bl2 = true;
            }
            this.whenDataChanged();
        }
        return bl2;
    }

    public static int typeForTag(String string) {
        for (int i = 0; i < accountTagQIF.length; ++i) {
            if (!string.equals(accountTagQIF[i])) continue;
            return i;
        }
        return -1;
    }

    public static int typeForName(String string) {
        for (int i = 0; i < accountName.length; ++i) {
            if (!string.equals(accountName[i])) continue;
            return i;
        }
        return -1;
    }

    public static String nameForType(int n) {
        return accountName[n];
    }

    public static String tagForType(int n) {
        return accountTagQIF[n];
    }

    public static int prefixForType(int n) {
        int n2 = -1;
        switch (n) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                n2 = 0;
                break;
            }
            case 6: {
                n2 = 1;
                break;
            }
            case 7: {
                n2 = 2;
                break;
            }
            case 8: {
                n2 = 3;
                break;
            }
            case 9: {
                n2 = 4;
                break;
            }
            case 10: {
                n2 = 5;
                break;
            }
        }
        return n2;
    }

    public Vector getTransactionList() {
        this.getBalance();
        return this.transactionList;
    }

    private void maybeSort() {
        if (this.transactionListUnsorted) {
            Collections.sort(this.transactionList);
            this.transactionListUnsorted = false;
            this.smallestAffectedRow = 0;
        }
    }

    public int size() {
        this.getBalance();
        return this.transactionList.size();
    }

    public Transaction getLastTransaction() {
        this.getBalance();
        Transaction transaction = null;
        if (this.size() > 0) {
            transaction = this.getTransaction(this.transactionList.size() - 1);
        }
        return transaction;
    }

    public void getBalance() {
        boolean bl;
        this.readTSV();
        this.maybeSort();
        int n = this.transactionList.size();
        double d = 0.0;
        long l = 0L;
        double d2 = 0.0;
        double d3 = 0.0;
        String string = "";
        boolean bl2 = bl = this.type == 3;
        if (this.smallestAffectedRow > 0) {
            Transaction transaction = (Transaction)this.transactionList.get(this.smallestAffectedRow - 1);
            d2 = transaction.balance;
            d3 = transaction.shareBalance;
            if (transaction.db_Price > 0.0) {
                d = transaction.db_Price;
                l = transaction.getTime();
            }
        }
        this.db_Transactions = this.transactionList.size();
        for (int i = this.smallestAffectedRow; i < this.db_Transactions; ++i) {
            Transaction transaction = (Transaction)this.transactionList.get(i);
            transaction.balance = d2 += transaction.db_Amount;
            if (!bl) continue;
            transaction.shareBalance = d3 += transaction.db_Shares;
            if (!(transaction.db_Price > 0.0)) continue;
            d = transaction.db_Price;
            l = transaction.getTime();
        }
        this.smallestAffectedRow = this.transactionList.size();
        this.db_ShareBalance = d3;
        if (bl) {
            this.db_MostRecentAccountPrice = d;
            this.db_MostRecentAccountPriceDate = l;
            this.db_ShareBalance = d3;
            this.adjustPriceComputeBalance();
        } else {
            this.db_Balance = d2;
        }
    }

    public void adjustPriceComputeBalance() {
        if (this.db_MostRecentPriceDate <= this.db_MostRecentAccountPriceDate) {
            this.db_MostRecentPrice = this.db_MostRecentAccountPrice;
            this.db_MostRecentPriceDate = this.db_MostRecentAccountPriceDate;
        }
        double d = (double)((int)((this.db_ShareBalance + 5.0E-4) * 1000.0)) / 1000.0;
        this.db_Balance = this.db_MostRecentPrice * d;
    }

    public static String createAccountFileName(int n, String string) {
        if (n < 0) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(prefixName[Account.prefixForType(n)]);
        stringBuffer.append("_");
        stringBuffer.append(Account.nameForType(n));
        stringBuffer.append("_");
        stringBuffer.append(string);
        stringBuffer = new StringBuffer(stringBuffer.toString().replaceAll("[^a-zA-Z0-9\\-]", "_"));
        stringBuffer.append(".tsv");
        return stringBuffer.toString();
    }

    public void createAccountFileName() {
        this.db_FileName = Account.createAccountFileName(this.type, this.db_Name);
    }

    public String toString() {
        return this.db_Name;
    }

    public void writeTSV() {
        if (this.dataChanged) {
            this.refreshTable();
            this.writeTSVFile(this.transactionList, this.getFullFilePath(), new Transaction(this.parent), "db_");
            this.clearDataChanged();
        }
    }

    public void writeTSVFile(Vector vector, String string, Object object, String string2) {
        this.parent.dataFileManager.writeDataTable(string, vector, object, string2);
    }

    public String getFullFilePath() {
        return this.filePath + "/" + this.db_FileName;
    }

    public void readTSV() {
        if (!this.fileRead) {
            this.fileRead = this.readTSVFile(this, this.transactionList, this.filePath, this.db_FileName, this.type, "db_");
            if (this.transactionList.size() > 0) {
                this.initializeAllTransactions(true);
            }
        }
    }

    public void initializeAllTransactions(boolean bl) {
        for (int i = 0; i < this.transactionList.size(); ++i) {
            Transaction transaction = (Transaction)this.transactionList.get(i);
            transaction.parent = this.parent;
            if (bl) {
                transaction.timeForDbDate();
            }
            transaction.init(this, this.type);
        }
        this.transactionListUnsorted = true;
    }

    public boolean readTSVFile(Account account, Vector vector, String string, String string2, int n, String string3) {
        boolean bl = false;
        if (vector.size() > 0) {
            return true;
        }
        if (string != null && string2 != null) {
            String string4 = string + "/" + string2;
            if (string4.indexOf(".tsv") == -1) {
                string4 = string4 + ".tsv";
            }
            Transaction transaction = new Transaction(this.parent, this);
            Vector vector2 = new Vector();
            bl = this.parent.dataFileManager.readDataTable(string4, vector2, (Object)transaction, string3);
            vector.addAll(vector2);
        }
        return bl;
    }

    public void setType(int n) {
        this.type = n;
        this.db_Type = Account.nameForType(n);
    }

    public void setType(String string) {
        this.db_Type = string;
        this.type = Account.typeForName(string);
    }

    public void createFromQIFData(TreeMap treeMap) {
        boolean bl;
        this.readTSV();
        Transaction transaction = new Transaction(this.parent, this, this.type);
        String string = this.parent.commonCode.safeTreeGet(treeMap, "D");
        long l = this.parent.commonCode.timeForQIFDate(string);
        transaction.setTime(l);
        transaction.db_Number = this.parent.commonCode.safeTreeGet(treeMap, "N");
        transaction.db_Amount = this.parent.commonCode.zeroFailParseDouble(this.parent.commonCode.safeTreeGet(treeMap, "T"));
        transaction.db_Payee = this.parent.commonCode.safeTreeGet(treeMap, "P");
        transaction.db_Memo = this.parent.commonCode.safeTreeGet(treeMap, "M");
        transaction.db_Category = this.parent.commonCode.safeTreeGet(treeMap, "L");
        transaction.db_Cleared = this.parent.commonCode.safeTreeGet(treeMap, "C").toLowerCase().equals("x");
        boolean bl2 = bl = transaction.db_Amount > 0.0;
        if (this.type == 3) {
            boolean bl3;
            transaction.db_Price = this.parent.commonCode.zeroFailParseDouble(this.parent.commonCode.safeTreeGet(treeMap, "I"));
            transaction.db_Shares = this.parent.commonCode.zeroFailParseDouble(this.parent.commonCode.safeTreeGet(treeMap, "Q"));
            transaction.db_Commission = this.parent.commonCode.zeroFailParseDouble(this.parent.commonCode.safeTreeGet(treeMap, "O"));
            transaction.db_Security = this.parent.commonCode.safeTreeGet(treeMap, "Y");
            if (this.db_Security.length() == 0 && transaction.db_Security.length() > 0) {
                this.db_Security = transaction.db_Security;
            }
            if (bl3 = this.parent.commonCode.isSale(transaction.db_Number)) {
                transaction.db_Shares = -Math.abs(transaction.db_Shares);
                transaction.db_Amount = -Math.abs(transaction.db_Amount);
                bl = !bl3;
            }
        }
        this.parent.qifFileHandler.decodeSplits(treeMap, transaction);
        this.parent.qifFileHandler.decodeAddress(treeMap, transaction);
        this.transactionList.add(transaction);
        this.setDataChanged();
        this.transactionListUnsorted = true;
    }
}

