/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.lang.reflect.Field;
import java.util.TreeMap;
import java.util.Vector;

public final class DataFileManager {
    final String lineSep = System.getProperty("line.separator");
    private final String delim = "\t";
    PLCash parent;

    public DataFileManager(PLCash pLCash) {
        this.parent = pLCash;
    }

    public void writeObjectToFile(String string, Object object, String string2) {
        try {
            FileWriter fileWriter = new FileWriter(string);
            this.parent.commonCode.testFileAccess(new File(string));
            Field[] fieldArray = object.getClass().getFields();
            String[] stringArray = this.getFieldNames(fieldArray, string2);
            String[] stringArray2 = this.getHeaderNames(stringArray, string2);
            for (int i = 0; i < stringArray.length; ++i) {
                Field field = object.getClass().getDeclaredField(stringArray[i]);
                String string3 = stringArray2[i] + "=" + this.getFieldValueAsString(field, object);
                fileWriter.write(string3);
                fileWriter.write(this.lineSep);
            }
            fileWriter.close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public Vector readObjectFromFile(String string, Object object, String string2) {
        Vector vector = new Vector();
        try {
            File file = new File(string);
            if (!this.parent.commonCode.testFileAccess(file)) {
                return vector;
            }
            if (file.exists()) {
                String string3;
                BufferedReader bufferedReader = new BufferedReader(new FileReader(string));
                while ((string3 = bufferedReader.readLine()) != null) {
                    int n = string3.indexOf("=");
                    if (n == -1) continue;
                    String string4 = string2 + string3.substring(0, n);
                    String string5 = string3.substring(n + 1);
                    this.parseSingleValue(object, string4, string5);
                }
                bufferedReader.close();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return vector;
    }

    public void writeDataTable(String string, Vector vector, Object object, String string2) {
        try {
            if (!this.parent.commonCode.testFileAccess(new File(string))) {
                return;
            }
            FileWriter fileWriter = new FileWriter(string);
            Field[] fieldArray = object.getClass().getFields();
            String[] stringArray = this.getFieldNames(fieldArray, string2);
            String[] stringArray2 = this.getHeaderNames(stringArray, string2);
            fileWriter.write(this.join(stringArray2, "\t"));
            fileWriter.write(this.lineSep);
            for (int i = 0; i < vector.size(); ++i) {
                Object e = vector.get(i);
                String[] stringArray3 = this.createRecord(e, stringArray);
                fileWriter.write(this.join(stringArray3, "\t"));
                fileWriter.write(this.lineSep);
            }
            fileWriter.close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void writeDataTable(String string, TreeMap treeMap, Object object, String string2) {
        try {
            String[] stringArray = treeMap.keySet().toArray(new String[0]);
            if (!this.parent.commonCode.testFileAccess(new File(string))) {
                return;
            }
            FileWriter fileWriter = new FileWriter(string);
            Field[] fieldArray = object.getClass().getFields();
            String[] stringArray2 = this.getFieldNames(fieldArray, string2);
            String[] stringArray3 = this.getHeaderNames(stringArray2, string2);
            fileWriter.write(this.join(stringArray3, "\t"));
            fileWriter.write(this.lineSep);
            for (int i = 0; i < stringArray.length; ++i) {
                Object v = treeMap.get(stringArray[i]);
                String[] stringArray4 = this.createRecord(v, stringArray2);
                fileWriter.write(this.join(stringArray4, "\t"));
                fileWriter.write(this.lineSep);
            }
            fileWriter.close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private String[] createRecord(Object object, String[] stringArray) {
        String[] stringArray2 = new String[stringArray.length];
        try {
            for (int i = 0; i < stringArray.length; ++i) {
                Field field = object.getClass().getDeclaredField(stringArray[i]);
                stringArray2[i] = this.getFieldValueAsString(field, object);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return stringArray2;
    }

    private String getFieldValueAsString(Field field, Object object) {
        String string = "";
        try {
            string = field.getType().isAssignableFrom(Boolean.TYPE) ? ((Boolean)field.get(object) != false ? "1" : "0") : (field.getType().isAssignableFrom(Boolean.class) ? ((Boolean)field.get(object) != false ? "1" : "0") : String.valueOf(field.get(object)));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return string;
    }

    Object createObjectFromClass(Object object) throws Exception {
        String string = object.getClass().getSimpleName();
        Object object2 = null;
        if (string.equals("MemorizedItem")) {
            object2 = new MemorizedItem(this.parent);
        } else if (string.equals("Account")) {
            object2 = new Account(this.parent);
        } else if (string.equals("CategoryItem")) {
            object2 = new CategoryItem();
        } else if (string.equals("SecurityItem")) {
            object2 = new SecurityItem();
        } else if (string.equals("PricesItem")) {
            object2 = new PricesItem(this.parent);
        } else if (string.equals("Transaction")) {
            object2 = new Transaction(this.parent);
        }
        if (object2 == null) {
            throw new Exception("name " + string + " not handled in createObjectFromClass");
        }
        return object2;
    }

    public boolean readDataTable(String string, Vector vector, Object object, String string2) {
        boolean bl = false;
        try {
            File file = new File(string);
            if (!this.parent.commonCode.testFileAccess(file)) {
                return false;
            }
            if (file.exists()) {
                bl = true;
                BufferedReader bufferedReader = new BufferedReader(new FileReader(string));
                String string3 = bufferedReader.readLine();
                String[] stringArray = this.split(string3, "\t");
                String[] stringArray2 = this.makeFieldNames(stringArray, string2);
                while ((string3 = bufferedReader.readLine()) != null) {
                    String[] stringArray3 = this.split(string3, "\t");
                    Object object2 = this.createObjectFromClass(object);
                    this.parseRecordValues(object2, stringArray2, stringArray3);
                    vector.add(object2);
                }
                bufferedReader.close();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return bl;
    }

    public void readDataTable(String string, TreeMap treeMap, Object object, String string2) {
        try {
            File file = new File(string);
            if (!this.parent.commonCode.testFileAccess(file)) {
                return;
            }
            if (file.exists()) {
                BufferedReader bufferedReader = new BufferedReader(new FileReader(string));
                String string3 = bufferedReader.readLine();
                String[] stringArray = this.split(string3, "\t");
                String[] stringArray2 = this.makeFieldNames(stringArray, string2);
                while ((string3 = bufferedReader.readLine()) != null) {
                    String[] stringArray3 = this.split(string3, "\t");
                    Object object2 = this.createObjectFromClass(object);
                    this.parseRecordValues(object2, stringArray2, stringArray3);
                    treeMap.put(stringArray3[0], object2);
                }
                bufferedReader.close();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private String[] makeFieldNames(String[] stringArray, String string) {
        if (stringArray == null) {
            return null;
        }
        String[] stringArray2 = new String[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray2[i] = string + stringArray[i];
        }
        return stringArray2;
    }

    private void parseRecordValues(Object object, String[] stringArray, String[] stringArray2) {
        for (int i = 0; i < stringArray2.length && i < stringArray.length; ++i) {
            String string = stringArray[i];
            String string2 = stringArray2[i];
            this.parseSingleValue(object, string, string2);
        }
    }

    void parseSingleValue(Object object, String string, String string2) {
        try {
            Field field = object.getClass().getDeclaredField(string);
            Class<Object> clazz = field.getType();
            if (clazz.isAssignableFrom(String.class)) {
                field.set(object, string2);
            } else if (clazz.isAssignableFrom(Boolean.class)) {
                field.set(object, new Boolean(string2.equals("1")));
            } else if (clazz.isAssignableFrom(Boolean.TYPE)) {
                field.set(object, new Boolean(string2.equals("1")));
            } else if (clazz.isAssignableFrom(Integer.class)) {
                field.set(object, new Integer(string2));
            } else if (clazz.isAssignableFrom(Integer.TYPE)) {
                field.set(object, new Integer(string2));
            } else if (clazz.isAssignableFrom(Long.class)) {
                field.set(object, new Long(string2));
            } else if (clazz.isAssignableFrom(Long.TYPE)) {
                field.set(object, new Long(string2));
            } else if (clazz.isAssignableFrom(Double.class)) {
                field.set(object, new Double(string2));
            } else if (clazz.isAssignableFrom(Double.TYPE)) {
                field.set(object, new Double(string2));
            } else if (clazz.isAssignableFrom(Color.class)) {
                String string3 = string2.replaceFirst("\\D+(\\d+)\\D+(\\d+)\\D+(\\d+)\\D+", "$1\t$2\t$3");
                String[] stringArray = string3.split("\t");
                field.set(object, new Color(Integer.parseInt(stringArray[0]), Integer.parseInt(stringArray[1]), Integer.parseInt(stringArray[2])));
            } else if (clazz.isAssignableFrom(Dimension.class)) {
                String string4 = string2.replaceFirst("\\D+(\\d+)\\D+(\\d+)\\D+", "$1\t$2");
                String[] stringArray = string4.split("\t");
                field.set(object, new Dimension(Integer.parseInt(stringArray[0]), Integer.parseInt(stringArray[1])));
            } else if (clazz.isAssignableFrom(Point.class)) {
                String string5 = string2.replaceFirst("\\D+(\\d+)\\D+(\\d+)\\D+", "$1\t$2");
                String[] stringArray = string5.split("\t");
                field.set(object, new Point(Integer.parseInt(stringArray[0]), Integer.parseInt(stringArray[1])));
            } else if (clazz.isAssignableFrom(Rectangle.class)) {
                String string6 = string2.replaceFirst("\\D+(\\d+)\\D+(\\d+)\\D+(\\d+)\\D+(\\d+)\\D+", "$1\t$2\t$3\t$4");
                String[] stringArray = string6.split("\t");
                field.set(object, new Rectangle(Integer.parseInt(stringArray[0]), Integer.parseInt(stringArray[1]), Integer.parseInt(stringArray[2]), Integer.parseInt(stringArray[3])));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public String[] getFieldNames(Field[] fieldArray, String string) {
        Vector<String> vector = new Vector<String>();
        for (int i = 0; i < fieldArray.length; ++i) {
            String string2 = fieldArray[i].getName();
            if (string2.indexOf(string) != 0) continue;
            vector.add(string2);
        }
        return vector.toArray(new String[vector.size()]);
    }

    public String[] getHeaderNames(String[] stringArray, String string) {
        String[] stringArray2 = new String[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray2[i] = stringArray[i].substring(string.length());
        }
        return stringArray2;
    }

    public String join(String[] stringArray, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < stringArray.length; ++i) {
            stringBuffer.append(stringArray[i]);
            if (i >= stringArray.length - 1) continue;
            stringBuffer.append(string);
        }
        return stringBuffer.toString();
    }

    public String[] split(String string, String string2) {
        int n;
        if (string == null) {
            return null;
        }
        Vector<String> vector = new Vector<String>();
        int n2 = 0;
        int n3 = string2.length();
        while ((n = string.indexOf(string2, n2)) != -1) {
            vector.add(string.substring(n2, n));
            n2 = n + n3;
        }
        vector.add(string.substring(n2));
        return vector.toArray(new String[vector.size()]);
    }
}

