/*
 * Decompiled with CFR 0.152.
 */
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.InputStream;
import java.net.URL;
import java.text.NumberFormat;
import java.util.Enumeration;
import java.util.Locale;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JSeparator;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public final class PLCash
extends JFrame {
    public static String VERSION = "2.5";
    static final int programBuild = 2415;
    CommonCode commonCode;
    QIFFileHandler qifFileHandler;
    DataFileManager dataFileManager;
    NumberFormat numberFormat;
    NumberFormat usNumberFormat;
    public int splitPaneWidth = 8;
    public String userDir;
    public String userPath;
    public String appDir;
    public String configPath;
    public String errorLogPath;
    public AccountHandler accountHandler;
    public QIFFileHandler qifHandler;
    public AccountSelectionPanel accountPanel;
    public DisplayHandler displayHandler;
    public BankAccountEditorPane bankEditorPane;
    public InvestmentAccountEditorPane investmentEditorPane;
    public AccountEditorPane accountEditorPane;
    public ProgramValues programValues;
    public PrintManager printManager;
    public BrowserSetupPanel browserSetupPanel;
    public HelpBrowser helpBrowser = null;
    private ReportGeneratorForm reportGeneratorForm = null;
    private EditorPane ep = null;
    public String osName;
    int oldTabIndex = 0;
    int newTabIndex = 0;
    static final String requiredJavaVersion = "1.5.0";
    public static final String programName = "PLCash";
    public static final String jarName = "PLCash.jar";
    static final String programTitle = "PLCash " + VERSION;
    static final String dataFileSuffix = ".tsv";
    static final String flagFileName = "PLCash_active";
    static final String dataDirName = "data";
    static final String reportDirName = "reportDesigns";
    static final String reportWebPageDirName = "reportDocuments";
    static final String documentationDirName = "Documentation";
    String[] dirList = new String[]{"Documentation"};
    static final String soundFileName = "alarm.au";
    public Category categoryHandler;
    public Memorized memHandler;
    public Security securityHandler;
    public Prices pricesHandler;
    SearchPanel searchPanel = null;
    boolean tabChanging = false;
    private JButton accountListButton;
    private JPanel centerPanel;
    private JMenuItem closeAllMenuItem;
    private JMenuItem closeMenuItem;
    private JMenuItem desktopIconMenuItem;
    private JMenuItem editCategoriesMenuItem;
    private JMenuItem editMemorizedMenuItem;
    private JPanel editPanel;
    private JMenuItem editPricesMenuItem;
    private JMenuItem editSecurityListMenuItem;
    private JMenuItem exitMenuItem;
    private JButton findButton;
    private JButton helpButton;
    private JButton importPricesButton;
    private JButton jButton2;
    private JMenu jMenu1;
    private JMenu jMenu2;
    private JMenu jMenu3;
    private JMenu jMenu4;
    private JMenuBar jMenuBar1;
    private JSeparator jSeparator1;
    private JSeparator jSeparator2;
    private JButton newButton;
    private JPopupMenu popupMenu;
    private JMenuItem pricesMenuItem;
    private JButton printChecksButton;
    private JMenuItem qifExportMenuItem;
    private JMenuItem qifImportMenuItem;
    private JButton reconcileButton;
    private JMenuItem reinstallDocsMenuItem;
    private JButton reportButton;
    private JButton saveAllButton;
    private JMenuItem setupBrowserMenuItem;
    private JCheckBoxMenuItem soundFeedbackMenuItem;
    private JSplitPane splitPane;
    public JTabbedPane tabbedPane;
    private JToolBar toolBar;
    private JMenuItem updatePricesMenuItem;

    public PLCash() {
        this.commonCode = new CommonCode(this);
        this.numberFormat = NumberFormat.getInstance();
        this.usNumberFormat = NumberFormat.getInstance(new Locale("en_US"));
        this.qifFileHandler = new QIFFileHandler(this);
        this.dataFileManager = new DataFileManager(this);
        this.testJavaVersion();
        this.setDefaultCloseOperation(0);
        this.appDir = this.getAppDir();
        this.userDir = System.getProperty("user.home");
        this.osName = System.getProperty("os.name");
        this.userPath = this.userDir + this.commonCode.fileSep + "." + programName;
        this.configPath = this.userPath + this.commonCode.fileSep + programName + ".ini";
        this.errorLogPath = this.userPath + this.commonCode.fileSep + programName + "ErrorLog.txt";
        File file = new File(this.userPath);
        file.mkdirs();
        if (!this.commonCode.testFileAccess(file)) {
            return;
        }
        if (!this.processFlagFile(this.userPath, flagFileName, false)) {
            return;
        }
        ErrorMessageLogger.setPath(this.errorLogPath, this);
        this.programValues = new ProgramValues(this);
        this.programValues.db_DataFilePath = this.userPath + this.commonCode.fileSep + dataDirName;
        this.programValues.db_ReportFilePath = this.userPath + this.commonCode.fileSep + reportDirName;
        this.programValues.db_ReportWebPageFilePath = this.userPath + this.commonCode.fileSep + reportWebPageDirName;
        this.programValues.db_QIFFilePath = this.userPath;
        this.programValues.db_documentationPath = this.userPath + this.commonCode.fileSep + documentationDirName;
        this.programValues.readValues(this.configPath);
        this.unpackJarTest(this.userPath, this.programValues.db_documentationPath, this.appDir, jarName, this.dirList);
        File file2 = new File(this.programValues.db_DataFilePath);
        File file3 = new File(this.programValues.db_ReportFilePath);
        File file4 = new File(this.programValues.db_ReportWebPageFilePath);
        file2.mkdirs();
        file3.mkdirs();
        file4.mkdirs();
        if (!this.commonCode.testFileAccess(file2)) {
            return;
        }
        if (!this.commonCode.testFileAccess(file3)) {
            return;
        }
        if (!this.commonCode.testFileAccess(file4)) {
            return;
        }
        this.setTitle(programTitle);
        URL uRL = this.getClass().getResource("icons/PLCash.png");
        Image image = new ImageIcon(uRL).getImage();
        this.setIconImage(image);
        this.moveIcon(uRL, this.userPath);
        this.initComponents();
        this.setSoundFeedback(false);
        if (this.osName.toLowerCase().indexOf("linux") == -1) {
            this.desktopIconMenuItem.setEnabled(false);
        }
        this.setupToolBar();
        this.categoryHandler = new Category(this);
        this.memHandler = new Memorized(this);
        this.securityHandler = new Security(this);
        this.pricesHandler = new Prices(this);
        this.accountHandler = new AccountHandler(this);
        this.accountHandler.readAllTSV(this.programValues.db_DataFilePath);
        this.bankEditorPane = new BankAccountEditorPane(this);
        this.investmentEditorPane = new InvestmentAccountEditorPane(this);
        this.accountEditorPane = new AccountEditorPane(this);
        this.browserSetupPanel = new BrowserSetupPanel(this);
        this.displayHandler = new DisplayHandler(this, this.tabbedPane);
        this.accountPanel = new AccountSelectionPanel(this);
        this.showAccountList();
        this.pack();
        this.setSize(this.programValues.db_ProgWindowSize);
        this.setLocation(this.programValues.db_ProgWindowLocation);
        this.setExtendedState(this.programValues.db_ProgWindowState);
        this.setVisible(true);
        this.closeEditWindow();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                PLCash.this.accountHandler.openSavedAccountList();
            }
        });
        if (!this.programValues.db_DisclaimerSeen) {
            DisclaimerWindow disclaimerWindow = new DisclaimerWindow((Frame)this, true);
            if (disclaimerWindow.valid) {
                this.programValues.db_DisclaimerSeen = true;
            }
        }
        this.testForNoAccounts();
    }

    public void p(String string) {
        System.out.println(string);
    }

    public void beep() {
        Beep.beep();
    }

    public void unpackJarTest(String string, String string2, String string3, String string4, String[] stringArray) {
        File file = new File(string2);
        if (!file.exists()) {
            for (int i = 0; i < stringArray.length; ++i) {
                this.unpackJarTest2(string, string3, string4, stringArray[i], false);
            }
        }
    }

    private void reinstallLocalFiles() {
        for (int i = 0; i < this.dirList.length; ++i) {
            this.unpackJarTest2(this.userPath, this.appDir, jarName, this.dirList[i], true);
        }
    }

    public void unpackJarTest2(String string, String string2, String string3, String string4, boolean bl) {
        String string5 = string + this.commonCode.fileSep + string4;
        try {
            File file = new File(string5);
            if (!file.exists() || bl) {
                file.mkdir();
                String string6 = string2 + "/" + string3;
                ZipFile zipFile = new ZipFile(string6);
                Enumeration<? extends ZipEntry> enumeration = zipFile.entries();
                while (enumeration.hasMoreElements()) {
                    String string7;
                    ZipEntry zipEntry = enumeration.nextElement();
                    String string8 = zipEntry.toString();
                    int n = string8.lastIndexOf("/");
                    if (n == -1 || !(string7 = string8.substring(0, n)).equals(string4)) continue;
                    String string9 = string8.substring(n + 1);
                    String string10 = string5 + "/" + string9;
                    n = string9.indexOf(46);
                    if (n == -1) continue;
                    if (this.testIsBinary(string10)) {
                        this.copyZipBinaryFile(zipFile, zipEntry, string10);
                        continue;
                    }
                    this.copyZipTextFile(zipFile, zipEntry, string10);
                }
                zipFile.close();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private boolean testIsBinary(String string) {
        return string.endsWith(".class") || string.endsWith(".zip") || string.endsWith(".gif") || string.endsWith(".jpg") || string.endsWith(".png");
    }

    public void copyZipBinaryFile(ZipFile zipFile, ZipEntry zipEntry, String string) {
        try {
            int n;
            File file = new File(string);
            this.commonCode.testFileAccess(file);
            BufferedInputStream bufferedInputStream = new BufferedInputStream(zipFile.getInputStream(zipEntry));
            BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(file));
            int n2 = 8192;
            byte[] byArray = new byte[n2];
            while ((n = bufferedInputStream.read(byArray, 0, n2)) != -1) {
                bufferedOutputStream.write(byArray, 0, n);
            }
            bufferedInputStream.close();
            bufferedOutputStream.close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void copyZipTextFile(ZipFile zipFile, ZipEntry zipEntry, String string) {
        try {
            int n;
            BufferedInputStream bufferedInputStream = new BufferedInputStream(zipFile.getInputStream(zipEntry));
            File file = new File(string);
            this.commonCode.testFileAccess(file);
            StringBuffer stringBuffer = new StringBuffer();
            int n2 = 8192;
            byte[] byArray = new byte[n2];
            while ((n = bufferedInputStream.read(byArray, 0, n2)) != -1) {
                stringBuffer.append(new String(byArray, 0, n));
            }
            bufferedInputStream.close();
            String string2 = stringBuffer.toString();
            string2 = this.commonCode.toJavaLineEndings(string2);
            string2 = this.commonCode.toSystemLineEndings(string2);
            DataOutputStream dataOutputStream = new DataOutputStream(new FileOutputStream(file));
            dataOutputStream.writeBytes(string2);
            dataOutputStream.close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void moveIcon(URL uRL, String string) {
        File file = new File(string + "/" + programName + ".png");
        if (!file.exists()) {
            try {
                int n;
                InputStream inputStream = uRL.openStream();
                FileOutputStream fileOutputStream = new FileOutputStream(file);
                while ((n = inputStream.read()) != -1) {
                    fileOutputStream.write(n);
                }
                inputStream.close();
                fileOutputStream.close();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    public void playSound() {
        if (this.programValues.db_SoundFeedback) {
            this.beep();
        }
    }

    private void setSoundFeedback(boolean bl) {
        if (bl) {
            this.programValues.db_SoundFeedback = !this.programValues.db_SoundFeedback;
        }
        this.soundFeedbackMenuItem.setSelected(this.programValues.db_SoundFeedback);
    }

    private void createShortcut(String string, String string2) {
        try {
            FileWriter fileWriter = new FileWriter(string2);
            fileWriter.write(string);
            fileWriter.close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void createDesktopShortcuts() {
        int n = JOptionPane.showConfirmDialog(this, "This will create desktop shortcuts for PLCash\non both the KDE and Gnome desktops in Linux.\n\nIf this program's path assumptions are out of date\nand the shortcuts don't get located correctly,\nyou can always copy a third, default shortcut\nnamed \"PLCash\"\nfrom the directory \"" + this.userPath + "\"\nto the location of your choosing.\n\nThis feature is especially useful if for some\nreason you must move the " + programName + "\nexecutable jar file -- in such a case, just run\nthis feature again and the shortcuts will be\nupdated with the new program location.\n\nCreate shortcuts?\n\n", "Create Desktop Shortcuts", 1);
        if (n == 0) {
            String string = this.userPath + "/" + programName + ".png";
            String string2 = "[Desktop Entry]\nExec=cd (appDir) ; java -jar (pn).jar\nName=(pn)\nName[en_US]=(pn)\nIcon=(iconPath)\nType=Application\n";
            string2 = string2.replaceAll("\\(pn\\)", programName);
            string2 = string2.replaceAll("\\(appDir\\)", this.appDir);
            string2 = string2.replaceAll("\\(iconPath\\)", string);
            string2 = string2.replaceAll("\n", this.commonCode.lineSep);
            this.createShortcut(string2, this.userPath + "/" + programName);
            this.createShortcut(string2, this.userDir + "/Desktop/" + programName);
            this.createShortcut(string2, this.userDir + "/.gnome-desktop/" + programName);
        }
    }

    private String getAppDir() {
        String string = this.getClass().getProtectionDomain().getCodeSource().getLocation().toString();
        string = string.replaceAll("file:", "");
        string = string.replaceFirst("[^/]+.jar", "");
        string = string.replaceAll("%20", " ");
        return string;
    }

    private void setupToolBar() {
        this.toolBar.setOrientation(this.programValues.db_ToolBarOrientation);
        int n = this.programValues.db_ToolBarLocation;
        switch (this.programValues.db_ToolBarOrientation) {
            case 0: {
                if (n == 0) {
                    this.getContentPane().add((Component)this.toolBar, "North");
                    break;
                }
                this.getContentPane().add((Component)this.toolBar, "South");
                break;
            }
            case 1: {
                if (n == 0) {
                    this.getContentPane().add((Component)this.toolBar, "West");
                    break;
                }
                this.getContentPane().add((Component)this.toolBar, "East");
            }
        }
    }

    private void saveToolBar() {
        this.programValues.db_ToolBarOrientation = this.toolBar.getOrientation();
        switch (this.programValues.db_ToolBarOrientation) {
            case 0: {
                this.programValues.db_ToolBarLocation = this.toolBar.getLocation().y < this.getSize().height / 2 ? 0 : 1;
                break;
            }
            case 1: {
                this.programValues.db_ToolBarLocation = this.toolBar.getLocation().x < this.getSize().width / 2 ? 0 : 1;
            }
        }
    }

    private void testJavaVersion() {
        boolean bl;
        String string = System.getProperty("java.version");
        boolean bl2 = bl = this.convertVersionString(string) >= this.convertVersionString(requiredJavaVersion);
        if (!bl) {
            JOptionPane.showMessageDialog(this, "Very Sorry!\n\nPLCash " + VERSION + " requires a Java runtime engine (JRE)\nwith a version of " + requiredJavaVersion + " or better.\nThis machine has a version " + string + " JRE.\nPlease acquire the correct JRE at http://java.com.", "Wrong Java Runtime Version", 2);
            System.exit(0);
        }
    }

    private int convertVersionString(String string) {
        try {
            int n;
            int n2;
            int n3 = string.length();
            for (n2 = 0; n2 < n3 && !Character.isDigit(string.charAt(n2)); ++n2) {
            }
            StringBuffer stringBuffer = new StringBuffer();
            char c = ' ';
            while (true) {
                block10: {
                    block9: {
                        if (n2 >= n3) break block9;
                        char c2 = string.charAt(n2);
                        c = c2;
                        if (Character.isDigit(c2)) break block10;
                    }
                    if (c != 46) break;
                }
                if (Character.isDigit(c)) {
                    stringBuffer.append(c);
                }
                ++n2;
            }
            for (n = Integer.parseInt(stringBuffer.toString()); n > 0 && n < 100; n *= 10) {
            }
            return n;
        }
        catch (Exception exception) {
            return 0;
        }
    }

    private void testForNoAccounts() {
        if (this.accountHandler.getDataSize() == 0) {
            this.beep();
            int n = JOptionPane.showConfirmDialog(this, "Do you want to create a new bank account?", "Create Bank Account", 0);
            if (n == 0) {
                this.newAccount();
            } else {
                this.beep();
                n = JOptionPane.showConfirmDialog(this, "Do you want to read a Quicken Information File (QIF)?", "Read Quicken File", 0);
                if (n == 0) {
                    QIFFileHandler.importQIF(this);
                }
            }
        }
    }

    private void newAccount() {
        this.loadAccountEditorPane(null);
    }

    public void launchHelp() {
        this.launchPage("index.html");
    }

    public void launchHelp(String string) {
        this.launchPage(string);
    }

    public void launchInternalBrowser(String string) {
        boolean bl = true;
        if (this.helpBrowser == null) {
            this.helpBrowser = new HelpBrowser(this);
        } else {
            bl = false;
        }
        this.displayHandler.addComp("Internal Browser", this.helpBrowser);
        if (bl) {
            this.helpBrowser.setPage(string);
        } else {
            this.helpBrowser.toPage(string);
        }
    }

    public void launchPage(String string) {
        this.launchPageWithFullPath(this.programValues.db_documentationPath + this.commonCode.fileSep + string);
    }

    public void launchPageWithFullPath(String string) {
        this.browserSetupPanel.launchBrowser(string);
    }

    public void showAccountList() {
        this.displayHandler.addComp("Accounts", this.accountPanel);
    }

    public void printChecks() {
        Account account = this.displayHandler.getSelectedAccount();
        if (account == null) {
            this.beep();
            JOptionPane.showMessageDialog(this, "To print checks, first display a specific account.", "Print Checks", 1);
        } else {
            this.printChecks(account);
        }
    }

    public void reconcile() {
        Account account = this.displayHandler.getSelectedAccount();
        if (account == null) {
            this.beep();
            JOptionPane.showMessageDialog(this, "To reconcile, first display a specific account.", "Reconcile Account", 1);
        } else {
            account.accountDisplay.reconcile();
        }
    }

    private boolean processFlagFile(String string, String string2, boolean bl) {
        boolean bl2 = false;
        String string3 = string + "/" + string2;
        File file = new File(string3);
        if (!this.commonCode.testFileAccess(file)) {
            return false;
        }
        if (bl) {
            file.delete();
        } else if (file.exists()) {
            this.beep();
            JOptionPane.showMessageDialog(this, "There appears to be another instance of\nPLCash running. If this is\nnot the case, please delete the file\n" + string3 + "\nand try again.\n\nPermitting multiple program instances would prevent\ndatabase integrity and might cause loss of data.\n", "Multiple program instances", 2);
            System.exit(0);
        } else {
            try {
                file.createNewFile();
                file.deleteOnExit();
                bl2 = true;
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        return bl2;
    }

    public boolean closeEditWindow() {
        if (!this.checkChanged()) {
            return false;
        }
        if (this.editPanel.getComponentCount() > 0) {
            this.editPanel.remove(0);
        }
        this.splitPane.setDividerLocation(this.splitPane.getSize().height);
        this.splitPane.setDividerSize(0);
        return true;
    }

    public boolean closeReportForm() {
        if (this.editPanel.getComponentCount() > 0) {
            this.editPanel.remove(0);
        }
        this.splitPane.setDividerLocation(this.splitPane.getSize().height);
        this.splitPane.setDividerSize(0);
        return true;
    }

    public boolean editorFormIsLoaded() {
        boolean bl = false;
        if (this.editPanel.getComponentCount() > 0) {
            Component component = this.editPanel.getComponent(0);
            bl = component instanceof EditorPane;
        }
        return bl;
    }

    public boolean checkChanged() {
        return (this.ep == null || this.ep.checkChanged()) && this.accountEditorPane.checkChanged();
    }

    public void loadEditorForm(final Account account, final int n) {
        if (account == null) {
            System.out.println("loadEditorForm account null value");
        }
        if (!this.closeEditWindow()) {
            return;
        }
        this.ep = null;
        if (account.type == 3) {
            this.editPanel.add((Component)this.investmentEditorPane, "Center");
            this.investmentEditorPane.loadForm(account, n);
            this.ep = this.investmentEditorPane;
        } else {
            this.editPanel.add((Component)this.bankEditorPane, "Center");
            this.bankEditorPane.loadForm(account, n);
            this.ep = this.bankEditorPane;
        }
        this.splitPane.setDividerSize(this.splitPaneWidth);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                PLCash.this.splitPane.setResizeWeight(1.0);
                PLCash.this.splitPane.resetToPreferredSizes();
                account.accountDisplay.scrollToTransaction(n, true);
            }
        });
    }

    public boolean accountEditorOpen() {
        boolean bl = false;
        if (this.editPanel.getComponentCount() > 0) {
            Component component = this.editPanel.getComponent(0);
            bl = component instanceof AccountEditorPane;
        }
        return bl;
    }

    public void loadAccountEditorPane(final Account account) {
        if (!this.closeEditWindow()) {
            return;
        }
        this.splitPane.setDividerSize(this.splitPaneWidth);
        this.accountEditorPane.loadForm(this.accountPanel.indexForAccount(account));
        this.editPanel.add((Component)this.accountEditorPane, "Center");
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                PLCash.this.splitPane.setResizeWeight(1.0);
                PLCash.this.splitPane.resetToPreferredSizes();
                PLCash.this.accountPanel.scrollToRow(account, true);
            }
        });
    }

    public void loadReportGeneratorPanel(String string) {
        if (!this.closeEditWindow()) {
            return;
        }
        this.splitPane.setDividerSize(this.splitPaneWidth);
        if (this.reportGeneratorForm == null) {
            this.reportGeneratorForm = new ReportGeneratorForm(this);
        }
        this.editPanel.add((Component)this.reportGeneratorForm, "Center");
        this.setSplitPaneDividerLocation();
        if (string.length() > 0) {
            this.reportGeneratorForm.changeTabs(string);
        }
    }

    private void setSplitPaneDividerLocation() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                PLCash.this.splitPane.setResizeWeight(1.0);
                PLCash.this.splitPane.resetToPreferredSizes();
            }
        });
    }

    public JSplitPane getSplitPane() {
        return this.splitPane;
    }

    private void handleMenu(MouseEvent mouseEvent) {
        if (mouseEvent.isPopupTrigger()) {
            this.popupMenu.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
        }
    }

    private void editCategories() {
        this.categoryHandler.displayData();
    }

    private void editMemorized() {
        this.memHandler.displayData();
    }

    private void editPrices() {
        this.pricesHandler.displayData();
    }

    private void editSecurityList() {
        this.securityHandler.displayData();
    }

    private void editAccountList() {
        this.accountHandler.displayData();
    }

    public void openSearchWindow() {
        Account account = this.displayHandler.getSelectedAccount();
        if (account != null) {
            this.openSearchWindow(account);
        }
    }

    public void openSearchWindow(Account account) {
        if (this.searchPanel == null) {
            this.searchPanel = new SearchPanel(this);
        }
        this.searchPanel.init(account);
        this.centerPanel.remove(this.searchPanel);
        this.centerPanel.add((Component)this.searchPanel, "North");
        this.validate();
        this.searchPanel.makeVisible();
    }

    public void closeSearchWindow() {
        if (this.searchPanel == null) {
            return;
        }
        this.centerPanel.remove(this.searchPanel);
        this.validate();
        if (this.searchPanel.defaultAccountDisplay != null) {
            this.searchPanel.defaultAccountDisplay.tableFocus();
        }
    }

    public void searchAgain(Account account) {
        if (this.searchPanel == null) {
            this.openSearchWindow(account);
        }
        if (!this.searchPanel.globalSearch && !this.searchPanel.defaultAccount.equals(account)) {
            this.openSearchWindow(account);
        } else {
            this.searchPanel.performSearch(false);
        }
    }

    private void testTabChange() {
        if (!this.tabChanging) {
            this.tabChanging = true;
            if (!this.closeEditWindow()) {
                this.tabbedPane.setSelectedIndex(this.oldTabIndex);
            }
            this.tabChanging = false;
        }
    }

    private void setOldTabIndex() {
        this.oldTabIndex = this.newTabIndex;
        this.newTabIndex = this.tabbedPane.getSelectedIndex();
    }

    public void printChecks(Account account) {
        if (this.printManager == null) {
            this.printManager = new PrintManager((Frame)this, true);
        }
        this.printManager.setupShow(account);
    }

    private void aboutDialog() {
        new AboutPageGenerator(this);
    }

    public void importPrices() {
        this.pricesHandler.importPrices();
    }

    public void updatePrices() {
        this.pricesHandler.updatePrices();
    }

    private void saveAllChanged() {
        this.accountHandler.saveOpenAccountList();
        this.accountHandler.writeAllTSV(this.programValues.db_DataFilePath);
        if (this.reportGeneratorForm != null) {
            this.reportGeneratorForm.saveReportDesign2();
        }
        if (this.searchPanel != null) {
            this.searchPanel.saveSearchValues();
        }
        this.browserSetupPanel.writeValues();
    }

    public void setupBrowser() {
        this.loadReportGeneratorPanel(this.browserSetupPanel.browserLabel);
    }

    private void initComponents() {
        this.popupMenu = new JPopupMenu();
        this.closeMenuItem = new JMenuItem();
        this.closeAllMenuItem = new JMenuItem();
        this.toolBar = new JToolBar();
        this.newButton = new MyJButton();
        this.saveAllButton = new MyJButton();
        this.accountListButton = new MyJButton();
        this.reconcileButton = new MyJButton();
        this.findButton = new MyJButton();
        this.reportButton = new MyJButton();
        this.importPricesButton = new MyJButton();
        this.printChecksButton = new MyJButton();
        this.jSeparator1 = new JSeparator();
        this.helpButton = new MyJButton();
        this.jButton2 = new MyJButton();
        this.centerPanel = new JPanel();
        this.splitPane = new JSplitPane();
        this.tabbedPane = new JTabbedPane();
        this.editPanel = new JPanel();
        this.jMenuBar1 = new JMenuBar();
        this.jMenu1 = new JMenu();
        this.jMenu3 = new JMenu();
        this.qifImportMenuItem = new JMenuItem();
        this.qifExportMenuItem = new JMenuItem();
        this.jMenu2 = new JMenu();
        this.editCategoriesMenuItem = new JMenuItem();
        this.editMemorizedMenuItem = new JMenuItem();
        this.editPricesMenuItem = new JMenuItem();
        this.editSecurityListMenuItem = new JMenuItem();
        this.pricesMenuItem = new JMenuItem();
        this.updatePricesMenuItem = new JMenuItem();
        this.desktopIconMenuItem = new JMenuItem();
        this.jSeparator2 = new JSeparator();
        this.exitMenuItem = new JMenuItem();
        this.jMenu4 = new JMenu();
        this.setupBrowserMenuItem = new JMenuItem();
        this.reinstallDocsMenuItem = new JMenuItem();
        this.soundFeedbackMenuItem = new JCheckBoxMenuItem();
        this.closeMenuItem.setText("Close");
        this.closeMenuItem.setToolTipText("Close this account");
        this.closeMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                PLCash.this.closeMenuItemActionPerformed(actionEvent);
            }
        });
        this.popupMenu.add(this.closeMenuItem);
        this.closeAllMenuItem.setText("Close All");
        this.closeAllMenuItem.setToolTipText("Close all open accounts");
        this.closeAllMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                PLCash.this.closeAllMenuItemActionPerformed(actionEvent);
            }
        });
        this.popupMenu.add(this.closeAllMenuItem);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                PLCash.this.exitForm(windowEvent);
            }
        });
        this.newButton.setIcon(new ImageIcon(this.getClass().getResource("/icons/New.png")));
        this.newButton.setToolTipText("Create a new account");
        this.newButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                PLCash.this.newButtonActionPerformed(actionEvent);
            }
        });
        this.toolBar.add(this.newButton);
        this.saveAllButton.setIcon(new ImageIcon(this.getClass().getResource("/icons/SaveAll.png")));
        this.saveAllButton.setToolTipText("Save all changed files");
        this.saveAllButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                PLCash.this.saveAllButtonActionPerformed(actionEvent);
            }
        });
        this.toolBar.add(this.saveAllButton);
        this.accountListButton.setIcon(new ImageIcon(this.getClass().getResource("/icons/Home.png")));
        this.accountListButton.setToolTipText("Show the account list");
        this.accountListButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                PLCash.this.accountListButtonActionPerformed(actionEvent);
            }
        });
        this.toolBar.add(this.accountListButton);
        this.reconcileButton.setIcon(new ImageIcon(this.getClass().getResource("/icons/PlusMinus.png")));
        this.reconcileButton.setToolTipText("Reconcile the displayed account against a bank statement");
        this.reconcileButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                PLCash.this.reconcileButtonActionPerformed(actionEvent);
            }
        });
        this.toolBar.add(this.reconcileButton);
        this.findButton.setIcon(new ImageIcon(this.getClass().getResource("/icons/DocumentMag.png")));
        this.findButton.setToolTipText("Search for transactions");
        this.findButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                PLCash.this.findButtonActionPerformed(actionEvent);
            }
        });
        this.toolBar.add(this.findButton);
        this.reportButton.setIcon(new ImageIcon(this.getClass().getResource("/icons/DocumentDraw.png")));
        this.reportButton.setToolTipText("Create a report");
        this.reportButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                PLCash.this.reportButtonActionPerformed(actionEvent);
            }
        });
        this.toolBar.add(this.reportButton);
        this.importPricesButton.setIcon(new ImageIcon(this.getClass().getResource("/icons/OpenDoc.png")));
        this.importPricesButton.setToolTipText("Import Prices");
        this.importPricesButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                PLCash.this.importPricesButtonActionPerformed(actionEvent);
            }
        });
        this.toolBar.add(this.importPricesButton);
        this.printChecksButton.setIcon(new ImageIcon(this.getClass().getResource("/icons/Print.png")));
        this.printChecksButton.setToolTipText("Print checks from the displayed account");
        this.printChecksButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                PLCash.this.printChecksButtonActionPerformed(actionEvent);
            }
        });
        this.toolBar.add(this.printChecksButton);
        this.toolBar.add(this.jSeparator1);
        this.helpButton.setIcon(new ImageIcon(this.getClass().getResource("/icons/Help.png")));
        this.helpButton.setToolTipText("Global Help");
        this.helpButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                PLCash.this.helpButtonActionPerformed(actionEvent);
            }
        });
        this.toolBar.add(this.helpButton);
        this.jButton2.setIcon(new ImageIcon(this.getClass().getResource("/icons/Options.png")));
        this.jButton2.setToolTipText("About PLCash");
        this.jButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                PLCash.this.jButton2ActionPerformed(actionEvent);
            }
        });
        this.toolBar.add(this.jButton2);
        this.getContentPane().add((Component)this.toolBar, "North");
        this.centerPanel.setLayout(new BorderLayout());
        this.splitPane.setDividerLocation(200);
        this.splitPane.setOrientation(0);
        this.splitPane.setResizeWeight(0.5);
        this.splitPane.setDoubleBuffered(true);
        this.splitPane.setOneTouchExpandable(true);
        this.tabbedPane.setMinimumSize(new Dimension(0, 0));
        this.tabbedPane.setPreferredSize(new Dimension(10, 10));
        this.tabbedPane.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                PLCash.this.tabbedPaneStateChanged(changeEvent);
            }
        });
        this.tabbedPane.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                PLCash.this.tabbedPaneMousePressed(mouseEvent);
            }

            @Override
            public void mouseReleased(MouseEvent mouseEvent) {
                PLCash.this.tabbedPaneMouseReleased(mouseEvent);
            }
        });
        this.splitPane.setTopComponent(this.tabbedPane);
        this.editPanel.setLayout(new BorderLayout());
        this.splitPane.setRightComponent(this.editPanel);
        this.centerPanel.add((Component)this.splitPane, "Center");
        this.getContentPane().add((Component)this.centerPanel, "Center");
        this.jMenu1.setText("File");
        this.jMenu1.setToolTipText("Various file operations");
        this.jMenu3.setText("QIF File import/export");
        this.qifImportMenuItem.setText("Import QIF File");
        this.qifImportMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                PLCash.this.qifImportMenuItemActionPerformed(actionEvent);
            }
        });
        this.jMenu3.add(this.qifImportMenuItem);
        this.qifExportMenuItem.setText("Export QIF File");
        this.qifExportMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                PLCash.this.qifExportMenuItemActionPerformed(actionEvent);
            }
        });
        this.jMenu3.add(this.qifExportMenuItem);
        this.jMenu1.add(this.jMenu3);
        this.jMenu2.setText("View/edit lists");
        this.editCategoriesMenuItem.setText("Category list");
        this.editCategoriesMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                PLCash.this.editCategoriesMenuItemActionPerformed(actionEvent);
            }
        });
        this.jMenu2.add(this.editCategoriesMenuItem);
        this.editMemorizedMenuItem.setText("Memorized transaction list");
        this.editMemorizedMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                PLCash.this.editMemorizedMenuItemActionPerformed(actionEvent);
            }
        });
        this.jMenu2.add(this.editMemorizedMenuItem);
        this.editPricesMenuItem.setText("Memorized price list");
        this.editPricesMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                PLCash.this.editPricesMenuItemActionPerformed(actionEvent);
            }
        });
        this.jMenu2.add(this.editPricesMenuItem);
        this.editSecurityListMenuItem.setText("Security list");
        this.editSecurityListMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                PLCash.this.editSecurityListMenuItemActionPerformed(actionEvent);
            }
        });
        this.jMenu2.add(this.editSecurityListMenuItem);
        this.jMenu1.add(this.jMenu2);
        this.pricesMenuItem.setText("Import prices");
        this.pricesMenuItem.setToolTipText("Read an investment price file, update prices");
        this.pricesMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                PLCash.this.pricesMenuItemActionPerformed(actionEvent);
            }
        });
        this.jMenu1.add(this.pricesMenuItem);
        this.updatePricesMenuItem.setText("Update prices");
        this.updatePricesMenuItem.setToolTipText("Synchronize account price information with newest prices");
        this.updatePricesMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                PLCash.this.updatePricesMenuItemActionPerformed(actionEvent);
            }
        });
        this.jMenu1.add(this.updatePricesMenuItem);
        this.desktopIconMenuItem.setText("Make desktop icons (Linux)");
        this.desktopIconMenuItem.setToolTipText("Create handy desktop icons for PLCash");
        this.desktopIconMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                PLCash.this.desktopIconMenuItemActionPerformed(actionEvent);
            }
        });
        this.jMenu1.add(this.desktopIconMenuItem);
        this.jMenu1.add(this.jSeparator2);
        this.exitMenuItem.setText("Exit PLCash");
        this.exitMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                PLCash.this.exitMenuItemActionPerformed(actionEvent);
            }
        });
        this.jMenu1.add(this.exitMenuItem);
        this.jMenuBar1.add(this.jMenu1);
        this.jMenu4.setText("Tools");
        this.setupBrowserMenuItem.setText("Set up external browser");
        this.setupBrowserMenuItem.setToolTipText("Used for viewing reports and help");
        this.setupBrowserMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                PLCash.this.setupBrowserMenuItemActionPerformed(actionEvent);
            }
        });
        this.jMenu4.add(this.setupBrowserMenuItem);
        this.reinstallDocsMenuItem.setText("Reinstall documentation files");
        this.reinstallDocsMenuItem.setToolTipText("In the event of an accidental erasure");
        this.reinstallDocsMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                PLCash.this.reinstallDocsMenuItemActionPerformed(actionEvent);
            }
        });
        this.jMenu4.add(this.reinstallDocsMenuItem);
        this.soundFeedbackMenuItem.setText("Sound on transaction commit/delete");
        this.soundFeedbackMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                PLCash.this.soundFeedbackMenuItemActionPerformed(actionEvent);
            }
        });
        this.jMenu4.add(this.soundFeedbackMenuItem);
        this.jMenuBar1.add(this.jMenu4);
        this.setJMenuBar(this.jMenuBar1);
        this.pack();
    }

    private void soundFeedbackMenuItemActionPerformed(ActionEvent actionEvent) {
        this.setSoundFeedback(true);
    }

    private void pricesMenuItemActionPerformed(ActionEvent actionEvent) {
        this.importPrices();
    }

    private void reinstallDocsMenuItemActionPerformed(ActionEvent actionEvent) {
        this.reinstallLocalFiles();
    }

    private void setupBrowserMenuItemActionPerformed(ActionEvent actionEvent) {
        this.setupBrowser();
    }

    private void saveAllButtonActionPerformed(ActionEvent actionEvent) {
        this.saveAllChanged();
    }

    private void updatePricesMenuItemActionPerformed(ActionEvent actionEvent) {
        this.updatePrices();
    }

    private void importPricesButtonActionPerformed(ActionEvent actionEvent) {
        this.importPrices();
    }

    private void reportButtonActionPerformed(ActionEvent actionEvent) {
        this.loadReportGeneratorPanel("");
    }

    private void findButtonActionPerformed(ActionEvent actionEvent) {
        this.openSearchWindow();
    }

    private void jButton2ActionPerformed(ActionEvent actionEvent) {
        this.aboutDialog();
    }

    private void desktopIconMenuItemActionPerformed(ActionEvent actionEvent) {
        this.createDesktopShortcuts();
    }

    private void reconcileButtonActionPerformed(ActionEvent actionEvent) {
        this.reconcile();
    }

    private void printChecksButtonActionPerformed(ActionEvent actionEvent) {
        this.printChecks();
    }

    private void accountListButtonActionPerformed(ActionEvent actionEvent) {
        this.showAccountList();
    }

    private void helpButtonActionPerformed(ActionEvent actionEvent) {
        this.launchHelp();
    }

    private void newButtonActionPerformed(ActionEvent actionEvent) {
        this.newAccount();
    }

    private void tabbedPaneStateChanged(ChangeEvent changeEvent) {
        this.setOldTabIndex();
        this.testTabChange();
    }

    private void qifExportMenuItemActionPerformed(ActionEvent actionEvent) {
        QIFFileHandler.exportQIF(this);
    }

    private void qifImportMenuItemActionPerformed(ActionEvent actionEvent) {
        QIFFileHandler.importQIF(this);
    }

    private void editSecurityListMenuItemActionPerformed(ActionEvent actionEvent) {
        this.editSecurityList();
    }

    private void editPricesMenuItemActionPerformed(ActionEvent actionEvent) {
        this.editPrices();
    }

    private void editMemorizedMenuItemActionPerformed(ActionEvent actionEvent) {
        this.editMemorized();
    }

    private void editCategoriesMenuItemActionPerformed(ActionEvent actionEvent) {
        this.editCategories();
    }

    private void closeAllMenuItemActionPerformed(ActionEvent actionEvent) {
        this.displayHandler.closeAll();
    }

    private void closeMenuItemActionPerformed(ActionEvent actionEvent) {
        this.displayHandler.closeSelectedTab();
    }

    private void tabbedPaneMouseReleased(MouseEvent mouseEvent) {
        this.handleMenu(mouseEvent);
    }

    private void tabbedPaneMousePressed(MouseEvent mouseEvent) {
        this.handleMenu(mouseEvent);
    }

    public void performExit() {
        boolean bl = true;
        if (!this.checkChanged()) {
            bl = false;
        }
        if (bl) {
            this.saveToolBar();
            this.saveAllChanged();
            this.programValues.db_ProgWindowSize = this.getSize();
            this.programValues.db_ProgWindowLocation = this.getLocation();
            this.programValues.db_ProgWindowState = this.getExtendedState();
            this.programValues.writeValues(this.configPath);
            this.processFlagFile(this.userPath, flagFileName, true);
            System.exit(0);
        }
    }

    private void exitForm(WindowEvent windowEvent) {
        this.performExit();
    }

    private void exitMenuItemActionPerformed(ActionEvent actionEvent) {
        this.performExit();
    }

    public static void main(String[] stringArray) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                System.setProperty("awt.useSystemAAFontSettings", "on");
                System.setProperty("swing.aatext", "true");
                new PLCash().setVisible(true);
            }
        });
    }
}

