/*
 * Decompiled with CFR 0.152.
 */
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Vector;
import javax.swing.DefaultCellEditor;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;
import javax.swing.border.TitledBorder;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;

public final class SplitsHandler
extends JPanel {
    String[] headerNames = new String[]{"Category/Transfer", "Amount", "Memo"};
    Vector origSplits = null;
    Vector editedSplits = null;
    int rows;
    private EmptyBorder tableCellBorder;
    MyTableCellRenderer tableRenderer;
    MyTableCellEditor tableEditor;
    MyComboBoxCellEditor comboEditor;
    MyTableModel mtm;
    PLCash parent;
    EditorPane editorPane;
    private Font tableFont;
    boolean isInvest;
    Account account = null;
    Transaction orig_t;
    private JScrollPane splitsScrollPane;
    private JMenuItem goToMenuItem;
    private JTable splitsTable;
    private JMenuItem deleteMenuItem;
    private JPopupMenu popupMenu;

    public SplitsHandler(PLCash pLCash, EditorPane editorPane, boolean bl) {
        this.parent = pLCash;
        this.editorPane = editorPane;
        this.isInvest = bl;
        this.initComponents();
        this.tableFont = new Font("Monospaced", 0, this.parent.programValues.db_TableFontSize);
        this.tableCellBorder = new EmptyBorder(0, 2, 0, 2);
    }

    public void refreshTable() {
        this.setupTable2();
    }

    public boolean setupTable(Account account, Transaction transaction, Vector vector) {
        if (account == null) {
            // empty if block
        }
        this.account = account;
        this.orig_t = transaction;
        this.origSplits = vector;
        this.editedSplits = this.copySplits(this.origSplits);
        return this.setupTable2();
    }

    public boolean setupTable2() {
        this.rows = this.editedSplits.size();
        this.addRowsIfNeeded(this.editedSplits, this.rows);
        this.setNewModel(this.headerNames, this.rows);
        try {
            this.tableRenderer = new MyTableCellRenderer();
            this.splitsTable.setDefaultRenderer(Class.forName("java.lang.Object"), this.tableRenderer);
            this.tableEditor = new MyTableCellEditor(new JTextField());
            this.comboEditor = new MyComboBoxCellEditor(new JComboBox());
            this.splitsTable.setDefaultEditor(Class.forName("java.lang.Object"), this.tableEditor);
            this.splitsTable.getColumnModel().getColumn(0).setCellEditor(this.comboEditor);
            this.splitsTable.setFont(new Font("Monospaced", 0, this.parent.programValues.db_TableFontSize));
        }
        catch (ClassNotFoundException classNotFoundException) {
            classNotFoundException.printStackTrace();
        }
        this.splitsTable.setFont(this.tableFont);
        FontMetrics fontMetrics = this.splitsTable.getFontMetrics(this.tableFont);
        int n = fontMetrics.getAscent() + fontMetrics.getDescent() + fontMetrics.getLeading() + 8;
        this.splitsTable.setRowHeight(n);
        return this.rows > 1;
    }

    private void setNewModel(String[] stringArray, int n) {
        this.mtm = new MyTableModel(stringArray, n);
        this.splitsTable.setModel(this.mtm);
    }

    public void stopEditing() {
        this.tableEditor.stopCellEditing();
        this.comboEditor.stopCellEditing();
    }

    private Vector copySplits(Vector vector) {
        int n = vector == null ? 1 : vector.size() + 1;
        Vector<Transaction> vector2 = new Vector<Transaction>();
        for (int i = 0; i < n; ++i) {
            Transaction transaction;
            if (i < n - 1) {
                Object e = vector.get(i);
                if (e instanceof MemorizedItem) {
                    MemorizedItem memorizedItem = (MemorizedItem)e;
                    transaction = new Transaction(this.parent, this.account, 0L, memorizedItem.makeEscapedDatabaseRecord());
                } else {
                    transaction = new Transaction(this.parent, (Transaction)vector.get(i));
                }
            } else {
                transaction = new Transaction(this.parent, this.account, this.orig_t.getTime(), "", "", 0.0);
            }
            vector2.add(transaction);
            if (transaction.acc != null) continue;
        }
        return vector2;
    }

    public Vector createSplitsVector() {
        if (this.editedSplits == null) {
            return null;
        }
        Vector<Transaction> vector = new Vector<Transaction>();
        for (int i = 0; i < this.editedSplits.size(); ++i) {
            Transaction transaction = (Transaction)this.editedSplits.get(i);
            if (transaction.db_Category.length() <= 0 || transaction.db_Amount == 0.0) continue;
            Transaction transaction2 = new Transaction(this.parent, transaction);
            vector.add(transaction2);
        }
        if (vector.size() == 0) {
            vector = null;
        }
        return vector;
    }

    private boolean addRowsIfNeeded(Vector vector, int n) {
        boolean bl = false;
        while (n > this.rows) {
            vector.add(new Transaction(this.parent, this.account, this.orig_t.getTime(), "", "", 0.0));
            this.rows = vector.size();
            bl = true;
        }
        return bl;
    }

    private Color fetchFCol(int n, Transaction transaction) {
        if (n != 1 || transaction.db_Amount >= 0.0) {
            return new Color(0, 0, 0);
        }
        return new Color(255, 0, 0);
    }

    private String fetchFieldData(int n, int n2) {
        if (this.editedSplits == null) {
            return "";
        }
        if (n >= this.rows) {
            return "";
        }
        Transaction transaction = (Transaction)this.editedSplits.get(n);
        return this.fetchFieldData(n2, transaction);
    }

    private String fetchFieldData(int n, Transaction transaction) {
        String string = "";
        switch (n) {
            case 0: {
                string = transaction.db_Category;
                break;
            }
            case 1: {
                if (transaction.db_Amount == 0.0) break;
                string = this.parent.commonCode.getCurrencyDollarCentString(transaction.db_Amount, false);
                break;
            }
            case 2: {
                string = transaction.db_Memo;
            }
        }
        return string;
    }

    private void goToTransfer() {
        if (this.editedSplits == null) {
            return;
        }
        int n = this.splitsTable.getSelectedRow();
        if (n >= 0 && n < this.editedSplits.size()) {
            Transaction transaction = (Transaction)this.editedSplits.get(n);
            transaction.updateKey();
            TransactionLocation transactionLocation = this.parent.commonCode.locateTransaction(this.parent.accountHandler.dataMap, this.account, transaction, this.parent.commonCode.ACTION_DO_NOTHING);
            if (transactionLocation != null) {
                int n2 = transactionLocation.a.indexOf(transactionLocation.t);
                this.parent.displayHandler.addTest(transactionLocation.a, n2);
            } else {
                JOptionPane.showMessageDialog(null, "Cannot jump to \"" + transaction.db_Category + "\".", "Jump to Transfer", 0);
            }
        }
    }

    private void deleteSplits() {
        if (this.editedSplits != null) {
            int[] nArray = this.splitsTable.getSelectedRows();
            if (nArray.length > 0) {
                int n = JOptionPane.showConfirmDialog(null, "Okay to delete " + nArray.length + " selected split(s)?", "Delete splits", 1);
                if (n == 0) {
                    this.editorPane.setChanged(true);
                    for (int i = nArray.length - 1; i >= 0; --i) {
                        int n2 = nArray[i];
                        if (n2 >= this.editedSplits.size()) continue;
                        this.editedSplits.remove(n2);
                    }
                    this.refreshTable();
                }
            } else {
                this.parent.beep();
            }
        }
    }

    private void handleMenu(MouseEvent mouseEvent) {
        if (mouseEvent.isPopupTrigger()) {
            this.popupMenu.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
        }
    }

    private void initComponents() {
        this.popupMenu = new JPopupMenu();
        this.goToMenuItem = new JMenuItem();
        this.deleteMenuItem = new JMenuItem();
        this.splitsScrollPane = new JScrollPane();
        this.splitsTable = new JTable();
        this.goToMenuItem.setText("Go to transfer");
        this.goToMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SplitsHandler.this.goToMenuItemActionPerformed(actionEvent);
            }
        });
        this.popupMenu.add(this.goToMenuItem);
        this.deleteMenuItem.setText("Delete ...");
        this.deleteMenuItem.setToolTipText("Delete this split");
        this.deleteMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SplitsHandler.this.deleteMenuItemActionPerformed(actionEvent);
            }
        });
        this.popupMenu.add(this.deleteMenuItem);
        this.setLayout(new BorderLayout());
        this.setMinimumSize(new Dimension(31, 80));
        this.splitsScrollPane.setBorder(new TitledBorder("Splits"));
        this.splitsTable.setModel(new DefaultTableModel(new Object[][]{{null, null, null, null}, {null, null, null, null}, {null, null, null, null}, {null, null, null, null}}, new String[]{"Title 1", "Title 2", "Title 3", "Title 4"}));
        this.splitsTable.setColumnSelectionAllowed(true);
        this.splitsTable.setPreferredScrollableViewportSize(new Dimension(450, 64));
        this.splitsTable.setRowMargin(0);
        this.splitsTable.setShowHorizontalLines(false);
        this.splitsTable.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                SplitsHandler.this.splitsTableMousePressed(mouseEvent);
            }

            @Override
            public void mouseReleased(MouseEvent mouseEvent) {
                SplitsHandler.this.splitsTableMouseReleased(mouseEvent);
            }
        });
        this.splitsScrollPane.setViewportView(this.splitsTable);
        this.add((Component)this.splitsScrollPane, "Center");
    }

    private void deleteMenuItemActionPerformed(ActionEvent actionEvent) {
        this.deleteSplits();
    }

    private void goToMenuItemActionPerformed(ActionEvent actionEvent) {
        this.goToTransfer();
    }

    private void splitsTableMouseReleased(MouseEvent mouseEvent) {
        this.handleMenu(mouseEvent);
    }

    private void splitsTableMousePressed(MouseEvent mouseEvent) {
        this.handleMenu(mouseEvent);
    }

    public class MyTableCellEditor
    extends DefaultCellEditor
    implements TableCellEditor {
        JTextField field;

        public MyTableCellEditor(JTextField jTextField) {
            super(jTextField);
            this.field = jTextField;
            this.field.setFont(SplitsHandler.this.tableRenderer.getFont());
            this.setClickCountToStart(2);
        }

        @Override
        public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
            String string = SplitsHandler.this.fetchFieldData(n, n2);
            this.field.setText(string);
            return this.field;
        }

        @Override
        public Object getCellEditorValue() {
            return this.field.getText();
        }
    }

    public class MyComboBoxCellEditor
    extends DefaultCellEditor
    implements TableCellEditor {
        JComboBox box;

        public MyComboBoxCellEditor(JComboBox jComboBox) {
            super(jComboBox);
            this.box = jComboBox;
            this.box.setFont(SplitsHandler.this.tableFont);
            if (!SplitsHandler.this.isInvest) {
                SplitsHandler.this.parent.categoryHandler.setupComboBox(this.box, null);
            }
            SplitsHandler.this.parent.accountHandler.setupComboBox(this.box, null);
            this.setClickCountToStart(2);
        }

        @Override
        public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
            String string = SplitsHandler.this.fetchFieldData(n, n2);
            this.box.setSelectedItem(string);
            return this.box;
        }

        @Override
        public Object getCellEditorValue() {
            return (String)this.box.getSelectedItem();
        }
    }

    final class MyTableCellRenderer
    extends JLabel
    implements TableCellRenderer {
        public MyTableCellRenderer() {
            this.setOpaque(true);
            this.setVerticalAlignment(0);
            this.setFont(SplitsHandler.this.tableFont);
            this.setBorder(SplitsHandler.this.tableCellBorder);
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            this.setBackground((n & 1) == 0 ? SplitsHandler.this.parent.programValues.db_EvenRowColor : SplitsHandler.this.parent.programValues.db_OddRowColor);
            if (n >= SplitsHandler.this.rows) {
                this.setText("");
            } else {
                Transaction transaction = (Transaction)SplitsHandler.this.editedSplits.get(n);
                this.setForeground(SplitsHandler.this.fetchFCol(n2, transaction));
                this.setText(SplitsHandler.this.fetchFieldData(n2, transaction));
            }
            if (bl) {
                this.setBackground(jTable.getSelectionBackground());
            }
            return this;
        }
    }

    final class MyTableModel
    extends DefaultTableModel {
        public MyTableModel(String[] stringArray, int n) {
            super(stringArray, n);
        }

        @Override
        public void setValueAt(Object object, int n, int n2) {
            String string = (String)object;
            if (string != null) {
                SplitsHandler.this.editorPane.setChanged(true);
                if (SplitsHandler.this.addRowsIfNeeded(SplitsHandler.this.editedSplits, n + 2)) {
                    this.setRowCount(SplitsHandler.this.rows);
                }
                Transaction transaction = (Transaction)SplitsHandler.this.editedSplits.get(n);
                switch (n2) {
                    case 0: {
                        transaction.db_Category = string;
                        break;
                    }
                    case 1: {
                        transaction.db_Amount = SplitsHandler.this.parent.commonCode.zeroFailParseDouble(string);
                        break;
                    }
                    case 2: {
                        transaction.db_Memo = string;
                    }
                }
                this.fireTableCellUpdated(n, n2);
            }
        }
    }
}

