/***************************************************************************
 *   Copyright (C) 2004 by Paul Lutus                                      *
 *   lutusp@arachnoid.com                                                  *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#include "graphicdisplay.h"
#include "signalgen.h"
#include "qapplication.h"


GraphicDisplay::GraphicDisplay(QLabel *f,SignalGen *p) {
    parent = p;
    frame = f;
    qpm = NULL;
    oldxsize = -1;
    oldysize = -1;
    busy = false;
}
GraphicDisplay::~GraphicDisplay() {
    delete(qpm);
}

void GraphicDisplay::ShowData(double data[], int size,double zeroPoint,double vscale,double hscale,bool force) {
    if(!busy) {
        busy = true;
        //SignalGen *p = (SignalGen *)parent;
        int xsize = frame->width();
        int ysize = frame->height();
        //printf("x: %d, y: %d\n",xsize,ysize);
        int hsize = (int) (size * hscale);
        //printf("x: %d, y: %d, s: %d, hs: %lf\n",xsize,ysize,size,hscale);
        if(qpm == NULL || oldxsize != xsize || oldysize != ysize) {
            delete(qpm);
            qpm = new QPixmap(xsize,ysize);
            oldxsize = xsize;
            oldysize = ysize;
        }
        if(qApp->tryLock()) {
            if(qpm != NULL && data != NULL && (parent->isRunning || force)) {
                qpm->fill(QColor(0,0,0));
                QPainter pixpainter(qpm);
                //pixpainter.begin(qpm);
                pixpainter.setPen(QColor(0,255,0));
                int py0 = scalePoint(zeroPoint,ysize-1,0);
                int opx = 0,opy = 0;
                for(int i = 0;i < hsize && (parent->isRunning || force);i++) {

                    double dx = (double)i/(double) hsize;
                    double dy = (data[i] * (vscale/2)) + zeroPoint;
                    int px = scalePoint(dx,0,xsize);
                    int py = scalePoint(dy,ysize-1,0);
                    if(i == 0) {
                        opx = 0;
                        opy = py0;
                    }
                    pixpainter.drawLine(opx,opy,px,py);
                    //printf("x: %d, y: %d\n",px,py);
                    opx = px;
                    opy = py;
                }
                pixpainter.end();
                if(!parent->closing) {
                    bitBlt(frame,0,0,qpm);
                }
            }
            qApp->unlock();
        }
        busy = false;
    }
}

int GraphicDisplay::scalePoint(double v,int a, int b) {
    return (int) ((v * (b-a)) + a);
}
