/***************************************************************************
 *   Copyright (C) 2004 by Paul Lutus                                      *
 *   lutusp@arachnoid.com                                                  *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#include "oscillatordisplaydriver.h"
#include "oscillatoraudiodriver.h"
#include "oscillatorfunctions.h"
#include "signalgen.h"
#include <qapplication.h>

OscillatorDisplayDriver::OscillatorDisplayDriver(SignalGen *p)
        : QThread() {
    parent = p;
    gd = new GraphicDisplay(parent->GraphicDisp,parent);
    size = 500;
    scale = .1;
    array = new double[size];
}

OscillatorDisplayDriver::~OscillatorDisplayDriver() {
    delete(gd);
    delete(array);
}

void OscillatorDisplayDriver::run() {
    process();
}

void OscillatorDisplayDriver::process() {
    //SignalGen *p = (SignalGen *)parent;
    while(parent->isRunning) {
        if(parent->osc->validAudio && scale > 0) {
            double step = scale/(double)size;
            double t = 0;
            for(int i = 0; i < size;i++) {
                // must change waveforms on the fly in response to user input
                double z = OscillatorFunctions::getFunct(parent->waveform)(parent->freqn,t);
                array[i] = z * parent->level;
                t += step;
            }
            gd->ShowData(array,size,.5,1.0,1.0,false);
            usleep(200000);
        }
    }
}
