/***************************************************************************
 *   Copyright (C) 2004 by Paul Lutus                                      *
 *   lutusp@arachnoid.com                                                  *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

static const char *HelpText = "*** Help for SlideProjector\n\nSlideProjector is (c) Copyright 2007, P. Lutus.\n\nSlideProjector is released under the GPL (the GNU General Public License). Additionally, it is CareWare (no money, now or ever). Visit the CareWare Page at www.arachnoid.com/careware.\n\nFor recent revisions and further information, visit the SlideProjector Home Page at www.arachnoid.com/SlideProjector.\n\nSlideProjector is a Linux-specific C++ program meant to prepare and display electronic slide shows. It relies on computer graphic files as its source of programming material, and it can be made to show the images in many different ways.\n\nSlideProjector retains user choices, and its slide shows for the current user, in the directory [PROGDIR] on this computer. These files can and should be backed up if any time is invested in them.\n\nBasically, SlideProjector allows the user to examine and manipulate directories of graphic images, creates a plain-text \"show\" file containing the images chosen by the user, and then displays that show. SlideProjector is compatible with the commands issued by common multimedia projectors.\n\n*** How to use SlideProjector\n\nTypically, a user will:\n\n1. Interactively prepare a list of images,\n2. Save the list, then\n3. Show the images.\n\n*** Creating a slide show\n\nRun SlideProjector. To begin creating your slide show, click the \"Editing\" tab at the bottom of the display.\n\nClick \"New/Copy\" and type a show name into the dialog that will apppear. Press \"Enter\" to create and save the new show.\n\nNow click the \"Add\" button at the right to choose a graphic image directory from your file system. Remember that the image files and locations must remain the same when the slide show is presented. This is because only the image paths and names are used in SlideProjector, and (very important) the image files are never moved or deleted.\n\nWhen you load a directory for the first time, you will be asked whether you want to create a thumbnail directory. The thumbnail directory contains miniature versions of all your images and greatly increases the speed of editing tasks.\n\nAgain, remember that SlideProjector never deletes or moves any files, it only manipulates file names. When you delete an image in SlideProjector, you are only deleting a name from a list, not a file from a drive.\n\nOnce the thumbnail directory is created, the images will appear in a new tab at the right of the display. Now you can manipulate the images in several ways.\n\nThe easiest way to create a slide show is to simply drag images from the right-hand window to the left. The default behavior is to remove the images from the right-hand window when they are moved to the left -- this allows you to keep track of which images have been added to your show and which have not. But if you prefer to keep copies of the images in the left windows, simply press the control key as you drag images.\n\nYou may select and move more than one image at a time -- just select a group of images by moving the mouse across them, then press the left mouse button are drag the group into the destination window.\n\nApart from dragging and dropping images, you may also use the clipboard to edit images. Just select images as above (or press Ctrl+A to select all the images), then press Ctrl+C for copy or Ctrl+X for cut, then click the destination window and press Ctrl+V (paste). There is also a context menu with these and other choices that can be gotten by pressing the right mouse button.\n\nYou may also preview an image by double-clicking it. This displays a larger version of the image. To return to the editing display, press the right mouse button.\n\nWhile experimenting with the editing features, be sure to look at the editing context menu choices by pressing the right mouse button.\n\n*** Image Placement and Editing\n\nNow for a little detail. Suppose you want to place a new image between two other images in your show -- let's say the two images are A and B and you want to put a new image N between them. Simply drag the new image over image A and release the mouse button. This will insert the image between images A and B. Remember this rule -- insertions are always placed after the image pointed to by the mouse cursor.\n\nThe above procedure can be used to insert multiple images as well -- just select the images and drag them to the destination as explained above.\n\nYou may wonder, if the new images are always placed after the chosen insertion point, how can you change the first slide in your show? Well, just insert the new slide after the first one, then drag the first slide over the new image to change their order. Example:\n\nBefore insertion, images A and B:\n\n[A][B]\n\nInsert new image N:\n\n[N] (drop on A)\n |\n[A][B]\n\nAfter insertion:\n\n[A][N][B]\n\nSlide A over N:\n\n[A]\n |\n[N][B]\n\nFinal order:\n\n[N][A][B]\n\nIn all candor, it is much easier to directly experiment with and use these methods than to try to diagram them in plain text.\n\nIf you make a change that you regret, just press Crtl+Z to recover the prior state. If you then decide you actually liked the change you have undone, you can re-do it using Ctrl+Shift+Z.\n\nRemember that Slideprojector editing and display relies on a plain-text list of image file paths. To prove this for yourself, do this experiment:\n\n1. Select some images in the editing views described above.\n2. Press Ctrl+C or choose the \"Copy\" context menu choice.\n3. Open a new, empty document in your favorite text editor.\n4. Press Ctrl+V or choose \"Paste\" in the editor's menu system.\n\nThe result will be a list of image file paths.\n\nThis procedure can be performed in reverse -- you can copy image file paths from any plain-text source such as a text editor or a file browser, and paste the resulting list into SlideProjector's editing windows to get the images into your show.\n\nAfter you are satisfied with your show, press \"Save\" at the upper left.\n\nEach show is saved as a separate plain text file, located on this computer in the directory [PROGDIR]. You may want to back up these files in cases where you need to:\n\n1. Preserve the result of a lot of effort,\n2. Transfer slide shows between computers.\n\n*** Displaying a slide show\n\nTo display your show, press the \"Display\" tab at the bottom of the program window. There are a number of options, accessed by way of buttons and keyboard:\n\nKeyboard          Function\n------------------------------------\nHome              Jump to first slide \nEnd               Jump to last slide \nLeft arrow/PgUp   Move to previous slide \nRight arrow/PgDn  Move to next slide\nF1                Help\nF2                Configuration\nF3                Slide display / normal window\nF4                Slide display / maximized window\nF5                Slide display / full-screen mode\nF6                Slide Display / toggle alignment square\nF7                Edit slide show\nF8                Start automatic slide show\nF9                Toggle zoom/unzoom image (mouse moves zoomed image)\n\nThe PgUP and PgDn keys are included because they are supported by many multimedia projector remote controls to change slides.\n\n*** Additional controls:\n\nIf the \"Right mouse button action\" is set to \"Toggles Zoom\" on the configuration tab, the right mouse button changes to/from a zoomed image presentation, as does the \"Esc\" key. Once the image is zoomed, the mouse can be used to pan around in the image (if the full-size image is larger than your computer display).\n\nIf the \"Right mouse button action\" is set to \"Toggles Key Slide\", both the right mouse button and the \"Esc\" key switches between a particular slide and the \"key\" slide (slide 1). This feature is used to switch between a map or organizational chart and a particular image, where frequent review of such a chart is needed.\n\nIf an automatic slide show is underway (see below), either the right mouse button or the \"Esc\" key can be used to stop the show.\n\n*** Automatic Slide Show\n\nAn automatic display feature allows an unattended slide show with a chosen time interval between slides. Choose the \"Configure\" tab, select a time interval and choose whether to repeat, then press \"Start Auto Show\". The show will begin. To stop the auto show, press \"Esc\" or the right mouse button.\n\n*** External Actions\n\nThis is a somewhat advanced feature, but very useful. SlideProjector can trigger external actions when a particular slide is shown, for example, it can play a sound effect to accompany a slide. To enable this feature, put a shell script in the SlideProjector directory (on your system, that would be [PROGDIR]) named \"extensions.sh\". I use this extension feature to play bird songs and other sound effects, synchronized with particular slides. Here is an example content for \"extensions.sh\":\n\n#!/bin/sh\n\nif `echo $1 | grep -q hermit_thrush`\nthen\n	play hermit_thrush.mp3 &\nfi\n\nWith this shell script content located in [PROGDIR]/extensions.sh on your system, and upon showing a slide with the characters \"hermit_thrush\" somewhere in its file name, the sound file \"hermit_thrush.mp3\" would be played.\n\nPlease notice the the \"&\" character at the end of the command line in my example. The \"&\" character causes the action to run simultaneously with the slide display. If it is not present, the action will be carried out first, then the slide will be shown.\n\nRemember about this feature that any imaginaable shell script content can be placed in the extensions shell script. The full path to the presently displayed slide is provided to the script, so you can control what happens on a slide-by-slide basis.\n\n*** Technical note\n\nSlideProjector is DCOP compliant and can be controlled in various ways through this interface. Just run SlideProjector, then run \"dcop\" from a shell or \"kdcop\" if you prefer a GUI interface, and explore the features under slideprojector.SlideProjectorIface. This interface will permit control of the the program from virtually any DCOP-compliant source.\n\n*** User support\n\nBecause SlideProjector is free (but please visit www.arachnoid.com/careware anyway), there is no user support. This program is very easy to use and common sense should be able to stand in for user support.\n\nIf you detect a bug in SlideProjector, please report it at http://www.arachnoid.com/messages. Make sure what you are reporting is in fact a bug. :)\n\n-- P. Lutus, Port Hadlock, WA";
