/***************************************************************************
 *   Copyright (C) 2004 by Paul Lutus                                      *
 *   lutusp@arachnoid.com                                                  *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#include "imagefilehandler.h"
#include "imagedata.h"
#include "dirent.h"

ImageFileHandler::ImageFileHandler() {
    fileList = NULL;
}

ImageFileHandler::~ImageFileHandler() {
    eraseImages();
    delete(fileList);
}

vector <string> ImageFileHandler::getProgramList(string path) {
    return readDirectory(path,".txt");
}

vector <string> ImageFileHandler::readDirectory(string path,string match) {
    DIR *p;
    vector <string> dir;
    if((p = opendir(path.c_str()))) {
        struct dirent *d;
        while((d = readdir(p))) {
            string s = string(d->d_name);
            size_t p = s.find(match);
            if(p != string::npos) {
                string name = s.substr(0,p);
                dir.push_back(name);
            }
        }
        closedir(p);
        sort(dir.begin(),dir.end());
    }
    return dir;
}

void ImageFileHandler::eraseImages() {
    if(fileList != NULL) {
        for(int i = 0;i < (int) fileList->size();i++) {
            delete((*fileList)[i]);
        }
        delete(fileList);
    }
}

void ImageFileHandler::newImageSet(string path,string name) {
    eraseImages();
    fileList = new vector <ImageData *> ();
    ifstream ifs((path + "/" + name + ".txt").c_str());
    string line;
    while(getline(ifs,line)) {
        fileList->push_back(new ImageData(line));
    }
    currentImage = 0;
}

int ImageFileHandler::listSize() {
    return (fileList == NULL)?0:fileList->size();
}

int ImageFileHandler::getCurrentImage() {
    return currentImage;
}

string ImageFileHandler::retrieveCurrentImagePath() {
    return (*fileList)[currentImage]->retrieveCurrentImagePath();
}

QImage *ImageFileHandler::retrieveFirstImage() {
    return retrieveImage(0);
}

QImage *ImageFileHandler::retrieveLastImage() {
    return retrieveImage(fileList->size()-1);
}

QImage *ImageFileHandler::retrieveDeltaImage(int d) {
    return retrieveImage(currentImage + d);
}

QImage *ImageFileHandler::retrieveImage(int i) {
    if(fileList == NULL)
        return NULL;
    if(i < 0 || i >= (int) fileList->size()) {
        QApplication::beep();
    }
    currentImage = i;
    currentImage = (currentImage < 0)?0:currentImage;
    currentImage = (currentImage >= (int) fileList->size())?fileList->size()-1:currentImage;
    QImage *im = getImage(currentImage,true);
    processAdjacentImages();
    return im;
}

QImage *ImageFileHandler::getImage(int i,bool now) {
    if(i < 0 || i >= (int) fileList->size())
        return NULL;
    QImage *im = (*fileList)[i]->getImage(now);
    return im;
}

void ImageFileHandler::processAdjacentImages() {
    getImage(currentImage+1,false);
    getImage(currentImage-1,false);
    for(int i = currentImage-2;i >= 0;i--) {
        (*fileList)[i]->removeImage();
    }
    for(int i = currentImage+2;i < (int) fileList->size();i++) {
        (*fileList)[i]->removeImage();
    }
}
