/***************************************************************************
 *   Copyright (C) 2004 by Paul Lutus                                      *
 *   lutusp@pl-alpha                                                       *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#include "myiconviewitem.h"
#include "myiconview.h"
#include "mypixmap.h"
#include <qtooltip.h>

// Don't allow labels to show -- instead, redefine "text()"
// to return an internal copy of the path.
// this allows transfers between independent copies of the program

MyIconViewItem::MyIconViewItem( MyIconView *p, int is, string& t ) :
QIconViewItem( p, NULL, MyPixmap(t,is) ) {
    iconSize = is;
    parent = p;
    path = t;
    int pos = t.find_last_of("/");
    name = t.substr(pos+1);
    //QToolTip::add(parent,name.c_str());
    //QObject::connect(
    //    this, SIGNAL(dropped( QDropEvent *, const QValueList<QIconDragItem>& )),
    //    this, SLOT(slotNewThing(QDropEvent *, const QValueList<QIconDragItem>&))
    //);
    //setAcceptDrops( TRUE );
    setDragEnabled(true);
    setDropEnabled(true);

}

MyIconViewItem::~MyIconViewItem() {}

bool MyIconViewItem::isValid() {
    QSize size = pixmap()->size();
    return(size.height() > 0 && size.width() > 0);
}

bool MyIconViewItem::acceptDrop( const QMimeSource *mime ) const {
    //printf("viewitem acceptdrop%d\n",rand());
    //fflush(stdout);
    if ( mime->provides( "text/plain" ) )
        return TRUE;
    return FALSE;
}

void MyIconViewItem::dropped( QDropEvent *e, const QValueList<QIconDragItem>& list) {
    //printf("viewitem passing signal.\n");
    //fflush(stdout);
    ((MyIconView *)parent)->slotNewItem(e,list);
}


string MyIconViewItem::text() {
    return path;
}
