/***************************************************************************
 *   Copyright (C) 2004 by Paul Lutus                                      *
 *   lutusp@pl-alpha                                                       *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#include "mypixmap.h"
#include <qfileinfo.h>
#include "slideprojector.h"



MyPixmap::MyPixmap(string& t, int is)
        : QPixmap() {
    QFileInfo info(t);
    string tp = info.dirPath() + "/" + SlideProjector::thumbDirName + "/" + SlideProjector::thumbFilePrefix + info.fileName();
    //printf("trying to read: %s\n",(const char*)tp);
    //fflush(stdout);
    QFileInfo th(tp);
    QImage *image;
    if(th.exists()) {
        image = new QImage(tp);
    } else {
        image = new QImage(t);
    }
    //printf("MyPixMap trying to load %s = %d\n",(const char*)t,(int) image);
    //fflush(stdout);
    if(image == NULL) {
        //printf("NULL MyPixMap for %s\n",(const char*)t);
        //fflush(stdout);
    } else if(image->isNull()) {
        //printf("null conversion MyPixMap for %s\n",(const char*)t);
        //fflush(stdout);
    } else {
        QImage small = image->scale(is,is,QImage::ScaleMin);
        if(small.isNull()) {
            //printf("null small conversion MyPixMap for %s\n",(const char*)t);
            //fflush(stdout);
        } else {
            convertFromImage(small);
        }
    }
    delete(image);
}

MyPixmap::~MyPixmap() {}


