/***************************************************************************
 *   Copyright (C) 2004 by Paul Lutus                                      *
 *   lutusp@arachnoid.com                                                  *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#ifndef MYQLABEL_H
#define MYQLABEL_H

#include <qlabel.h>
#include <qnamespace.h>
#include <qpixmap.h>
#include <qimage.h>
#include <qpainter.h>
#include <qcursor.h>
#include <qobject.h>
#include <qtimer.h>

class SlideProjector;

/**
@author Paul Lutus
*/
class MyQLabel : public QLabel
{
  Q_OBJECT
public:
  MyQLabel(SlideProjector * p1,QWidget *p2 = 0,const char* name = 0, WFlags fl = 0);

  ~MyQLabel();

  QPixmap *pm;
  QImage *image;

  QColor backgroundColor;
  QColor borderColor;

  QTimer *cursorTimer;

  SlideProjector *parent;

  int oldWidth,oldHeight;

  QSize minimumSizeHint();

  void setImage(QImage *im,bool update,bool fe);
  void setPMap();
  void toggleAlignmentFrame(bool);
  void contextMenuEvent( QContextMenuEvent * e);
  void refreshImage(bool active);

  void paintEvent(QPaintEvent *e);

  bool alignmentFrame;
  bool borderFrame;

  bool fromEditor;

  bool oldZoom;
  int mouseStartX,mouseStartY;
  int mouseDeltaX,mouseDeltaY;
  int mouseOldX,mouseOldY;
  int mouseTime;

public slots:
  void mousePressEvent(QMouseEvent* e);
  void mouseMoveEvent(QMouseEvent* e);
  void cursorControl();

};

#endif
