/***************************************************************************
 *   Copyright (C) 2004 by Paul Lutus                                      *
 *   lutusp@arachnoid.com                                                  *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#include "thumbcreationthread.h"
#include <string>
#include <qimage.h>
#include <qapplication.h>
#include "slideprojector.h"


using namespace std;

ThumbCreationThread::ThumbCreationThread()
        : QThread() {}


ThumbCreationThread::~ThumbCreationThread() {}

void ThumbCreationThread::execute(string d, QProgressBar *dpb,int ics, bool ca) {
    dir = d;
    pbar = dpb;
    iconSize = ics;
    createAll = ca;
    start( QThread::IdlePriority );
}

void ThumbCreationThread::run() {
    //qApp->lock();
    makeThumbnailDirThread();
    //qApp->unlock();
}

void ThumbCreationThread::makeThumbnailDirThread() {
    QDir d1(dir);
    string p2 = dir + "/" + SlideProjector::thumbDirName;
    QDir d2(p2);
    d2.mkdir(d2.path());
    d1.setFilter( QDir::Files );
    int len = d1.count();
    for(unsigned int i = 0; i < d1.count();i++) {
        int pbarv = ((i+1) * 100) / len;
        pbar->setProgress(pbarv);
        //pbar->update();
        string src = d1.path() + "/" + d1[i];
        string dest = d2.path() +  "/" + SlideProjector::thumbFilePrefix + d1[i];
        if(createAll || !fileExists(dest)) {
            //printf("Making %s\n",src.c_str());
            //fflush(stdout);
            QImage *image = new QImage(src);
            if(!image->isNull()) {
                QImage it = image->scale(iconSize,iconSize,QImage::ScaleMin);
                if(it == NULL) {
                    //printf("ERROR: NULL for scaled %s\n",(const char*)src);
                    //fflush(stdout);
                } else {
                    QString format = QImage::imageFormat(src);
                    it.save(dest,format);
                }
            }
            delete image;
        }
    }
    pbar->reset();
    pbar->update();
}

bool ThumbCreationThread::fileExists(string path) {
    ifstream ifs(path.c_str());
    bool r = ifs.is_open();
    ifs.close();
    return r;
}
