/*
 * Decompiled with CFR 0.152.
 */
package tankcalc;

import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JOptionPane;
import javax.swing.JTextField;
import tankcalc.MutableDouble;
import tankcalc.TankCalc;

public final class CopyPasteTankDescription {
    TankCalc parent;
    Object[] controlList;

    public CopyPasteTankDescription(TankCalc p) {
        this.parent = p;
        this.controlList = new Object[]{this.parent.tankOrientationComboBox, this.parent.sensorOrientationComboBox, this.parent.residVolumeTextField, this.parent.tankAngleTextField, this.parent.g_LTextField, this.parent.g_RTextField, this.parent.sensorXTextField, this.parent.sensorYTextField, this.parent.sensorZTextField, this.parent.leftCapComboBox, this.parent.g_rLTextField, this.parent.rightCapComboBox, this.parent.g_rRTextField, this.parent.inputUnitsComboBox, this.parent.outputUnitsComboBox, this.parent.tableHeightStepSizeTextField, this.parent.tableVolumeStepSizeTextField, this.parent.decimalPlacesComboBox, this.parent.tableTitleTextField, this.parent.wallThicknessTextField, this.parent.wallDensityTextField, this.parent.contentDensityTextField, this.parent.weightUnitsComboBox, this.parent.leftCapCheckBox, this.parent.cylinderCheckBox, this.parent.rightCapCheckBox, this.parent.sensorCheckBox, this.parent.lineThicknessComboBox, this.parent.anaglyphCheckBox, this.parent.xLinesComboBox, this.parent.yLinesComboBox, this.parent.inverseCheckBox};
    }

    void setClipboardContents(String s) {
        StringSelection stringSelection = new StringSelection(s);
        Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        clipboard.setContents(stringSelection, this.parent);
    }

    String getClipboardContents() {
        String s = null;
        Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        Transferable content = clipboard.getContents(this.parent);
        if (content != null) {
            try {
                s = (String)content.getTransferData(DataFlavor.stringFlavor);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return s;
    }

    public void copyTankDescription() {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < this.controlList.length; ++i) {
            String value = null;
            Object comp = this.controlList[i];
            String name = comp.getClass().getSimpleName();
            if (name.equals("JComboBox")) {
                value = "" + ((JComboBox)comp).getSelectedIndex();
            } else if (name.equals("JCheckBox")) {
                value = ((JCheckBox)comp).isSelected() ? "1" : "0";
            } else if (name.equals("JTextField")) {
                value = ((JTextField)comp).getText();
                value = value.replaceAll("\\|", "@@");
            } else if (name.equals("MutableDouble")) {
                value = String.format("%.4f", ((MutableDouble)comp).v);
            } else {
                System.out.println("cannot decode control " + name);
            }
            if (value == null) continue;
            if (i > 0) {
                sb.append("|");
            }
            sb.append(value);
        }
        this.setClipboardContents(sb.toString());
    }

    public boolean pasteTankDescription(String data) {
        boolean success = true;
        try {
            if (data != null && data.length() > 8) {
                success = false;
                data = this.testForFile(data);
                data = data.replaceFirst("^[\\s|\"|']*(.*?)[\\s|\"|']*$", "$1");
                String[] array = (data = data.replaceAll("(\n|\r|\t)", "")).split("\\|");
                if (array != null && array.length >= this.controlList.length / 2) {
                    for (int i = 0; i < this.controlList.length && i < array.length; ++i) {
                        String value = array[i];
                        Object comp = this.controlList[i];
                        String name = comp.getClass().getSimpleName();
                        if (name.equals("JComboBox")) {
                            ((JComboBox)comp).setSelectedIndex(Integer.parseInt(value));
                            continue;
                        }
                        if (name.equals("JCheckBox")) {
                            ((JCheckBox)comp).setSelected(value.equals("1"));
                            continue;
                        }
                        if (name.equals("JTextField")) {
                            value = value.replaceAll("@@", "|");
                            ((JTextField)comp).setText(value);
                            continue;
                        }
                        if (!name.equals("MutableDouble")) continue;
                        ((MutableDouble)comp).v = this.parent.getDouble(value);
                    }
                    success = true;
                    this.parent.setModeAndLabels();
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return success;
    }

    public void showError(String source) {
        this.parent.beep();
        JOptionPane.showMessageDialog(this.parent, "Unable to acquire tank description from " + source + ".", "Description Parse Error", 1);
    }

    public void pasteTankDescriptionFromClipboard() {
        boolean success;
        this.parent.beep();
        int response = JOptionPane.showConfirmDialog(this.parent, "Okay to overwrite existing tank description?", "Paste new tank description", 2);
        if (response == 0 && !(success = this.pasteTankDescription(this.getClipboardContents()))) {
            this.showError("clipboard");
        }
    }

    String testForFile(String data) {
        File f = new File(data);
        if (f.exists()) {
            StringBuilder sb = new StringBuilder();
            try {
                String line;
                BufferedReader br = new BufferedReader(new FileReader(f));
                while ((line = br.readLine()) != null) {
                    sb.append(line).append("\n");
                }
                br.close();
                data = sb.toString();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return data;
    }
}

