/*
 * Decompiled with CFR 0.152.
 */
package tankcalc;

import java.awt.Point;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import tankcalc.DataTableModel;
import tankcalc.TankCalc;

public final class DataTableDisplay
extends JTable {
    TankCalc parent;
    DataTableModel dataTableModel = null;
    int hScroll;
    int vScroll;

    public DataTableDisplay(TankCalc p) {
        this.parent = p;
        this.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                DataTableDisplay.this.updateDisplay();
            }

            @Override
            public void focusLost(FocusEvent e) {
                DataTableDisplay.this.hScroll = DataTableDisplay.this.parent.tableScrollPane.getHorizontalScrollBar().getValue();
                DataTableDisplay.this.vScroll = DataTableDisplay.this.parent.tableScrollPane.getVerticalScrollBar().getValue();
            }
        });
        this.setToolTipText("Double-click: copy line to clipboard");
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent me) {
                ArrayList<String> data;
                JTable table = (JTable)me.getSource();
                Point p = me.getPoint();
                int row = table.rowAtPoint(p);
                if (me.getClickCount() == 2 && (data = DataTableDisplay.this.dataTableModel.getRowData(row)) != null) {
                    String s = DataTableDisplay.this.parent.buildTSVRow(DataTableDisplay.this.parent.strHeaderArray) + DataTableDisplay.this.parent.buildTSVRow(data);
                    DataTableDisplay.this.parent.copyToClipboard(s);
                }
            }
        });
    }

    protected void updateDisplay() {
        if (this.dataTableModel == null) {
            this.dataTableModel = new DataTableModel(this.parent, this);
            this.setModel(this.dataTableModel);
        }
        this.dataTableModel.updateDisplay();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                DataTableDisplay.this.parent.tableScrollPane.getHorizontalScrollBar().setValue(DataTableDisplay.this.hScroll);
                DataTableDisplay.this.parent.tableScrollPane.getVerticalScrollBar().setValue(DataTableDisplay.this.vScroll);
            }
        });
    }
}

