/*
 * Decompiled with CFR 0.152.
 */
package tankcalc;

import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.util.ArrayList;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableColumnModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumn;
import tankcalc.DataTableCellRenderer;
import tankcalc.TankCalc;

public final class DataTableModel
extends AbstractTableModel {
    TankCalc parent;
    String[] header;
    int[] columnWidths;
    JTable table;
    Font font;
    FontMetrics fm;
    JTableHeader hd;
    DefaultTableCellRenderer headerRenderer;

    public DataTableModel(TankCalc p, JTable table) {
        this.parent = p;
        this.table = table;
        Font origfont = table.getFont();
        this.font = new Font("SansSerif", 0, origfont.getSize());
        table.setFont(this.font);
        this.hd = table.getTableHeader();
        this.hd.setFont(this.font);
        this.hd.setOpaque(true);
        this.fm = table.getFontMetrics(this.font);
        this.headerRenderer = (DefaultTableCellRenderer)this.hd.getDefaultRenderer();
        this.headerRenderer.setHorizontalAlignment(0);
        this.headerRenderer.setFont(this.font);
        this.headerRenderer.setOpaque(true);
        this.headerRenderer.setBackground(new Color(0xC0D0C0));
    }

    protected String padString(String s) {
        return " " + s + " ";
    }

    protected void updateDisplay() {
        if (this.parent.strHeaderArray != null && this.parent.strTableArray != null && this.parent.strTableArray.size() > 0) {
            this.header = this.parent.strHeaderArray.toArray(new String[0]);
            this.columnWidths = new int[this.header.length];
            int marg = 8;
            int cw = this.fm.stringWidth("X");
            for (int n = 0; n < this.columnWidths.length; ++n) {
                this.columnWidths[n] = this.header[n].length() * cw + marg;
            }
            DefaultTableColumnModel tcm = new DefaultTableColumnModel();
            this.table.setColumnModel(tcm);
            int i = 0;
            for (String string : this.parent.strHeaderArray) {
                TableColumn tc = new TableColumn(i);
                DataTableCellRenderer rr = new DataTableCellRenderer();
                tc.setHeaderValue("<html>" + string);
                tc.setCellRenderer(rr);
                tcm.addColumn(tc);
                this.columnWidths[i] = Math.max(string.length() * cw + marg, this.columnWidths[i]);
                ++i;
            }
            this.table.setShowGrid(true);
            for (ArrayList arrayList : this.parent.strTableArray) {
                for (int n = 0; n < arrayList.size(); ++n) {
                    String ss = (String)arrayList.get(n);
                    this.columnWidths[n] = Math.max(ss.length() * cw + marg * 4, this.columnWidths[n]);
                }
            }
            for (int n = 0; n < this.getColumnCount(); ++n) {
                tcm.getColumn(n).setPreferredWidth(this.columnWidths[n]);
            }
            int ch = this.fm.getHeight();
            this.table.setRowHeight(ch + marg);
        }
    }

    public ArrayList<String> getRowData(int row) {
        if (row >= 0 && row < this.getRowCount()) {
            return this.parent.strTableArray.get(row);
        }
        return null;
    }

    @Override
    public String getColumnName(int column) {
        return this.header[column];
    }

    @Override
    public int getRowCount() {
        return this.parent.strTableArray.size();
    }

    @Override
    public int getColumnCount() {
        return this.header != null ? this.header.length : 0;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        if (rowIndex >= 0 && rowIndex < this.parent.strTableArray.size() && this.parent.strTableArray.size() > 0 && columnIndex >= 0 && columnIndex < this.parent.strTableArray.get(0).size()) {
            return this.padString(this.parent.strTableArray.get(rowIndex).get(columnIndex));
        }
        return "";
    }

    @Override
    public boolean isCellEditable(int row, int col) {
        return false;
    }
}

