/*
 * Decompiled with CFR 0.152.
 */
package tankcalc;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Desktop;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URI;
import java.net.URL;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.border.LineBorder;
import javax.swing.event.HyperlinkEvent;
import javax.swing.table.DefaultTableModel;
import javax.swing.text.html.parser.ParserDelegator;
import tankcalc.Constants;
import tankcalc.CopyPasteTankDescription;
import tankcalc.DataTableDisplay;
import tankcalc.HelpPane;
import tankcalc.ImageGenerator;
import tankcalc.InitManager;
import tankcalc.SurfaceAreaMassComputer;
import tankcalc.TankCompResult;
import tankcalc.TankImageView;
import tankcalc.TankProcessor;
import tankcalc.TankProperties;
import tankcalc.UserActionManager;

public final class TankCalc
extends JPanel
implements ClipboardOwner {
    public String programName;
    public String VERSION = "7.4";
    JFrame appFrame;
    InitManager initManager = null;
    protected Rectangle screenBounds;
    boolean applet = false;
    ArrayList<Double[]> dblList = null;
    ArrayList<ArrayList<String>> strTableArray = null;
    ArrayList<String> strHeaderArray = null;
    int[] intColumnWidths;
    HelpPane helpPane = null;
    protected int helpScrollPos = 0;
    SurfaceAreaMassComputer samc = null;
    TankProcessor tankProcessor;
    TankProperties sharedTP;
    boolean enabled = false;
    boolean makeTableFlag;
    String[] tableTitle;
    int helpSlideIndex = 0;
    NumberFormat numberFormat;
    String[] helpSlides = new String[]{"tank_dimensional_diagram_half.png", "tank_end_cap_description_half.png", "tank_math_description_half.png", "tank_sensor_placement_half.png"};
    TankImageView mainPanel3d = null;
    TankImageView subPanel3d = null;
    Color graphicBackgroundColor;
    Color graphicForegroundColor;
    double graphicCurrentFactor;
    CopyPasteTankDescription copyPasteDescription;
    ImageGenerator imageGenHi;
    ImageGenerator imageGenLo;
    int mostRecentTableType = -1;
    boolean inverseMode = false;
    String[] tableCSS = new String[]{"<style type=\"text/css\">", "body {font-family: Verdana, Tahoma, Helvetica, Arial;}", "table {", "border-top:1px solid black;", "border-right:1px solid black;", "border-bottom:1px solid black;", "}", "td {", "border-left:1px solid black;", "padding-right:4px;", "padding-left:4px;", "}", "th {", "text-align:center;", "border-left:1px solid black;", "border-bottom:1px solid black;", "background:#ffffe0;", "font-weight: bold;", "vertical-align:bottom;", "padding:4px;", "}", ".cell0 { text-align:right; background:#f0f0f0; }", ".cell1 { text-align:right; background:white; }", "</style>"};
    protected JLabel LVariableLabel;
    private ButtonGroup NormalInversebuttonGroup;
    protected JLabel RVariableLabel;
    private JPanel SingleResultPanel;
    private JPanel TablePanel;
    protected JCheckBox anaglyphCheckBox;
    protected JLabel anaglyphicLabel;
    protected JCheckBox antialiasingCheckBox;
    private JButton buildHVDataTableButton;
    private JButton buildSpecTableButton;
    private JButton buildVHDataTableButton;
    protected JTextField contentDensityTextField;
    private JPanel controlPanelA;
    private JPanel controlPanelB;
    private JButton copyButton;
    private JButton copyDescButton;
    private JButton copyHTMLToClipboardButton;
    private JButton copyPlainToClipboardButton;
    private JButton copyTSVToClipboardButton;
    protected JCheckBox cylinderCheckBox;
    protected JTextField cylinderIntegrationStepsTextField;
    protected JTable dataTableDisplay;
    protected JLabel debug_label;
    protected JComboBox<Integer> decimalPlacesComboBox;
    protected JTextField endCapIntegrationStepsTextField;
    private JPanel entryPanel;
    private JPanel fillerPanel;
    protected JTextField g_LTextField;
    protected JTextField g_RTextField;
    protected JTextField g_rLTextField;
    protected JTextField g_rRTextField;
    private JButton ghBackButton;
    private JButton ghForwardButton;
    private JButton graphicDefaultsButton;
    private JPanel graphicDisplayPanel;
    private JPanel graphicHelpControls;
    private JPanel graphicModelPanel;
    private JPanel graphicPanel;
    private JLabel heightStepSizeLabel;
    private JPanel helpPanel;
    private JLabel helpSlideLabel;
    private JLabel inputLabel;
    private JPanel inputPanel;
    protected JLabel inputTag;
    protected JComboBox<String> inputUnitsComboBox;
    protected JCheckBox inverseCheckBox;
    protected JLabel jLabel10;
    protected JLabel jLabel11;
    private JLabel jLabel12;
    private JLabel jLabel13;
    protected JLabel jLabel18;
    protected JLabel jLabel19;
    protected JLabel jLabel20;
    protected JLabel jLabel21;
    private JLabel jLabel3;
    private JLabel jLabel5;
    private JLabel jLabel6;
    protected JLabel jLabel9;
    private JPanel jPanel3;
    private JScrollPane jScrollPane2;
    private JScrollPane jScrollPane5;
    protected JLabel lbVariableLabel1;
    protected JLabel lbVariableLabel2;
    protected JCheckBox leftCapCheckBox;
    protected JComboBox leftCapComboBox;
    protected JComboBox<Integer> lineThicknessComboBox;
    private JLabel lineThicknessLabel;
    protected JTabbedPane mainTabbedPane;
    private JPanel modePanel;
    private JLabel outputLabel;
    protected JLabel outputTag;
    protected JComboBox<String> outputUnitsComboBox;
    private JButton pasteDescButton;
    private JCheckBox polygonCheckBox;
    private JButton resetButton;
    protected JLabel residVolumeLabel;
    protected JTextField residVolumeTextField;
    protected JCheckBox rightCapCheckBox;
    protected JComboBox rightCapComboBox;
    protected JTextField rootFinderEpsilonTextField;
    protected JLabel rtVariableLabel1;
    protected JLabel rtVariableLabel2;
    protected JTextField scalingFactorTextField;
    private JLabel scaling_factor_label;
    protected JCheckBox sensorCheckBox;
    protected JComboBox sensorOrientationComboBox;
    protected JLabel sensorPathLabel;
    protected JTextField sensorXTextField;
    protected JTextField sensorYTextField;
    protected JTextField sensorZTextField;
    protected JTextField singleInputField;
    protected JTextField singleOutputField;
    private JLabel statusLabel;
    private JPanel statusPanel;
    private JButton tableCancelButton;
    private JPanel tableControlPanel;
    private JPanel tableDisplayPanel;
    private JPanel tableGenPanel;
    protected JTextField tableHeightStepSizeTextField;
    private JProgressBar tableProgressBar;
    protected JScrollPane tableScrollPane;
    protected JTextField tableTitleTextField;
    private ButtonGroup tableTypeButtonGroup;
    protected JTextField tableVolumeStepSizeTextField;
    protected JLabel tankAngleLabel;
    protected JTextField tankAngleTextField;
    protected JComboBox tankOrientationComboBox;
    protected JComboBox<Integer> transparencyComboBox;
    private JLabel transparencyLabel;
    private JPanel unitsSubPanel;
    private JPanel viewPanel;
    private JLabel volumeStepSizeLabel;
    protected JTextField wallDensityTextField;
    protected JLabel wallThicknessLabel;
    protected JTextField wallThicknessTextField;
    protected JComboBox weightUnitsComboBox;
    protected JLabel xCoordLabel;
    protected JComboBox<Integer> xLinesComboBox;
    protected JLabel yCoordLabel;
    protected JComboBox<Integer> yLinesComboBox;
    protected JLabel zCoordLabel;

    public TankCalc(JFrame p, boolean appl, String[] args) {
        this.appFrame = p;
        String[] progArgs = args;
        this.resetConfig(this.appFrame);
        this.initManager = new InitManager(this, this.applet);
        this.tankProcessor = new TankProcessor();
        this.imageGenHi = new ImageGenerator(this.tankProcessor, this.sharedTP, false);
        this.imageGenLo = new ImageGenerator(this.tankProcessor, this.sharedTP, true);
        this.applet = appl;
        this.programName = this.getClass().getSimpleName();
        ParserDelegator workaround = new ParserDelegator();
        this.numberFormat = NumberFormat.getInstance();
        this.initComponents();
        int w = 800;
        int h = 650;
        Dimension ss = Toolkit.getDefaultToolkit().getScreenSize();
        this.screenBounds = new Rectangle((ss.width - w) / 2, (ss.height - h) / 2, w, h);
        ArrayList<JComboBox<Integer>> boxes = new ArrayList<JComboBox<Integer>>();
        boxes.add(this.xLinesComboBox);
        boxes.add(this.yLinesComboBox);
        this.loadNumberBoxes(boxes, 0, 512, 16);
        boxes.clear();
        boxes.add(this.lineThicknessComboBox);
        boxes.add(this.transparencyComboBox);
        this.loadNumberBoxes(boxes, 0, 10, 1);
        this.samc = new SurfaceAreaMassComputer(this, this.sharedTP);
        this.copyPasteDescription = new CopyPasteTankDescription(this);
        this.helpPane = new HelpPane(this);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        this.helpPanel.add((Component)this.helpPane, gridBagConstraints);
        this.mainPanel3d = new TankImageView(this, this.sharedTP);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        this.graphicDisplayPanel.add((Component)this.mainPanel3d, gridBagConstraints);
        this.mainPanel3d.setPaintChipColors();
        this.subPanel3d = new TankImageView(this, this.sharedTP);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        this.viewPanel.add((Component)this.subPanel3d, gridBagConstraints);
        this.loadComboBox(this.inputUnitsComboBox, Constants.inputUnitNames, 3);
        this.loadComboBox(this.outputUnitsComboBox, Constants.outputUnitVolumeNames, 6);
        this.loadDecComboBox();
        if (this.appFrame != null) {
            this.appFrame.setBounds(this.screenBounds);
        }
        this.manageHelpSlides(0);
        this.setWheelActions();
        this.initManager.getDefaultValues();
        if (!this.applet) {
            this.initManager.readConfig();
            this.writeValues();
        }
        this.mainTabbedPane.setSelectedIndex(this.sharedTP.currentTab);
        this.enabled = true;
        this.processArgs(progArgs);
        this.setModeAndLabels();
        this.updateGraphicImages();
        this.processTabClick();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                TankCalc.this.helpPane.setScrollPos(TankCalc.this.helpScrollPos);
            }
        });
    }

    void resetConfig(JFrame p) {
        this.sharedTP = new TankProperties();
        this.sharedTP.programFrame = p;
    }

    void setConfigurationDefaults() {
        if (this.userRequest("Okay to reset default values?")) {
            this.enabled = false;
            this.resetConfig(this.appFrame);
            this.writeValues();
            this.enabled = true;
            this.mainPanel3d.updateSettings(this.sharedTP);
            this.subPanel3d.updateSettings(this.sharedTP);
            this.tankProcessor.setValues(this, this.sharedTP);
            this.samc.updateSettings(this.sharedTP);
            this.setModeAndLabels();
        }
    }

    void p(String s) {
        System.out.println(s);
    }

    String pn(double n) {
        return String.format("%.4f", n);
    }

    boolean processArgs(String[] args) {
        boolean success = true;
        if (args != null && args.length > 0) {
            success = false;
            for (int i = 0; i < args.length && !(success = this.copyPasteDescription.pasteTankDescription(args[i])); ++i) {
            }
            if (!success) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        TankCalc.this.copyPasteDescription.showError("program arguments");
                    }
                });
            }
        }
        return success;
    }

    void setWheelActions() {
        new UserActionManager(this.tankAngleTextField, 0, 90, this);
        new UserActionManager(this.g_LTextField, 0, 100000, this);
        new UserActionManager(this.g_RTextField, 0, 10000, this);
        new UserActionManager(this.sensorXTextField, -1000000, 1000000, this);
        new UserActionManager(this.sensorYTextField, -1000000, 1000000, this);
        new UserActionManager(this.sensorZTextField, -1000000, 1000000, this);
        new UserActionManager(this.residVolumeTextField, -1000000, 1000000, this);
        new UserActionManager(this.g_rLTextField, 0, 1000000, this);
        new UserActionManager(this.g_rRTextField, 0, 1000000, this);
        new UserActionManager(this.lineThicknessComboBox, 0, 32, this);
        new UserActionManager(this.yLinesComboBox, 0, 512, this);
        new UserActionManager(this.xLinesComboBox, 0, 512, this);
        new UserActionManager(this.transparencyComboBox, 0, 10, this);
    }

    void loadNumberBoxes(ArrayList<JComboBox<Integer>> boxes, int a, int b, int def) {
        for (JComboBox<Integer> box : boxes) {
            box.removeAllItems();
            for (int x = a; x <= b; ++x) {
                box.addItem(x);
            }
            box.setSelectedIndex(def);
        }
    }

    void loadComboBox(JComboBox<String> box, String[] list, int def) {
        box.removeAllItems();
        for (String s : list) {
            box.addItem("<html>" + s + "</html>");
        }
        box.setSelectedIndex(def);
    }

    void loadDecComboBox() {
        this.decimalPlacesComboBox.removeAllItems();
        for (int i = 0; i <= 16; ++i) {
            this.decimalPlacesComboBox.addItem(i);
        }
        this.decimalPlacesComboBox.setSelectedIndex(this.sharedTP.defaultDecimalPlaces);
    }

    public void setVerticalMode(boolean mode) {
        if (mode) {
            this.tankOrientationComboBox.setSelectedItem("Vertical");
            this.getHVTMode();
        }
    }

    void getHVTMode() {
        this.sharedTP.tankOrientation = this.tankOrientationComboBox.getSelectedIndex();
        this.sharedTP.sensorOrientation = this.sensorOrientationComboBox.getSelectedIndex();
    }

    void getInverseMode() {
    }

    void getInputUnits() {
        this.sharedTP.inputUnitIndex = this.inputUnitsComboBox.getSelectedIndex();
    }

    void getOutputUnits() {
        this.sharedTP.outputUnitIndex = this.outputUnitsComboBox.getSelectedIndex();
    }

    String getUnitLabel(boolean hvLabel, boolean height, boolean inverse, boolean input, boolean capitalize) {
        String result = "";
        if (hvLabel) {
            result = result + (height ^ inverse ? "Height " : "Volume ");
        }
        result = result + (input ^ inverse ? Constants.inputUnitNames[this.sharedTP.inputUnitIndex] : Constants.outputUnitVolumeNames[this.sharedTP.outputUnitIndex]);
        if (!capitalize) {
            result = result.toLowerCase();
        }
        return result;
    }

    void showMaxValues() {
        this.readValues();
        double maxh = this.tankProcessor.convertLengthUnits(this.tankProcessor.maxHeight, true);
        double maxVolumeConverted = this.tankProcessor.convertVolumeUnits(this.tankProcessor.maxVolume, true);
        double sensorOff = this.tankProcessor.convertLengthUnits(this.tankProcessor.trueSensorOffset, true);
        String vals = "Tank internal height: " + this.formatNum(maxh) + " " + this.sharedTP.currentInputUnitName;
        vals = vals + ", sensor offset " + this.formatNum(sensorOff) + " " + this.sharedTP.currentInputUnitName;
        vals = vals + ", volume: " + this.formatNum(maxVolumeConverted) + " " + this.sharedTP.currentOutputUnitName;
        String msg = "<html>" + vals + "</html>";
        this.setStatus(msg, false);
    }

    void setModeAndLabels() {
        if (this.enabled) {
            boolean success = this.readValues();
            this.tankAngleTextField.setEnabled(this.sharedTP.tankOrientation == 2);
            this.tankAngleLabel.setEnabled(this.sharedTP.tankOrientation == 2);
            this.transparencyComboBox.setEnabled(this.sharedTP.polygonMode);
            this.transparencyLabel.setEnabled(this.sharedTP.polygonMode);
            this.lineThicknessComboBox.setEnabled(!this.sharedTP.polygonMode);
            this.lineThicknessLabel.setEnabled(!this.sharedTP.polygonMode);
            this.LVariableLabel.setText(" Cylinder length (L) " + this.sharedTP.currentInputUnitName);
            this.RVariableLabel.setText(" Cylinder radius (R) " + this.sharedTP.currentInputUnitName);
            this.lbVariableLabel1.setText(" Left/bottom cap radius (r) " + this.sharedTP.currentInputUnitName);
            this.rtVariableLabel1.setText(" Right/top cap radius (r) " + this.sharedTP.currentInputUnitName);
            this.inputLabel.setText("<html> Enter " + this.getUnitLabel(true, true, this.inverseMode, true, false) + ":</html>");
            this.outputLabel.setText("<html> Result " + this.getUnitLabel(true, false, this.inverseMode, false, false) + ":</html>");
            this.heightStepSizeLabel.setText("<html>&nbsp;Height Table Step Size " + this.getUnitLabel(false, true, false, true, false) + "</html>");
            this.volumeStepSizeLabel.setText("<html>&nbsp;Volume Table Step Size " + this.getUnitLabel(false, true, true, true, false) + "</html>");
            this.residVolumeLabel.setText("<html>&nbsp;Residual " + this.getUnitLabel(true, false, false, false, false) + "</html>");
            this.xCoordLabel.setText(" Sensor X position " + this.getUnitLabel(false, true, false, true, false));
            this.yCoordLabel.setText(" Sensor Y position " + this.getUnitLabel(false, true, false, true, false));
            this.zCoordLabel.setText(" Sensor Z position " + this.getUnitLabel(false, true, false, true, false));
            this.wallThicknessLabel.setText(" Wall thickness " + this.sharedTP.currentInputUnitName);
            this.mainPanel3d.createTankImage(this.sharedTP);
            if (success) {
                this.showMaxValues();
            }
            this.subPanel3d.repaint();
        }
    }

    void setModeIfEnter(KeyEvent evt) {
        if (evt.getKeyChar() == '\n') {
            this.setModeAndLabels();
        }
    }

    void setStatus(String s, boolean error) {
        this.statusLabel.setText(s);
        if (error) {
            Toolkit.getDefaultToolkit().beep();
        }
    }

    double getDouble(String s) {
        double v = 0.0;
        try {
            s = s.toLowerCase();
            String[] array = s.split("e");
            v = this.numberFormat.parse(array[0]).doubleValue();
            if (array.length > 1) {
                double e = this.numberFormat.parse(array[1]).doubleValue();
                v *= Math.pow(10.0, e);
            }
        }
        catch (ParseException parseException) {
            // empty catch block
        }
        return v;
    }

    double getDoubleForTextField(JTextField tf, String label, int mode) {
        double v = 0.0;
        String s = tf.getText();
        switch (mode) {
            case 0: {
                v = this.getDouble(s);
                break;
            }
            case 1: {
                if (s.matches(".*%.*")) {
                    this.sharedTP.tankAngleUnitIndex = 1;
                    v = this.getDouble(s.replaceAll("%", ""));
                    break;
                }
                this.sharedTP.tankAngleUnitIndex = 0;
                v = this.getDouble(s);
                break;
            }
            case 2: {
                if (s.matches(".*d.*")) {
                    v = this.getDouble(s.replaceAll("d", ""));
                    v = Math.tan(v * (Math.PI / 180)) * this.sharedTP.g_R;
                    break;
                }
                if (s.matches(".*%.*")) {
                    v = this.getDouble(s.replaceAll("%", ""));
                    v = v / 100.0 * this.sharedTP.g_R;
                    break;
                }
                v = this.getDouble(s);
                break;
            }
            default: {
                v = this.getDouble(s);
            }
        }
        if (Double.isNaN(v)) {
            v = 0.0;
            tf.setText("0");
        }
        return v;
    }

    int getIntForTextField(JTextField tf, String label) {
        int v = 0;
        try {
            String s = tf.getText();
            v = Integer.parseInt(s);
        }
        catch (Exception e) {
            this.setStatus("Error: Bad entry for " + label, true);
        }
        return v;
    }

    int setEndCapMode(JRadioButton[] array) {
        int i;
        for (i = 0; i < array.length && !array[i].isSelected(); ++i) {
        }
        return i;
    }

    void errorMessage(String s) {
        this.beep();
        JOptionPane.showMessageDialog(this, s, this.programName + " " + this.VERSION + " Error", 2);
    }

    boolean userRequest(String s) {
        Object[] options = new Object[]{"No", "Yes"};
        this.beep();
        int r = JOptionPane.showOptionDialog(this, s, this.programName + " " + this.VERSION, 0, 3, null, options, options[0]);
        return r == 1;
    }

    boolean readValues() {
        boolean result = true;
        if (this.enabled) {
            this.sharedTP.decimalPlaces = this.decimalPlacesComboBox.getSelectedIndex();
            this.sharedTP.wallThickness = this.getDoubleForTextField(this.wallThicknessTextField, " wall thickness", 0);
            this.sharedTP.wallDensity = this.getDoubleForTextField(this.wallDensityTextField, " wall density", 0);
            this.sharedTP.contentDensity = this.getDoubleForTextField(this.contentDensityTextField, " content density", 0);
            this.sharedTP.weightUnitIndex = this.weightUnitsComboBox.getSelectedIndex();
            this.sharedTP.weightUnitName = (String)this.weightUnitsComboBox.getSelectedItem();
            this.sharedTP.inputUnitIndex = this.inputUnitsComboBox.getSelectedIndex();
            this.sharedTP.outputUnitIndex = this.outputUnitsComboBox.getSelectedIndex();
            this.sharedTP.residualVolume = this.getDoubleForTextField(this.residVolumeTextField, " residual volume value", 0);
            this.sharedTP.rootFinderEpsilon = this.getDoubleForTextField(this.rootFinderEpsilonTextField, " root finder epsilon value", 0);
            this.sharedTP.cylinderIntegrationSteps = this.getIntForTextField(this.cylinderIntegrationStepsTextField, " cylinder integration steps value");
            this.sharedTP.endCapIntegrationSteps = this.getIntForTextField(this.endCapIntegrationStepsTextField, " end cap integration steps value");
            this.sharedTP.leftEndCapMode = this.leftCapComboBox.getSelectedIndex();
            this.sharedTP.rightEndCapMode = this.rightCapComboBox.getSelectedIndex();
            this.sharedTP.tankOrientation = this.tankOrientationComboBox.getSelectedIndex();
            this.sharedTP.sensorOrientation = this.sensorOrientationComboBox.getSelectedIndex();
            this.sharedTP.enteredAngleDegrees = this.getDoubleForTextField(this.tankAngleTextField, "A (tank Angle) value", 1);
            this.sharedTP.g_L = this.getDoubleForTextField(this.g_LTextField, "L (cylinder Length) value", 0);
            this.sharedTP.g_R = this.getDoubleForTextField(this.g_RTextField, "R (cylinder radius) value", 0);
            this.sharedTP.g_rL = this.getDoubleForTextField(this.g_rLTextField, "left r (end cap radius) value", 2);
            this.sharedTP.g_rR = this.getDoubleForTextField(this.g_rRTextField, "right r (end cap radius) value", 2);
            this.sharedTP.scalingFactor = this.getDoubleForTextField(this.scalingFactorTextField, " scaling factor value", 0);
            this.sharedTP.sensorPositionX = this.getDoubleForTextField(this.sensorXTextField, " sensor X position value", 0);
            this.sharedTP.sensorPositionY = this.getDoubleForTextField(this.sensorYTextField, " sensor Y position value", 0);
            this.sharedTP.sensorPositionZ = this.getDoubleForTextField(this.sensorZTextField, " sensor Z position value", 0);
            this.sharedTP.graphicDrawLeftCap = this.leftCapCheckBox.isSelected();
            this.sharedTP.graphicDrawRightCap = this.rightCapCheckBox.isSelected();
            this.sharedTP.graphicDrawCylinder = this.cylinderCheckBox.isSelected();
            this.sharedTP.graphicDrawSensor = this.sensorCheckBox.isSelected();
            this.sharedTP.graphicAnaglyphMode = this.anaglyphCheckBox.isSelected();
            this.sharedTP.graphicInverseMode = this.inverseCheckBox.isSelected();
            this.sharedTP.polygonMode = this.polygonCheckBox.isSelected();
            this.sharedTP.polygonTransparency = this.transparencyComboBox.getSelectedIndex();
            this.sharedTP.graphicAntialiasingMode = this.antialiasingCheckBox.isSelected();
            this.sharedTP.graphicLineThickness = this.lineThicknessComboBox.getSelectedIndex();
            this.sharedTP.graphicXDrawSteps = this.xLinesComboBox.getSelectedIndex();
            this.sharedTP.graphicYDrawSteps = this.yLinesComboBox.getSelectedIndex();
            this.sharedTP.currentInputUnitName = this.getUnitLabel(false, true, false, true, false);
            this.sharedTP.currentOutputUnitName = this.getUnitLabel(false, false, false, false, false);
            this.sharedTP.tableTitle = this.tableTitleTextField.getText();
            this.sharedTP.tableHeightStepSize = this.getDoubleForTextField(this.tableHeightStepSizeTextField, " height step size", 0);
            this.sharedTP.tableVolumeStepSize = this.getDoubleForTextField(this.tableVolumeStepSizeTextField, " volume step size", 0);
            if (!this.sharedTP.tankUpright && Math.abs(this.sharedTP.sensorPositionZ) > this.sharedTP.g_R) {
                this.setStatus("Z value may not exceed tank radius in this mode", true);
                this.sharedTP.sensorPositionZ = this.sharedTP.sensorPositionZ < 0.0 ? -this.sharedTP.g_R : this.sharedTP.g_R;
                this.sensorZTextField.setText(this.formatNum(this.sharedTP.sensorPositionZ));
                result = false;
            } else {
                result = this.tankProcessor.setValues(this, this.sharedTP);
                if (!result) {
                    this.setStatus("One of more entered values exceeds permitted limits", true);
                }
            }
            this.updateGraphicImages();
        }
        return result;
    }

    String doubleToString(double v) {
        return "" + v;
    }

    String intToString(int v) {
        return String.format("%d", v);
    }

    void setComboBox(JComboBox box, int index) {
        if (index >= 0 && index < box.getItemCount()) {
            box.setSelectedIndex(index);
        }
    }

    protected void writeValues() {
        this.setComboBox(this.decimalPlacesComboBox, this.sharedTP.decimalPlaces);
        this.wallThicknessTextField.setText(this.doubleToString(this.sharedTP.wallThickness));
        this.wallDensityTextField.setText(this.doubleToString(this.sharedTP.wallDensity));
        this.contentDensityTextField.setText(this.doubleToString(this.sharedTP.contentDensity));
        this.contentDensityTextField.setText(this.doubleToString(this.sharedTP.contentDensity));
        this.setComboBox(this.weightUnitsComboBox, this.sharedTP.weightUnitIndex);
        this.setComboBox(this.inputUnitsComboBox, this.sharedTP.inputUnitIndex);
        this.setComboBox(this.outputUnitsComboBox, this.sharedTP.outputUnitIndex);
        this.residVolumeTextField.setText(this.doubleToString(this.sharedTP.residualVolume));
        this.rootFinderEpsilonTextField.setText(this.doubleToString(this.sharedTP.rootFinderEpsilon));
        this.cylinderIntegrationStepsTextField.setText(this.intToString(this.sharedTP.cylinderIntegrationSteps));
        this.endCapIntegrationStepsTextField.setText(this.intToString(this.sharedTP.endCapIntegrationSteps));
        this.setComboBox(this.leftCapComboBox, this.sharedTP.leftEndCapMode);
        this.setComboBox(this.rightCapComboBox, this.sharedTP.rightEndCapMode);
        this.setComboBox(this.tankOrientationComboBox, this.sharedTP.tankOrientation);
        this.setComboBox(this.sensorOrientationComboBox, this.sharedTP.sensorOrientation);
        this.tankAngleTextField.setText(this.doubleToString(this.sharedTP.enteredAngleDegrees));
        this.g_LTextField.setText(this.doubleToString(this.sharedTP.g_L));
        this.g_RTextField.setText(this.doubleToString(this.sharedTP.g_R));
        this.g_rLTextField.setText(this.doubleToString(this.sharedTP.g_rL));
        this.g_rRTextField.setText(this.doubleToString(this.sharedTP.g_rR));
        this.scalingFactorTextField.setText(this.doubleToString(this.sharedTP.scalingFactor));
        this.sensorXTextField.setText(this.doubleToString(this.sharedTP.sensorPositionX));
        this.sensorYTextField.setText(this.doubleToString(this.sharedTP.sensorPositionY));
        this.sensorZTextField.setText(this.doubleToString(this.sharedTP.sensorPositionZ));
        this.anaglyphCheckBox.setSelected(this.sharedTP.graphicAnaglyphMode);
        this.inverseCheckBox.setSelected(this.sharedTP.graphicInverseMode);
        this.polygonCheckBox.setSelected(this.sharedTP.polygonMode);
        this.antialiasingCheckBox.setSelected(this.sharedTP.graphicAntialiasingMode);
        this.leftCapCheckBox.setSelected(this.sharedTP.graphicDrawLeftCap);
        this.rightCapCheckBox.setSelected(this.sharedTP.graphicDrawRightCap);
        this.cylinderCheckBox.setSelected(this.sharedTP.graphicDrawCylinder);
        this.sensorCheckBox.setSelected(this.sharedTP.graphicDrawSensor);
        this.setComboBox(this.transparencyComboBox, this.sharedTP.polygonTransparency);
        this.setComboBox(this.lineThicknessComboBox, this.sharedTP.graphicLineThickness);
        this.setComboBox(this.xLinesComboBox, this.sharedTP.graphicXDrawSteps);
        this.setComboBox(this.yLinesComboBox, this.sharedTP.graphicYDrawSteps);
        this.tableTitleTextField.setText(this.sharedTP.tableTitle);
        this.tableHeightStepSizeTextField.setText(this.doubleToString(this.sharedTP.tableHeightStepSize));
        this.tableVolumeStepSizeTextField.setText(this.doubleToString(this.sharedTP.tableVolumeStepSize));
    }

    void detectEnterKey(KeyEvent evt) {
        if (evt.getKeyChar() == '\n') {
            this.computeSingleResult();
        }
    }

    String formatNum(double v) {
        if (Double.isNaN(v)) {
            return " -- ";
        }
        String s = String.format("%." + this.sharedTP.decimalPlaces + "f", v);
        return s;
    }

    /*
     * Enabled aggressive block sorting
     */
    void computeSingleResult() {
        double v;
        this.setModeAndLabels();
        if (!this.readValues()) return;
        double y = this.getDoubleForTextField(this.singleInputField, "input", 0);
        if (Double.isNaN(y)) {
            this.setStatus("Error: input argument out of range", true);
            this.singleOutputField.setText("");
            return;
        }
        if (this.inverseMode) {
            double max;
            if (!((y = this.tankProcessor.convertVolumeUnits(y, false)) <= (max = this.tankProcessor.computeMaxVolume().volume))) {
                this.setStatus("Error: input argument exceeds maximum volume", true);
                this.singleOutputField.setText("");
                return;
            }
            v = this.tankProcessor.heightForVolume((double)y).height;
            v = this.tankProcessor.convertLengthUnits(v, true);
        } else {
            y = this.tankProcessor.convertLengthUnits(y, false);
            v = this.tankProcessor.volumeForHeight((double)y).volume;
            v = this.tankProcessor.convertVolumeUnits(v, true);
        }
        String result = this.formatNum(v);
        this.singleOutputField.setText(result);
    }

    protected String plainTextConvertExponents(String s) {
        return s.replaceAll("&sup(\\d);", "^$1");
    }

    ArrayList<String> computeLine(ArrayList<Double[]> array, double y, double max) {
        double x;
        TankCompResult z = this.tankProcessor.computeHeightOrVolume(y);
        if (Double.isNaN(z.volume)) {
            if (!this.inverseMode) {
                z = this.tankProcessor.tankFullVolume();
                z.volume *= this.sharedTP.scalingFactor;
            } else {
                z.volume = this.tankProcessor.maxHeight;
            }
        }
        if (this.inverseMode) {
            x = this.tankProcessor.convertLengthUnits(z.height, true);
            y = this.tankProcessor.convertVolumeUnits(y, true);
        } else {
            x = this.tankProcessor.convertVolumeUnits(z.volume, true);
            y = this.tankProcessor.convertLengthUnits(y, true);
        }
        z.wettedArea = this.tankProcessor.convertAreaUnits(z.wettedArea, true);
        z.surfaceArea = this.tankProcessor.convertAreaUnits(z.surfaceArea, true);
        if (array != null) {
            array.add(new Double[]{y, z.volume, z.wettedArea, z.surfaceArea});
        }
        String a = this.formatNum(y);
        String b = this.formatNum(x);
        String c = this.formatNum(z.wettedArea);
        String d = this.formatNum(z.surfaceArea);
        String pct = this.formatNum(z.volume * 100.0 / max);
        return new ArrayList<String>(Arrays.asList(a, b, c, d, pct));
    }

    void addTableRecord(ArrayList<String> record, boolean header) {
        for (int i = 0; i < record.size(); ++i) {
            this.intColumnWidths[i] = Math.max(this.intColumnWidths[i], record.get(i).length() + 2);
        }
        if (header) {
            this.strHeaderArray = record;
        } else {
            this.strTableArray.add(record);
        }
    }

    boolean stringArraysMatch(ArrayList<String> a, ArrayList<String> b) {
        if (a != null && b != null && a.size() > 0 && a.size() == b.size()) {
            int i = 0;
            for (String s : a) {
                if (!s.equals(b.get(i))) {
                    return false;
                }
                ++i;
            }
            return true;
        }
        return false;
    }

    void buildDataTable() {
        if (!Double.isNaN(this.sharedTP.tableHeightStepSize) && !Double.isNaN(this.sharedTP.tableVolumeStepSize)) {
            double max;
            String a;
            String b;
            String u1 = this.getUnitLabel(false, true, false, true, true);
            String u2 = Constants.outputUnitAreaNames[this.sharedTP.inputUnitIndex];
            String u3 = this.getUnitLabel(false, false, false, false, true);
            if (this.inverseMode) {
                b = "Sensor Height " + u1;
                a = "LV " + u3;
            } else {
                a = "Sensor Height " + u1;
                b = "LV " + u3;
            }
            String c = "LWA " + u2;
            String d = "LSA " + u2;
            String e = "%";
            double step = 0.0;
            if (this.inverseMode) {
                step = this.tankProcessor.convertVolumeUnits(this.sharedTP.tableVolumeStepSize, false);
                max = this.tankProcessor.computeMaxVolume().volume * this.sharedTP.scalingFactor;
            } else {
                step = this.tankProcessor.convertLengthUnits(this.sharedTP.tableHeightStepSize, false);
                max = this.tankProcessor.computeFullTankHeight();
                max /= this.tankProcessor.sensorScalingFactor();
            }
            if (Double.isNaN(max) || Math.abs(max) > 1.0E10) {
                this.beep();
                JOptionPane.showMessageDialog(this, "Sensor path anomaly -- cannot create table", "Table Generation Error", 1);
            } else {
                this.addTableRecord(new ArrayList<String>(Arrays.asList(a, b, c, d, e)), true);
                this.computeLine(this.dblList, max, max);
                double maxVal = this.dblList.get(0)[1];
                this.dblList.clear();
                ArrayList<String> array = new ArrayList<String>();
                int iy = 0;
                while (true) {
                    double d2;
                    double y = (double)iy * step;
                    if (!(d2 <= max) || !this.makeTableFlag) break;
                    array = this.computeLine(this.dblList, y, maxVal);
                    this.addTableRecord(array, false);
                    int n = (int)(y / max * 100.0);
                    this.tableProgressBar.setString("Building Table (" + n + "%)");
                    this.tableProgressBar.setValue(n);
                    ++iy;
                }
                ArrayList<String> lastLine = array;
                array = this.computeLine(this.dblList, max, maxVal);
                this.strTableArray.add(array);
                if (this.makeTableFlag && this.stringArraysMatch(lastLine, array)) {
                    this.dblList.remove(this.dblList.size() - 1);
                    this.strTableArray.remove(this.strTableArray.size() - 1);
                }
            }
        }
    }

    void buildSpecTable() {
        this.samc.createList();
    }

    void buildTableGeneric(int type) {
        this.mostRecentTableType = type;
        this.intColumnWidths = new int[]{0, 0, 0, 0, 0};
        this.setModeAndLabels();
        this.tableCancelButton.setEnabled(true);
        if (this.readValues()) {
            this.dblList = new ArrayList();
            this.strTableArray = new ArrayList();
            this.strHeaderArray = new ArrayList();
            this.tableProgressBar.setStringPainted(true);
            if (type == 0) {
                this.buildDataTable();
            } else {
                this.buildSpecTable();
            }
            if (this.makeTableFlag) {
                this.setStatus("Created table with " + this.strTableArray.size() + " records", false);
            } else {
                this.dblList = new ArrayList();
                this.setStatus("Table Build Canceled", true);
            }
        }
        this.tableProgressBar.setValue(0);
        this.tableProgressBar.setString("");
        this.makeTableFlag = false;
        this.tableCancelButton.setEnabled(false);
        this.updateTableDisplay();
    }

    void buildDataTableThread(final int type) {
        if (!this.makeTableFlag) {
            this.makeTableFlag = true;
            Thread t = new Thread(){

                @Override
                public void run() {
                    TankCalc.this.buildTableGeneric(type);
                }
            };
            t.start();
        } else {
            this.beep();
        }
    }

    protected void buildTable(int type, boolean inverse) {
        this.eraseSingleEntry();
        this.inverseMode = inverse;
        this.buildDataTableThread(type);
    }

    protected void eraseSingleEntry() {
        this.singleInputField.setText("");
        this.singleOutputField.setText("");
    }

    void cancelTable() {
        this.makeTableFlag = false;
        this.tableProgressBar.setValue(0);
        this.dblList = new ArrayList();
    }

    String getFormattedTable(int tableType) {
        String result = "";
        switch (tableType) {
            case 0: {
                result = this.buildPlainTextTable();
                break;
            }
            case 1: {
                result = this.buildTSVTable();
                break;
            }
            case 2: {
                result = this.buildHTMLTable(this.mostRecentTableType);
            }
        }
        return result;
    }

    String createEndCapLabel(boolean leftCap) {
        double a = leftCap ? this.tankProcessor.g_rL : this.tankProcessor.g_rR;
        double b = leftCap ? this.tankProcessor.leftMajorSphereRadius : this.tankProcessor.rightMajorSphereRadius;
        return this.formatNum(this.tankProcessor.convertLengthUnits(a, true)) + "/" + this.formatNum(this.tankProcessor.convertLengthUnits(b, true));
    }

    protected String tankOrientationTitle() {
        return Constants.tankOrientationTitles[this.sharedTP.tankOrientation];
    }

    protected String tankOrientationString() {
        String s = Constants.tankOrientationTitles[this.sharedTP.tankOrientation];
        if (this.sharedTP.tankOrientation == 2) {
            s = s + " (" + this.formatNum(this.sharedTP.angleDegrees) + "\u00b0)";
        }
        return s;
    }

    ArrayList<String> createTitle(boolean html) {
        ArrayList<String> titleVec = new ArrayList<String>();
        String userTitle = this.tableTitleTextField.getText();
        if (userTitle.length() > 0) {
            titleVec.add(userTitle);
        }
        return titleVec;
    }

    String joinVec(ArrayList<String> v, String token) {
        StringBuilder sb = new StringBuilder();
        Iterator<String> it = v.iterator();
        boolean first = true;
        while (it.hasNext()) {
            if (!first) {
                sb.append(token);
            }
            sb.append(it.next());
            first = false;
        }
        return sb.toString();
    }

    void addLine(StringBuilder sb, ArrayList<String> fields) {
        int i = 0;
        for (String s : fields) {
            s = s.replaceAll("&sup(\\d);", "^$1");
            sb.append(String.format("%" + this.intColumnWidths[i] + "s", s));
            ++i;
        }
        sb.append("\n");
    }

    String buildPlainTextTable() {
        StringBuilder sb = new StringBuilder();
        StringBuilder underscore = new StringBuilder();
        int fullWidth = 0;
        for (int width : this.intColumnWidths) {
            fullWidth += width;
            for (int j = 0; j < width; ++j) {
                underscore.append("-");
            }
        }
        String title = this.tableTitleTextField.getText() + "\n";
        int delta = (fullWidth + title.length()) / 2;
        sb.append(String.format("%" + delta + "s", title));
        sb.append("\n\n");
        boolean needUnderscore = true;
        ArrayList<ArrayList<String>> list = new ArrayList<ArrayList<String>>();
        list.add(this.strHeaderArray);
        list.addAll(this.strTableArray);
        for (ArrayList arrayList : list) {
            this.addLine(sb, arrayList);
            if (!needUnderscore) continue;
            sb.append((CharSequence)underscore).append("\n");
            needUnderscore = false;
        }
        return sb.toString();
    }

    String buildTSVTable() {
        StringBuilder sb = new StringBuilder();
        String title = this.tableTitleTextField.getText() + "\n";
        title = title.replaceAll(",", " -");
        sb.append(title);
        sb.append("\n\n");
        ArrayList<ArrayList<String>> list = new ArrayList<ArrayList<String>>();
        list.add(this.strHeaderArray);
        list.addAll(this.strTableArray);
        for (ArrayList arrayList : list) {
            String row = this.buildTSVRow(arrayList);
            sb.append(row);
        }
        return sb.toString();
    }

    String buildTSVRow(ArrayList<String> array) {
        StringBuilder ssb = new StringBuilder();
        int i = 0;
        for (String ss : array) {
            if (i > 0) {
                ssb.append("\t");
            }
            ssb.append(ss);
            ++i;
        }
        ssb.append("\n");
        return this.plainTextConvertExponents(ssb.toString());
    }

    String getCSS() {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < this.tableCSS.length; ++i) {
            sb.append(this.tableCSS[i]);
            sb.append("\n");
        }
        return sb.toString();
    }

    String wrapTag(String tag, String content, String extra) {
        return "<" + tag + (extra.length() > 0 ? " " + extra : "") + ">" + content + "</" + tag + ">\n";
    }

    String wrapTag(String tag, String content) {
        return this.wrapTag(tag, content, "");
    }

    /*
     * WARNING - void declaration
     */
    String buildHTMLTable(int type) {
        void var12_18;
        StringBuilder sb = new StringBuilder();
        String banner = "";
        String vs = this.sharedTP.tableTitle;
        if (vs.length() > 0) {
            banner = vs;
            banner = this.wrapTag("b", banner);
            banner = this.wrapTag("p", banner);
        }
        String title = vs;
        String headTitle = title.replaceAll("\n+", " -- ");
        headTitle = this.wrapTag("title", headTitle);
        String head = this.wrapTag("head", headTitle + "\n" + this.getCSS());
        int i = 0;
        String s = "";
        ArrayList<ArrayList<String>> list = new ArrayList<ArrayList<String>>();
        list.add(this.strHeaderArray);
        list.addAll(this.strTableArray);
        for (ArrayList arrayList : list) {
            int row = i % 2;
            String css = "class=\"cell" + row + "\"";
            for (String ss : arrayList) {
                ss = ss.replaceFirst("\\^(\\d)", "<sup>$1</sup>");
                s = s + this.wrapTag(i == 0 ? "th" : "td", ss);
            }
            sb.append(this.wrapTag("tr", s, css));
            s = "";
            ++i;
        }
        String body = this.wrapTag("table", sb.toString(), "cellpadding=\"2\" cellspacing=\"0\" border=\"0\"");
        String string = "";
        if (type == 0) {
            String string5 = "<b>LV</b> = Liquid Volume<br/>";
            string5 = string5 + "<b>LWA</b> = Liquid Wetted Area (liquid/tank interface)<br/>";
            string5 = string5 + "<b>LSA</b> = Liquid Surface Area (liquid/gas interface)";
            string5 = this.wrapTag("p", string5);
        }
        String source = "Source: " + this.programName + " " + this.VERSION + ", Copyright &copy; 2014, P. Lutus<br/>(<a href=\"http://www.arachnoid.com/TankCalc/index.html\">http://www.arachnoid.com/TankCalc</a>)";
        source = this.wrapTag("p", source);
        String string6 = this.wrapTag("div", (String)var12_18 + source, "align=\"center\"");
        s = banner + "<br/>" + body + string6;
        s = head + this.wrapTag("body", this.wrapTag("div", s, "align=\"center\""));
        s = this.wrapTag("html", s);
        return s;
    }

    void updateTableDisplay() {
        ((DataTableDisplay)this.dataTableDisplay).updateDisplay();
    }

    private void manageHyperlinks(HyperlinkEvent evt) {
        String surl;
        if (evt.getEventType() == HyperlinkEvent.EventType.ACTIVATED && (surl = evt.getURL().toString()).matches("http://.*")) {
            try {
                Desktop.getDesktop().browse(URI.create(surl));
            }
            catch (Exception e) {
                System.out.println(e);
            }
        }
    }

    public void setClipboardContents(String s) {
        StringSelection stringSelection = new StringSelection(s);
        Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        clipboard.setContents(stringSelection, this);
    }

    @Override
    public void lostOwnership(Clipboard aClipboard, Transferable aContents) {
    }

    void copyToClipboard(String s) {
        if (s.length() > 0) {
            if (this.applet) {
                this.setStatus("See help on applet clipboard operations.", true);
            }
            this.setClipboardContents(s);
        } else {
            this.setStatus("Error: Must create data first.", true);
        }
    }

    void copyTableToClipboard(int type) {
        this.copyToClipboard(this.getFormattedTable(type));
    }

    public void beep() {
        Toolkit.getDefaultToolkit().beep();
    }

    void processTabClick() {
        Component comp = this.mainTabbedPane.getSelectedComponent();
        if (comp == this.helpPanel) {
            this.helpPane.findTextField.requestFocusInWindow();
        } else if (comp == this.graphicModelPanel) {
            this.mainPanel3d.requestFocusInWindow();
        } else if (comp == this.tableGenPanel) {
            this.buildTable(1, true);
        }
        this.updateGraphicImages();
        this.sharedTP.currentTab = this.mainTabbedPane.getSelectedIndex();
    }

    public String getConfig() {
        if (this.initManager != null) {
            this.helpScrollPos = this.helpPane.getScrollPos();
            return this.initManager.getConfig();
        }
        return null;
    }

    public void setConfig(String data) {
        this.initManager.setConfig(data);
        this.setModeAndLabels();
        this.mainPanel3d.updateSettings(this.sharedTP);
        this.processTabClick();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                TankCalc.this.helpPane.setScrollPos(TankCalc.this.helpScrollPos);
            }
        });
    }

    void manageHelpSlides(int n) {
        this.helpSlideIndex += n;
        if (this.helpSlideIndex < 0) {
            this.helpSlideIndex = 0;
            this.beep();
        }
        if (this.helpSlideIndex > this.helpSlides.length - 1) {
            this.helpSlideIndex = this.helpSlides.length - 1;
            this.beep();
        }
        this.ghBackButton.setEnabled(this.helpSlideIndex > 0);
        this.ghForwardButton.setEnabled(this.helpSlideIndex < this.helpSlides.length - 1);
        URL url = this.getClass().getResource("help_slides/" + this.helpSlides[this.helpSlideIndex]);
        Image appIcon = new ImageIcon(url).getImage();
        this.helpSlideLabel.setIcon(new ImageIcon(appIcon));
    }

    String readResourceFile(String fn) {
        String s = "";
        try {
            String line;
            InputStream is = this.getClass().getResourceAsStream(fn);
            InputStreamReader isr = new InputStreamReader(is);
            BufferedReader br = new BufferedReader(isr);
            StringBuilder sb = new StringBuilder();
            while ((line = br.readLine()) != null) {
                sb.append(line);
                sb.append("\n");
            }
            is.close();
            s = sb.toString();
        }
        catch (Exception e) {
            System.out.println("readResourceFile: " + e);
        }
        return s;
    }

    void updateGraphicImages() {
        if (this.mainPanel3d != null) {
            this.mainPanel3d.createTankImage(this.sharedTP);
        }
        if (this.subPanel3d != null) {
            this.subPanel3d.createTankImage(this.sharedTP);
        }
    }

    public void close() {
        if (!this.applet) {
            this.helpScrollPos = this.helpPane.getScrollPos();
            this.initManager.writeConfig();
        }
        this.setVisible(false);
        System.exit(0);
    }

    private void initComponents() {
        this.NormalInversebuttonGroup = new ButtonGroup();
        this.tableTypeButtonGroup = new ButtonGroup();
        this.mainTabbedPane = new JTabbedPane();
        this.inputPanel = new JPanel();
        this.viewPanel = new JPanel();
        this.unitsSubPanel = new JPanel();
        this.copyDescButton = new JButton();
        this.pasteDescButton = new JButton();
        this.resetButton = new JButton();
        this.jScrollPane5 = new JScrollPane();
        this.entryPanel = new JPanel();
        this.LVariableLabel = new JLabel();
        this.g_LTextField = new JTextField();
        this.RVariableLabel = new JLabel();
        this.g_RTextField = new JTextField();
        this.lbVariableLabel1 = new JLabel();
        this.lbVariableLabel2 = new JLabel();
        this.g_rLTextField = new JTextField();
        this.rtVariableLabel1 = new JLabel();
        this.rtVariableLabel2 = new JLabel();
        this.g_rRTextField = new JTextField();
        this.leftCapComboBox = new JComboBox();
        this.rightCapComboBox = new JComboBox();
        this.scaling_factor_label = new JLabel();
        this.scalingFactorTextField = new JTextField();
        this.jLabel19 = new JLabel();
        this.tankOrientationComboBox = new JComboBox();
        this.tankAngleLabel = new JLabel();
        this.tankAngleTextField = new JTextField();
        this.sensorPathLabel = new JLabel();
        this.sensorOrientationComboBox = new JComboBox();
        this.xCoordLabel = new JLabel();
        this.yCoordLabel = new JLabel();
        this.zCoordLabel = new JLabel();
        this.sensorXTextField = new JTextField();
        this.sensorYTextField = new JTextField();
        this.sensorZTextField = new JTextField();
        this.residVolumeLabel = new JLabel();
        this.residVolumeTextField = new JTextField();
        this.wallThicknessLabel = new JLabel();
        this.jLabel20 = new JLabel();
        this.jLabel21 = new JLabel();
        this.wallThicknessTextField = new JTextField();
        this.wallDensityTextField = new JTextField();
        this.contentDensityTextField = new JTextField();
        this.inputTag = new JLabel();
        this.inputUnitsComboBox = new JComboBox();
        this.outputTag = new JLabel();
        this.outputUnitsComboBox = new JComboBox();
        this.jLabel18 = new JLabel();
        this.weightUnitsComboBox = new JComboBox();
        this.jLabel9 = new JLabel();
        this.cylinderIntegrationStepsTextField = new JTextField();
        this.jLabel10 = new JLabel();
        this.endCapIntegrationStepsTextField = new JTextField();
        this.heightStepSizeLabel = new JLabel();
        this.tableHeightStepSizeTextField = new JTextField();
        this.volumeStepSizeLabel = new JLabel();
        this.jLabel11 = new JLabel();
        this.tableVolumeStepSizeTextField = new JTextField();
        this.jLabel5 = new JLabel();
        this.decimalPlacesComboBox = new JComboBox();
        this.rootFinderEpsilonTextField = new JTextField();
        this.tableGenPanel = new JPanel();
        this.SingleResultPanel = new JPanel();
        this.modePanel = new JPanel();
        this.inputLabel = new JLabel();
        this.singleInputField = new JTextField();
        this.outputLabel = new JLabel();
        this.singleOutputField = new JTextField();
        this.TablePanel = new JPanel();
        this.tableControlPanel = new JPanel();
        this.copyHTMLToClipboardButton = new JButton();
        this.tableCancelButton = new JButton();
        this.buildVHDataTableButton = new JButton();
        this.buildHVDataTableButton = new JButton();
        this.buildSpecTableButton = new JButton();
        this.copyTSVToClipboardButton = new JButton();
        this.copyPlainToClipboardButton = new JButton();
        this.fillerPanel = new JPanel();
        this.tableProgressBar = new JProgressBar();
        this.jPanel3 = new JPanel();
        this.jLabel6 = new JLabel();
        this.tableTitleTextField = new JTextField();
        this.tableDisplayPanel = new JPanel();
        this.tableScrollPane = new JScrollPane();
        this.dataTableDisplay = new DataTableDisplay(this);
        this.graphicModelPanel = new JPanel();
        this.graphicDisplayPanel = new JPanel();
        this.controlPanelA = new JPanel();
        this.inverseCheckBox = new JCheckBox();
        this.leftCapCheckBox = new JCheckBox();
        this.cylinderCheckBox = new JCheckBox();
        this.rightCapCheckBox = new JCheckBox();
        this.sensorCheckBox = new JCheckBox();
        this.lineThicknessLabel = new JLabel();
        this.lineThicknessComboBox = new JComboBox();
        this.jLabel3 = new JLabel();
        this.anaglyphicLabel = new JLabel();
        this.anaglyphCheckBox = new JCheckBox();
        this.controlPanelB = new JPanel();
        this.jLabel12 = new JLabel();
        this.xLinesComboBox = new JComboBox();
        this.jLabel13 = new JLabel();
        this.yLinesComboBox = new JComboBox();
        this.polygonCheckBox = new JCheckBox();
        this.transparencyLabel = new JLabel();
        this.transparencyComboBox = new JComboBox();
        this.antialiasingCheckBox = new JCheckBox();
        this.graphicDefaultsButton = new JButton();
        this.copyButton = new JButton();
        this.graphicPanel = new JPanel();
        this.jScrollPane2 = new JScrollPane();
        this.helpSlideLabel = new JLabel();
        this.graphicHelpControls = new JPanel();
        this.ghBackButton = new JButton();
        this.ghForwardButton = new JButton();
        this.helpPanel = new JPanel();
        this.statusPanel = new JPanel();
        this.statusLabel = new JLabel();
        this.debug_label = new JLabel();
        this.setFocusable(false);
        this.setMinimumSize(new Dimension(400, 300));
        this.setPreferredSize(new Dimension(800, 600));
        this.setLayout(new GridBagLayout());
        this.mainTabbedPane.setTabPlacement(3);
        this.mainTabbedPane.setFocusable(false);
        this.mainTabbedPane.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                TankCalc.this.mainTabbedPaneMouseClicked(evt);
            }
        });
        this.inputPanel.setFocusable(false);
        this.inputPanel.setMinimumSize(new Dimension(382, 260));
        this.inputPanel.setPreferredSize(new Dimension(382, 260));
        this.inputPanel.setLayout(new GridBagLayout());
        this.viewPanel.setBackground(Color.white);
        this.viewPanel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.inputPanel.add((Component)this.viewPanel, gridBagConstraints);
        this.unitsSubPanel.setLayout(new GridBagLayout());
        this.copyDescButton.setIcon(new ImageIcon(this.getClass().getResource("/tankcalc/icons/edit-copy.png")));
        this.copyDescButton.setText("Copy");
        this.copyDescButton.setToolTipText("Copy this tank's description to the clipboard");
        this.copyDescButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                TankCalc.this.copyDescButtonMouseClicked(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 9;
        gridBagConstraints.gridy = 0;
        this.unitsSubPanel.add((Component)this.copyDescButton, gridBagConstraints);
        this.pasteDescButton.setIcon(new ImageIcon(this.getClass().getResource("/tankcalc/icons/edit-paste.png")));
        this.pasteDescButton.setText("Paste");
        this.pasteDescButton.setToolTipText("Paste a tank description or file name from the clipboard");
        this.pasteDescButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                TankCalc.this.pasteDescButtonMouseClicked(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 10;
        gridBagConstraints.gridy = 0;
        this.unitsSubPanel.add((Component)this.pasteDescButton, gridBagConstraints);
        this.resetButton.setIcon(new ImageIcon(this.getClass().getResource("/tankcalc/icons/edit-clear.png")));
        this.resetButton.setText("Defaults");
        this.resetButton.setToolTipText("Reset all entries to default values");
        this.resetButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                TankCalc.this.resetButtonMouseClicked(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 8;
        gridBagConstraints.gridy = 0;
        this.unitsSubPanel.add((Component)this.resetButton, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.inputPanel.add((Component)this.unitsSubPanel, gridBagConstraints);
        this.jScrollPane5.setVerticalScrollBarPolicy(22);
        this.jScrollPane5.setMinimumSize(new Dimension(360, 22));
        this.jScrollPane5.setPreferredSize(new Dimension(360, 437));
        this.entryPanel.setBackground(new Color(51, 51, 51));
        this.entryPanel.setLayout(new GridBagLayout());
        this.LVariableLabel.setFont(new Font("Dialog", 0, 12));
        this.LVariableLabel.setForeground(new Color(255, 255, 255));
        this.LVariableLabel.setText(" Cylinder length (L)");
        this.LVariableLabel.setIconTextGap(0);
        this.LVariableLabel.setMaximumSize(new Dimension(3000, 24));
        this.LVariableLabel.setMinimumSize(new Dimension(200, 24));
        this.LVariableLabel.setPreferredSize(new Dimension(240, 24));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 18;
        this.entryPanel.add((Component)this.LVariableLabel, gridBagConstraints);
        this.g_LTextField.setHorizontalAlignment(4);
        this.g_LTextField.setText("96.0");
        this.g_LTextField.setToolTipText("Enter cylinder section length");
        this.g_LTextField.setMaximumSize(new Dimension(150, 24));
        this.g_LTextField.setMinimumSize(new Dimension(24, 24));
        this.g_LTextField.setPreferredSize(new Dimension(24, 24));
        this.g_LTextField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent evt) {
                TankCalc.this.g_LTextFieldKeyTyped(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        this.entryPanel.add((Component)this.g_LTextField, gridBagConstraints);
        this.RVariableLabel.setFont(new Font("Dialog", 0, 12));
        this.RVariableLabel.setForeground(new Color(255, 255, 255));
        this.RVariableLabel.setText(" Cylinder radius (R)");
        this.RVariableLabel.setIconTextGap(0);
        this.RVariableLabel.setMaximumSize(new Dimension(3000, 24));
        this.RVariableLabel.setMinimumSize(new Dimension(200, 24));
        this.RVariableLabel.setPreferredSize(new Dimension(240, 24));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 18;
        this.entryPanel.add((Component)this.RVariableLabel, gridBagConstraints);
        this.g_RTextField.setHorizontalAlignment(4);
        this.g_RTextField.setText("36.0");
        this.g_RTextField.setToolTipText("Enter cylinder radius");
        this.g_RTextField.setMaximumSize(new Dimension(150, 24));
        this.g_RTextField.setMinimumSize(new Dimension(24, 24));
        this.g_RTextField.setPreferredSize(new Dimension(24, 24));
        this.g_RTextField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent evt) {
                TankCalc.this.g_RTextFieldKeyTyped(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        this.entryPanel.add((Component)this.g_RTextField, gridBagConstraints);
        this.lbVariableLabel1.setFont(new Font("Dialog", 0, 12));
        this.lbVariableLabel1.setForeground(new Color(255, 255, 255));
        this.lbVariableLabel1.setText(" Left/Bottom cap radius (r) cm");
        this.lbVariableLabel1.setIconTextGap(0);
        this.lbVariableLabel1.setMaximumSize(new Dimension(3000, 24));
        this.lbVariableLabel1.setMinimumSize(new Dimension(200, 24));
        this.lbVariableLabel1.setPreferredSize(new Dimension(240, 24));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 18;
        this.entryPanel.add((Component)this.lbVariableLabel1, gridBagConstraints);
        this.lbVariableLabel2.setFont(new Font("Dialog", 0, 12));
        this.lbVariableLabel2.setForeground(new Color(255, 255, 255));
        this.lbVariableLabel2.setText(" Left/Bottom cap type");
        this.lbVariableLabel2.setIconTextGap(0);
        this.lbVariableLabel2.setMaximumSize(new Dimension(3000, 24));
        this.lbVariableLabel2.setMinimumSize(new Dimension(200, 24));
        this.lbVariableLabel2.setPreferredSize(new Dimension(240, 24));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.anchor = 18;
        this.entryPanel.add((Component)this.lbVariableLabel2, gridBagConstraints);
        this.g_rLTextField.setHorizontalAlignment(4);
        this.g_rLTextField.setText("18.0");
        this.g_rLTextField.setToolTipText("Enter left/bottom cap radius (see help on how to make this entry)");
        this.g_rLTextField.setMaximumSize(new Dimension(150, 24));
        this.g_rLTextField.setMinimumSize(new Dimension(24, 24));
        this.g_rLTextField.setPreferredSize(new Dimension(24, 24));
        this.g_rLTextField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent evt) {
                TankCalc.this.g_rLTextFieldKeyTyped(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        this.entryPanel.add((Component)this.g_rLTextField, gridBagConstraints);
        this.rtVariableLabel1.setFont(new Font("Dialog", 0, 12));
        this.rtVariableLabel1.setForeground(new Color(255, 255, 255));
        this.rtVariableLabel1.setText(" Right/top cap radius (r) cm ");
        this.rtVariableLabel1.setIconTextGap(0);
        this.rtVariableLabel1.setMaximumSize(new Dimension(3000, 24));
        this.rtVariableLabel1.setMinimumSize(new Dimension(200, 24));
        this.rtVariableLabel1.setPreferredSize(new Dimension(240, 24));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.anchor = 18;
        this.entryPanel.add((Component)this.rtVariableLabel1, gridBagConstraints);
        this.rtVariableLabel2.setFont(new Font("Dialog", 0, 12));
        this.rtVariableLabel2.setForeground(new Color(255, 255, 255));
        this.rtVariableLabel2.setText(" Right/top cap type");
        this.rtVariableLabel2.setIconTextGap(0);
        this.rtVariableLabel2.setMaximumSize(new Dimension(3000, 24));
        this.rtVariableLabel2.setMinimumSize(new Dimension(200, 24));
        this.rtVariableLabel2.setPreferredSize(new Dimension(240, 24));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.anchor = 18;
        this.entryPanel.add((Component)this.rtVariableLabel2, gridBagConstraints);
        this.g_rRTextField.setHorizontalAlignment(4);
        this.g_rRTextField.setText("18.0");
        this.g_rRTextField.setToolTipText("Enter right/top cap radius (see help on how to make this entry)");
        this.g_rRTextField.setMaximumSize(new Dimension(150, 24));
        this.g_rRTextField.setMinimumSize(new Dimension(24, 24));
        this.g_rRTextField.setPreferredSize(new Dimension(24, 24));
        this.g_rRTextField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent evt) {
                TankCalc.this.g_rRTextFieldKeyTyped(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        this.entryPanel.add((Component)this.g_rRTextField, gridBagConstraints);
        this.leftCapComboBox.setModel(new DefaultComboBoxModel<String>(new String[]{"Elliptical", "Conical", "Spherical"}));
        this.leftCapComboBox.setToolTipText("Enter left/bottom end cap type");
        this.leftCapComboBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                TankCalc.this.leftCapComboBoxItemStateChanged(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        this.entryPanel.add((Component)this.leftCapComboBox, gridBagConstraints);
        this.rightCapComboBox.setModel(new DefaultComboBoxModel<String>(new String[]{"Elliptical", "Conical", "Spherical"}));
        this.rightCapComboBox.setToolTipText("Enter right/top end cap type");
        this.rightCapComboBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                TankCalc.this.rightCapComboBoxItemStateChanged(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        this.entryPanel.add((Component)this.rightCapComboBox, gridBagConstraints);
        this.scaling_factor_label.setFont(new Font("Dialog", 0, 12));
        this.scaling_factor_label.setForeground(new Color(255, 255, 255));
        this.scaling_factor_label.setText("Scaling Factor");
        this.scaling_factor_label.setPreferredSize(new Dimension(240, 24));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 13;
        gridBagConstraints.anchor = 18;
        this.entryPanel.add((Component)this.scaling_factor_label, gridBagConstraints);
        this.scalingFactorTextField.setHorizontalAlignment(4);
        this.scalingFactorTextField.setText("1.0");
        this.scalingFactorTextField.setToolTipText("Scaling factor for oval cross-section tanks");
        this.scalingFactorTextField.setMaximumSize(new Dimension(150, 24));
        this.scalingFactorTextField.setMinimumSize(new Dimension(24, 24));
        this.scalingFactorTextField.setPreferredSize(new Dimension(24, 24));
        this.scalingFactorTextField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent evt) {
                TankCalc.this.scalingFactorTextFieldKeyTyped(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 13;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        this.entryPanel.add((Component)this.scalingFactorTextField, gridBagConstraints);
        this.jLabel19.setFont(new Font("Dialog", 0, 12));
        this.jLabel19.setForeground(new Color(255, 255, 255));
        this.jLabel19.setText(" Tank orientation");
        this.jLabel19.setIconTextGap(0);
        this.jLabel19.setMaximumSize(new Dimension(3000, 24));
        this.jLabel19.setMinimumSize(new Dimension(200, 24));
        this.jLabel19.setPreferredSize(new Dimension(240, 24));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 14;
        gridBagConstraints.anchor = 18;
        this.entryPanel.add((Component)this.jLabel19, gridBagConstraints);
        this.tankOrientationComboBox.setModel(new DefaultComboBoxModel<String>(new String[]{"Horizontal", "Vertical", "Tilted"}));
        this.tankOrientationComboBox.setToolTipText("Select tank orientation");
        this.tankOrientationComboBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                TankCalc.this.tankOrientationComboBoxItemStateChanged(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 14;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        this.entryPanel.add((Component)this.tankOrientationComboBox, gridBagConstraints);
        this.tankAngleLabel.setFont(new Font("Dialog", 0, 12));
        this.tankAngleLabel.setForeground(new Color(255, 255, 255));
        this.tankAngleLabel.setText(" Tank angle degrees (or slope %)");
        this.tankAngleLabel.setHorizontalTextPosition(0);
        this.tankAngleLabel.setIconTextGap(0);
        this.tankAngleLabel.setMaximumSize(new Dimension(200, 24));
        this.tankAngleLabel.setMinimumSize(new Dimension(200, 24));
        this.tankAngleLabel.setPreferredSize(new Dimension(240, 24));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 15;
        gridBagConstraints.anchor = 18;
        this.entryPanel.add((Component)this.tankAngleLabel, gridBagConstraints);
        this.tankAngleTextField.setHorizontalAlignment(4);
        this.tankAngleTextField.setText("5%");
        this.tankAngleTextField.setToolTipText("<html>Enter angle in degrees (0-90) or slope in percent<br/>\n(use percent % sign for slope)</html>");
        this.tankAngleTextField.setMaximumSize(new Dimension(150, 24));
        this.tankAngleTextField.setMinimumSize(new Dimension(24, 24));
        this.tankAngleTextField.setPreferredSize(new Dimension(24, 24));
        this.tankAngleTextField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent evt) {
                TankCalc.this.tankAngleTextFieldKeyTyped(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 15;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        this.entryPanel.add((Component)this.tankAngleTextField, gridBagConstraints);
        this.sensorPathLabel.setFont(new Font("Dialog", 0, 12));
        this.sensorPathLabel.setForeground(new Color(255, 255, 255));
        this.sensorPathLabel.setText(" Sensor axis");
        this.sensorPathLabel.setIconTextGap(0);
        this.sensorPathLabel.setMaximumSize(new Dimension(3000, 25));
        this.sensorPathLabel.setMinimumSize(new Dimension(200, 24));
        this.sensorPathLabel.setPreferredSize(new Dimension(240, 24));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 16;
        gridBagConstraints.anchor = 18;
        this.entryPanel.add((Component)this.sensorPathLabel, gridBagConstraints);
        this.sensorOrientationComboBox.setModel(new DefaultComboBoxModel<String>(new String[]{"Contents", "Y axis", "X axis"}));
        this.sensorOrientationComboBox.setToolTipText("Sensor is perpendicular to this axis");
        this.sensorOrientationComboBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                TankCalc.this.sensorOrientationComboBoxItemStateChanged(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 16;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        this.entryPanel.add((Component)this.sensorOrientationComboBox, gridBagConstraints);
        this.xCoordLabel.setFont(new Font("Dialog", 0, 12));
        this.xCoordLabel.setForeground(new Color(255, 255, 255));
        this.xCoordLabel.setText(" Sensor X position cm");
        this.xCoordLabel.setIconTextGap(0);
        this.xCoordLabel.setMaximumSize(new Dimension(3000, 24));
        this.xCoordLabel.setMinimumSize(new Dimension(200, 24));
        this.xCoordLabel.setPreferredSize(new Dimension(240, 24));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 17;
        gridBagConstraints.anchor = 18;
        this.entryPanel.add((Component)this.xCoordLabel, gridBagConstraints);
        this.yCoordLabel.setFont(new Font("Dialog", 0, 12));
        this.yCoordLabel.setForeground(new Color(255, 255, 255));
        this.yCoordLabel.setText(" Sensor Y position cm");
        this.yCoordLabel.setIconTextGap(0);
        this.yCoordLabel.setMaximumSize(new Dimension(3000, 24));
        this.yCoordLabel.setMinimumSize(new Dimension(200, 24));
        this.yCoordLabel.setPreferredSize(new Dimension(240, 24));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 18;
        gridBagConstraints.anchor = 18;
        this.entryPanel.add((Component)this.yCoordLabel, gridBagConstraints);
        this.zCoordLabel.setFont(new Font("Dialog", 0, 12));
        this.zCoordLabel.setForeground(new Color(255, 255, 255));
        this.zCoordLabel.setText(" Sensor Z position cm");
        this.zCoordLabel.setIconTextGap(0);
        this.zCoordLabel.setMaximumSize(new Dimension(3000, 24));
        this.zCoordLabel.setMinimumSize(new Dimension(200, 24));
        this.zCoordLabel.setPreferredSize(new Dimension(240, 24));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 19;
        gridBagConstraints.anchor = 18;
        this.entryPanel.add((Component)this.zCoordLabel, gridBagConstraints);
        this.sensorXTextField.setHorizontalAlignment(4);
        this.sensorXTextField.setText("0.0");
        this.sensorXTextField.setToolTipText("Enter the sensor's X (left/right) position");
        this.sensorXTextField.setMaximumSize(new Dimension(150, 24));
        this.sensorXTextField.setMinimumSize(new Dimension(24, 24));
        this.sensorXTextField.setPreferredSize(new Dimension(24, 24));
        this.sensorXTextField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent evt) {
                TankCalc.this.sensorXTextFieldKeyTyped(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 17;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        this.entryPanel.add((Component)this.sensorXTextField, gridBagConstraints);
        this.sensorYTextField.setHorizontalAlignment(4);
        this.sensorYTextField.setText("0.0");
        this.sensorYTextField.setToolTipText("Enter the sensor's Y (up/down) position");
        this.sensorYTextField.setMaximumSize(new Dimension(150, 24));
        this.sensorYTextField.setMinimumSize(new Dimension(24, 24));
        this.sensorYTextField.setPreferredSize(new Dimension(24, 24));
        this.sensorYTextField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent evt) {
                TankCalc.this.sensorYTextFieldKeyTyped(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 18;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        this.entryPanel.add((Component)this.sensorYTextField, gridBagConstraints);
        this.sensorZTextField.setHorizontalAlignment(4);
        this.sensorZTextField.setText("0.0");
        this.sensorZTextField.setToolTipText("Enter the sensor's Z (front/back) position");
        this.sensorZTextField.setMaximumSize(new Dimension(150, 24));
        this.sensorZTextField.setMinimumSize(new Dimension(24, 24));
        this.sensorZTextField.setPreferredSize(new Dimension(24, 24));
        this.sensorZTextField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent evt) {
                TankCalc.this.sensorZTextFieldKeyTyped(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 19;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        this.entryPanel.add((Component)this.sensorZTextField, gridBagConstraints);
        this.residVolumeLabel.setFont(new Font("Dialog", 0, 12));
        this.residVolumeLabel.setForeground(new Color(255, 255, 255));
        this.residVolumeLabel.setText(" Residual Volume");
        this.residVolumeLabel.setIconTextGap(0);
        this.residVolumeLabel.setMaximumSize(new Dimension(3000, 24));
        this.residVolumeLabel.setMinimumSize(new Dimension(200, 24));
        this.residVolumeLabel.setPreferredSize(new Dimension(240, 24));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 20;
        gridBagConstraints.anchor = 18;
        this.entryPanel.add((Component)this.residVolumeLabel, gridBagConstraints);
        this.residVolumeTextField.setHorizontalAlignment(4);
        this.residVolumeTextField.setText("0.0");
        this.residVolumeTextField.setToolTipText("Enter volume to adjust for inaccessible/unmeasured content");
        this.residVolumeTextField.setMaximumSize(new Dimension(150, 24));
        this.residVolumeTextField.setMinimumSize(new Dimension(24, 24));
        this.residVolumeTextField.setPreferredSize(new Dimension(24, 24));
        this.residVolumeTextField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent evt) {
                TankCalc.this.residVolumeTextFieldKeyTyped(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 20;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        this.entryPanel.add((Component)this.residVolumeTextField, gridBagConstraints);
        this.wallThicknessLabel.setFont(new Font("Dialog", 0, 12));
        this.wallThicknessLabel.setForeground(new Color(255, 255, 255));
        this.wallThicknessLabel.setText(" Wall thickness");
        this.wallThicknessLabel.setIconTextGap(0);
        this.wallThicknessLabel.setMaximumSize(new Dimension(3000, 24));
        this.wallThicknessLabel.setMinimumSize(new Dimension(200, 24));
        this.wallThicknessLabel.setPreferredSize(new Dimension(240, 24));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 21;
        gridBagConstraints.anchor = 18;
        this.entryPanel.add((Component)this.wallThicknessLabel, gridBagConstraints);
        this.jLabel20.setFont(new Font("Dialog", 0, 12));
        this.jLabel20.setForeground(new Color(255, 255, 255));
        this.jLabel20.setText(" Wall material density");
        this.jLabel20.setIconTextGap(0);
        this.jLabel20.setMaximumSize(new Dimension(3000, 24));
        this.jLabel20.setMinimumSize(new Dimension(200, 24));
        this.jLabel20.setPreferredSize(new Dimension(240, 24));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 22;
        gridBagConstraints.anchor = 18;
        this.entryPanel.add((Component)this.jLabel20, gridBagConstraints);
        this.jLabel21.setFont(new Font("Dialog", 0, 12));
        this.jLabel21.setForeground(new Color(255, 255, 255));
        this.jLabel21.setText(" Content density");
        this.jLabel21.setIconTextGap(0);
        this.jLabel21.setMaximumSize(new Dimension(3000, 24));
        this.jLabel21.setMinimumSize(new Dimension(200, 24));
        this.jLabel21.setPreferredSize(new Dimension(240, 24));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 23;
        gridBagConstraints.anchor = 18;
        this.entryPanel.add((Component)this.jLabel21, gridBagConstraints);
        this.wallThicknessTextField.setHorizontalAlignment(4);
        this.wallThicknessTextField.setText("0.1");
        this.wallThicknessTextField.setToolTipText("Enter tank wall thickness");
        this.wallThicknessTextField.setMaximumSize(new Dimension(150, 24));
        this.wallThicknessTextField.setMinimumSize(new Dimension(24, 24));
        this.wallThicknessTextField.setPreferredSize(new Dimension(24, 24));
        this.wallThicknessTextField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent evt) {
                TankCalc.this.wallThicknessTextFieldKeyTyped(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 21;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        this.entryPanel.add((Component)this.wallThicknessTextField, gridBagConstraints);
        this.wallDensityTextField.setHorizontalAlignment(4);
        this.wallDensityTextField.setText("8.03");
        this.wallDensityTextField.setToolTipText("Enter tank wall density value (water = 1, steel = 8.03)");
        this.wallDensityTextField.setMaximumSize(new Dimension(150, 24));
        this.wallDensityTextField.setMinimumSize(new Dimension(24, 24));
        this.wallDensityTextField.setPreferredSize(new Dimension(24, 24));
        this.wallDensityTextField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent evt) {
                TankCalc.this.wallDensityTextFieldKeyTyped(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 22;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        this.entryPanel.add((Component)this.wallDensityTextField, gridBagConstraints);
        this.contentDensityTextField.setHorizontalAlignment(4);
        this.contentDensityTextField.setText("0.70");
        this.contentDensityTextField.setToolTipText("Enter tank content density value (water = 1)");
        this.contentDensityTextField.setMaximumSize(new Dimension(150, 24));
        this.contentDensityTextField.setMinimumSize(new Dimension(24, 24));
        this.contentDensityTextField.setPreferredSize(new Dimension(24, 24));
        this.contentDensityTextField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent evt) {
                TankCalc.this.contentDensityTextFieldKeyTyped(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 23;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        this.entryPanel.add((Component)this.contentDensityTextField, gridBagConstraints);
        this.inputTag.setFont(new Font("Dialog", 0, 12));
        this.inputTag.setForeground(new Color(255, 255, 255));
        this.inputTag.setText(" Length Units");
        this.inputTag.setIconTextGap(0);
        this.inputTag.setMaximumSize(new Dimension(3000, 24));
        this.inputTag.setMinimumSize(new Dimension(200, 24));
        this.inputTag.setPreferredSize(new Dimension(240, 24));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 24;
        gridBagConstraints.anchor = 18;
        this.entryPanel.add((Component)this.inputTag, gridBagConstraints);
        this.inputUnitsComboBox.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        this.inputUnitsComboBox.setToolTipText("Select tank dimension length units");
        this.inputUnitsComboBox.setFocusable(false);
        this.inputUnitsComboBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                TankCalc.this.inputUnitsComboBoxItemStateChanged(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 24;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        this.entryPanel.add(this.inputUnitsComboBox, gridBagConstraints);
        this.outputTag.setFont(new Font("Dialog", 0, 12));
        this.outputTag.setForeground(new Color(255, 255, 255));
        this.outputTag.setText(" Volume Units");
        this.outputTag.setIconTextGap(0);
        this.outputTag.setMaximumSize(new Dimension(3000, 24));
        this.outputTag.setMinimumSize(new Dimension(200, 24));
        this.outputTag.setPreferredSize(new Dimension(240, 24));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 25;
        gridBagConstraints.anchor = 18;
        this.entryPanel.add((Component)this.outputTag, gridBagConstraints);
        this.outputUnitsComboBox.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        this.outputUnitsComboBox.setToolTipText("Select tank content volume units");
        this.outputUnitsComboBox.setFocusable(false);
        this.outputUnitsComboBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                TankCalc.this.outputUnitsComboBoxItemStateChanged(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 25;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        this.entryPanel.add(this.outputUnitsComboBox, gridBagConstraints);
        this.jLabel18.setFont(new Font("Dialog", 0, 12));
        this.jLabel18.setForeground(new Color(255, 255, 255));
        this.jLabel18.setText(" Weight units");
        this.jLabel18.setIconTextGap(0);
        this.jLabel18.setMaximumSize(new Dimension(3000, 24));
        this.jLabel18.setMinimumSize(new Dimension(200, 24));
        this.jLabel18.setPreferredSize(new Dimension(240, 24));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 26;
        gridBagConstraints.anchor = 18;
        this.entryPanel.add((Component)this.jLabel18, gridBagConstraints);
        this.weightUnitsComboBox.setModel(new DefaultComboBoxModel<String>(new String[]{"kilograms", "pounds"}));
        this.weightUnitsComboBox.setSelectedIndex(1);
        this.weightUnitsComboBox.setToolTipText("Select weight units");
        this.weightUnitsComboBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                TankCalc.this.weightUnitsComboBoxItemStateChanged(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 26;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        this.entryPanel.add((Component)this.weightUnitsComboBox, gridBagConstraints);
        this.jLabel9.setFont(new Font("Dialog", 0, 12));
        this.jLabel9.setForeground(new Color(255, 255, 255));
        this.jLabel9.setText(" Cylinder integration steps");
        this.jLabel9.setIconTextGap(0);
        this.jLabel9.setMaximumSize(new Dimension(3000, 24));
        this.jLabel9.setMinimumSize(new Dimension(200, 24));
        this.jLabel9.setPreferredSize(new Dimension(240, 24));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 28;
        gridBagConstraints.anchor = 18;
        this.entryPanel.add((Component)this.jLabel9, gridBagConstraints);
        this.cylinderIntegrationStepsTextField.setHorizontalAlignment(4);
        this.cylinderIntegrationStepsTextField.setText("200");
        this.cylinderIntegrationStepsTextField.setToolTipText("The number of steps to integrate the cylinder's volume");
        this.cylinderIntegrationStepsTextField.setMaximumSize(new Dimension(150, 24));
        this.cylinderIntegrationStepsTextField.setMinimumSize(new Dimension(24, 24));
        this.cylinderIntegrationStepsTextField.setPreferredSize(new Dimension(24, 24));
        this.cylinderIntegrationStepsTextField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent evt) {
                TankCalc.this.cylinderIntegrationStepsTextFieldKeyTyped(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 28;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        this.entryPanel.add((Component)this.cylinderIntegrationStepsTextField, gridBagConstraints);
        this.jLabel10.setFont(new Font("Dialog", 0, 12));
        this.jLabel10.setForeground(new Color(255, 255, 255));
        this.jLabel10.setText(" End cap integration steps");
        this.jLabel10.setIconTextGap(0);
        this.jLabel10.setMaximumSize(new Dimension(3000, 24));
        this.jLabel10.setMinimumSize(new Dimension(200, 24));
        this.jLabel10.setPreferredSize(new Dimension(240, 24));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 29;
        gridBagConstraints.anchor = 18;
        this.entryPanel.add((Component)this.jLabel10, gridBagConstraints);
        this.endCapIntegrationStepsTextField.setHorizontalAlignment(4);
        this.endCapIntegrationStepsTextField.setText("400");
        this.endCapIntegrationStepsTextField.setToolTipText("The number of steps to integrate each end cap's volume");
        this.endCapIntegrationStepsTextField.setMaximumSize(new Dimension(150, 24));
        this.endCapIntegrationStepsTextField.setMinimumSize(new Dimension(24, 24));
        this.endCapIntegrationStepsTextField.setPreferredSize(new Dimension(24, 24));
        this.endCapIntegrationStepsTextField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent evt) {
                TankCalc.this.endCapIntegrationStepsTextFieldKeyTyped(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 29;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        this.entryPanel.add((Component)this.endCapIntegrationStepsTextField, gridBagConstraints);
        this.heightStepSizeLabel.setFont(new Font("Dialog", 0, 12));
        this.heightStepSizeLabel.setForeground(new Color(255, 255, 255));
        this.heightStepSizeLabel.setText(" Height Table Step Size");
        this.heightStepSizeLabel.setPreferredSize(new Dimension(240, 24));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 30;
        gridBagConstraints.anchor = 18;
        this.entryPanel.add((Component)this.heightStepSizeLabel, gridBagConstraints);
        this.tableHeightStepSizeTextField.setHorizontalAlignment(4);
        this.tableHeightStepSizeTextField.setText("1.0");
        this.tableHeightStepSizeTextField.setPreferredSize(new Dimension(24, 24));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 30;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        this.entryPanel.add((Component)this.tableHeightStepSizeTextField, gridBagConstraints);
        this.volumeStepSizeLabel.setFont(new Font("Dialog", 0, 12));
        this.volumeStepSizeLabel.setForeground(new Color(255, 255, 255));
        this.volumeStepSizeLabel.setText(" Volume Table Step Size");
        this.volumeStepSizeLabel.setPreferredSize(new Dimension(240, 24));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 31;
        gridBagConstraints.anchor = 18;
        this.entryPanel.add((Component)this.volumeStepSizeLabel, gridBagConstraints);
        this.jLabel11.setFont(new Font("Dialog", 0, 12));
        this.jLabel11.setForeground(new Color(255, 255, 255));
        this.jLabel11.setText(" Root finder epsilon");
        this.jLabel11.setPreferredSize(new Dimension(240, 24));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 32;
        gridBagConstraints.anchor = 18;
        this.entryPanel.add((Component)this.jLabel11, gridBagConstraints);
        this.tableVolumeStepSizeTextField.setHorizontalAlignment(4);
        this.tableVolumeStepSizeTextField.setText("1.0");
        this.tableVolumeStepSizeTextField.setMaximumSize(new Dimension(150, 24));
        this.tableVolumeStepSizeTextField.setMinimumSize(new Dimension(24, 24));
        this.tableVolumeStepSizeTextField.setPreferredSize(new Dimension(24, 24));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 31;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        this.entryPanel.add((Component)this.tableVolumeStepSizeTextField, gridBagConstraints);
        this.jLabel5.setFont(new Font("Dialog", 0, 12));
        this.jLabel5.setForeground(new Color(255, 255, 255));
        this.jLabel5.setText(" Displayed Decimal Places  ");
        this.jLabel5.setPreferredSize(new Dimension(240, 24));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 27;
        gridBagConstraints.anchor = 18;
        this.entryPanel.add((Component)this.jLabel5, gridBagConstraints);
        this.decimalPlacesComboBox.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        this.decimalPlacesComboBox.setToolTipText("Number resolution");
        this.decimalPlacesComboBox.setMinimumSize(new Dimension(40, 24));
        this.decimalPlacesComboBox.setPreferredSize(new Dimension(10, 24));
        this.decimalPlacesComboBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                TankCalc.this.decimalPlacesComboBoxItemStateChanged(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 27;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        this.entryPanel.add(this.decimalPlacesComboBox, gridBagConstraints);
        this.rootFinderEpsilonTextField.setHorizontalAlignment(4);
        this.rootFinderEpsilonTextField.setText("1e-8");
        this.rootFinderEpsilonTextField.setToolTipText("The accuracy specifier for the height-from-volume root finder");
        this.rootFinderEpsilonTextField.setMaximumSize(new Dimension(150, 24));
        this.rootFinderEpsilonTextField.setMinimumSize(new Dimension(24, 24));
        this.rootFinderEpsilonTextField.setPreferredSize(new Dimension(24, 24));
        this.rootFinderEpsilonTextField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent evt) {
                TankCalc.this.rootFinderEpsilonTextFieldKeyTyped(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 32;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        this.entryPanel.add((Component)this.rootFinderEpsilonTextField, gridBagConstraints);
        this.jScrollPane5.setViewportView(this.entryPanel);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.weighty = 1.0;
        this.inputPanel.add((Component)this.jScrollPane5, gridBagConstraints);
        this.mainTabbedPane.addTab("Input", new ImageIcon(this.getClass().getResource("/tankcalc/icons/accessories-text-editor.png")), this.inputPanel);
        this.tableGenPanel.setFocusable(false);
        this.tableGenPanel.setLayout(new GridBagLayout());
        this.SingleResultPanel.setBorder(BorderFactory.createTitledBorder("Single Result"));
        this.SingleResultPanel.setLayout(new GridBagLayout());
        this.modePanel.setLayout(new GridBagLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 11;
        this.SingleResultPanel.add((Component)this.modePanel, gridBagConstraints);
        this.inputLabel.setHorizontalAlignment(2);
        this.inputLabel.setText("jLabel4");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.ipadx = 8;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 16, 4, 4);
        this.SingleResultPanel.add((Component)this.inputLabel, gridBagConstraints);
        this.singleInputField.setHorizontalAlignment(4);
        this.singleInputField.setToolTipText("Enter a value, then press Enter");
        this.singleInputField.setMargin(new Insets(0, 4, 0, 4));
        this.singleInputField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent evt) {
                TankCalc.this.singleInputFieldKeyTyped(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        this.SingleResultPanel.add((Component)this.singleInputField, gridBagConstraints);
        this.outputLabel.setHorizontalAlignment(2);
        this.outputLabel.setText("jLabel5");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.ipadx = 8;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(4, 16, 4, 4);
        this.SingleResultPanel.add((Component)this.outputLabel, gridBagConstraints);
        this.singleOutputField.setHorizontalAlignment(4);
        this.singleOutputField.setToolTipText("Single result appears here");
        this.singleOutputField.setMargin(new Insets(0, 4, 0, 4));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.weightx = 1.0;
        this.SingleResultPanel.add((Component)this.singleOutputField, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.tableGenPanel.add((Component)this.SingleResultPanel, gridBagConstraints);
        this.TablePanel.setBorder(new LineBorder(new Color(0, 0, 0), 1, true));
        this.TablePanel.setLayout(new GridBagLayout());
        this.tableControlPanel.setLayout(new GridBagLayout());
        this.copyHTMLToClipboardButton.setIcon(new ImageIcon(this.getClass().getResource("/tankcalc/icons/edit-copy.png")));
        this.copyHTMLToClipboardButton.setText("Copy HTML");
        this.copyHTMLToClipboardButton.setToolTipText("Copy table to system clipboard as HTML");
        this.copyHTMLToClipboardButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                TankCalc.this.copyHTMLToClipboardButtonMouseClicked(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 0.5;
        this.tableControlPanel.add((Component)this.copyHTMLToClipboardButton, gridBagConstraints);
        this.tableCancelButton.setIcon(new ImageIcon(this.getClass().getResource("/tankcalc/icons/process-stop.png")));
        this.tableCancelButton.setText("Cancel");
        this.tableCancelButton.setToolTipText("Cancel current table build");
        this.tableCancelButton.setEnabled(false);
        this.tableCancelButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                TankCalc.this.tableCancelButtonMouseClicked(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 0.5;
        this.tableControlPanel.add((Component)this.tableCancelButton, gridBagConstraints);
        this.buildVHDataTableButton.setIcon(new ImageIcon(this.getClass().getResource("/tankcalc/icons/system-run.png")));
        this.buildVHDataTableButton.setText("Volume -> Height");
        this.buildVHDataTableButton.setToolTipText("Set volume -> height mode, create table (slower)");
        this.buildVHDataTableButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                TankCalc.this.buildVHDataTableButtonMouseClicked(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 0.5;
        this.tableControlPanel.add((Component)this.buildVHDataTableButton, gridBagConstraints);
        this.buildHVDataTableButton.setIcon(new ImageIcon(this.getClass().getResource("/tankcalc/icons/system-run.png")));
        this.buildHVDataTableButton.setText("Height -> Volume");
        this.buildHVDataTableButton.setToolTipText("Set height -> volume mode, create table");
        this.buildHVDataTableButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                TankCalc.this.buildHVDataTableButtonMouseClicked(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 0.5;
        this.tableControlPanel.add((Component)this.buildHVDataTableButton, gridBagConstraints);
        this.buildSpecTableButton.setIcon(new ImageIcon(this.getClass().getResource("/tankcalc/icons/accessories-text-editor.png")));
        this.buildSpecTableButton.setText("Properties");
        this.buildSpecTableButton.setToolTipText("Build properties table with current settings");
        this.buildSpecTableButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                TankCalc.this.buildSpecTableButtonMouseClicked(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 0.5;
        this.tableControlPanel.add((Component)this.buildSpecTableButton, gridBagConstraints);
        this.copyTSVToClipboardButton.setIcon(new ImageIcon(this.getClass().getResource("/tankcalc/icons/edit-copy.png")));
        this.copyTSVToClipboardButton.setText("Copy TSV");
        this.copyTSVToClipboardButton.setToolTipText("Copy table to system clipboard as tab-separated values (TSV)");
        this.copyTSVToClipboardButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                TankCalc.this.copyTSVToClipboardButtonMouseClicked(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 0.5;
        this.tableControlPanel.add((Component)this.copyTSVToClipboardButton, gridBagConstraints);
        this.copyPlainToClipboardButton.setIcon(new ImageIcon(this.getClass().getResource("/tankcalc/icons/edit-copy.png")));
        this.copyPlainToClipboardButton.setText("Copy Plain");
        this.copyPlainToClipboardButton.setToolTipText("Copy table to system clipboard as plain text");
        this.copyPlainToClipboardButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                TankCalc.this.copyPlainToClipboardButtonMouseClicked(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 0.5;
        this.tableControlPanel.add((Component)this.copyPlainToClipboardButton, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.weighty = 1.0;
        this.tableControlPanel.add((Component)this.fillerPanel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weighty = 1.0;
        this.TablePanel.add((Component)this.tableControlPanel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 15;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(2, 0, 2, 0);
        this.TablePanel.add((Component)this.tableProgressBar, gridBagConstraints);
        this.jPanel3.setLayout(new GridBagLayout());
        this.jLabel6.setText(" Table Title  ");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(0, 2, 0, 2);
        this.jPanel3.add((Component)this.jLabel6, gridBagConstraints);
        this.tableTitleTextField.setHorizontalAlignment(0);
        this.tableTitleTextField.setToolTipText("Enter an optional table title");
        this.tableTitleTextField.setPreferredSize(new Dimension(4, 24));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        this.jPanel3.add((Component)this.tableTitleTextField, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 15;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(4, 0, 0, 0);
        this.TablePanel.add((Component)this.jPanel3, gridBagConstraints);
        this.tableDisplayPanel.setLayout(new BorderLayout());
        this.tableScrollPane.setBackground(new Color(255, 255, 255));
        this.dataTableDisplay.setFont(new Font("Courier", 0, 12));
        this.dataTableDisplay.setModel(new DefaultTableModel(new Object[][]{{null, null, null, null}, {null, null, null, null}, {null, null, null, null}, {null, null, null, null}}, new String[]{"Title 1", "Title 2", "Title 3", "Title 4"}));
        this.dataTableDisplay.setAutoResizeMode(0);
        this.dataTableDisplay.setCursor(new Cursor(12));
        this.tableScrollPane.setViewportView(this.dataTableDisplay);
        this.tableDisplayPanel.add((Component)this.tableScrollPane, "Center");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.TablePanel.add((Component)this.tableDisplayPanel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.tableGenPanel.add((Component)this.TablePanel, gridBagConstraints);
        this.mainTabbedPane.addTab("Compute", new ImageIcon(this.getClass().getResource("/tankcalc/icons/TankCalcIcon.png")), this.tableGenPanel);
        this.graphicModelPanel.setLayout(new GridBagLayout());
        this.graphicDisplayPanel.setLayout(new GridBagLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.graphicModelPanel.add((Component)this.graphicDisplayPanel, gridBagConstraints);
        this.inverseCheckBox.setText("Inverse");
        this.inverseCheckBox.setToolTipText("Dark background");
        this.inverseCheckBox.setFocusable(false);
        this.inverseCheckBox.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                TankCalc.this.inverseCheckBoxMouseClicked(evt);
            }
        });
        this.controlPanelA.add(this.inverseCheckBox);
        this.leftCapCheckBox.setSelected(true);
        this.leftCapCheckBox.setText("Left Cap");
        this.leftCapCheckBox.setToolTipText("Draw the left tank cap");
        this.leftCapCheckBox.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                TankCalc.this.leftCapCheckBoxMouseClicked(evt);
            }
        });
        this.controlPanelA.add(this.leftCapCheckBox);
        this.cylinderCheckBox.setSelected(true);
        this.cylinderCheckBox.setText("Cylinder");
        this.cylinderCheckBox.setToolTipText("Draw the tank central cylinder");
        this.cylinderCheckBox.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                TankCalc.this.cylinderCheckBoxMouseClicked(evt);
            }
        });
        this.controlPanelA.add(this.cylinderCheckBox);
        this.rightCapCheckBox.setSelected(true);
        this.rightCapCheckBox.setText("Right Cap");
        this.rightCapCheckBox.setToolTipText("Draw the tank right cap");
        this.rightCapCheckBox.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                TankCalc.this.rightCapCheckBoxMouseClicked(evt);
            }
        });
        this.controlPanelA.add(this.rightCapCheckBox);
        this.sensorCheckBox.setSelected(true);
        this.sensorCheckBox.setText("Sensor");
        this.sensorCheckBox.setToolTipText("Draw the tank content sensor");
        this.sensorCheckBox.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                TankCalc.this.sensorCheckBoxMouseClicked(evt);
            }
        });
        this.controlPanelA.add(this.sensorCheckBox);
        this.lineThicknessLabel.setText("| Line:");
        this.controlPanelA.add(this.lineThicknessLabel);
        this.lineThicknessComboBox.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        this.lineThicknessComboBox.setToolTipText("Line Thickness");
        this.lineThicknessComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TankCalc.this.lineThicknessComboBoxActionPerformed(evt);
            }
        });
        this.controlPanelA.add(this.lineThicknessComboBox);
        this.jLabel3.setText("|");
        this.controlPanelA.add(this.jLabel3);
        this.anaglyphicLabel.setHorizontalAlignment(0);
        this.anaglyphicLabel.setIcon(new ImageIcon(this.getClass().getResource("/tankcalc/icons/glasses_3d_pic_small.png")));
        this.controlPanelA.add(this.anaglyphicLabel);
        this.anaglyphCheckBox.setText("Anaglyph");
        this.anaglyphCheckBox.setToolTipText("Anaglyphic view (3D with red-blue glasses)");
        this.anaglyphCheckBox.setFocusable(false);
        this.anaglyphCheckBox.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                TankCalc.this.anaglyphCheckBoxMouseClicked(evt);
            }
        });
        this.controlPanelA.add(this.anaglyphCheckBox);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.graphicModelPanel.add((Component)this.controlPanelA, gridBagConstraints);
        this.controlPanelB.setFocusable(false);
        this.jLabel12.setText("X:");
        this.controlPanelB.add(this.jLabel12);
        this.xLinesComboBox.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        this.xLinesComboBox.setToolTipText("Number of X lines/columns in graphic");
        this.xLinesComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TankCalc.this.xLinesComboBoxActionPerformed(evt);
            }
        });
        this.controlPanelB.add(this.xLinesComboBox);
        this.jLabel13.setText("Y:");
        this.controlPanelB.add(this.jLabel13);
        this.yLinesComboBox.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        this.yLinesComboBox.setToolTipText("<html>Number of Y lines/rows in graphic<br/>(suggest 16 for line drawing, 64 for polygons)</html>");
        this.yLinesComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TankCalc.this.yLinesComboBoxActionPerformed(evt);
            }
        });
        this.controlPanelB.add(this.yLinesComboBox);
        this.polygonCheckBox.setText("Polygons");
        this.polygonCheckBox.setToolTipText("Polygons instead of lines");
        this.polygonCheckBox.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                TankCalc.this.polygonCheckBoxMouseClicked(evt);
            }
        });
        this.controlPanelB.add(this.polygonCheckBox);
        this.transparencyLabel.setText("| Transp:");
        this.controlPanelB.add(this.transparencyLabel);
        this.transparencyComboBox.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        this.transparencyComboBox.setToolTipText("Polygon Image Transparency");
        this.controlPanelB.add(this.transparencyComboBox);
        this.antialiasingCheckBox.setSelected(true);
        this.antialiasingCheckBox.setText("Antialiasing");
        this.antialiasingCheckBox.setToolTipText("Much better appearance, but longer drawing time");
        this.antialiasingCheckBox.setFocusable(false);
        this.antialiasingCheckBox.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                TankCalc.this.antialiasingCheckBoxMouseClicked(evt);
            }
        });
        this.controlPanelB.add(this.antialiasingCheckBox);
        this.graphicDefaultsButton.setIcon(new ImageIcon(this.getClass().getResource("/tankcalc/icons/edit-clear.png")));
        this.graphicDefaultsButton.setText("Defaults");
        this.graphicDefaultsButton.setToolTipText("Set image default values");
        this.graphicDefaultsButton.setFocusable(false);
        this.graphicDefaultsButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                TankCalc.this.graphicDefaultsButtonMouseClicked(evt);
            }
        });
        this.controlPanelB.add(this.graphicDefaultsButton);
        this.copyButton.setIcon(new ImageIcon(this.getClass().getResource("/tankcalc/icons/edit-copy.png")));
        this.copyButton.setText("Copy");
        this.copyButton.setToolTipText("Copy graphic to clipboard");
        this.copyButton.setFocusable(false);
        this.copyButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                TankCalc.this.copyButtonMouseClicked(evt);
            }
        });
        this.controlPanelB.add(this.copyButton);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.graphicModelPanel.add((Component)this.controlPanelB, gridBagConstraints);
        this.mainTabbedPane.addTab("Model", new ImageIcon(this.getClass().getResource("/tankcalc/icons/applications-multimedia.png")), this.graphicModelPanel);
        this.graphicPanel.setBackground(Color.white);
        this.graphicPanel.setFocusable(false);
        this.graphicPanel.setLayout(new GridBagLayout());
        this.jScrollPane2.setBackground(Color.white);
        this.helpSlideLabel.setBackground(Color.white);
        this.helpSlideLabel.setHorizontalAlignment(0);
        this.jScrollPane2.setViewportView(this.helpSlideLabel);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.graphicPanel.add((Component)this.jScrollPane2, gridBagConstraints);
        this.ghBackButton.setIcon(new ImageIcon(this.getClass().getResource("/tankcalc/icons/go-previous.png")));
        this.ghBackButton.setText("Previous");
        this.ghBackButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                TankCalc.this.ghBackButtonMouseClicked(evt);
            }
        });
        this.graphicHelpControls.add(this.ghBackButton);
        this.ghForwardButton.setIcon(new ImageIcon(this.getClass().getResource("/tankcalc/icons/go-next.png")));
        this.ghForwardButton.setText("Next");
        this.ghForwardButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                TankCalc.this.ghForwardButtonMouseClicked(evt);
            }
        });
        this.graphicHelpControls.add(this.ghForwardButton);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.graphicPanel.add((Component)this.graphicHelpControls, gridBagConstraints);
        this.mainTabbedPane.addTab("Graphic Help", new ImageIcon(this.getClass().getResource("/tankcalc/icons/applications-graphics.png")), this.graphicPanel);
        this.helpPanel.setBorder(new LineBorder(new Color(0, 0, 0), 1, true));
        this.helpPanel.setFocusable(false);
        this.helpPanel.setLayout(new GridBagLayout());
        this.mainTabbedPane.addTab("Text Help", new ImageIcon(this.getClass().getResource("/tankcalc/icons/system-help.png")), this.helpPanel);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.mainTabbedPane, gridBagConstraints);
        this.statusPanel.setFocusable(false);
        this.statusPanel.setLayout(new GridBagLayout());
        this.statusLabel.setText("Status");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.statusPanel.add((Component)this.statusLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 0.5;
        this.statusPanel.add((Component)this.debug_label, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 15;
        gridBagConstraints.weightx = 1.0;
        this.add((Component)this.statusPanel, gridBagConstraints);
    }

    private void mainTabbedPaneMouseClicked(MouseEvent evt) {
        this.processTabClick();
    }

    private void ghForwardButtonMouseClicked(MouseEvent evt) {
        this.manageHelpSlides(1);
    }

    private void ghBackButtonMouseClicked(MouseEvent evt) {
        this.manageHelpSlides(-1);
    }

    private void copyButtonMouseClicked(MouseEvent evt) {
        this.mainPanel3d.toClipboard();
    }

    private void graphicDefaultsButtonMouseClicked(MouseEvent evt) {
        this.mainPanel3d.setDefaults(this.sharedTP);
    }

    private void antialiasingCheckBoxMouseClicked(MouseEvent evt) {
        this.readValues();
    }

    private void inverseCheckBoxMouseClicked(MouseEvent evt) {
        this.readValues();
    }

    private void anaglyphCheckBoxMouseClicked(MouseEvent evt) {
        this.readValues();
    }

    private void sensorCheckBoxMouseClicked(MouseEvent evt) {
        this.readValues();
    }

    private void rightCapCheckBoxMouseClicked(MouseEvent evt) {
        this.readValues();
    }

    private void cylinderCheckBoxMouseClicked(MouseEvent evt) {
        this.readValues();
    }

    private void leftCapCheckBoxMouseClicked(MouseEvent evt) {
        this.readValues();
    }

    private void buildSpecTableButtonMouseClicked(MouseEvent evt) {
        this.buildTable(1, true);
    }

    private void buildVHDataTableButtonMouseClicked(MouseEvent evt) {
        this.buildTable(0, true);
    }

    private void tableCancelButtonMouseClicked(MouseEvent evt) {
        this.cancelTable();
    }

    private void copyHTMLToClipboardButtonMouseClicked(MouseEvent evt) {
        this.copyTableToClipboard(2);
    }

    private void decimalPlacesComboBoxItemStateChanged(ItemEvent evt) {
        this.setModeAndLabels();
    }

    private void singleInputFieldKeyTyped(KeyEvent evt) {
        this.detectEnterKey(evt);
    }

    private void weightUnitsComboBoxItemStateChanged(ItemEvent evt) {
        this.setModeAndLabels();
    }

    private void outputUnitsComboBoxItemStateChanged(ItemEvent evt) {
        this.setModeAndLabels();
    }

    private void inputUnitsComboBoxItemStateChanged(ItemEvent evt) {
        this.setModeAndLabels();
    }

    private void contentDensityTextFieldKeyTyped(KeyEvent evt) {
        this.samc.createIfEnter(evt);
    }

    private void wallDensityTextFieldKeyTyped(KeyEvent evt) {
        this.samc.createIfEnter(evt);
    }

    private void wallThicknessTextFieldKeyTyped(KeyEvent evt) {
        this.setModeIfEnter(evt);
    }

    private void sensorZTextFieldKeyTyped(KeyEvent evt) {
        this.setModeIfEnter(evt);
    }

    private void sensorYTextFieldKeyTyped(KeyEvent evt) {
        this.setModeIfEnter(evt);
    }

    private void sensorXTextFieldKeyTyped(KeyEvent evt) {
        this.setModeIfEnter(evt);
    }

    private void sensorOrientationComboBoxItemStateChanged(ItemEvent evt) {
        this.setModeAndLabels();
    }

    private void tankAngleTextFieldKeyTyped(KeyEvent evt) {
        this.setModeIfEnter(evt);
    }

    private void tankOrientationComboBoxItemStateChanged(ItemEvent evt) {
        this.setModeAndLabels();
    }

    private void rightCapComboBoxItemStateChanged(ItemEvent evt) {
        this.setModeAndLabels();
    }

    private void leftCapComboBoxItemStateChanged(ItemEvent evt) {
        this.setModeAndLabels();
    }

    private void g_rRTextFieldKeyTyped(KeyEvent evt) {
        this.setModeIfEnter(evt);
    }

    private void g_rLTextFieldKeyTyped(KeyEvent evt) {
        this.setModeIfEnter(evt);
    }

    private void g_RTextFieldKeyTyped(KeyEvent evt) {
        this.setModeIfEnter(evt);
    }

    private void g_LTextFieldKeyTyped(KeyEvent evt) {
        this.setModeIfEnter(evt);
    }

    private void resetButtonMouseClicked(MouseEvent evt) {
        this.setConfigurationDefaults();
    }

    private void pasteDescButtonMouseClicked(MouseEvent evt) {
        this.copyPasteDescription.pasteTankDescriptionFromClipboard();
    }

    private void copyDescButtonMouseClicked(MouseEvent evt) {
        this.copyPasteDescription.copyTankDescription();
    }

    private void lineThicknessComboBoxActionPerformed(ActionEvent evt) {
        this.readValues();
    }

    private void xLinesComboBoxActionPerformed(ActionEvent evt) {
        this.readValues();
    }

    private void yLinesComboBoxActionPerformed(ActionEvent evt) {
        this.readValues();
    }

    private void residVolumeTextFieldKeyTyped(KeyEvent evt) {
        this.setModeIfEnter(evt);
    }

    private void cylinderIntegrationStepsTextFieldKeyTyped(KeyEvent evt) {
        this.setModeIfEnter(evt);
    }

    private void rootFinderEpsilonTextFieldKeyTyped(KeyEvent evt) {
        this.setModeIfEnter(evt);
    }

    private void endCapIntegrationStepsTextFieldKeyTyped(KeyEvent evt) {
        this.setModeIfEnter(evt);
    }

    private void polygonCheckBoxMouseClicked(MouseEvent evt) {
        this.setModeAndLabels();
    }

    private void buildHVDataTableButtonMouseClicked(MouseEvent evt) {
        this.buildTable(0, false);
    }

    private void copyTSVToClipboardButtonMouseClicked(MouseEvent evt) {
        this.copyTableToClipboard(1);
    }

    private void copyPlainToClipboardButtonMouseClicked(MouseEvent evt) {
        this.copyTableToClipboard(0);
    }

    private void scalingFactorTextFieldKeyTyped(KeyEvent evt) {
        this.setModeIfEnter(evt);
    }
}

