/*
 * Decompiled with CFR 0.152.
 */
package tankcalc;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Polygon;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import javax.swing.GroupLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.Timer;
import tankcalc.AreaResult;
import tankcalc.CartesianPoint;
import tankcalc.Constants;
import tankcalc.GPolygon;
import tankcalc.IColor;
import tankcalc.ImageArray;
import tankcalc.ImageGenerator;
import tankcalc.ImageTransferable;
import tankcalc.TankCalc;
import tankcalc.TankProcessor;
import tankcalc.TankProperties;
import tankcalc.Transform3D;

public class TankImageView
extends JPanel
implements MouseListener,
MouseMotionListener,
MouseWheelListener {
    TankCalc parent;
    Dimension oldSize;
    BufferedImage imagea = null;
    BufferedImage imageb = null;
    CartesianPoint oldP;
    CartesianPoint newP;
    ImageGenerator imageGenHi;
    ImageGenerator imageGenLo;
    int oldxs = -1;
    int oldys = -1;
    int xsize;
    int ysize;
    int xCenter;
    int yCenter;
    double threeDFactor = 0.03;
    double mouseScaleGainFactor = 0.3;
    int pressX = 0;
    int pressY = 0;
    double defaultScale = 40.0;
    double paintScale;
    double polygonTransparency = 0.0;
    TankProperties sharedTP;
    Transform3D graphicTransform;
    TankProcessor tvi;
    int counter = 0;
    boolean lowResMode = false;
    Timer timer;
    int timeDelay = 500;

    public TankImageView(TankCalc p, TankProperties stp) {
        this.parent = p;
        this.tvi = p.tankProcessor;
        this.imageGenHi = p.imageGenHi;
        this.imageGenLo = p.imageGenLo;
        this.sharedTP = stp;
        this.initComponents();
        this.setup();
    }

    private void setup() {
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        this.addMouseWheelListener(this);
        this.graphicTransform = new Transform3D();
        this.updateSettings(this.sharedTP);
    }

    public void setPaintChipColors() {
        this.setChipColor(this.parent.LVariableLabel, Constants.cylinderColor);
        this.setChipColor(this.parent.RVariableLabel, Constants.cylinderColor);
        this.setChipColor(this.parent.lbVariableLabel1, Constants.leftCapColor);
        this.setChipColor(this.parent.lbVariableLabel2, Constants.leftCapColor);
        this.setChipColor(this.parent.rtVariableLabel1, Constants.rightCapColor);
        this.setChipColor(this.parent.rtVariableLabel2, Constants.rightCapColor);
        this.setChipColor(this.parent.sensorPathLabel, Constants.sensorColor);
        this.setChipColor(this.parent.xCoordLabel, Constants.sensorColor);
        this.setChipColor(this.parent.yCoordLabel, Constants.sensorColor);
        this.setChipColor(this.parent.zCoordLabel, Constants.sensorColor);
    }

    void setChipColor(JLabel label, IColor col) {
        label.setOpaque(true);
        label.setBackground(new Color(col.getRGB()));
    }

    protected void createTankImage(TankProperties sp) {
        this.sharedTP = sp;
        this.setMode();
        double tolerance = 2.0;
        double me = this.tvi.maxExtent;
        double rf = this.parent.tankProcessor.g_R * 2.0;
        double d = me = me < rf ? rf : me;
        if (this.sharedTP.modelScaleFactor == 0.0 || me > this.sharedTP.modelOldScaleFactor * tolerance || me < this.sharedTP.modelOldScaleFactor / tolerance) {
            this.sharedTP.modelScaleFactor = me;
            this.sharedTP.modelScale = 800.0 / this.sharedTP.modelScaleFactor;
            this.sharedTP.modelTranslateX = 0.0;
            this.sharedTP.modelTranslateY = 0.0;
            this.sharedTP.modelTranslateZ = 0.0;
            this.setTranslate();
            this.sharedTP.modelOldScaleFactor = this.sharedTP.modelScaleFactor;
        }
        this.sharedTP.graphicPerspectiveFactor = this.sharedTP.modelScaleFactor * 3.0;
        this.rebuildModel();
        this.updateSettings(this.sharedTP);
    }

    void rebuildModel() {
        this.imageGenHi.rebuildModel(this.sharedTP);
        this.imageGenLo.rebuildModel(this.sharedTP);
    }

    @Override
    public void paintComponent(Graphics g) {
        Graphics2D g2 = (Graphics2D)g;
        this.drawSequence(g2);
    }

    public void drawSequence(Graphics2D g) {
        int w = this.getWidth();
        int h = this.getHeight();
        this.drawSequence(g, w, h);
    }

    public void drawSequence(Graphics2D g, int w, int h) {
        ImageGenerator gen;
        this.polygonTransparency = (double)this.sharedTP.polygonTransparency / 10.0;
        ImageGenerator imageGenerator = gen = this.lowResMode ? this.imageGenLo : this.imageGenHi;
        if (this.graphicTransform.sx * this.graphicTransform.cy > 0.0) {
            this.drawImage(g, gen.leftView, w, h);
        } else {
            this.drawImage(g, gen.rightView, w, h);
        }
    }

    public void drawImage(Graphics2D g, ArrayList<ImageArray> src, int xsize, int ysize) {
        if (src != null && xsize > 0 && ysize > 0) {
            this.xCenter = xsize / 2;
            this.yCenter = ysize / 2;
            double ts = xsize < ysize ? (double)xsize : (double)ysize;
            Graphics2D cga = null;
            Graphics2D cgb = null;
            this.paintScale = this.sharedTP.modelScale * ts * 0.001;
            if (this.sharedTP.graphicAnaglyphMode) {
                if (xsize != this.oldxs || ysize != this.oldys || this.imagea == null || this.imageb == null) {
                    this.imagea = new BufferedImage(xsize, ysize, 1);
                    this.imageb = new BufferedImage(xsize, ysize, 1);
                    this.oldxs = xsize;
                    this.oldys = ysize;
                }
                cga = (Graphics2D)this.imagea.getGraphics();
                cga.setColor(new Color(0));
                cga.fillRect(0, 0, xsize, ysize);
                cgb = (Graphics2D)this.imageb.getGraphics();
                cgb.setColor(new Color(0));
                cgb.fillRect(0, 0, xsize, ysize);
            } else {
                g.setColor(this.parent.graphicBackgroundColor);
                g.fillRect(0, 0, xsize, ysize);
                g.setColor(this.parent.graphicForegroundColor);
                g.drawRect(0, 0, xsize - 1, ysize - 1);
            }
            if (this.sharedTP.graphicAntialiasingMode) {
                RenderingHints rh = new RenderingHints(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                g.addRenderingHints(rh);
                if (this.sharedTP.graphicAnaglyphMode) {
                    cga.addRenderingHints(rh);
                    cgb.addRenderingHints(rh);
                }
            }
            ArrayList<PlotElement> plotLista = new ArrayList<PlotElement>();
            ArrayList<PlotElement> plotListb = new ArrayList<PlotElement>();
            for (ImageArray vec : src) {
                if (!vec.isActive()) continue;
                if (this.sharedTP.graphicAnaglyphMode) {
                    double f = this.sharedTP.graphicInverseMode ? this.parent.graphicCurrentFactor : -this.parent.graphicCurrentFactor;
                    this.drawElements(cga, plotLista, vec, f, this.sharedTP.graphicAnaglyphMode, Constants.redColor);
                    this.drawElements(cgb, plotListb, vec, -f, this.sharedTP.graphicAnaglyphMode, Constants.cyanColor);
                    continue;
                }
                this.drawElements(g, plotLista, vec, 0.0, this.sharedTP.graphicAnaglyphMode, null);
            }
            if (this.sharedTP.polygonMode) {
                Collections.sort(plotLista, new PlotComparator());
                if (this.sharedTP.graphicAnaglyphMode) {
                    for (PlotElement p : plotLista) {
                        cga.setColor(new Color(p.color, true));
                        cga.fillPolygon(p.poly);
                    }
                    Collections.sort(plotListb, new PlotComparator());
                    for (PlotElement p : plotListb) {
                        cgb.setColor(new Color(p.color, true));
                        cgb.fillPolygon(p.poly);
                    }
                } else {
                    for (PlotElement p : plotLista) {
                        g.setColor(new Color(p.color, true));
                        g.fillPolygon(p.poly);
                    }
                }
            }
            if (this.sharedTP.graphicAnaglyphMode) {
                g.drawImage((Image)this.imagea, 0, 0, this);
                g.setXORMode(new Color(this.sharedTP.graphicInverseMode ? 0 : 0xFFFFFF));
                g.drawImage((Image)this.imageb, 0, 0, this);
                cga.dispose();
                cgb.dispose();
            }
        }
    }

    private void drawElements(Graphics2D g, ArrayList<PlotElement> list, ImageArray vec, double threeDFactor, boolean anaglyphMode, IColor color) {
        if (this.sharedTP.polygonMode) {
            this.drawPolygons(list, vec, threeDFactor, anaglyphMode, color);
        } else {
            this.drawLines(g, vec, threeDFactor, anaglyphMode, color);
        }
    }

    private void drawLines(Graphics2D cg, ImageArray vec, double threeDFactor, boolean anaglyphMode, IColor color) {
        CartesianPoint p;
        if (anaglyphMode) {
            cg.setColor(new Color(color.getRGB()));
        }
        cg.setStroke(new BasicStroke(this.sharedTP.graphicLineThickness));
        int vpx = vec.getX();
        int vpy = vec.getY();
        for (int y = 0; y <= vpy; ++y) {
            for (int x = 0; x <= vpx && (p = vec.point[x][y]) != null; ++x) {
                p = p.clone();
                if (!anaglyphMode) {
                    cg.setColor(new Color(p.icolor == null ? color.getRGB() : p.icolor.getRGB()));
                }
                p.start = x == 0;
                this.drawScaledLine(cg, p, threeDFactor);
            }
        }
        for (int x = 0; x < vec.point.length; ++x) {
            for (int y = 0; y < vec.point[x].length && (p = vec.point[x][y]) != null; ++y) {
                p = p.clone();
                if (!anaglyphMode) {
                    cg.setColor(new Color(p.icolor == null ? color.getRGB() : p.icolor.getRGB()));
                }
                p.start = y == 0;
                this.drawScaledLine(cg, p, threeDFactor);
            }
        }
    }

    int highlight(IColor color, int alpha, double v, int highValue) {
        int b = (int)((double)color.b + v * (double)(highValue - color.b));
        int g = (int)((double)color.g + v * (double)(highValue - color.g));
        int r = (int)((double)color.r + v * (double)(highValue - color.r));
        return alpha << 24 | r << 16 | g << 8 | b;
    }

    int anaglyphHighlight(IColor color, int alpha, double v) {
        int b = (int)(v * (double)color.b);
        int g = (int)(v * (double)color.g);
        int r = (int)(v * (double)color.r);
        return alpha << 24 | r << 16 | g << 8 | b;
    }

    AreaResult compAreaAdd(GPolygon gpoly, Polygon poly, double threeDFactor) {
        double xya = 0.0;
        double xza = 0.0;
        double yza = 0.0;
        double avgz = 0.0;
        CartesianPoint op = null;
        for (CartesianPoint ip : gpoly.vector) {
            CartesianPoint p = ip.clone();
            this.graphicTransform.transformPoint(p);
            this.perspective(p, threeDFactor);
            if (op != null) {
                xya += op.x * p.y - op.y * p.x;
                yza += op.y * p.z - op.z * p.y;
                xza += op.x * p.z - op.z * p.x;
            }
            op = p;
            avgz += p.z;
            int ix = this.scalePoint(this.xCenter, this.paintScale, p.x);
            int iy = this.scalePoint(this.yCenter, -this.paintScale, p.y);
            poly.addPoint(ix, iy);
        }
        boolean outside = xya > 0.0;
        double xya2 = xya * xya;
        double area = xya2 / (xya2 + xza * xza + yza * yza);
        return new AreaResult(area, outside, avgz /= (double)gpoly.length());
    }

    private void drawPolygons(ArrayList<PlotElement> list, ImageArray vec, double threeDFactor, boolean anaglyphMode, IColor color) {
        int anaglyphMask = color == Constants.cyanColor ? -16711681 : -65536;
        int highlightValue = 240;
        for (GPolygon[] pa : vec.gpoly) {
            CartesianPoint p = pa[0].vector[0];
            for (GPolygon pb : pa) {
                IColor cc = anaglyphMode || p == null || p.icolor == null ? color : p.icolor;
                Polygon poly = new Polygon();
                AreaResult result = this.compAreaAdd(pb, poly, threeDFactor);
                double alpha = result.outside ? 1.0 - this.polygonTransparency : 1.0;
                int ialpha = (int)(255.0 * alpha);
                int hv = 0;
                hv = anaglyphMode ? this.anaglyphHighlight(cc, ialpha, 1.0 - result.area) & anaglyphMask : this.highlight(cc, ialpha, result.area, highlightValue);
                list.add(new PlotElement(hv, poly, result.avgz));
            }
        }
    }

    private void drawScaledLine(Graphics2D cg, CartesianPoint p, double threeDFactor) {
        if (p.start) {
            this.oldP = p;
            this.graphicTransform.transformPoint(this.oldP);
            this.perspective(this.oldP, threeDFactor);
        } else {
            this.newP = p;
            this.graphicTransform.transformPoint(this.newP);
            this.perspective(this.newP, threeDFactor);
            cg.drawLine(this.scalePoint(this.xCenter, this.paintScale, this.oldP.x), this.scalePoint(this.yCenter, -this.paintScale, this.oldP.y), this.scalePoint(this.xCenter, this.paintScale, this.newP.x), this.scalePoint(this.yCenter, -this.paintScale, this.newP.y));
            this.oldP = this.newP;
        }
    }

    void perspective(CartesianPoint v, double threeDFactor) {
        v.y *= (this.sharedTP.graphicPerspectiveFactor + v.z) / this.sharedTP.graphicPerspectiveFactor;
        if (this.sharedTP.graphicAnaglyphMode) {
            v.x += v.z * threeDFactor;
        }
        v.x *= (this.sharedTP.graphicPerspectiveFactor + v.z) / this.sharedTP.graphicPerspectiveFactor;
    }

    int scalePoint(double center, double scale, double x) {
        return (int)(x * scale + center);
    }

    public void setMode() {
        this.parent.anaglyphicLabel.setEnabled(this.sharedTP.graphicAnaglyphMode);
        this.parent.graphicForegroundColor = this.sharedTP.graphicInverseMode ? Color.white : Color.black;
        this.parent.graphicBackgroundColor = this.sharedTP.graphicInverseMode ? Color.black : Color.white;
        this.parent.graphicCurrentFactor = this.sharedTP.graphicInverseMode ? this.threeDFactor : -this.threeDFactor;
    }

    void setTranslate() {
        this.graphicTransform.setXtranslate(this.sharedTP.modelTranslateX);
        this.graphicTransform.setYtranslate(this.sharedTP.modelTranslateY);
        this.graphicTransform.setZtranslate(this.sharedTP.modelTranslateZ);
    }

    void setRotations() {
        this.graphicTransform.setXAngle(this.sharedTP.modelAngleX);
        this.graphicTransform.setYAngle(this.sharedTP.modelAngleY);
    }

    public void updateSettings(TankProperties sp) {
        this.sharedTP = sp;
        this.setTranslate();
        this.setRotations();
        this.setMode();
        this.repaint();
    }

    public void setDefaults(TankProperties sp) {
        this.sharedTP = sp;
        this.graphicTransform.resetAll();
        this.sharedTP.modelAngleX = -45.0;
        this.sharedTP.modelAngleY = -30.0;
        this.sharedTP.modelTranslateX = 0.0;
        this.sharedTP.modelTranslateY = 0.0;
        this.sharedTP.modelTranslateZ = 0.0;
        this.parent.transparencyComboBox.setSelectedIndex(5);
        this.parent.xLinesComboBox.setSelectedIndex(this.sharedTP.polygonMode ? 16 : 16);
        this.parent.yLinesComboBox.setSelectedIndex(this.sharedTP.polygonMode ? 64 : 16);
        this.parent.lineThicknessComboBox.setSelectedIndex(1);
        this.parent.cylinderCheckBox.setSelected(true);
        this.parent.leftCapCheckBox.setSelected(true);
        this.parent.rightCapCheckBox.setSelected(true);
        this.parent.sensorCheckBox.setSelected(true);
        this.parent.readValues();
        this.sharedTP.modelScaleFactor = 0.0;
        this.createTankImage(this.sharedTP);
    }

    void setLowMode() {
        if (!this.lowResMode) {
            this.lowResMode = true;
            if (this.timer != null) {
                this.timer.stop();
                this.timer = null;
            }
            this.timer = new Timer(this.timeDelay, new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    TankImageView.this.lowResMode = false;
                    TankImageView.this.repaint();
                }
            });
            this.timer.start();
        }
    }

    @Override
    public void mousePressed(MouseEvent evt) {
        this.pressX = evt.getX();
        this.pressY = evt.getY();
        this.setLowMode();
    }

    @Override
    public void mouseDragged(MouseEvent evt) {
        int x = evt.getX();
        int y = evt.getY();
        if (evt.isShiftDown()) {
            double mouseTranslateGainFactor = 2.0 / this.sharedTP.modelScale;
            this.sharedTP.modelTranslateX += (double)(this.pressX - x) * mouseTranslateGainFactor;
            this.sharedTP.modelTranslateY -= (double)(this.pressY - y) * mouseTranslateGainFactor;
        } else {
            this.sharedTP.modelAngleX += (double)(this.pressX - x) * this.mouseScaleGainFactor;
            this.sharedTP.modelAngleY += (double)(this.pressY - y) * this.mouseScaleGainFactor;
        }
        this.pressX = x;
        this.pressY = y;
        this.setRotations();
        this.setTranslate();
        this.repaint();
        this.setLowMode();
    }

    @Override
    public void mouseWheelMoved(MouseWheelEvent evt) {
        double v = (double)evt.getWheelRotation() * 0.1;
        v = evt.isShiftDown() ? v * 0.1 : v;
        v = evt.isAltDown() ? v * 0.01 : v;
        this.sharedTP.modelScale *= 1.0 - v;
        this.repaint();
        this.setLowMode();
    }

    @Override
    public void mouseClicked(MouseEvent evt) {
        this.requestFocus();
        this.setLowMode();
    }

    @Override
    public void mouseEntered(MouseEvent evt) {
    }

    @Override
    public void mouseExited(MouseEvent evt) {
    }

    @Override
    public void mouseReleased(MouseEvent evt) {
    }

    @Override
    public void mouseMoved(MouseEvent evt) {
    }

    public void handleKeyPressed(KeyEvent evt) {
    }

    public void handleKeyReleased(KeyEvent evt) {
        double tstep = 32.0 / this.sharedTP.modelScale;
        int kcode = evt.getKeyCode();
        if (kcode == 40) {
            this.sharedTP.modelTranslateY -= tstep;
        } else if (kcode == 38) {
            this.sharedTP.modelTranslateY += tstep;
        } else if (kcode == 37) {
            this.sharedTP.modelTranslateX -= tstep;
        } else if (kcode == 39) {
            this.sharedTP.modelTranslateX += tstep;
        } else if (kcode == 36) {
            this.sharedTP.modelTranslateZ += tstep;
        } else if (kcode == 35) {
            this.sharedTP.modelTranslateZ -= tstep;
        }
        this.setTranslate();
        this.repaint();
        this.setLowMode();
    }

    void toClipboard() {
        if (this.parent.applet) {
            this.parent.setStatus("Sorry -- can't copy image from applet.", true);
        } else {
            int w = this.sharedTP.clipboardGraphicWidth;
            int h = this.sharedTP.clipboardGraphicHeight;
            BufferedImage im = new BufferedImage(w, h, 1);
            Graphics2D g = (Graphics2D)im.getGraphics();
            this.drawSequence(g, w, h);
            g.dispose();
            ImageTransferable imt = new ImageTransferable(im);
            Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
            clipboard.setContents(imt, null);
        }
    }

    private void initComponents() {
        this.setToolTipText("<html>\nZoom = mouse wheel<br/>\nRotate = drag mouse<br/>\nTranslate = Shift+drag mouse\n</html>");
        this.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                TankImageView.this.formKeyReleased(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 400, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 300, Short.MAX_VALUE));
    }

    private void formKeyReleased(KeyEvent evt) {
        this.handleKeyReleased(evt);
    }

    class PlotComparator
    implements Comparator<PlotElement> {
        PlotComparator() {
        }

        @Override
        public int compare(PlotElement p1, PlotElement p2) {
            return p1.avgz == p2.avgz ? 0 : (p1.avgz > p2.avgz ? 1 : -1);
        }
    }

    class PlotElement {
        int color;
        Polygon poly;
        double avgz;

        public PlotElement(int c, Polygon p, double av) {
            this.color = c;
            this.poly = p;
            this.avgz = av;
        }
    }
}

