/*
 * Decompiled with CFR 0.152.
 */
package tankcalc;

import tankcalc.CartesianPoint;

public final class Transform3D {
    private double axr = 0.0;
    private double ayr = 0.0;
    double sx;
    double sy;
    double cx;
    double cy;
    double tx = 0.0;
    double ty = 0.0;
    double tz = 0.0;

    public Transform3D() {
        this.genValues();
    }

    public void setXtranslate(double v) {
        this.tx = v;
    }

    public void setYtranslate(double v) {
        this.ty = v;
    }

    public void setZtranslate(double v) {
        this.tz = v;
    }

    public void setXAngle(double v) {
        this.axr = v * (Math.PI / 180);
        this.genValues();
    }

    public void setYAngle(double v) {
        this.ayr = v * (Math.PI / 180);
        this.genValues();
    }

    private void genValues() {
        this.sx = Math.sin(this.axr);
        this.cx = Math.cos(this.axr);
        this.sy = Math.sin(this.ayr);
        this.cy = Math.cos(this.ayr);
    }

    public void transformPoint(CartesianPoint v) {
        double x = v.x - this.tx;
        double y = v.y - this.ty;
        double z = v.z - this.tz;
        double hf = x * this.sx - z * this.cx;
        v.y = y * this.cy + this.sy * hf;
        v.x = x * this.cx + z * this.sx;
        v.z = -y * this.sy + this.cy * hf;
    }

    public void resetAll() {
        this.axr = 0.0;
        this.ayr = 0.0;
        this.tx = 0.0;
        this.ty = 0.0;
        this.tz = 0.0;
        this.genValues();
    }
}

