/*
 * This class is identical in TankCalc and TankCalcAndroid
 * Please keep it that way
 */
package tankcalc;

import java.io.Serializable;
import java.awt.*;

/**
 *
 * @author lutusp
 */
final public class TankProperties implements Serializable {

    double g_L = 96;
    double g_R = 36;
    double g_rL = 18;
    double g_rR = 18;
    double scalingFactor = 1.0;
    double sensorPositionX = 0;
    double sensorPositionY = 0;
    double sensorPositionZ = 0;
    double residualVolume = 0;
    double enteredAngleDegrees = 0;
    int tankAngleUnitIndex = 0;
    double angleDegrees = 0;
    double angleRadians = 0;
    double tableHeightStepSize = 1;
    double tableVolumeStepSize = 100;
    String tableTitle = "";
    //int tableType = Constants.TABLEHTML;
    //boolean inverseMode = false;
    boolean tankUpright = false;
    int tankOrientation = 0;
    int sensorOrientation = 0;
    int leftEndCapMode = 0; // elliptical
    int rightEndCapMode = 0;
    int cylinderIntegrationSteps = 200;
    int endCapIntegrationSteps = 400;
    double rootFinderEpsilon = 1e-8;
    int inputUnitIndex = 3; // inches
    int outputUnitIndex = 6; // gallons
    int weightUnitIndex = Constants.WEIGHTPOUNDS;
    String weightUnitName = "";
    String currentInputUnitName = "";
    String currentOutputUnitName = "";
    String emailAddress = "";
    int decimalPlaces = 2;
    int defaultDecimalPlaces = 2;

    boolean graphicDrawLeftCap = true;
    boolean graphicDrawCylinder = true;
    boolean graphicDrawRightCap = true;
    boolean graphicDrawSensor = true;
    boolean graphicAnaglyphMode = false;
    boolean graphicInverseMode = false;
    boolean graphicAntialiasingMode = false;
    boolean polygonMode = true;
    int polygonTransparency = 5;
    boolean graphicTransparent = true;
    int graphicLineThickness = 1;
    boolean graphicHints = true;
    double graphicPerspectiveFactor = 100;
    double modelAngleX = -45;
    double modelAngleY = -30;
    double modelTranslateX = 0;
    double modelTranslateY = 0;
    double modelTranslateZ = 0;
    double modelScale = 240;
    double modelScaleFactor = 0;
    double modelOldScaleFactor = 0;
    int graphicXDrawSteps = 16;
    int graphicYDrawSteps = 64;
    int currentTab = 0;
    int clipboardGraphicWidth = 1280;
    int clipboardGraphicHeight = 1024;

    double wallThickness = .1;
    double wallDensity = 8.03;
    double contentDensity = 0.7;
    double maxVolumeConverted = 0;
    // only used by TankCalc
    Frame programFrame = null;
}
