/*
 * Decompiled with CFR 0.152.
 */
package tankflow;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.image.BufferedImage;
import javax.swing.JPanel;
import tankflow.MatrixFunctions;
import tankflow.Pair;
import tankflow.TankFlow;

public final class GraphicPane
extends JPanel
implements MouseListener,
MouseMotionListener {
    private static final long serialVersionUID = -2734553019461908656L;
    TankFlow parent;
    double width;
    double height;
    double dwidth;
    double dheight;
    int dotsize = 5;
    int sd2 = this.dotsize / 2;
    double margin = 10.0;
    double wmargin;
    double hmargin;
    double xl;
    double xh;
    double yl;
    double yh;
    double xstart;
    double xend;
    double ystart;
    double yend;
    double MARGINDIV = 8.0;
    double gs = 10.0;
    double xm;
    double ym;
    boolean mouseOver = false;
    boolean reverse;

    public GraphicPane(TankFlow p) {
        this.parent = p;
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
    }

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        if (this.parent != null && g != null && this.parent.terms != null && this.parent.terms.size() > 0 && this.parent.results != null && this.parent.results.size() > 0) {
            this.drawChart(g, this.getWidth(), this.getHeight());
        }
    }

    protected void drawChart(Graphics g, int w, int h) {
        this.width = w;
        this.height = h;
        Graphics2D g2 = (Graphics2D)g;
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        this.wmargin = this.width / this.margin;
        this.hmargin = this.height / this.margin;
        this.dwidth = this.width - this.wmargin;
        this.dheight = this.height - this.hmargin;
        g2.setColor(Color.WHITE);
        g2.fillRect(0, 0, (int)this.width, (int)this.height);
        this.size_graphic();
        this.draw_grid(g2);
        this.draw_chart(g2);
        this.draw_text_labels(g2);
    }

    protected BufferedImage grabScreen(int w, int h) {
        BufferedImage bi = new BufferedImage(w, h, 2);
        this.drawChart(bi.getGraphics(), w, h);
        return bi;
    }

    protected void size_graphic() {
        this.xl = 1.0E9;
        this.xh = -1.0E9;
        this.yl = 1.0E9;
        this.yh = -1.0E9;
        for (Pair p : this.parent.arg) {
            this.xl = Math.min(this.xl, p.x);
            this.xh = Math.max(this.xh, p.x);
            this.yl = Math.min(this.yl, p.y);
            this.yh = Math.max(this.yh, p.y);
        }
        this.xm = (this.xh - this.xl) / this.MARGINDIV;
        this.ym = (this.yh - this.yl) / this.MARGINDIV;
        this.xstart = this.xl;
        this.xend = this.xh;
        this.ystart = this.yl;
        this.yend = this.yh;
        this.xl -= this.xm;
        this.xh += this.xm;
        this.yl -= this.ym;
        this.yh += this.ym;
    }

    protected void draw_grid(Graphics2D g2) {
        g2.setColor(Color.GREEN);
        int xi = 0;
        while ((double)xi <= this.gs) {
            int xp = (int)this.ntrp(xi, 0.0, this.gs, this.wmargin, this.dwidth);
            g2.drawLine(xp, (int)(this.height - this.hmargin), xp, (int)(this.height - this.dheight));
            ++xi;
        }
        g2.setColor(Color.GREEN);
        int yi = 0;
        while ((double)yi <= this.gs) {
            int yp = (int)this.ntrp(yi, 0.0, this.gs, (int)(this.height - this.hmargin), (int)(this.height - this.dheight));
            g2.drawLine((int)this.wmargin, yp, (int)this.dwidth, yp);
            ++yi;
        }
    }

    protected void draw_text_labels(Graphics2D g2) {
        String s;
        double y;
        int xp;
        g2.setColor(Color.BLACK);
        int fs = (int)this.width / 75;
        g2.setFont(new Font("Monospace", 0, fs));
        int xi = 0;
        while ((double)xi <= this.gs) {
            xp = (int)this.ntrp(xi, 0.0, this.gs, this.wmargin, this.dwidth);
            y = (int)this.ntrp(xi, 0.0, this.gs, this.xl, this.xh);
            s = String.format("%.4g", y);
            int dx = xp - 4 * s.length();
            g2.drawString(s, dx, (int)(this.height - this.hmargin) + 16);
            ++xi;
        }
        int yi = 0;
        while ((double)yi <= this.gs) {
            int yp = (int)this.ntrp(yi, 0.0, this.gs, (int)(this.height - this.hmargin), (int)(this.height - this.dheight));
            y = (int)this.ntrp(yi, 0.0, this.gs, this.yl, this.yh);
            s = String.format("%.4g", y);
            xp = (int)(this.wmargin - (double)fs * 0.7 * (double)s.length());
            g2.drawString(s, xp, yp);
            ++yi;
        }
    }

    protected void draw_chart(Graphics2D g2) {
        g2.setColor(Color.BLUE);
        int ox = -1;
        int oy = -1;
        boolean starting = true;
        int line_segments = 500;
        int xi = 0;
        while (xi <= line_segments) {
            double x = this.ntrp(xi, 0.0, line_segments, this.xstart, this.xend);
            double y = MatrixFunctions.regress(x, this.parent.terms);
            int xp = (int)this.ntrp(x, this.xl, this.xh, this.wmargin, this.dwidth);
            int yp = (int)this.ntrp(y, this.yl, this.yh, this.hmargin, this.dheight);
            yp = (int)(this.height - (double)yp);
            if (!starting) {
                g2.drawLine(ox, oy, xp, yp);
            }
            starting = false;
            ox = xp;
            oy = yp;
            ++xi;
        }
        g2.setColor(Color.RED);
        for (Pair p : this.parent.arg) {
            int xp = (int)this.ntrp(p.x, this.xl, this.xh, this.wmargin, this.dwidth) - this.sd2;
            int yp = (int)this.ntrp(p.y, this.yl, this.yh, this.hmargin, this.dheight) + this.sd2;
            g2.fillOval(xp, (int)(this.height - (double)yp), this.dotsize, this.dotsize);
        }
    }

    protected double ntrp(double x, double xl, double xh, double yl, double yh) {
        return (x - xl) * (yh - yl) / (xh - xl) + yl;
    }

    protected void manageMouse(MouseEvent e) {
        if (this.mouseOver) {
            int px = e.getX();
            int py = e.getY();
            double x = this.ntrp(px, this.wmargin, this.dwidth, this.xl, this.xh);
            double y = this.ntrp(py, this.hmargin, this.dheight, this.yh, this.yl);
            String s = String.format("x=" + this.parent.format_number(x) + ",y=" + this.parent.format_number(y), new Object[0]);
            this.setToolTipText(s);
        }
    }

    @Override
    public void mouseDragged(MouseEvent e) {
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        this.manageMouse(e);
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
        this.mouseOver = true;
    }

    @Override
    public void mouseExited(MouseEvent e) {
        this.mouseOver = false;
    }
}

