/*
 * Decompiled with CFR 0.152.
 */
package tankflow;

import java.awt.Frame;
import java.awt.Rectangle;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JRadioButton;
import javax.swing.JScrollBar;
import javax.swing.JSpinner;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import tankflow.MutableDouble;
import tankflow.StateProperties;
import tankflow.StringComparatorNoCase;
import tankflow.TankFlow;

public final class InitManager {
    TankFlow parent;
    StateProperties source;
    String fileSep;
    String lineSep;
    String appName;
    String userDir;
    String userPath;
    String initPath;
    String defaultValues = "";

    public InitManager(TankFlow p) {
        this.parent = p;
        this.setSource();
        this.getDefaultValues();
        this.lineSep = System.getProperty("line.separator");
        this.fileSep = System.getProperty("file.separator");
        this.appName = this.parent.getClass().getSimpleName();
        this.userDir = System.getProperty("user.home");
        this.userPath = String.valueOf(this.userDir) + this.fileSep + "." + this.appName;
        this.initPath = String.valueOf(this.userPath) + this.fileSep + this.appName + ".ini";
        this.testMakeDirs(this.userPath);
    }

    void setSource() {
        this.source = this.parent.sharedSP;
    }

    private String[] parsePair(String val) {
        String[] pair = null;
        int p = val.indexOf("=");
        if (p > 0) {
            pair = new String[]{val.substring(0, p), val.substring(p + 1, val.length())};
            int i = 0;
            while (i < 2 && i < pair.length) {
                pair[i] = pair[i].replaceFirst("^\\s*(.*?)\\s*$", "$1");
                ++i;
            }
        }
        return pair;
    }

    protected void setConfig(String data) {
        if (data != null) {
            this.setSource();
            String[] values = data.split(this.lineSep);
            int i = 0;
            while (i < values.length) {
                String item = this.strip(values[i]);
                String[] pair = this.parsePair(item);
                if (pair != null && pair.length >= 2) {
                    String value = this.unescapeLF(pair[1]);
                    this.readWriteField(pair[0], value);
                }
                ++i;
            }
        }
    }

    protected String escapeLF(String s) {
        return s.replaceAll("\n", "\\\\n");
    }

    protected String unescapeLF(String s) {
        return s.replaceAll("\\\\n", "\n");
    }

    protected String getConfig() {
        this.setSource();
        ArrayList<String> data = new ArrayList<String>();
        HashMap<String, Field> fnht = this.getFieldNames();
        Iterator<String> en = fnht.keySet().iterator();
        while (en.hasNext()) {
            Field field = fnht.get(en.next());
            String name = field.getName();
            String value = this.readWriteField(name, null);
            if (value == null) continue;
            value = this.escapeLF(value);
            data.add(String.valueOf(name) + " = " + value);
        }
        Collections.sort(data, new StringComparatorNoCase());
        String[] array = data.toArray(new String[0]);
        return String.valueOf(this.join(array, this.lineSep)) + this.lineSep;
    }

    protected void readConfig() {
        String data = this.readTextFile(this.initPath, this.lineSep);
        this.setConfig(data);
    }

    protected void getDefaultValues() {
        this.defaultValues = this.getConfig();
    }

    protected void setDefaultValues() {
        this.setConfig(this.defaultValues);
    }

    private Rectangle parseRectangle(String value) {
        ArrayList<Integer> vi = new ArrayList<Integer>();
        Rectangle rect = new Rectangle();
        try {
            Matcher m = Pattern.compile("(-|\\d)+").matcher(value);
            while (m.find()) {
                vi.add(Integer.parseInt(m.group()));
            }
            if (vi.size() == 4) {
                Iterator it = vi.iterator();
                rect = new Rectangle((Integer)it.next(), (Integer)it.next(), (Integer)it.next(), (Integer)it.next());
            }
        }
        catch (Exception e) {
            System.out.println(String.valueOf(this.getClass().getName()) + ": error: " + e);
        }
        return rect;
    }

    private double getDouble(String s) {
        return Double.parseDouble(s);
    }

    private String formatNum(double v) {
        return String.format("" + v, new Object[0]);
    }

    private String formatNum(int v) {
        return String.format("" + v, new Object[0]);
    }

    private String readWriteField(String name, String value) {
        try {
            Class<?> pc = this.source.getClass();
            Field f = pc.getDeclaredField(name);
            Object obj = null;
            try {
                obj = f.get(this.source);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (obj != null) {
                boolean write;
                String classType = f.getType().toString();
                classType = classType.replaceFirst(".*\\.(.*)", "$1");
                boolean bl = write = value != null;
                if (write) {
                    value = this.strip(value);
                }
                if (classType.equals("int")) {
                    if (write) {
                        f.setInt(this.source, Integer.parseInt(value));
                    } else {
                        value = this.formatNum(f.getInt(this.source));
                    }
                } else if (classType.equals("double")) {
                    if (write) {
                        f.setDouble(this.source, this.getDouble(value));
                    } else {
                        value = this.formatNum(f.getDouble(this.source));
                    }
                } else if (classType.equals("MutableDouble")) {
                    if (write) {
                        ((MutableDouble)obj).v = this.getDouble(value);
                    } else {
                        value = this.formatNum(((MutableDouble)obj).v);
                    }
                } else if (classType.equals("boolean")) {
                    if (write) {
                        f.setBoolean(this.source, value.equals("true"));
                    } else {
                        value = "" + f.getBoolean(this.source);
                    }
                } else if (classType.equals("String")) {
                    if (write) {
                        f.set(this.source, value);
                    } else {
                        value = (String)f.get(this.source);
                    }
                } else if (classType.equals("Rectangle")) {
                    if (write) {
                        Rectangle r = this.parseRectangle(value);
                        if (r != null) {
                            f.set(this.source, r);
                        }
                    } else {
                        value = f.get(this.source).toString();
                    }
                } else if (classType.equals("JRadioButton")) {
                    JRadioButton button = (JRadioButton)obj;
                    if (write) {
                        button.setSelected(value.equals("true"));
                    } else {
                        value = "" + button.isSelected();
                    }
                } else if (classType.equals("JCheckBox")) {
                    JCheckBox cb = (JCheckBox)obj;
                    if (write) {
                        cb.setSelected(value.equals("true"));
                    } else {
                        value = "" + cb.isSelected();
                    }
                } else if (classType.equals("JTextField")) {
                    JTextField tf = (JTextField)obj;
                    if (write) {
                        tf.setText(value);
                    } else {
                        value = tf.getText();
                    }
                } else if (classType.equals("JComboBox")) {
                    JComboBox box = (JComboBox)obj;
                    if (write) {
                        box.setSelectedIndex(Integer.parseInt(value));
                    } else {
                        value = "" + box.getSelectedIndex();
                    }
                } else if (classType.equals("JSpinner")) {
                    JSpinner box = (JSpinner)obj;
                    if (write) {
                        box.setValue(Integer.parseInt(value));
                    } else {
                        value = "" + box.getValue();
                    }
                } else if (classType.equals("JScrollBar")) {
                    JScrollBar box = (JScrollBar)obj;
                    if (write) {
                        int v = Integer.parseInt(value);
                        box.setValue(v);
                    } else {
                        value = "" + box.getValue();
                    }
                } else if (classType.equals("Frame")) {
                    Frame tp = (Frame)obj;
                    if (write) {
                        Rectangle r = this.parseRectangle(value);
                        if (r != null) {
                            tp.setBounds(r);
                        }
                    } else {
                        value = "" + tp.getBounds();
                    }
                } else if (classType.equals("JTabbedPane")) {
                    JTabbedPane tp = (JTabbedPane)obj;
                    if (write) {
                        tp.setSelectedIndex(Integer.parseInt(value));
                    } else {
                        value = "" + tp.getSelectedIndex();
                    }
                } else {
                    System.out.println(String.valueOf(this.getClass().getName()) + ": cannot decode value for " + classType + " (" + name + ")");
                }
            }
        }
        catch (Exception e) {
            System.out.println(String.valueOf(this.getClass().getName()) + ":readWriteField: \"" + name + "\": " + e);
        }
        return value;
    }

    protected void writeConfig() {
        String output = this.getConfig();
        try {
            BufferedWriter bw = new BufferedWriter(new FileWriter(this.initPath));
            bw.write(output);
            bw.close();
        }
        catch (IOException e) {
            System.out.println(e);
        }
    }

    private HashMap<String, Field> getFieldNames() {
        Field[] fields;
        HashMap<String, Field> hash = new HashMap<String, Field>();
        Field[] fieldArray = fields = this.source.getClass().getDeclaredFields();
        int n = fields.length;
        int n2 = 0;
        while (n2 < n) {
            Field field = fieldArray[n2];
            String name = field.getName();
            hash.put(name, field);
            ++n2;
        }
        return hash;
    }

    private String readTextFile(String path, String lineSep) {
        String s = null;
        File f = new File(path);
        if (f.exists()) {
            StringBuilder sb = new StringBuilder();
            try {
                String line;
                BufferedReader br = new BufferedReader(new FileReader(f));
                while ((line = br.readLine()) != null) {
                    sb.append(line).append(lineSep);
                }
                br.close();
                s = sb.toString();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return s;
    }

    private boolean testMakeDirs(String path) {
        File fpath = new File(path);
        if (fpath.exists()) {
            return false;
        }
        fpath.mkdirs();
        return true;
    }

    private String join(String[] array, String delim) {
        StringBuilder sb = new StringBuilder();
        int i = 0;
        while (i < array.length) {
            if (i > 0) {
                sb.append(delim);
            }
            sb.append(array[i]);
            ++i;
        }
        return sb.toString();
    }

    private String strip(String s) {
        return s.replaceFirst("^\\s*(.*)\\s*$", "$1");
    }
}

