/*
 * Decompiled with CFR 0.152.
 */
package tankflow;

import java.util.ArrayList;
import tankflow.Pair;

public final class MatrixFunctions {
    private MatrixFunctions() {
    }

    private static void divide(double[][] A, int i, int j, int m) {
        int q = j + 1;
        while (q < m) {
            double[] dArray = A[i];
            int n = q++;
            dArray[n] = dArray[n] / A[i][j];
        }
        A[i][j] = 1.0;
    }

    private static void eliminate(double[][] A, int i, int j, int n, int m) {
        int k = 0;
        while (k < n) {
            if (k != i && A[k][j] != 0.0) {
                int q = j + 1;
                while (q < m) {
                    double[] dArray = A[k];
                    int n2 = q;
                    dArray[n2] = dArray[n2] - A[k][j] * A[i][q];
                    ++q;
                }
                A[k][j] = 0.0;
            }
            ++k;
        }
    }

    private static ArrayList<Double> echelonize(double[][] mat) {
        int n = mat.length;
        int m = mat[0].length;
        int i = 0;
        int j = 0;
        while (i < n && j < m) {
            int k = i;
            while (k < n && mat[k][j] == 0.0) {
                ++k;
            }
            if (k < n) {
                if (k != i) {
                    double[] swap = mat[i];
                    mat[i] = mat[k];
                    mat[k] = swap;
                }
                if (mat[i][j] != 1.0) {
                    MatrixFunctions.divide(mat, i, j, m);
                }
                MatrixFunctions.eliminate(mat, i, j, n, m);
                ++i;
            }
            ++j;
        }
        ArrayList<Double> terms = new ArrayList<Double>();
        double[][] dArray = mat;
        int n2 = mat.length;
        int n3 = 0;
        while (n3 < n2) {
            double[] mc = dArray[n3];
            terms.add(mc[n]);
            ++n3;
        }
        return terms;
    }

    static ArrayList<Double> compute_coefficients(ArrayList<Pair> data, int p) {
        int r;
        int n = data.size();
        int rs = 2 * ++p - 1;
        double[][] m = new double[p][p + 1];
        double[] mpc = new double[rs];
        mpc[0] = n;
        for (Pair pr : data) {
            double x = pr.x;
            r = 1;
            while (r < rs) {
                int n2 = r++;
                mpc[n2] = mpc[n2] + x;
                x *= pr.x;
            }
            double[] dArray = m[0];
            int n3 = p;
            dArray[n3] = dArray[n3] + pr.y;
            x = pr.x;
            r = 1;
            while (r < p) {
                double[] dArray2 = m[r];
                int n4 = p;
                dArray2[n4] = dArray2[n4] + x * pr.y;
                x *= pr.x;
                ++r;
            }
        }
        r = 0;
        while (r < p) {
            int c = 0;
            while (c < p) {
                m[r][c] = mpc[r + c];
                ++c;
            }
            ++r;
        }
        return MatrixFunctions.echelonize(m);
    }

    static double corr_coeff(ArrayList<Pair> data, ArrayList<Double> terms) {
        int n = data.size();
        double sx = 0.0;
        double sx2 = 0.0;
        double sy = 0.0;
        double sy2 = 0.0;
        double sxy = 0.0;
        for (Pair pr : data) {
            double x = MatrixFunctions.regress(pr.x, terms);
            double y = pr.y;
            sx += x;
            sy += y;
            sxy += x * y;
            sx2 += x * x;
            sy2 += y * y;
        }
        double div = Math.sqrt((sx2 - sx * sx / (double)n) * (sy2 - sy * sy / (double)n));
        if (div == 0.0) {
            return 0.0;
        }
        double q = (sxy - sx * sy / (double)n) / div;
        return q * q;
    }

    static double std_error(ArrayList<Pair> data, ArrayList<Double> terms) {
        int n = data.size();
        if (n > 2) {
            double a = 0.0;
            for (Pair pr : data) {
                double q = MatrixFunctions.regress(pr.x, terms) - pr.y;
                a += q * q;
            }
            return Math.sqrt(a / (double)(n - 2));
        }
        return 0.0;
    }

    static double regress(double x, ArrayList<Double> terms) {
        double a = 0.0;
        double t = 1.0;
        for (double term : terms) {
            a += term * t;
            t *= x;
        }
        return a;
    }
}

