/***************************************************************************
 *   Copyright (C) 2012 by Paul Lutus                                      *
 *   lutusp@arachnoid.com                                                  *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
package com.arachnoid.anchorsentinel;

import java.io.Serializable;

import android.media.RingtoneManager;

final public class SerializedData implements Serializable {

	private static final long serialVersionUID = -2226552893122468281L;
	// preset default values
	int activeTab = 0;
	int unitIndex = 0; // feet
	double guardRadius = 300.0;
	int intervalIndex = 5; // 2^n velocity integration interval
	int gpsFailLimit = 3; // 2^n seconds of no fixes before alarm
	String anchorAlarmMessage = "Warning: Anchor is dragging.";
	String gpsAlarmMessage = "Warning: No GPS position.";
	boolean toneAlarm = true;
	boolean voiceAlarm = true;
	boolean showArrival = false;
	boolean guarding = false;
}
