/***************************************************************************
 *   Copyright (C) 2013 by Paul Lutus                                      *
 *   http://arachnoid.com/administration                                   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

package com.arachnoid.anchorsentinel;

import android.content.Context;
import android.os.PowerManager;

class WakeLockFunctions {
	
	private static PowerManager.WakeLock alarmWakeLock = null;
	
	static void acquireWakeLock(Context context) {
		if (alarmWakeLock != null) {
			return;
		}

		PowerManager pm =(PowerManager) context.getSystemService(Context.POWER_SERVICE);
		alarmWakeLock = pm.newWakeLock(
				PowerManager.PARTIAL_WAKE_LOCK |
				PowerManager.ACQUIRE_CAUSES_WAKEUP |
				PowerManager.ON_AFTER_RELEASE, "AnchorSentinelActivity");
		alarmWakeLock.acquire();
	}

	static void releaseWakeLock() {
		if (alarmWakeLock != null) {
			alarmWakeLock.release();
			alarmWakeLock = null;
		}
	}

}
