/***************************************************************************
 *   Copyright (C) 2011 by Paul Lutus                                      *
 *   http://arachnoid.com/administration                                   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

package com.arachnoid.carpetempus;

import java.util.HashMap;
import android.app.Activity;
import android.content.Intent;
import android.media.AudioManager;
import android.os.Bundle;
import android.speech.tts.TextToSpeech;
import android.speech.tts.TextToSpeech.OnInitListener;
import android.view.View;
import android.view.Window;
import android.view.WindowManager;
import android.widget.Button;
import android.widget.TextView;
import android.util.Log;

final public class AlarmAlertDialogActivity extends Activity implements
		OnInitListener {
	CarpeTempusApplication app;
	GenericEvent ae = null;
	private TextToSpeech mTts = null;
	int SPEECH_DATA_CHECK = 333;
	// MySpeechPrompt speechPrompt = null;
	int pauseBetweenPromptsMSec = 5000;
	HashMap<String, String> extraHash;
	Thread speakThread = null;
	boolean speechReady = false;
	boolean speaking = false;

	@Override
	public void onCreate(Bundle savedInstanceState) {
		super.onCreate(savedInstanceState);
		setWakeLock(true);
		app = (CarpeTempusApplication) getApplication();
		requestWindowFeature(Window.FEATURE_LEFT_ICON);
		if (app.serialData.digitalAlertDialog) {
			setContentView(R.layout.alarmdialogdigital);
		} else {
			setContentView(R.layout.alarmdialoganalog);
		}
		setFeatureDrawableResource(Window.FEATURE_LEFT_ICON,
				R.drawable.app_icon);

		try {

			int index = getIntent().getIntExtra("AlarmEventIndex", -1);
			ae = app.getEventForIndex(index);
			//Log.e("ZZZ: next null test","" + index + "," + ae);
			if (ae != null) {
				Button b = (Button) findViewById(R.id.snooze_button);
				if (b != null) {
					if (ae instanceof TimerEvent) {
						b.setVisibility(View.GONE);
					} else {
						b.setEnabled(!ae.getSnooze());
					}
				}
				setTitle(app.programTitle + ": " + ae.getNameTag() + " Alert");
				TextView msg = (TextView) findViewById(R.id.dialog_message);
				msg.setText(ae.getMessage());
			} else {
				app.showMessage(this, "onCreate: Event Not Found",
						"AlarmAlertDialog");
			}
		} catch (Exception e) {
			e.printStackTrace();
		}
		if (ae.getVoice()) {
			Intent checkIntent = new Intent();
			checkIntent.setAction(TextToSpeech.Engine.ACTION_CHECK_TTS_DATA);
			startActivityForResult(checkIntent, SPEECH_DATA_CHECK);

		}
		if (ae.getTone() && app.ringtone != null) {
			app.ringtone.start();
		}
	}

	private void setWakeLock(boolean hold) {
		// if (DEBUG) Log.d(LOG_TAG, (hold ? "hold" : " releasing wake lock");
		Window win = getWindow();
		WindowManager.LayoutParams winParams = win.getAttributes();
		winParams.flags |= (WindowManager.LayoutParams.FLAG_DISMISS_KEYGUARD
				| WindowManager.LayoutParams.FLAG_SHOW_WHEN_LOCKED | WindowManager.LayoutParams.FLAG_ALLOW_LOCK_WHILE_SCREEN_ON);
		if (hold)
			winParams.flags |= WindowManager.LayoutParams.FLAG_TURN_SCREEN_ON;
		else
			winParams.flags &= (~WindowManager.LayoutParams.FLAG_TURN_SCREEN_ON);
		win.setAttributes(winParams);
	}

	@Override
	protected void onActivityResult(int requestCode, int resultCode, Intent data) {
		super.onActivityResult(requestCode, resultCode, data);
		if (requestCode == SPEECH_DATA_CHECK) {
			if (resultCode == TextToSpeech.Engine.CHECK_VOICE_DATA_PASS) {
				// success, create the TTS instance
				waitForSpeechReady();
				closeSpeechProcess();
				mTts = new TextToSpeech(this, this);
			} else {
				app.beep();
				app.makeToast("Cannot synthesize voice");
				// missing data, install it
				Intent installIntent = new Intent();
				installIntent
						.setAction(TextToSpeech.Engine.ACTION_INSTALL_TTS_DATA);
				startActivity(installIntent);
			}
		}
	}
	
	public void onInit(int status) {
		speechReady = true;
		speak();
	}

	protected void speak() {
		if (mTts != null) {
			extraHash = new HashMap<String, String>();
			extraHash.put(TextToSpeech.Engine.KEY_PARAM_STREAM,
					String.valueOf(AudioManager.STREAM_ALARM));
			final String msg = ae.getMessage();
			speakThread = new Thread() {
				public void run() {
					try {
						int repetitions = ae.getRepetitions();
						boolean infinite = (repetitions == 0);
						speaking = true;
						while (speaking && mTts != null
								&& (infinite || repetitions > 0)) {
							waitForSpeechReady();
							mTts.speak(msg, TextToSpeech.QUEUE_FLUSH, extraHash);
							if (speaking) {
								Thread.sleep(pauseBetweenPromptsMSec);
							}
							if (!infinite) {
								repetitions--;
							}
						}
						waitForSpeechReady();
						closeSpeechProcess();
						// should we cancel the dialog because
						// we used up the repetitions?
						if (speaking && !infinite) {
							finish();
						}
					} catch (Exception e) {
						e.printStackTrace();
					}
				}
			};
			speakThread.start();
		}
	}

	protected void waitForSpeechReady() {
		try {
			while (mTts != null && mTts.isSpeaking()) {
				Thread.sleep(100);
			}
		} catch (InterruptedException e) {
			e.printStackTrace();
		}
	}

	private void stopPrompt() {
		if (speaking && speakThread != null) {
			speaking = false;
			speakThread.interrupt();
		}
		if (ae.getTone() && app.ringtone != null) {
			app.ringtone.stop();
		}
		closeSpeechProcess();
	}

	private void closeSpeechProcess() {
		if (mTts != null) {
			mTts.stop();
			mTts.shutdown();
			mTts = null;
		}
	}

	public void dismissButton(View v) {
		stopPrompt();
		ae.setSnooze(false);
		finish();
	}

	public void snoozeButton(View v) {
		stopPrompt();
		ae.setSnooze(true);
		finish();
	}

	public void onRestart() {
		super.onRestart();
	}

	public void onStart() {
		super.onStart();

	}

	public void onResume() {
		super.onResume();
	}

	public void onPause() {
		super.onPause();
	}

	public void onDestroy() {
		super.onDestroy();
		setWakeLock(false);
		stopPrompt();
		finish();
	}

	
}
