/***************************************************************************
 *   Copyright (C) 2011 by Paul Lutus                                      *
 *   http://arachnoid.com/administration                                   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

package com.arachnoid.carpetempus;

import java.util.Date;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.os.PowerManager;
import android.util.Log;

// this class is no longer used

final public class AlarmHandler extends BroadcastReceiver {

    Intent dialogIntent = null, activityIntent = null;

    private void processEvents(CarpeTempusApplication app, int index) {
        if (index != -1) {
            GenericEvent event = app.alarms.get(index);
            app.logToFile("*** entering process events", false);
            //Log.e("ZZZ: processEvents", "" + app.alarms.get(index).getMessage());

            app.logToFile(
                    "processEvents alarm candidate: "
                            + app.dateTag(new Date(event
                            .getEventTimeUTCSec())), false);
            if (event.alarmTime()) {
                app.logToFile(
                        "*** processEvents alarm user dialog launched for: "
                                + event.getMessage() + " ***",
                        false);
                alertUser(app, index, true);
            }
        } else {
            app.logToFile("failed: index == -1.", false);
        }
    }

    private void alertUser(CarpeTempusApplication app, int index,
                           boolean dialog) {
        //Log.e("ZZZ: alerting", "with " + app.alarms.get(index).getMessage());
        dialogIntent = new Intent(app, AlarmAlertDialogActivity.class);
        dialogIntent.addFlags(Intent.FLAG_ACTIVITY_NEW_TASK);
        dialogIntent.putExtra("AlarmEventIndex", index);
        app.context.startActivity(dialogIntent);
    }

    @Override
    public void onReceive(Context context, Intent intent) {


        // use WakeLock to prevent premature OS shutdown

        PowerManager pm = (PowerManager) context.getSystemService(Context.POWER_SERVICE);
        PowerManager.WakeLock wl = pm.newWakeLock(PowerManager.PARTIAL_WAKE_LOCK, "CarpeTempus:");

        // acquire the lock
        wl.acquire();

        int index = intent.getIntExtra("eventIndex", -1);
        //Log.e("ZZZ: get intent extra", "intent extra data index: " + index);
        CarpeTempusApplication app = (CarpeTempusApplication) context
                .getApplicationContext();

        app.logToFile("AlarmHandler: onReceive: to processEvents.", false);
        app.updateDisplay();
        processEvents(app, index);
        // must reestablish real-time event monitor
        app.setAlarmTimeout();

        // release the lock
        wl.release();
    }
}
