/***************************************************************************
 *   Copyright (C) 2011 by Paul Lutus                                      *
 *   http://arachnoid.com/administration                                   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

package com.arachnoid.carpetempus;

import android.content.Context;
import android.util.AttributeSet;
import android.widget.CheckBox;
import android.widget.LinearLayout;
import android.widget.TextView;

final public class GenericRowLayout extends LinearLayout {
	TextView tv;
	CheckBox cb;
	String label;

	public GenericRowLayout(Context context) {
		super(context);
	}

	public GenericRowLayout(Context context,AttributeSet as) {
		super(context,as);
	}

	public GenericRowLayout(Context context,AttributeSet as,int defStyle) {
		super(context,as,defStyle);
	}

	public void setup(String label) {
		this.label = label;
		tv = (TextView) findViewById(R.id.list_item_textview);
		cb = (CheckBox) findViewById(R.id.list_item_checkbox);
		tv.setText(label);
	}

	public String toString() {
		return "" + tv + "," + cb;
	}

}
