/***************************************************************************
 *   Copyright (C) 2011 by Paul Lutus                                      *
 *   http://arachnoid.com/administration                                   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

package com.arachnoid.carpetempus;

import android.app.Dialog;
import android.content.Context;
import android.os.Bundle;
import android.view.View;
import android.view.Window;

final public class MyTimeSetDialog extends Dialog {
	Context context;
	MyTimeSetEntryField tsHours, tsMinutes,tsSeconds,tsAmpm;
	int hour,minute,second,ampm;
	GenericEvent ae;
	boolean is24Hour;
	int[] elements;
	OnTimeSetListener listener = null;

	public interface OnTimeSetListener {

		void onTimeSet(MyTimeSetDialog view, int hour, int minute, int second);
	}

	protected MyTimeSetDialog(Context context, OnTimeSetListener tl,GenericEvent ae,boolean is24Hour) {
		super(context);
		this.ae = ae;
		listener = tl;
		this.context = context;
		this.hour = ae.getHour();
		this.minute = ae.getMinute();
		this.second = ae.getSecond();
		this.is24Hour = is24Hour;
	}

	/** Called when the activity is first created. */
	@Override
	protected void onCreate(Bundle savedInstanceState) {
		super.onCreate(savedInstanceState);
		requestWindowFeature(Window.FEATURE_LEFT_ICON);
		if(is24Hour) {
			setContentView(R.layout.mytimeset24hourdialoglayout);
		}
		else {
			setContentView(R.layout.mytimesetampmdialoglayout);
		}
		setFeatureDrawableResource(Window.FEATURE_LEFT_ICON, R.drawable.app_icon);
		
		int[] values;
		if(is24Hour || (ae instanceof TimerEvent)) {
			elements = new int[] {R.id.hour_picker,R.id.minute_picker,R.id.second_picker};
			values = new int[] {hour,minute,second};
		}
		else {
			int ampmHour = hour % 12;
			int ampm = (hour >= 12)?1:0;
			elements = new int[] {R.id.ampm_picker,R.id.hour_picker,R.id.minute_picker,R.id.second_picker};
			values = new int[] {ampm,ampmHour,minute,second};
		}
		// initial carryfield (for highest digit) is null
		MyTimeSetEntryField carryField = null;

		for(int i = 0; i < elements.length;i++) {
			MyTimeSetEntryField field = (MyTimeSetEntryField) findViewById(elements[i]);
			field.setValue(values[i]);
			if(i == 0 && (ae instanceof TimerEvent)) {
				// for a timer, there's no need to
				// limit ourselves to 24 hours
				field.setMaxValue(99);
			}
			// set carryfield to next higher digit's field
			field.setCarryField(carryField);
			carryField = field;
		}
		int[] buttons = new int[] {R.id.cancel_button,R.id.set_button};
		for (int btn : buttons) {
			findViewById(btn).setOnClickListener(
					new View.OnClickListener() {
						public void onClick(View v) {
							pressedButton(v);
						}});
		}
	}

	private void pressedButton(View v) {
		int bid = v.getId();
		switch(bid) {
		case R.id.set_button:
			if (ae instanceof TimerEvent) {
				ae.setActive(false);
			}
			setTime();
			dismiss();
			break;
		case R.id.cancel_button:
			dismiss();
			break;
		}
	}

	public void setTime() {
		int[] values = new int[elements.length];
		for(int i = 0; i < elements.length;i++) {
			MyTimeSetEntryField field = (MyTimeSetEntryField) findViewById(elements[i]);
			values[i] = field.getValue();
		}

		if(is24Hour || (ae instanceof TimerEvent)) {
			hour = values[0];
			minute = values[1];
			second = values[2];	
		}
		else {
			ampm = values[0];
			hour = values[1];
			hour += (ampm > 0)?12:0;
			minute = values[2];
			second = values[3];
		}
		listener.onTimeSet(this, hour, minute,second);
		dismiss();
	}
}