/***************************************************************************
 *   Copyright (C) 2011 by Paul Lutus                                      *
 *   http://arachnoid.com/administration                                   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

package com.arachnoid.carpetempus;

final public class TimerEvent extends GenericEvent {
	private static final long serialVersionUID = -7267985452619204695L;
	protected boolean alarmTripped = false;

	public TimerEvent(GenericEvent te) {
		super(te);
	}

	public TimerEvent(long wSec, String m) {
		super(wSec, m);
	}

	public TimerEvent copy() {
		return new TimerEvent(this);
	}

	public String getNameTag() {
		return "Timer";
	}

	public boolean alarmTime() {
		long now = currentTimeUTCSec();
		// prevent multiple dialogs
		if (now > lastAlarmTime) {
			// add four seconds to prevent reactivation
			lastAlarmTime = now + 4;
			setActive(getRecurring() && canRecur());
			return true;
		}
		return false;
	}

	public boolean getActive() {
		return active;
	}
	
	// avoid timers that cannot be cancelled
	public boolean canRecur() {
		return eventTimeUTCSec >= 8;
	}

	public void setActive(boolean state) {
		if (state) {
			//setEventTimeUTCSec(eventTimeUTCSec);
			timeToGo = eventTimeUTCSec + currentTimeUTCSec();
		} else {
			timeToGo = 0;
		}
		active = state;
		if (!active) {
			alarmTripped = false;
		}
		lastAlarmTime = -1;
	}

	protected void makeLocalDateTimeFieldsfromEventTime() {
		long q = getEventTimeUTCSec();
		alarmTS = (int) (q % 60);
		q /= 60;
		alarmTM = (int) (q % 60);
		alarmTH = (int) ((q / 60) % 100);
	}

	public void readEventDateTime() {
		setEventTimeUTCSec(alarmTH * 3600 + alarmTM * 60 + alarmTS);
	}

	public void toggleActive() {
		setActive(!active);
	}

	public long getTimeToGo() {
		// display either current time-to-go if active
		// or timer value if inactive
		long r = (timeToGo != 0) ? timeToGo - currentTimeUTCSec() : eventTimeUTCSec;
		// 100 hours of seconds
		return r % 360000;
	}

	public long getNextEventTimeUTCSec() {
		return timeToGo;
	}

	protected String secToTimeString(CarpeTempusApplication app) {
		makeLocalDateTimeFieldsfromEventTime();
		long t = getTimeToGo();
		long sec = t % 60;
		t /= 60;
		long min = t % 60;
		t /= 60;
		long hr = t % 100;
		return String.format("%02d:%02d:%02d", hr, min, sec);
	}
	
	public String toString() {
		return "TimerEvent: \"" + getMessage() + "\" , " + dtStringFromTimeMS(getEventTimeUTCSec() * 1000);
	}
}
