package com.arachnoid.satfinderandroid;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Paint;
import android.graphics.Rect;
import android.util.AttributeSet;
import android.util.Log;
import android.view.Surface;

final public class SatImageOverlay extends android.support.v7.widget.AppCompatImageView {
    float rToD = (float) (180 / Math.PI);
    float dToR = (float) (Math.PI / 180);
    float textSize;
    float xDim, yDim;
    //float xGain, yGain;
    float xAngle, yAngle;
    float scalingFactor;
    //float vcf;
    int[] satColors = {Color.rgb(0, 64, 0), Color.rgb(64, 0, 0), Color.rgb(0, 0, 64),
            Color.rgb(64, 64, 0), Color.rgb(64, 0, 64)};
    int[] lightSatColors = {Color.rgb(128, 255, 128), Color.rgb(255, 128, 128), Color.rgb(128, 128, 255),
            Color.rgb(255, 255, 128), Color.rgb(255, 128, 255)};

    SatFinderAndroidActivity activity = null;
    SatFinderAndroidApplication app;
    //double cameraVAngle, cameraHAngle;

    public SatImageOverlay(Context context) {
        super(context);
        setup(context);
    }

    public SatImageOverlay(Context context, AttributeSet attrs) {
        super(context, attrs);
        setup(context);
    }

    public SatImageOverlay(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        setup(context);
    }

    private void setup(Context context) {
        activity = (SatFinderAndroidActivity) context;
        app = activity.app;
    }

    public void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        drawOverlay(canvas);
    }

    protected void drawOverlay(Canvas canvas) {

        textSize = activity.metrics.density * 22;
        canvas.save();

        //cameraAngle = (activity.cameraHorizAngle > activity.cameraVertAngle) ? activity.cameraHorizAngle : activity.cameraVertAngle;
        Rect rect = canvas.getClipBounds();
        //Log.e("onDraw2", "" + canvas + "," + rect);
        xDim = rect.right;
        yDim = rect.bottom;
        if (xDim == 0 || yDim == 0) {
            return;
        }
        switch (activity.cameraOrientation) {
            case Surface.ROTATION_0:
            case Surface.ROTATION_180:
                xAngle = activity.cameraYAngle;
                yAngle = activity.cameraXAngle;
                break;
            case Surface.ROTATION_90:
            case Surface.ROTATION_270:
                xAngle = activity.cameraXAngle;
                yAngle = activity.cameraYAngle;
                break;
            default:
                Log.e("Error", "No orientation!");
                break;
        }
        scalingFactor = .9f;
        //debugCounter += 1;
        //if (debugCounter % 10 == 0) {
        //activity.getCameraAngles();

        //    String debug = String.format("V:%.1f, H:%.1f, X:%.1f, Y:%.1f", activity.cameraXAngle, activity.cameraYAngle, xDim, yDim);
        //    Log.e("Monitor", debug);
        //}
        Paint paint = new Paint();
        paint.setStyle(Paint.Style.STROKE);
        paint.setAntiAlias(true);
        paint.setStrokeWidth(3);
        //paint.setColor(Color.rgb(255, 255, 0));
        //canvas.drawRect(0f, 0f, xDim, yDim, paint);
        //paint.setColor(Color.rgb(255, 0,255));
        //canvas.drawRect(0f,0f,
        //        scaledValue(45,xAngle,xDim),
        //        scaledValue(45,yAngle,yDim),
        //        paint);
        paint.setStyle(Paint.Style.FILL);
        int c = (activity.lightColorScheme) ? Color.rgb(128, 128, 255) : Color.rgb(0, 0, 128);
        paint.setColor(c);
        // an empirical value
        //projectionGain = (xsize > ysize)?xsize:ysize;
        float vOffset = scaler(-activity.sensorPitch, yAngle, yDim) / scalingFactor;
        //String sdebug = String.format("az:%.1f,roll:%.1f,pitch:%.1f,xAngle:%.1f,yAngle:%.1f,x:%.1f,y:%.1f", activity.sensorAzimuth, activity.sensorRoll * rToD, activity.sensorPitch * rToD, xAngle * rToD, yAngle * rToD, xDim, yDim);
        //String sdebug2 = String.format("xDim:%.1f,yDim: %.1f,vOffset:%.1f", xDim, yDim, vOffset);
        //Log.e("Monitor", sdebug);
        canvas.translate(xDim / 2.0f, (yDim / 2.0f) + vOffset);
        canvas.rotate(-activity.sensorRoll * rToD);
        paint.setStrokeWidth(4);
        // deliberately excessive line length
        canvas.drawLine(-xDim, 0, xDim, 0, paint);
        paint.setStrokeWidth(1);
        paint.setTextSize(textSize);
        paint.setStyle(Paint.Style.FILL);
        String s = (activity.lowestSelKey == 0) ? "(No Target Selected)" : "Horizon";
        float len = paint.measureText(s) / 2;
        canvas.drawText(s, -len, -paint.ascent(), paint);
        drawCompassScale(canvas, paint);
        drawSats(canvas, paint);
        canvas.restore();
        invalidate();
    }

    // arguments radians

    private float convertAzimuth(double a, double magDec) {
        double az = activity.sensorAzimuth + magDec - Math.PI/2;
        double xp = (float) (a - az);
        xp = (xp + Math.PI * 4) % (Math.PI * 2) - Math.PI/2;
        return scaler((float) (xp), xAngle, xDim);
    }

    private void drawCompassScale(Canvas canvas, Paint paint) {
        int c = (activity.lightColorScheme) ? Color.rgb(255, 128, 128) : Color.rgb(128, 0, 0);
        String compassConvention = (app.configuration.trueCompass) ? "T" : "M";
        paint.setColor(c);
        for (int a = 0; a < 360; a += 20) {
            float az = convertAzimuth(a * dToR, activity.useMagDec);
            String s = String.format("%d°%s", a, compassConvention);
            float len = paint.measureText(s) / 2;
            canvas.drawText(s, az - len, -paint.descent(), paint);
        }
    }

    private void drawSats(Canvas canvas, Paint paint) {
        paint.setTextSize(textSize);
        int i = 0;
        if (app.configuration.satSelectList.keySet().size() > 0) {
            for (int key : app.configuration.satSelectList.keySet()) {
                if (app.configuration.satSelectList.get(key)) {
                    if (activity.satData.size() > key) {
                        SatDescription sd = activity.satData.get(key);
                        if (sd != null && !sd.isHeader) {
                            int c = (activity.lightColorScheme) ? lightSatColors[i % satColors.length] : satColors[i % satColors.length];
                            drawSat(canvas, paint, sd.targetAzTrue * dToR, sd.targetEl * dToR,
                                    sd.satName, c);
                            //sd.debug();
                            i++;
                        }
                    }
                }
            }
        }
        if (false) {
            // extra data for calibration
            paint.setColor(Color.rgb(64, 0, 0));
            float xstep = 20;
            float ystep = 20;
            for (float x = 0; x < 360; x += xstep) {
                for (float y = 0; y < 60; y += ystep) {
                    drawSat(canvas, paint, x * dToR, y * dToR, String.format("%.0f/%.0f°", x, y), Color.RED);
                }
            }
        }
    }

    private void drawSat(Canvas canvas, Paint paint, double az, double el,
                         String name, int col) {
        int radius = (int) xDim / 128;
        paint.setStyle(Paint.Style.FILL);
        paint.setColor(col);
        float alt = scaler((float) -el, yAngle, yDim);
        float xp = convertAzimuth(az, activity.magDec);
        canvas.drawCircle(xp, alt, radius, paint);
        float len = paint.measureText(name) / 2;
        canvas.drawText(name, xp - len, alt - (radius + paint.descent()), paint);
    }

    private float scaler(float angle, float maxAngle, float size) {
        return angle * size * scalingFactor / maxAngle;
    }

}
