/*
 * This class is identical in TankCalc and TankCalcAndroid
 * Please keep it that way
 */
package com.arachnoid.tankcalcandroid;

/**
*
* @author lutusp
*/
final public class ImageArray {

   private boolean active;
   private int xs, ys;
   CartesianPoint[][] point;
   GPolygon[][] gpoly;
   
   // used to map traversal of graphic polygons
   private static int[] polyTraverseX = new int[]{0, 1, 1, 0, 0};
   private static int[] polyTraverseY = new int[]{0, 0, 1, 1, 0};

   public ImageArray(boolean a,int xv, int yv) {
       active = a;
       xs = xv;
       ys = yv;
       point = new CartesianPoint[xs+1][ys+1];
       gpoly = new GPolygon[xs][ys];
   }
   
   protected void createPolygons() {
       int len = polyTraverseX.length;
      for (int y = 0; y < ys; y++) {
           for (int x = 0; x < xs; x++) {
               GPolygon gp = new GPolygon(len);
               for (int i = 0; i < len; i++) {
                   gp.vector[i] = point[x + polyTraverseX[i]][y + polyTraverseY[i]];
               }
               gpoly[x][y] = gp;
           }
       } 
   }

   int getX() {
       return xs;
   }

   int getY() {
       return ys;
   }
   
   boolean isActive() {
       return active;
   }
}
