/// ***************************************************************************
// *   Copyright (C) 2018 by Paul Lutus                                      *
// *   lutusp@arachnoid.com                                                  *
// *                                                                         *
// *   This program is free software; you can redistribute it and/or modify  *
// *   it under the terms of the GNU General Public License as published by  *
// *   the Free Software Foundation; either version 2 of the License, or     *
// *   (at your option) any later version.                                   *
// *                                                                         *
// *   This program is distributed in the hope that it will be useful,       *
// *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
// *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
// *   GNU General Public License for more details.                          *
// *                                                                         *
// *   You should have received a copy of the GNU General Public License     *
// *   along with this program; if not, write to the                         *
// *   Free Software Foundation, Inc.,                                       *
// *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
// ***************************************************************************

 package Arachnophilia;

/*
 * AboutBox.java
 *
 * Created on February 27, 2002, 7:33 PM
 */

import java.awt.*;
import java.net.*;
import javax.swing.*;
import javax.swing.event.*;
import javax.swing.text.html.*;


/**
 *
 * @author  Administrator
 */
public class AboutBox extends javax.swing.JDialog {
    
    Arachnophilia main;
    /** Creates new form AboutBox */
    public AboutBox(Arachnophilia m, boolean modal) {
        super(m, modal);
        main = m;
        initComponents();
        
        String rightText = "<html><font face=\"MonoSpaced\"><b>" + ArachConstants.APPNAME + " "
        + "Build " + ArachConstants.BUILDNUMBER + "<br>"
        +"Arachnophilia is &copy; Copyright 2014, P. Lutus<br>"
        +"Arachnophilia is <a href=\"http://www.arachnoid.com/careware\">CareWare</b></font></html>";
        rightTitle.setContentType("text/html");
        rightTitle.setEditable(false);
        rightTitle.setText(rightText);
        mainTitle.setEditable(false);
        rightTitle.addHyperlinkListener(new Hyperactive());
        mainTitle.addHyperlinkListener(new Hyperactive());
        String mainText = "<html><font face=\"MonoSpaced\"><b>Local configuration directory:</b><br>" + main.basePath + "<br>"
        + "<b>Local application directory:</b><br>" + main.jarPath + "<br>"
        +"<b>Arachnophilia Home Page:</b><br>"
        + "<a href=\"http://www.arachnoid.com/arachnophilia\">http://www.arachnoid.com/arachnophilia</a><br>"
        +"<b>Arachnophilia online documentation:</b><br>"
        +"<a href=\"http://www.arachnoid.com/arachnophilia/Documentation\">http://www.arachnoid.com/arachnophilia/Documentation</a><br>"
        +"<b>CareWare Page:</b><br>"
        +"<a href=\"http://www.arachnoid.com/careware\">http://www.arachnoid.com/careware</a></font></html>";
        mainTitle.setContentType("text/html");
        mainTitle.setText(mainText);
        Rectangle ss = main.getBounds();
        int w = ss.width/8;
        int h = ss.height/8;
        setBounds(ss.x+w,ss.y+h,ss.width-w*2,ss.height-h*2);
        setTitle("About Arachnophilia");
        setVisible(true);
    }
    
    class Hyperactive implements HyperlinkListener {
 
        @Override
         public void hyperlinkUpdate(javax.swing.event.HyperlinkEvent e) {
                   if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                       JEditorPane pane = (JEditorPane) e.getSource();
                       if (e instanceof HTMLFrameHyperlinkEvent) {
                           //HTMLFrameHyperlinkEvent  evt = (HTMLFrameHyperlinkEvent)e;
                           //HTMLDocument doc = (HTMLDocument)pane.getDocument();
                           //doc.processHTMLFrameHyperlinkEvent(evt);
                       } else {
                           try {
                               URL url = e.getURL();
                               main.launchBrowser(url.toString());
                               //pane.setPage(e.getURL());
                           } catch (Throwable t) {
                               t.printStackTrace(System.out);
                           }
                       }
                   }
               }
               
     }


    
    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {
        java.awt.GridBagConstraints gridBagConstraints;

        jPanel1 = new javax.swing.JPanel();
        jButton1 = new javax.swing.JButton();
        mainScroll = new javax.swing.JScrollPane();
        mainTitle = new MyJEditorPane(main);
        rightScroll = new javax.swing.JScrollPane();
        rightTitle = new MyJEditorPane(main);
        closeButton = new MyJButton();

        addWindowListener(new java.awt.event.WindowAdapter() {
            public void windowClosing(java.awt.event.WindowEvent evt) {
                closeDialog(evt);
            }
        });

        jPanel1.setLayout(new java.awt.GridBagLayout());

        jButton1.setIcon(new javax.swing.ImageIcon(getClass().getResource("/Arachnophilia/Arach.png"))); // NOI18N
        jButton1.setText(" ");
        jButton1.setToolTipText("Arachie says \"Hi!\"");
        jButton1.setBorder(javax.swing.BorderFactory.createEmptyBorder(4, 4, 4, 4));
        jButton1.setFocusPainted(false);
        jButton1.setFocusable(false);
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTH;
        gridBagConstraints.insets = new java.awt.Insets(8, 8, 12, 12);
        jPanel1.add(jButton1, gridBagConstraints);

        mainScroll.setBorder(null);

        mainTitle.setBorder(javax.swing.BorderFactory.createEmptyBorder(3, 3, 3, 3));
        mainTitle.setFont(new java.awt.Font("Monospaced", 0, 12)); // NOI18N
        mainScroll.setViewportView(mainTitle);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTH;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(8, 8, 8, 8);
        jPanel1.add(mainScroll, gridBagConstraints);

        rightScroll.setBorder(null);

        rightTitle.setBorder(javax.swing.BorderFactory.createEmptyBorder(3, 3, 3, 3));
        rightTitle.setFont(new java.awt.Font("Monospaced", 0, 12)); // NOI18N
        rightScroll.setViewportView(rightTitle);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(8, 8, 8, 8);
        jPanel1.add(rightScroll, gridBagConstraints);

        closeButton.setText("Close");
        closeButton.setToolTipText("Close and exit the about dialog");
        closeButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                closeButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.insets = new java.awt.Insets(4, 0, 4, 0);
        jPanel1.add(closeButton, gridBagConstraints);

        getContentPane().add(jPanel1, java.awt.BorderLayout.CENTER);

        pack();
    }// </editor-fold>//GEN-END:initComponents

     private void closeButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_closeButtonActionPerformed
         // Add your handling code here:
         quit();
     }//GEN-LAST:event_closeButtonActionPerformed
    
    /** Closes the dialog */
    private void closeDialog(java.awt.event.WindowEvent evt) {//GEN-FIRST:event_closeDialog
        quit();
    }//GEN-LAST:event_closeDialog
    
    private void quit()
    {
        setVisible(false);
        dispose();
    }
    /**
     * @param args the command line arguments
     *//*
    public static void main(String args[]) {
        new AboutBox(new javax.swing.JFrame(), true).show();
    }*/
    
    
    // Variables declaration - do not modify//GEN-BEGIN:variables
    protected javax.swing.JButton closeButton;
    private javax.swing.JButton jButton1;
    private javax.swing.JPanel jPanel1;
    private javax.swing.JScrollPane mainScroll;
    private javax.swing.JEditorPane mainTitle;
    private javax.swing.JScrollPane rightScroll;
    private javax.swing.JEditorPane rightTitle;
    // End of variables declaration//GEN-END:variables
    
}
