// ***************************************************************************
// *   Copyright (C) 2018 by Paul Lutus                                      *
// *   lutusp@arachnoid.com                                                  *
// *                                                                         *
// *   This program is free software; you can redistribute it and/or modify  *
// *   it under the terms of the GNU General Public License as published by  *
// *   the Free Software Foundation; either version 2 of the License, or     *
// *   (at your option) any later version.                                   *
// *                                                                         *
// *   This program is distributed in the hope that it will be useful,       *
// *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
// *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
// *   GNU General Public License for more details.                          *
// *                                                                         *
// *   You should have received a copy of the GNU General Public License     *
// *   along with this program; if not, write to the                         *
// *   Free Software Foundation, Inc.,                                       *
// *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
// ***************************************************************************

 package Arachnophilia;


/*
 * TideConstants.java
 *
 * Created on October 12, 2001, 1:30 PM
 */
import java.awt.*;

/**
 *
 * @author  Administrator
 * @version
 */
public interface ArachConstants {

    static final public String APPNAME = "Arachnophilia 5.5";
    static final public String BUILDNUMBER = "2953";
    static final public String requiredJavaVersion = "1.7.0";
    String USERDIR = System.getProperty("user.dir");
    String USERHOME = System.getProperty("user.home");
    String SYSTEM_EOL = System.getProperty("line.separator");
    String SYSTEM_FILESEP = System.getProperty("file.separator");
    String DefaultEncoding = "UTF-8";
    static final public String xmlDecl = "<?xml version=\"1.0\" standalone=\"yes\" encoding=\"UTF-8\"?>";
    char DEGREE_CHAR = (char) 176;
    double M_PI = 3.141592653589793;
    double M_PI2 = 6.283185307179586;
    double M_PID2 = 1.570796326794897;
    double RADIANS = 0.01745329251994329;
    double DEGREES = 57.29577951308232;
    double SECONDS_TO_HOURS = 2.7777777777777778e-4;
    double FEET_TO_METERS = .3048;
    double METERS_TO_FEET = 3.280839895013123;
    double convday = 4.16666666666667E-02;
    double convhour = 6.66666666666667E-02;
    double convmin = 1.66666666666667E-02;
    double convsec = 2.77777777777778E-04;
    double convcircle = 2.77777777777778E-03;
    double SUNSET = -.833333333333333;
    double CIVIL = -6.0;
    double NAUTICAL = -12.0;
    double ASTRONOMICAL = -18.0;
    String dowNames[] = {"Sun", "Mon", "Tue", "Wed", "Thu", "Fri", "Sat"};
    String monthNames[] = {"January", "February", "March", "April", "May", "June", "July", "August", "September", "October", "November", "December"};
    public String[] barPositions = {
        BorderLayout.NORTH, BorderLayout.EAST, BorderLayout.SOUTH, BorderLayout.WEST
    };
    /*int FILETYPE_TEXT = 0;
    int FILETYPE_HTML = 1;
    int FILETYPE_JAVA = 2;
    int FILETYPE_JAVASCRIPT = 3;
    int FILETYPE_PERL = 4;
    int FILETYPE_C = 5;
    int FILETYPE_CPP  = 6;
    int FILETYPE_ALL = 7;*/
    //public String[] fileTypeNames = {"Text","HTML","Java","JavaScript","Perl","C","C++","Graphics","All"};
    //public String[] fileTemplateSuffs = {"txt","html","java","js","pl","c","cpp","gif",""};
    /*public String[] tokenMarkerClassNames = {
    "TokenMarker",
    "HTMLTokenMarker",
    "JavaTokenMarker",
    "JavaScriptTokenMarker",
    "PerlTokenMarker",
    "CTokenMarker",
    "CCTokenMarker",
    ""
    };*/
    /*
    public int[] styleConstants = {
        Token.COMMENT_DOCUMENTATION,
        Token.COMMENT_EOL,
        Token.COMMENT_MULTILINE,
        Token.DATA_TYPE,
        Token.ERROR_CHAR,
        Token.ERROR_IDENTIFIER,
        Token.ERROR_NUMBER_FORMAT,
        Token.ERROR_NUMBER_FORMAT,
        Token.ERROR_STRING_DOUBLE,
        Token.FUNCTION,
        Token.IDENTIFIER,
        Token.LITERAL_BACKQUOTE,
        Token.LITERAL_BOOLEAN,
        Token.LITERAL_CHAR,
        Token.LITERAL_NUMBER_DECIMAL_INT,
        Token.LITERAL_NUMBER_FLOAT,
        Token.LITERAL_NUMBER_HEXADECIMAL,
        Token.LITERAL_STRING_DOUBLE_QUOTE,
        Token.MARKUP_TAG_ATTRIBUTE,
        Token.MARKUP_TAG_DELIMITER,
        Token.MARKUP_TAG_NAME,
        Token.NULL,
        Token.NUM_TOKEN_TYPES,
        Token.OPERATOR,
        Token.PREPROCESSOR,
        Token.RESERVED_WORD,
        Token.SEPARATOR,
        Token.VARIABLE,
        Token.WHITESPACE
    };
        //Token.COMMENT1, Token.COMMENT2, Token.KEYWORD1, Token.KEYWORD2, Token.KEYWORD3, Token.LITERAL1, Token.LITERAL2, Token.LABEL, Token.OPERATOR, Token.INVALID, Token.INTAG0, Token.INTAG1, Token.INTAG2, Token.INTAG3, Token.INTAG4};
    public String[] styleNames = {
        "COMMENT_DOCUMENTATION","COMMENT_EOL","COMMENT_MULTILINE","DATA_TYPE","ERROR_CHAR","ERROR_IDENTIFIER","ERROR_NUMBER_FORMAT","ERROR_NUMBER_FORMAT","ERROR_STRING_DOUBLE","FUNCTION","IDENTIFIER","LITERAL_BACKQUOTE","LITERAL_BOOLEAN","LITERAL_CHAR","LITERAL_NUMBER_DECIMAL_INT","LITERAL_NUMBER_FLOAT","LITERAL_NUMBER_HEXADECIMAL","LITERAL_STRING_DOUBLE_QUOTE","MARKUP_TAG_ATTRIBUTE","MARKUP_TAG_DELIMITER","MARKUP_TAG_NAME","NULL","NUM_TOKEN_TYPES","OPERATOR","PREPROCESSOR","RESERVED_WORD","SEPARATOR","VARIABLE","WHITESPACE"
    };
        //"COMMENT1", "COMMENT2", "KEYWORD1", "KEYWORD2", "KEYWORD3", "LITERAL1", "LITERAL2", "LABEL", "OPERATOR", "INVALID", "INTAG0", "INTAG1", "INTAG2", "INTAG3", "INTAG4"};
     * */
}
