// ***************************************************************************
// *   Copyright (C) 2018 by Paul Lutus                                      *
// *   lutusp@arachnoid.com                                                  *
// *                                                                         *
// *   This program is free software; you can redistribute it and/or modify  *
// *   it under the terms of the GNU General Public License as published by  *
// *   the Free Software Foundation; either version 2 of the License, or     *
// *   (at your option) any later version.                                   *
// *                                                                         *
// *   This program is distributed in the hope that it will be useful,       *
// *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
// *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
// *   GNU General Public License for more details.                          *
// *                                                                         *
// *   You should have received a copy of the GNU General Public License     *
// *   along with this program; if not, write to the                         *
// *   Free Software Foundation, Inc.,                                       *
// *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
// ***************************************************************************

package Arachnophilia;


/*
 * Document.java
 *
 * Created on November 21, 2001, 2:38 PM
 */
//import FilePicker.ArachFileFilter;
//import Arachnophilia;
//import JArachTextArea.*;
import BrowserStuff.*;
import FilePicker.*;
import java.awt.*;
import java.awt.event.*;
import java.io.*;
import javax.swing.*;
import javax.swing.text.*;

/**
 *
 * @author Administrator
 */
final public class ArachDocument extends JPanel {

    public Arachnophilia main;
    UndoRedoHandler undoRedoHandler;
    public MySyntaxTextArea textComp = null;
    //JTextArea textComp = null;
    private String fullPath = "";
    File file = null;
    private String path = "";
    public String name = "";
    public int fileType;
    public boolean validCreation = false;
    public long lastModifiedTime = -1;
    boolean needInit = true;
    public int firstPaint = 0;
    public boolean suppressFirst = true;
    public boolean docChanged = false;
    public boolean isFile = false;
    public boolean isHTMLDocument = false;
    public boolean lockDocument = false;
    // true on first draw
    public boolean centerCaret = true;
    public BrowserLauncher browserLauncher;
    public String fileTypeName = "";
    public boolean spellChecking = false;
    String shortName;

    /**
     * Creates new form Document
     */
    public ArachDocument(String localPath, Arachnophilia m, int t, boolean isFile) {
        main = m;
        fileType = t;
        fileTypeName = main.fileTypes.getFileTypeName(t);
        fullPath = localPath;
        shortName = fullPath;
        int p = fullPath.lastIndexOf(ArachConstants.SYSTEM_FILESEP);
        if (p != -1 && p < fullPath.length() - 1) {
            shortName = fullPath.substring(p + 1);
        }
        this.isFile = isFile;
        browserLauncher = new BrowserLauncher(this, main);
        isHTMLDocument = (fileTypeName.equals("HTML")) || (fileTypeName.equals("PHP"));

        initComponents();

        undoRedoHandler = new UndoRedoHandler(main, m.configValues.undoRedoStackSize);

        setLayout(new BorderLayout());

        setNewFont();
        setup(localPath);
        changeFileType(fileType);
    }

    public String getFullPath() {
        return fullPath;
    }
    
    public String getShortName() {
        return shortName;
    }

    protected void setFullPath(String fp) {
        if (fp.length() == 0) {
            int x = 0 / 0;
        }
        fullPath = fp;
    }

    public String getPath() {
        return path;
    }

    protected void setPath(String fp) {
        if (fp.length() == 0) {
            int x = 0 / 0;
        }
        path = fp;
    }

    private void setup(String localPath) {
        boolean saveMax = main.configValues.maximized;
        if (readSourceFile()) {
            main.fileHandler.updateDocTitle(this);
            main.fileHandler.setFileNameStrings(localPath, this, isFile);
            main.configValues.maximized = saveMax;
            setVisible(true);
            docChanged = false;
            main.latestOpenedDocument = this;
            validCreation = true;
        }
    }

    private boolean readSourceFile() {
        boolean result = false;
        String s;
        // deal with nonexistent template file
        if (fullPath.indexOf("Templates") != -1 && !(new File(fullPath).exists())) {
            s = "#//; (No template for this file type)\n\n|\n";
        } else {
            s = ArachComp.readDataFile(fullPath, true);
        }
        if (s != null) {
            if (!isFile) { // is this a template?
                s = main.comSwitchboard.exec(s, 0);
            }
            lastModifiedTime = ArachComp.getLastModifiedTime(fullPath);

            int p = 0;
            if (!isFile) {
                p = getStringCaretPos(s);
                if (p < 0) {
                    p = 0;
                }
                s = clearStringCaretPos(s, p);
            }
            setupView(s, p, p, 0, fileType);
            textComp.setCaretPosition(p);
            docChanged = false;
            result = true;
        }
        return result;
    }

    public void testLastModifiedTime() {
        if (lastModifiedTime != -1) {
            long newTime = ArachComp.getLastModifiedTime(fullPath);
            if (newTime > lastModifiedTime) {
                FileChangedDialog fcd = new FileChangedDialog(main, fullPath, docChanged, true);
                int state = fcd.state;
                //System.out.println("" + state);
                switch (state) {
                    case 3: // overwrite
                        saveFile(false, false, true);
                        break;
                    case 2: // reload content from file
                        updateFileContent();
                        lastModifiedTime = newTime;
                        break;
                    default:
                        lastModifiedTime = newTime;
                        break;
                }
            }
        }
    }

    public void updateFileContent() {
        if (textComp != null) {
            int selStart = textComp.getSelectionStart();
            int selEnd = textComp.getSelectionEnd();
            int firstLine = textComp.getFirstLine();
            String s = ArachComp.readDataFile(fullPath, true);
            textComp.setText(s);
            textComp.setSelectionStart(selStart);
            textComp.setSelectionEnd(selEnd);
            textComp.setFirstLine(firstLine);
            Caret car = textComp.getCaret();
            if (car != null) {
                textComp.setCaretPosition(selEnd);
                textComp.moveCaretPosition(selEnd);
                car.setSelectionVisible(true);
            }
            docChanged = false;
            main.fileHandler.updateDocTitle(this);
        }
    }

    public boolean handleLineFeed(KeyEvent evt) {
        boolean ok = false;
        if (evt.getKeyChar() == KeyEvent.VK_ENTER && (evt.getModifiers() & (KeyEvent.ALT_MASK | KeyEvent.SHIFT_MASK | KeyEvent.CTRL_MASK)) == 0) {
            try {
                //System.out.println("is linefeed");
                if (main.configValues.autoIndent) {
                    int p = textComp.getCaretLine();
                    int a = textComp.getLineStartOffset(p);
                    int pos = textComp.getCaretPosition();
                    String line = textComp.getText(a, pos - a);
                    String sys_tab = ArachComp.getTabString();
                    StringBuilder ttab = new StringBuilder("");
                    ttab.append((line.endsWith("{") || line.endsWith(":") || line.endsWith("(") || line.endsWith("[")) ? sys_tab : "");
                    //System.out.println("line left of cursor: [" + line + "]");
                    int len = line.length();
                    for (int i = 0; i < len && Character.isWhitespace(line.charAt(i)); i++) {
                        ttab.append(" ");
                    }
                    //System.out.println("[" + tab + "] len: " + tab.length());
                    textComp.select(pos, pos);
                    textComp.replaceSelection("\n" + ttab.toString());
                    ok = true;
                    evt.consume();
                }
            } catch (Exception e) {
                e.printStackTrace(System.out);
            }
        }
        return ok;
    }

    public int getFileType() {
        return fileType;
    }

    public void gotoLine(int line) {
        int total = textComp.getLineCount();
        line = (line > total - 1) ? total - 1 : line;
        line = (line < 0) ? 0 : line;
        int offset = textComp.getLineStartOffset(line);
        textComp.setCaretPosition(offset);
        centerCaretOnPage();
    }

    // aesthetically place the caret
    // this doesn't work on the first paint.
    public void centerCaretOnPage() {
        textComp.centerCaretInView();
    }

    public void centerCaretOnPage(int v) {
        textComp.centerCaretInView(v);
    }

    public String getBrowserTempFileName() {
        if (browserLauncher.browserTempFile != null) {
            return browserLauncher.browserTempFile.getPath();
        } else {
            return "";
        }
    }

    public void undoPush() {
        undoRedoHandler.undoPush(textComp);
    }

    public void undo() {

        undoRedoHandler.undoPop(textComp);
        if (main.haveFocus) {
            textComp.grabFocus();
        }
    }

    public void redo() {
        undoRedoHandler.redoPop(textComp);
        if (main.haveFocus) {
            textComp.grabFocus();
        }
    }

    public void computeStatusString() {

        if (textComp != null) {
            int lineCount = textComp.getLineCount();
            int caretPosition = textComp.getCaretPosition();
            int caretLine = textComp.getCaretLine();
            int lineStartOffset = textComp.getLineStartOffset(caretLine);
            int lineLength = textComp.getLineLength(caretLine);
            int docLength = textComp.getLength();
            long percent = 0;
            if (docLength > 0) {
                percent = 100 * caretPosition / docLength;
            }
            String s = "R(" + (caretLine + 1) + ":" + lineCount + ")";
            s += " C(" + (caretPosition - lineStartOffset + 1) + ":" + (lineLength + 1) + ")";
            s += " D(" + (caretPosition) + ":" + (docLength) + ") " + percent + "%";
            main.updateStatusBar(s);
        }
    }

    public void setTabSize(int t) {
        main.configValues.tabSize = t;
        if (textComp != null) {
            textComp.getDocument().putProperty(PlainDocument.tabSizeAttribute, new Integer(t));
        }
    }

    public void setTabSize() {
        setTabSize(main.configValues.tabSize);
    }

    public void changeWrapMode(boolean wrap) {
        // no more mode changes
        main.configValues.lineWrap = wrap;
        firstPaint = 0;
        if (textComp == null) {
            return;
        }
        textComp.setLineWrap(main.configValues.lineWrap);
        textComp.setWrapStyleWord(true);
        textComp.makeCaretVisible();
    }

    public void toggleWrapMode() {
        changeWrapMode(!main.configValues.lineWrap);
    }

    private void setupView(String s, int a, int b, int c, int type) {
        suppressFirst = true;
        textComp = new MySyntaxTextArea(main, s, this);
        textComp.setFont(getFont());
        textComp.scrollPane.setViewportView((JTextArea) textComp);

        if (s.length() > 0) {
            if (c == a) {

                textComp.setCaretPosition(b);
                textComp.moveCaretPosition(c);
            } else {
                textComp.setCaretPosition(a);
                textComp.moveCaretPosition(c);
            }

        }

        if (getComponentCount() > 0) {
            remove(0);
        }
        add(textComp.scrollPane);
        // EDIT
        textComp.scrollPane.setLineNumbersEnabled(main.configValues.lineNumberColumn);

        textComp.addMouseListener(new java.awt.event.MouseAdapter() {

            @Override
            public void mousePressed(java.awt.event.MouseEvent evt) {
                //System.out.println("doc mouse pressed");
                handleMouse(evt);
            }

            @Override
            public void mouseReleased(java.awt.event.MouseEvent evt) {
                //System.out.println("doc mouse released");
                handleMouse(evt);
            }
        });

        setTabSize();
        if (main.haveFocus) {
            textComp.rfiw();
        }
        changeWrapMode(main.configValues.lineWrap);
        suppressFirst = false;
    }

    public void setNewFont() {
        Font f = new Font(
                main.configValues.editFontName, main.configValues.editFontStyle, (int) main.configValues.editFontSize);
        setFont(f);
        if (textComp != null) {
            textComp.setFont(f);
            textComp.scrollPane.setFont(f);
            updateUI();
        }
        updateUI();
    }

    // use this comparator to test for duplicates
    public boolean equals(ArachDocument d) {
        return d.fullPath.equals(fullPath);
    }

    private int getStringCaretPos(String s) {
        return s.indexOf("|");
    }

    private String clearStringCaretPos(String s, int p) {
        if (p >= 0 && p < s.length() - 1) {
            s = s.substring(0, p) + s.substring(p + 1);
        }
        return s;
    }

    public void changeFileType(int type) {
        chooseSyntaxPainter(type);
        fileType = type;
        repaint();
    }

    private void chooseSyntaxPainter(int type) {
        if (type >= 0 && type < main.fileTypes.markerClassNames.length) {
            String markerName = main.fileTypes.markerClassNames[type];
            // prevent meaningless doc change signal
            boolean oldChanged = docChanged;
            if (markerName.length() == 0) {
                textComp.setTokenMaker(null);
            } else {
                if (Character.isLetter(markerName.charAt(0))) {
                    try {
                        textComp.setTokenMaker(markerName);
                    } catch (Exception e) {
                        e.printStackTrace(System.out);
                    }
                } else {
                    textComp.setTokenMaker(null);
                }
            }
            docChanged = oldChanged;
        }
    }

    public boolean saveClose(boolean prompt) {
        boolean saved = saveFile(prompt, true, false);
        if (saved) {
            //System.out.println("Closing");
            browserLauncher.closeThings();
            main.fileHandler.removeDoc(this);
            if (main.currentSelectedDocument == this) {
                main.currentSelectedDocument = null;
            }
            //setVisible(false);
            //dispose();
        }
        return saved;
    }

    public boolean saveFile(boolean prompt, boolean closing, boolean force) {
        if (!docChanged && !force) {
            return true;
        } else {
            return saveFile(fullPath, isFile, prompt, closing);
        }
    }

    @Override
    public String toString() {
        return fullPath;
    }

    public boolean saveFile(String path, boolean isFile, boolean prompt, boolean closing) {
        String data;
        if (path.equals("")) {
            path = fullPath;
        }
        boolean saved = false;
        if (textComp != null) {
            data = textComp.getText();
            if (isFile) {
                int r = JOptionPane.YES_OPTION;
                if (prompt) {
                    r = saveFilePrompt(path);
                }
                if (r == JOptionPane.CANCEL_OPTION) {
                    saved = false;
                } else if (r == JOptionPane.NO_OPTION) {
                    saved = true;
                } else if (r == JOptionPane.YES_OPTION) {
                    File newFile = new File(path);
                    File oldFile = new File(fullPath);
                    main.fileHandler.swapDocuments(oldFile, newFile, this);
                    saved = ArachComp.writeDataFile(path, data, true);
                    if (saved) {
                        // don't retain a temp file with wrong path
                        if (!oldFile.getPath().equals(newFile.getPath())) {
                            browserLauncher.retireTempFile();
                        }
                        //System.out.println("saved to " + path);
                        main.fileHandler.setFileNameStrings(path, this, true);
                        docChanged = false;
                        updateTitle();
                        main.configValues.fileTypePaths[fileType] = ArachComp.pathFromFullPath(path);

                        main.recentFileList.put(path);
                    }
                }
            } else { // not a file
                int r = JOptionPane.YES_OPTION;
                if (prompt) {
                    r = saveFilePrompt(path);
                }
                if (r == JOptionPane.YES_OPTION) {
                    saved = saveFileAs(closing);
                } else if (r == JOptionPane.NO_OPTION) {
                    saved = true;
                }
            }
        }
        lastModifiedTime = ArachComp.getLastModifiedTime(fullPath);
        return saved;
    }

    private int saveFilePrompt(String path) {
        SaveFileDialog dlg = new SaveFileDialog(main, true, "File Not Saved", "The file \"" + path + "\"\nis changed but has not been saved.\n\nPlease choose:");
        int r = dlg.outcome();
        return r;
    }

    public void launchBrowser(String arg) {
        browserLauncher.launchBrowser(arg);
    }

    public void updateTitle() {
        main.fileHandler.updateDocTitle(this);
    }

    public boolean saveFileAs(boolean closing) {
        String s = main.fileHandler.genNewFileName(this);
        return saveFileAs(s, closing);
    }

    public boolean saveFileAs(String name, boolean closing) {
        boolean saved = false;
        final PickerDialog fc;
        String localPath = main.configValues.fileTypePaths[fileType];
        //ArachFileFilter aff = new ArachFileFilter(fileType,ArachComp.fileTypeNames,ArachComp.suffixArrayList);
        main.fileTypes.setFileType(fileType);
        File origFile = new File(localPath, name);
        if (localPath.length() > 0) {
            File fp = new File(localPath);
            fc = new PickerDialog(main, fp, main.fileTypes, PickerPanel.FILES_ONLY);
        } else {
            fc = new PickerDialog(main, main.fileTypes, PickerPanel.FILES_ONLY);
        }
        //fc.setFileSelectionMode(PickerPanel.FILES_ONLY);
        fc.setDialogTitle("Save " + main.fileTypes.fileTypeNames[fileType] + " file");

        File tf = new File(name);
        //System.out.println(tf.getName());
        //if(tf.exists()) {
        fc.setFileName(tf.getName());
        //}
        int returnVal = fc.showSaveDialog();
        while (closing && !saved && returnVal == PickerPanel.CANCEL) {
            int r = saveFilePrompt(localPath);
            if (r == JOptionPane.NO_OPTION) {
                saved = true;
            }
            if (!saved) {
                returnVal = fc.showSaveDialog();
            }
        }
        if (!saved && returnVal == PickerPanel.ACCEPT) {
            File f = fc.getSelectedFile();
            if (f != null) {
                int r = JOptionPane.YES_OPTION;
                if (f.exists() && !f.equals(origFile)) {
                    r = JOptionPane.showConfirmDialog(main, "File \"" + f.getPath() + "\" exists.\nOkay to overwrite?", "File Exists", JOptionPane.YES_NO_CANCEL_OPTION);
                }
                if (r == JOptionPane.YES_OPTION) {
                    File tempf = this.file;
                    saved = saveFile(f.getPath(), true, false, closing);
                    if (saved) { // if the name has changed
                        main.fileHandler.swapDocuments(tempf, f, this);
                    }
                }
            }
        }
        lastModifiedTime = ArachComp.getLastModifiedTime(fullPath);
        return saved;
    }

    /**
     * This method is called from within the constructor to initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is always
     * regenerated by the Form Editor.
     */
    private void initComponents() {//GEN-BEGIN:initComponents

        setLayout(new java.awt.BorderLayout());

        addComponentListener(new java.awt.event.ComponentAdapter() {
            public void componentShown(java.awt.event.ComponentEvent evt) {
                formComponentShown(evt);
            }
            public void componentHidden(java.awt.event.ComponentEvent evt) {
                formComponentHidden(evt);
            }
        });
        addContainerListener(new java.awt.event.ContainerAdapter() {
            public void componentRemoved(java.awt.event.ContainerEvent evt) {
                formComponentRemoved(evt);
            }
        });
        addFocusListener(new java.awt.event.FocusAdapter() {
            public void focusGained(java.awt.event.FocusEvent evt) {
                formFocusGained(evt);
            }
        });

    }//GEN-END:initComponents

    private void formFocusGained(java.awt.event.FocusEvent evt) {//GEN-FIRST:event_formFocusGained
        // Add your handling code here:
        //System.out.println("focus gained " + this);
        onActivation();
    }//GEN-LAST:event_formFocusGained

    private void closePlainMenuActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_closePlainMenuActionPerformed
        // Add your handling code here:
        main.closeDoc(this);
    }//GEN-LAST:event_closePlainMenuActionPerformed

    private void closeFancyMenuActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_closeFancyMenuActionPerformed
        // Add your handling code here:
        main.closeDoc(this);
    }//GEN-LAST:event_closeFancyMenuActionPerformed

    private void formComponentHidden(java.awt.event.ComponentEvent evt) {//GEN-FIRST:event_formComponentHidden
        // Add your handling code here:
        onDeactivation();
    }//GEN-LAST:event_formComponentHidden

    private void formComponentShown(java.awt.event.ComponentEvent evt) {//GEN-FIRST:event_formComponentShown
        // Add your handling code here:
        //System.out.println("form component shown " + this);
        onActivation();
    }//GEN-LAST:event_formComponentShown

    private void formComponentRemoved(java.awt.event.ContainerEvent evt) {//GEN-FIRST:event_formComponentRemoved
        // Add your handling code here:
        onDeactivation();
    }//GEN-LAST:event_formComponentRemoved

    private void testMenuItemActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_testMenuItemActionPerformed
        // Add your handling code here:
        doTest();
    }//GEN-LAST:event_testMenuItemActionPerformed

    private void toggleLineWrapActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_toggleLineWrapActionPerformed
        // Add your handling code here:
        toggleLineWrap();
    }//GEN-LAST:event_toggleLineWrapActionPerformed

    private void showFancyMenuItemActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_showFancyMenuItemActionPerformed
        // Add your handling code here:
        changeWrapMode(true);
    }//GEN-LAST:event_showFancyMenuItemActionPerformed

    private void toPlainTextMenuItemActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_toPlainTextMenuItemActionPerformed
        // Add your handling code here:
        changeWrapMode(false);
    }//GEN-LAST:event_toPlainTextMenuItemActionPerformed

    private void changeFontMenuItemActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_changeFontMenuItemActionPerformed
        // Add your handling code here:
        // setEditFont();
    }//GEN-LAST:event_changeFontMenuItemActionPerformed

    private void eolMarkMenuItemActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_eolMarkMenuItemActionPerformed
        // Add your handling code here:
        toggleEOLMarks();
    }//GEN-LAST:event_eolMarkMenuItemActionPerformed

    private void lineNumsButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_lineNumsButtonActionPerformed
        // Add your handling code here:
        toggleLineNumbers();
    }//GEN-LAST:event_lineNumsButtonActionPerformed

    private void testMaxMenuItemActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_testMaxMenuItemActionPerformed
        // Add your handling code here:
        //System.out.println(isMaximum());
    }//GEN-LAST:event_testMaxMenuItemActionPerformed

    private void MaxDocMenuItemActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_MaxDocMenuItemActionPerformed
        // Add your handling code here:
        /* try {
        //setMaximum(true);
        }
        catch(Exception e) {
        e.printStackTrace();
        }*/
    }//GEN-LAST:event_MaxDocMenuItemActionPerformed

    private void linePanelMenuItemActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_linePanelMenuItemActionPerformed
        // Add your handling code here:
        toggleLineNumbers();
    }//GEN-LAST:event_linePanelMenuItemActionPerformed

    private void formMousePressed(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_formMousePressed
        // Add your handling code here:
        handleMouse(evt);
    }//GEN-LAST:event_formMousePressed

    private void formMouseReleased(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_formMouseReleased
        // Add your handling code here:
        handleMouse(evt);
    }//GEN-LAST:event_formMouseReleased

    private void doTest() {
        if (textComp != null) {
            //textComp.centerEditPos();
        }
    }

    public void toggleLineNumbers() {
        main.configValues.lineNumberColumn = !main.configValues.lineNumberColumn;
        // EDIT
        textComp.scrollPane.setLineNumbersEnabled(main.configValues.lineNumberColumn);
        if (textComp != null) {
            //textComp.setL;
        }
        //repaint();
    }

    public void toggleLineWrap() {
        if (textComp == null) {
            return;
        }
        toggleWrapMode();
    }

    public void handleMouse(java.awt.event.MouseEvent evt) {

        //System.out.println("ArachDocument: " + evt);
        if (main.haveFocus) {
            textComp.rfiw();
        }
        if ((evt.getModifiers() & InputEvent.BUTTON1_MASK) == 0) {
            // move the caret on a right-click
            int a = textComp.getSelectionStart();
            int b = textComp.getSelectionEnd();
            // if no selection, move caret to mouse
            if (a == b) { // if no selection
                Point mouse = new Point(evt.getX(), evt.getY());
                int pos = textComp.viewToModel(mouse);
                textComp.setCaretPosition(pos);
            }
        }

        if (evt.isPopupTrigger()) {
            // 2. test various right-click functions
            if (!main.processRightClick(evt, this)) {
                // 3. show default context menu
                main.getDocPopup().show((JComponent) textComp, evt.getX(), evt.getY());
            }
        }
    }

    public void onActivation() {
        main.currentSelectedDocument = this;
        main.setProgramTitle();
        if (main.haveFocus) {
            textComp.rfiw();
        }
        if (needInit) {
            needInit = false;
            //main.windowList.refreshList();
        }
        /*try {
        setMaximum(main.configValues.maximized);
        }
        catch(Exception e) {
        e.printStackTrace();
        }*/
    }

    private void onDeactivation() {
        main.updateStatusBar("");
    }

    public void toggleEOLMarks() {
        main.configValues.paintEOLMarks = !main.configValues.paintEOLMarks;
        repaint();
    }
    // Variables declaration - do not modify//GEN-BEGIN:variables
    // End of variables declaration//GEN-END:variables
}
