// ***************************************************************************
// *   Copyright (C) 2018 by Paul Lutus                                      *
// *   lutusp@arachnoid.com                                                  *
// *                                                                         *
// *   This program is free software; you can redistribute it and/or modify  *
// *   it under the terms of the GNU General Public License as published by  *
// *   the Free Software Foundation; either version 2 of the License, or     *
// *   (at your option) any later version.                                   *
// *                                                                         *
// *   This program is distributed in the hope that it will be useful,       *
// *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
// *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
// *   GNU General Public License for more details.                          *
// *                                                                         *
// *   You should have received a copy of the GNU General Public License     *
// *   along with this program; if not, write to the                         *
// *   Free Software Foundation, Inc.,                                       *
// *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
// ***************************************************************************

 package Arachnophilia;

/*
 * DocContentHandler.java
 *
 * Created on February 10, 2002, 4:27 PM
 */

import javax.swing.text.*;

/**
 *
 * @author  Administrator
 * @version
 */
final public class DocContentHandler {
    
    int selectionStart;
    int selectionEnd;
    int firstLine;
    int cp;
    int origLen;
    int finalLen;
    ArachDocument doc;
    MySyntaxTextArea textComp;
    boolean selectionValid = false;
    boolean caretAtBeginning = false;
    Arachnophilia main;
    public DocContentHandler(Arachnophilia m) {
        main = m;
        doc = main.currentSelectedDocument;
    }
    
    public ArachDocument getDoc() {
        return doc;
    }
    
    public String getContent(ArachDocument d) {
        doc = d;
        return getContent2();
    }
    
    public boolean isHTML()
    {
        return doc.getFileType() == main.fileTypes.getFileTypeForName("HTML");
    }
    
    public String getContent() {
        doc = main.currentSelectedDocument;
        return getContent2();
    }
    
    private String getContent2() {
        String content = null;
        selectionValid = false;
        if(doc != null) {
            
            textComp = doc.textComp;
            if(textComp != null) {
                firstLine = textComp.getFirstLine();
                selectionStart = textComp.getSelectionStart();
                selectionEnd = textComp.getSelectionEnd();
                cp = textComp.getCaretPosition();
                caretAtBeginning = cp == selectionStart;
                
                if(selectionStart == selectionEnd) {
                    content = textComp.getText();
                    selectionValid = false;
                }
                else {
                    selectionValid = true;
                    content = textComp.getSelectedText();
                }
            }
            origLen = content.length();
        }
        else {
            textComp = null;
            doc = null;
        }
        return content;
    }
    
    public void setContent(String content) {
        setContent(content,false);
    }
    
    public void setContent(String content,boolean insert) {
        if(textComp != null) {
            finalLen = content.length();
            doc.undoPush();
            if(selectionValid || insert) {
                textComp.replaceSelection(content);
            }
            else {
                textComp.setText(content);
            }
            doc.docChanged = true;
            doc.updateTitle();
            cp = checkRange(cp,textComp);
            textComp.setCaretPosition(cp);
            if(selectionValid) {
                selectionStart = checkRange(selectionStart,textComp);
                selectionEnd = checkRange(selectionEnd+finalLen-origLen,textComp);
                if(caretAtBeginning) {
                    textComp.setCaretPosition(selectionEnd);
                    textComp.moveCaretPosition(selectionStart);
                }
                else {
                    textComp.setCaretPosition(selectionStart);
                    textComp.moveCaretPosition(selectionEnd);
                }
                
            }
            textComp.setFirstLine(firstLine);
            //System.out.println(selectionStart + "," + selectionEnd + "," + cp + "," + content);
            Caret car = textComp.getCaret();
            if(car != null) {
                car.setSelectionVisible(true);
            }
        }
    }
    
    public boolean textSelected() {
        return selectionStart != selectionEnd;
    }
    
    public int checkRange(int v, MySyntaxTextArea tc) {
        int top = tc.getLength();
        v = (v < 0)?0:v;
        v = (v > top)?top:v;
        return v;
    }
    
    
}
