// ***************************************************************************
// *   Copyright (C) 2018 by Paul Lutus                                      *
// *   lutusp@arachnoid.com                                                  *
// *                                                                         *
// *   This program is free software; you can redistribute it and/or modify  *
// *   it under the terms of the GNU General Public License as published by  *
// *   the Free Software Foundation; either version 2 of the License, or     *
// *   (at your option) any later version.                                   *
// *                                                                         *
// *   This program is distributed in the hope that it will be useful,       *
// *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
// *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
// *   GNU General Public License for more details.                          *
// *                                                                         *
// *   You should have received a copy of the GNU General Public License     *
// *   along with this program; if not, write to the                         *
// *   Free Software Foundation, Inc.,                                       *
// *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
// ***************************************************************************

package Arachnophilia;

/*
 * EscapeUnescapeStringHandler.java
 *
 * Created on February 6, 2002, 5:10 PM
 */
/**
 *
 * @author Administrator
 * @version
 */
final public class EscapeUnescapeStringHandler {

    static public String escapeString(String src) {
        //System.out.println(src);
        StringBuilder result = new StringBuilder();
        int len = src.length();
        for (int i = 0; i < len; i++) {
            char c = src.charAt(i);
            String r = "" + c;
            switch (c) {
                case '\b':
                    r = "\\b";
                    break;
                case '\f':
                    r = "\\f";
                    break;
                case '\n':
                    r = "\\n";
                    break;
                case '\r':
                    r = "\\r";
                    break;
                case '\t':
                    r = "\\t";
                    break;
                case '\"':
                    r = "\\\"";
                    break;
                case '\\': // escape the escape character also
                    r = "\\\\";
                    break;
            }
            result.append(r);
        }
        //System.out.println(result.toString());
        return result.toString();
    }

    static public String unescapeString(String src) {
        //System.out.println(src);
        boolean escChar = false;
        StringBuilder result = new StringBuilder();
        char c;
        String r;
        int len = src.length();
        for (int i = 0; i < len; i++) {
            r = "";
            c = src.charAt(i);
            if (!escChar) {
                if (c == '\\') {
                    escChar = true;
                }
            } else {
                escChar = false;
                switch (c) {
                    case 'b':
                        r = "\b";
                        break;
                    case 'f':
                        r = "\f";
                        break;
                    case 'n':
                        r = "\n";
                        break;
                    case 'r':
                        r = "\r";
                        break;
                    case 't':
                        r = "\t";
                        break;
                    case '\"':
                        r = "\"";
                        break;
                    case 'x': // hex notation
                    case 'u': // unicode notation
                        int v = 0;
                        int qc;
                        int dc;
                        do {
                            if (i < len - 1) {
                                qc = src.charAt(++i);
                                if (!isHexDigit((char) qc)) {
                                    c = (char) v;
                                    qc = 0;
                                    i--;
                                } else {
                                    dc = Character.toLowerCase((char) qc) - '0';
                                    if (dc > 9) {
                                        dc -= 39;
                                    }
                                    v = (v << 4) + dc;
                                }
                            } else {
                                c = (char) v;
                                qc = 0;
                            }
                        } while (isHexDigit((char) qc));
                        break;
                    case '\\': // user wants literal "\"
                        r = "\\";
                        break;
                } // switch
            }
            if (!escChar) {
                if (r.length() > 0) {
                    result.append(r);
                } else {
                    result.append(c);
                }
            }
        }
        //System.out.println(result.toString());
        return result.toString();
    }

    static private boolean isHexDigit(char c) {
        return (((c >= '0') && (c <= '9')) || ((c >= 'a') && (c <= 'f')) || ((c >= 'A') && (c <= 'F')));
    }

    // find first and last quotes in quoted line
    static public int findFirstQuote(int start, String s) {
        return s.indexOf("\"", start);
    }

    // scan across a string looking for the final, unescaped quote
    static public int findLastQuote(int start, String s) {
        int i = findFirstQuote(start, s);
        if (i < 0) {
            return i;
        }
        boolean inquote = true;
        boolean escChar = false;
        int len = s.length();
        do {
            i++;
            char c = s.charAt(i);
            if (!escChar) {
                if (c == '\\') {
                    escChar = true;
                }
                if (c == '\"') {
                    inquote = false;
                }
            } else {// prior escape character
                escChar = false;
            }
        } while (inquote && i < len);
        return i;
    }
}
