// ***************************************************************************
// *   Copyright (C) 2018 by Paul Lutus                                      *
// *   lutusp@arachnoid.com                                                  *
// *                                                                         *
// *   This program is free software; you can redistribute it and/or modify  *
// *   it under the terms of the GNU General Public License as published by  *
// *   the Free Software Foundation; either version 2 of the License, or     *
// *   (at your option) any later version.                                   *
// *                                                                         *
// *   This program is distributed in the hope that it will be useful,       *
// *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
// *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
// *   GNU General Public License for more details.                          *
// *                                                                         *
// *   You should have received a copy of the GNU General Public License     *
// *   along with this program; if not, write to the                         *
// *   Free Software Foundation, Inc.,                                       *
// *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
// ***************************************************************************

 package Arachnophilia;

/*
 * FileListHandler.java
 *
 * Created on December 18, 2001, 3:42 PM
 */
import java.awt.*;
import java.io.*;
import java.util.*;
import javax.swing.*;

/**
 *
 * @author  Administrator
 * @version
 */
final public class FileListHandler {

    HashMap<String,ArachDocument> fileList;
    JTabbedPane pane;
    Arachnophilia main;

    /** Creates new FileListHandler */
    public FileListHandler(JTabbedPane p, Arachnophilia m) {
        pane = p;
        main = m;
        fileList = new HashMap<String,ArachDocument>();
    }

    public ArachDocument[] docArray() {
        return fileList.values().toArray(new ArachDocument[]{});
    }

    public int openCount() {
        return fileList.size();
    }

    public boolean newDoc(String path, Arachnophilia m, int type, boolean isFile, boolean plainText) {
        ArachDocument d = new ArachDocument(path, m, type, isFile);
        if (!d.validCreation) {
            return false;
        } else {
            if (pane.indexOfTab(d.name) != -1) {
                ArachDocument dd = (ArachDocument) pane.getComponentAt(pane.indexOfTab(d.name));
                if (dd.file == null) {
                    JOptionPane.showMessageDialog(main, "You may not open more than one unsaved document of a given type at a time.\nPlease save and/or close the unsaved document named\n\"" + d.name + "\" and try again.", "Unsaved document \"" + d.name + "\" already exists", JOptionPane.WARNING_MESSAGE);
                    return false;
                }
            }
            pane.addTab(d.name, null, d, d.getFullPath());
            pane.setSelectedComponent(d);
            main.currentSelectedDocument = d;
            fileList.put(d.getFullPath(), d);
            return true;
        }
    }

    public ArachDocument findExisting(File f) {
        ArachDocument doc = null;
        if (fileList.containsKey(f.getPath())) {
            doc = (ArachDocument) fileList.get(f.getPath());
            if (doc != null) {
                int i = pane.indexOfComponent(doc);
                if (i == -1) {
                    doc = null;
                    fileList.remove(f.getPath());
                }
            }
        }
        return doc;
    }

    public void removeDoc(ArachDocument d) {
        int i = pane.indexOfComponent(d);
        if (i != -1) {
            pane.remove(i);
            main.updateStatusBar("");
        } else {
            //System.out.println("can't find " + d);
        }
        fileList.remove(d.getFullPath());
    }

    public void swapDocuments(File a, File b, ArachDocument d) {
        //System.out.println("a!");
        if (a == null || b == null || a.equals(b)) {
            return;
        }
        //System.out.println("b!");
        ArachDocument td = (ArachDocument) fileList.remove(a.getPath());
        fileList.put(b.getPath(), d);
        //updateDocTitle(d);
        removeDups(d);
    }

    public void updateDocTitle(ArachDocument d) {
        int i = pane.indexOfComponent(d);
        if (i != -1) {
            pane.setTitleAt(i, d.name + ((d.docChanged) ? " *" : ""));
            pane.setToolTipTextAt(i, d.getFullPath());
        }
    }

    private void removeDups(ArachDocument d) {
        int tabBase = (main.macroEditShowing) ? 1 : 0;
        for (int i = tabBase; i < pane.getTabCount(); i++) {
            ArachDocument t = (ArachDocument) pane.getComponentAt(i);
            if (t != d) { // if the objects are not the same
                //System.out.println(t.fullPath + "," + d.fullPath);
                if (t.equals(d)) {
                    //System.out.println(t.fullPath + " == " + d.fullPath);
                    pane.remove(t);
                    break;
                }
            }
        }
    }

    public void changeFontSizes() {
        int tabBase = (main.macroEditShowing) ? 1 : 0;
        for (int i = tabBase; i < pane.getTabCount(); i++) {
            ArachDocument t = (ArachDocument) pane.getComponentAt(i);
            t.setNewFont();
        }
    }

    public void setFocusToActive() {
        Component d = pane.getSelectedComponent();
        setFocusTo(d);
    }

    public void refreshCurrentDisplayedDocument() {
        Component d = pane.getSelectedComponent();
        if (d != null) {
            d.repaint();
        }
    }

    public void moveToNextDocument() {
        int i = pane.getSelectedIndex();
        if (i != -1) {
            i = (i + 1) % pane.getComponentCount();
            pane.setSelectedIndex(i);
        }
        setFocusToActive();
    }

    public void moveToPriorDocument() {
        int i = pane.getSelectedIndex();
        if (i != -1) {
            i += pane.getComponentCount();
            i = (i - 1) % pane.getComponentCount();
            pane.setSelectedIndex(i);
        }
        setFocusToActive();
    }

    public void setFocusTo(Component d) {
        if (d != null && pane.indexOfComponent(d) != -1) {
            pane.setSelectedComponent(d);
            d.requestFocusInWindow();
        }
    }

    public String genNewFileName(ArachDocument d) {
        String path = main.configValues.fileTypePaths[d.fileType];
        int i = 0;
        if (!d.isFile) {
            File f;
            do {
                String s = "Untitled" + (++i) + "." + main.fileTypes.fileTemplateSuffs[d.fileType];
                f = new File(path, s);
            } while (f.exists());
            return f.getName();
        } else {
            return d.name;
        }
    }

    public void setFileNameStrings(String path, ArachDocument d, boolean isFile) {
        d.isFile = isFile;
        if (isFile) {
            d.file = new File(path);
            d.setFullPath(d.file.getPath());
            d.setPath( ArachComp.pathFromFullPath(d.getFullPath()));
            d.name = ArachComp.nameFromFullPath(d.getFullPath());
        } else {
            d.name = "New " + main.fileTypes.fileTypeNames[d.fileType] + " Document";
            d.setFullPath(d.name);
        }
        updateDocTitle(d);
    }
}
