// ***************************************************************************
// *   Copyright (C) 2018 by Paul Lutus                                      *
// *   lutusp@arachnoid.com                                                  *
// *                                                                         *
// *   This program is free software; you can redistribute it and/or modify  *
// *   it under the terms of the GNU General Public License as published by  *
// *   the Free Software Foundation; either version 2 of the License, or     *
// *   (at your option) any later version.                                   *
// *                                                                         *
// *   This program is distributed in the hope that it will be useful,       *
// *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
// *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
// *   GNU General Public License for more details.                          *
// *                                                                         *
// *   You should have received a copy of the GNU General Public License     *
// *   along with this program; if not, write to the                         *
// *   Free Software Foundation, Inc.,                                       *
// *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
// ***************************************************************************

 package Arachnophilia;

/*
 * FloatingWindow.java
 *
 * Created on March 2, 2002, 10:10 AM
 */

import java.awt.*;
import java.awt.event.*;
import java.util.*;
import javax.swing.*;

/**
 *
 * @author  Administrator
 */

public abstract class FloatingWindow extends javax.swing.JFrame {
    
    static final int destroyDelayMillis = 4000;
    // there can only be one floating
    // window at a time
    static FloatingWindow window = null;
    javax.swing.Timer destroyTimer = null;
    /** Creates new form FloatingWindow */
    public FloatingWindow(ArrayList<String> v,Point p) {
        setup(v,p);
    }
    
    private void setup(ArrayList<String> v,Point p) {
        //super((Frame)null,true);
        // use the new undecorated JFrame
        // instead of JWindow
        setUndecorated(true);
        // allow only one instantiation
        // at a time
        if(window != null) {
            window.resetDestroyTimer();
            window.setVisible(false);
            window.dispose();
        }
        window = this;
        
        initComponents();
        // must add listeners to these
        // to see where the mouse is
        scrollPane.getVerticalScrollBar().addMouseListener(new java.awt.event.MouseAdapter() {
            @Override
            public void mouseExited(java.awt.event.MouseEvent evt) {
                dataListMouseExited(evt);
            }
            @Override
            public void mouseEntered(java.awt.event.MouseEvent evt) {
                dataListMouseEntered(evt);
            }
        });
        scrollPane.getHorizontalScrollBar().addMouseListener(new java.awt.event.MouseAdapter() {
            @Override
            public void mouseExited(java.awt.event.MouseEvent evt) {
                dataListMouseExited(evt);
            }
            @Override
            public void mouseEntered(java.awt.event.MouseEvent evt) {
                dataListMouseEntered(evt);
            }
        });
        dataList.setModel(new DefaultComboBoxModel<String>(v.toArray(new String[]{})));
        pack();
        Dimension ss = Toolkit.getDefaultToolkit().getScreenSize();
       
        Dimension bs = getSize();
        int n = p.x + bs.width;
        if(n > ss.width) {
            p.x -= n -ss.width;
        }
        n = p.y + bs.height;
        if(n > ss.height) {
            p.y -= n - ss.height;
        }
         setLocation(p);
        showWindow();
    }
    
    public void showWindow() {
        setDestroyTimer();
        setVisible(true);
        requestFocusInWindow();
        //toFront();
        
    }
    
    // destroy after 2 seconds
    // unless mouse re-enters window
    
    private void setDestroyTimer() {
        if(destroyTimer == null) {
            destroyTimer = new javax.swing.Timer(destroyDelayMillis,
            new ActionListener(){
                @Override
                public void actionPerformed(ActionEvent e) {
                    if(window != null) {
                        window.setVisible(false);
                        //window.dispose();
                    }
                    resetDestroyTimer();
                }
            }
            );
            destroyTimer.start();
        }
    }
    
    private void resetDestroyTimer() {
        if(destroyTimer != null) {
            destroyTimer.stop();
            destroyTimer = null;
        }
    }
    
    private void doValueChanged() {
        String s = (String)dataList.getSelectedValue();
        
        if(window != null) {
             window.resetDestroyTimer();
            window.setVisible(false);
            window.dispose();
        }  
        processChange(s);
    }
    
    abstract void processChange(String s);
    abstract void cleanup();
    
    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        scrollPane = new javax.swing.JScrollPane();
        dataList = new JList<String>();

        addKeyListener(new java.awt.event.KeyAdapter() {
            public void keyPressed(java.awt.event.KeyEvent evt) {
                formKeyPressed(evt);
            }
        });
        addWindowListener(new java.awt.event.WindowAdapter() {
            public void windowClosing(java.awt.event.WindowEvent evt) {
                exitForm(evt);
            }
        });
        addWindowFocusListener(new java.awt.event.WindowFocusListener() {
            public void windowGainedFocus(java.awt.event.WindowEvent evt) {
            }
            public void windowLostFocus(java.awt.event.WindowEvent evt) {
                formWindowLostFocus(evt);
            }
        });

        dataList.setBackground(new java.awt.Color(255, 255, 216));
        dataList.addMouseListener(new java.awt.event.MouseAdapter() {
            public void mousePressed(java.awt.event.MouseEvent evt) {
                dataListMousePressed(evt);
            }
            public void mouseReleased(java.awt.event.MouseEvent evt) {
                dataListMouseReleased(evt);
            }
            public void mouseClicked(java.awt.event.MouseEvent evt) {
                dataListMouseClicked(evt);
            }
            public void mouseExited(java.awt.event.MouseEvent evt) {
                dataListMouseExited(evt);
            }
            public void mouseEntered(java.awt.event.MouseEvent evt) {
                dataListMouseEntered(evt);
            }
        });
        dataList.addMouseMotionListener(new java.awt.event.MouseMotionAdapter() {
            public void mouseDragged(java.awt.event.MouseEvent evt) {
                dataListMouseDragged(evt);
            }
        });
        scrollPane.setViewportView(dataList);

        getContentPane().add(scrollPane, java.awt.BorderLayout.CENTER);

        pack();
    }// </editor-fold>//GEN-END:initComponents

    private void dataListMouseReleased(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_dataListMouseReleased
        // Add your handling code here:
        //System.out.println("list release");
        //evt.consume();
    }//GEN-LAST:event_dataListMouseReleased

    private void dataListMousePressed(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_dataListMousePressed
        // Add your handling code here:
        //System.out.println("list press");
        //evt.consume();
    }//GEN-LAST:event_dataListMousePressed

    private void dataListMouseDragged(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_dataListMouseDragged
        // Add your handling code here:
        //System.out.println("list drag");
        //evt.consume();
    }//GEN-LAST:event_dataListMouseDragged

    private void dataListMouseClicked(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_dataListMouseClicked
        // Add your handling code here:
        //System.out.println("list click");
        evt.consume();
        doValueChanged();
    }//GEN-LAST:event_dataListMouseClicked

    private void dataListItemStateChanged(java.awt.event.ItemEvent evt) {//GEN-FIRST:event_dataListItemStateChanged
        // Add your handling code here:
        //System.out.println("item state changed");
        //doValueChanged();
    }//GEN-LAST:event_dataListItemStateChanged

    private void formKeyPressed(java.awt.event.KeyEvent evt) {//GEN-FIRST:event_formKeyPressed
        // Add your handling code here:
        //String s = evt.getKey_Text(evt.getKeyCode());
        int kcode = evt.getKeyCode();
        if(kcode == KeyEvent.VK_ESCAPE) {
            quit();
        }
    }//GEN-LAST:event_formKeyPressed
    
    private void formWindowLostFocus(java.awt.event.WindowEvent evt) {//GEN-FIRST:event_formWindowLostFocus
        // Add your handling code here:
        //System.out.println("window lost focus");
        quit();
    }//GEN-LAST:event_formWindowLostFocus
    
    private void dataListMouseExited(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_dataListMouseExited
        // Add your handling code here:
        //System.out.println("mouse exited");
        setDestroyTimer();
    }//GEN-LAST:event_dataListMouseExited
    
    private void dataListMouseEntered(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_dataListMouseEntered
        // Add your handling code here:
        //System.out.println("mouse entered");
        resetDestroyTimer();
    }//GEN-LAST:event_dataListMouseEntered
        
    /** Exit the Application */
    private void exitForm(java.awt.event.WindowEvent evt) {//GEN-FIRST:event_exitForm
        quit();
    }//GEN-LAST:event_exitForm
    
    private void quit() {
        if(window != null) {
            window.resetDestroyTimer();
            window.setVisible(false);
            window.dispose();
        }
        cleanup();
    }
    /**
     * @param args the command line arguments
     *//*
    public static void main(String args[]) {
        new FloatingWindow().show();
    }*/
    
    
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JList<String> dataList;
    private javax.swing.JScrollPane scrollPane;
    // End of variables declaration//GEN-END:variables
    
}
