/// ***************************************************************************
// *   Copyright (C) 2018 by Paul Lutus                                      *
// *   lutusp@arachnoid.com                                                  *
// *                                                                         *
// *   This program is free software; you can redistribute it and/or modify  *
// *   it under the terms of the GNU General Public License as published by  *
// *   the Free Software Foundation; either version 2 of the License, or     *
// *   (at your option) any later version.                                   *
// *                                                                         *
// *   This program is distributed in the hope that it will be useful,       *
// *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
// *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
// *   GNU General Public License for more details.                          *
// *                                                                         *
// *   You should have received a copy of the GNU General Public License     *
// *   along with this program; if not, write to the                         *
// *   Free Software Foundation, Inc.,                                       *
// *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
// ***************************************************************************

 package Arachnophilia;

/*
 * IconSelector.java
 *
 * Created on February 13, 2002, 7:01 PM
 */
import java.awt.*;
import java.io.*;
import java.lang.reflect.Array;
import java.security.*;
import java.util.*;
import java.util.zip.*;
import javax.swing.*;

/**
 *
 * @author  Administrator
 */
public final class IconSelector extends javax.swing.JDialog {

    Arachnophilia main;
    public String choice = "";

    /** Creates new form IconSelector */
    public IconSelector(String icon, Arachnophilia m, boolean modal) {
        super(m, modal);
        main = m;
        choice = icon;
        initComponents();
        instructions.setText("Note: this option applies most significantly to toolbar buttons.");
        instructions.setBackground(getContentPane().getBackground());
        loadIcons();
        setTitle(ArachConstants.APPNAME + " Icon Selector");
        Rectangle r = main.getBounds();
        int w = r.width / 6;
        int h = r.height / 6;
        setBounds(r.x + w, r.y + h, r.width - w * 2, r.height - h * 2);
        setVisible(true);
    }
    
    public <T> Enumeration arrayToEnumeration(final T a) {
    return (new Enumeration() {
        int size = Array.getLength(a);

        int cursor;

        @Override
        public boolean hasMoreElements() {
          return (cursor < size);
        }

        @Override
        public Object nextElement() {
          return Array.get(a, cursor++);
        }
      });
    }

    private void loadIcons() {
        //ArrayList<String> v = new ArrayList<String>();
        try {
            CodeSource src = getClass().getProtectionDomain().getCodeSource();
            File f = new File(src.getLocation().toURI().getPath());
            ZipFile zip = new ZipFile(f);
            Enumeration dir = zip.entries();
            centerPanel.setLayout(new GridLayout(16, 32));
            while(dir.hasMoreElements()) {
                ZipEntry zi = (ZipEntry) dir.nextElement();
                String fn = zi.toString();
                if (fn.indexOf("Icons/") == 0 && fn.indexOf(".gif") != -1) {
                    ImageIcon ic = new ImageIcon(getClass().getResource("/" + fn));
                    //v.add(ic);
                    MyJButton b = new MyJButton(ic);
                    b.setToolTipText(fn);
                    centerPanel.add(b);
                    b.addActionListener(new java.awt.event.ActionListener() {
                        @Override
                        public void actionPerformed(java.awt.event.ActionEvent evt) {
                            handleIconChoice(evt);
                        }
                    });
                }
            }
        } catch (Exception e) {
            e.printStackTrace(System.out);
        }
    }

    public void handleIconChoice(java.awt.event.ActionEvent evt) {
        choice = ((JButton) evt.getSource()).getToolTipText();
        //System.out.println("choice: " + choice);
        doCancel();
    }

    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    private void initComponents() {//GEN-BEGIN:initComponents
        bottomPanal = new javax.swing.JPanel();
        jLabel1 = new javax.swing.JLabel();
        jButton2 = new MyJButton();
        jLabel2 = new javax.swing.JLabel();
        cancelButton = new MyJButton();
        jScrollPane1 = new javax.swing.JScrollPane();
        centerPanel = new javax.swing.JPanel();
        jPanel3 = new javax.swing.JPanel();
        instructions = new javax.swing.JTextArea();

        addWindowListener(new java.awt.event.WindowAdapter() {
            public void windowClosing(java.awt.event.WindowEvent evt) {
                closeDialog(evt);
            }
        });

        jLabel1.setText("Click an icon above, or choose");
        bottomPanal.add(jLabel1);

        jButton2.setText("No Icon");
        jButton2.setToolTipText("Choose no icon");
        jButton2.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButton2ActionPerformed(evt);
            }
        });

        bottomPanal.add(jButton2);

        jLabel2.setText("or");
        bottomPanal.add(jLabel2);

        cancelButton.setText("Cancel");
        cancelButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                cancelButtonActionPerformed(evt);
            }
        });

        bottomPanal.add(cancelButton);

        getContentPane().add(bottomPanal, java.awt.BorderLayout.SOUTH);

        jScrollPane1.setViewportView(centerPanel);

        getContentPane().add(jScrollPane1, java.awt.BorderLayout.CENTER);

        jPanel3.setLayout(new java.awt.BorderLayout());

        instructions.setBackground(new java.awt.Color(204, 204, 204));
        instructions.setEditable(false);
        instructions.setLineWrap(true);
        instructions.setWrapStyleWord(true);
        jPanel3.add(instructions, java.awt.BorderLayout.CENTER);

        getContentPane().add(jPanel3, java.awt.BorderLayout.NORTH);

        pack();
    }//GEN-END:initComponents

    private void jButton2ActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButton2ActionPerformed
        // Add your handling code here:
        doNoIcon();
    }//GEN-LAST:event_jButton2ActionPerformed

    private void cancelButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_cancelButtonActionPerformed
        // Add your handling code here:
        doCancel();
    }//GEN-LAST:event_cancelButtonActionPerformed

    private void doNoIcon() {
        choice = "";
        doCancel();
    }

    private void doCancel() {
        setVisible(false);
        dispose();
    }

    /** Closes the dialog */
    private void closeDialog(java.awt.event.WindowEvent evt) {//GEN-FIRST:event_closeDialog
        setVisible(false);
        dispose();
    }//GEN-LAST:event_closeDialog
    /**
     * @param args the command line arguments
     *//*
    public static void main(String args[]) {
    new IconSelector(new javax.swing.JFrame(), true).show();
    }*/

    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JPanel jPanel3;
    private javax.swing.JButton jButton2;
    private javax.swing.JScrollPane jScrollPane1;
    private javax.swing.JPanel centerPanel;
    private javax.swing.JTextArea instructions;
    private javax.swing.JPanel bottomPanal;
    private javax.swing.JButton cancelButton;
    private javax.swing.JLabel jLabel2;
    private javax.swing.JLabel jLabel1;
    // End of variables declaration//GEN-END:variables
}
