// ***************************************************************************
// *   Copyright (C) 2018 by Paul Lutus                                      *
// *   lutusp@arachnoid.com                                                  *
// *                                                                         *
// *   This program is free software; you can redistribute it and/or modify  *
// *   it under the terms of the GNU General Public License as published by  *
// *   the Free Software Foundation; either version 2 of the License, or     *
// *   (at your option) any later version.                                   *
// *                                                                         *
// *   This program is distributed in the hope that it will be useful,       *
// *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
// *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
// *   GNU General Public License for more details.                          *
// *                                                                         *
// *   You should have received a copy of the GNU General Public License     *
// *   along with this program; if not, write to the                         *
// *   Free Software Foundation, Inc.,                                       *
// *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
// ***************************************************************************

 package Arachnophilia;

/*
 * RegExpWarning.java
 *
 * Created on February 22, 2002, 9:08 PM
 */

import java.awt.*;

/**
 *
 * @author  Administrator
 */
public final class InfoDialog extends javax.swing.JDialog {

    public boolean dontShowAgain = false;
    /** Creates new form RegExpWarning */
    public InfoDialog(java.awt.Frame parent, boolean modal,String title,String content) {
        super(parent, modal);
        setTitle(title);
        initComponents();
        
        textArea.setText(content);
        textArea.setBackground(getContentPane().getBackground());
        pack();
        Rectangle r = parent.getBounds();
        int w = r.width/8;
        int h = r.height/8;
        setLocation(r.x+w,r.y+h);
        setVisible(true);
    
    }

    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    private void initComponents() {//GEN-BEGIN:initComponents
        jPanel1 = new javax.swing.JPanel();
        noShowCheckBox = new javax.swing.JCheckBox();
        okButton = new javax.swing.JButton();
        jScrollPane1 = new javax.swing.JScrollPane();
        textArea = new javax.swing.JTextArea();

        addWindowListener(new java.awt.event.WindowAdapter() {
            public void windowClosing(java.awt.event.WindowEvent evt) {
                closeDialog(evt);
            }
        });

        noShowCheckBox.setText("Don't show this again");
        jPanel1.add(noShowCheckBox);

        okButton.setText("OK");
        okButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                okButtonActionPerformed(evt);
            }
        });

        jPanel1.add(okButton);

        getContentPane().add(jPanel1, java.awt.BorderLayout.SOUTH);

        textArea.setBackground(new java.awt.Color(204, 204, 204));
        textArea.setColumns(60);
        textArea.setEditable(false);
        textArea.setLineWrap(true);
        textArea.setWrapStyleWord(true);
        textArea.setMargin(new java.awt.Insets(4, 4, 4, 4));
        jScrollPane1.setViewportView(textArea);

        getContentPane().add(jScrollPane1, java.awt.BorderLayout.CENTER);

        pack();
    }//GEN-END:initComponents

    private void okButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_okButtonActionPerformed
        // Add your handling code here:
        close();
    }//GEN-LAST:event_okButtonActionPerformed

    private void close()
    {
        dontShowAgain = noShowCheckBox.getSelectedObjects() != null;
        setVisible(false);
        dispose();
    }
    /** Closes the dialog */
    private void closeDialog(java.awt.event.WindowEvent evt) {//GEN-FIRST:event_closeDialog
        setVisible(false);
        dispose();
    }//GEN-LAST:event_closeDialog

    /**
    * @param args the command line arguments
    */
    public static void main(String args[]) {
        InfoDialog infoDialog = new InfoDialog(new javax.swing.JFrame(), true,"Title","Content");
        System.exit(0);
    }


    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JPanel jPanel1;
    private javax.swing.JScrollPane jScrollPane1;
    private javax.swing.JCheckBox noShowCheckBox;
    private javax.swing.JButton okButton;
    private javax.swing.JTextArea textArea;
    // End of variables declaration//GEN-END:variables

}
