// ***************************************************************************
// *   Copyright (C) 2018 by Paul Lutus                                      *
// *   lutusp@arachnoid.com                                                  *
// *                                                                         *
// *   This program is free software; you can redistribute it and/or modify  *
// *   it under the terms of the GNU General Public License as published by  *
// *   the Free Software Foundation; either version 2 of the License, or     *
// *   (at your option) any later version.                                   *
// *                                                                         *
// *   This program is distributed in the hope that it will be useful,       *
// *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
// *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
// *   GNU General Public License for more details.                          *
// *                                                                         *
// *   You should have received a copy of the GNU General Public License     *
// *   along with this program; if not, write to the                         *
// *   Free Software Foundation, Inc.,                                       *
// *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
// ***************************************************************************

package Arachnophilia;

/*
 * InitFileHandler.java
 *
 * Created on October 19, 2001, 6:42 PM
 */
import java.awt.*;
import java.io.*;
import java.lang.reflect.*;
import java.util.*;

/**
 *
 * @author Administrator
 * @version
 */
public final class InitFileHandler extends Object {

    String path;
    Arachnophilia main;

    /**
     * Creates new InitFileHandler
     */
    public InitFileHandler(String p, Arachnophilia m) {
        path = p;
        main = m;
    }

    public Object readSymbolicObject(ConfigValues v, String name) {
        Object o = new Object(); // default
        try {
            Class cv = v.getClass();
            Field a = cv.getField(name);
            //System.out.println("readSymbolicObject: " + name);
            o = a.get(v);
        } catch (Exception e) {
            e.printStackTrace(System.out);

        }
        return o;
    }

    public Color readSymbolicColor(ConfigValues v, String name) {
        Color color = Color.black;
        Object o = readSymbolicObject(v, name);
        return (o != null) ? (Color) o : color;
    }

    public boolean readSymbolicBoolean(ConfigValues v, String name) {
        boolean b = false;
        Object o = readSymbolicObject(v, name);
        return (o != null) ? (boolean) ((Boolean) o).booleanValue() : b;
    }

    public double readSymbolicDouble(ConfigValues v, String name) {
        double d = 0.0;
        Object o = readSymbolicObject(v, name);
        return (o != null) ? (double) ((Double) o).doubleValue() : d;
    }

    public int readSymbolicInt(ConfigValues v, String name) {
        int d = 0;
        Object o = readSymbolicObject(v, name);
        return (o != null) ? (int) ((Integer) o).intValue() : d;
    }

    public long readSymbolicLong(ConfigValues v, String name) {
        long d = 0;
        Object o = readSymbolicObject(v, name);
        return (o != null) ? (long) ((Long) o).longValue() : d;
    }

    public void write(ConfigValues v) {
        try {
            BufferedWriter bw = new BufferedWriter(
                    new OutputStreamWriter(
                    new FileOutputStream(path), "UTF8"));
            Class cv = v.getClass();
            Field[] a = cv.getFields();

            for (int i = 0; i < a.length; i++) {
                String name = a[i].getName();
                String type = a[i].getType().getName();
                int p;
                if ((p = type.indexOf("[")) != 0) {
                    writeValue(v, a[i], name, bw);
                } else {
                    if (a[i].get(v) instanceof int[]) {
                        int[] array = (int[]) a[i].get(v);
                        for (int j = 0; j < array.length; j++) {
                            bw.write(name + "[" + j + "]=" + array[j] + ArachConstants.SYSTEM_EOL);
                        }
                    } else if (a[i].get(v) instanceof long[]) {
                        long[] array = (long[]) a[i].get(v);
                        for (int j = 0; j < array.length; j++) {
                            bw.write(name + "[" + j + "]=" + array[j] + ArachConstants.SYSTEM_EOL);
                        }
                    } else if (a[i].get(v) instanceof double[]) {
                        double[] array = (double[]) a[i].get(v);
                        for (int j = 0; j < array.length; j++) {
                            bw.write(name + "[" + j + "]=" + array[j] + ArachConstants.SYSTEM_EOL);
                        }
                    } else {
                        Object[] array = (Object[]) a[i].get(v);
                        for (int j = 0; j < array.length; j++) {
                            bw.write(name + "[" + j + "]=" + array[j].toString() + ArachConstants.SYSTEM_EOL);
                        }
                    }
                }
            }
            bw.close();
        } catch (Exception e) {
            System.out.println(e.toString());
        }
    }

    private void writeValue(ConfigValues v, Field a, String name, BufferedWriter bw) {
        try {
            bw.write(name + "=" + a.get(v).toString() + ArachConstants.SYSTEM_EOL);
        } catch (Exception e) {
            e.printStackTrace(System.out);
        }
    }

    public void read(ConfigValues v) {
        try {
            BufferedReader br = new BufferedReader(
                    new InputStreamReader(
                    new FileInputStream(path), "UTF8"));
            Class cv = v.getClass();
            String name, value;
            String type;
            String line;
            while ((line = br.readLine()) != null) {
                readValue(line, v);
            }
            br.close();
        } catch (Exception e) {
            System.out.println(e.toString());
        }
    }

    private void readValue(String line, ConfigValues v) {
        int p = line.indexOf("=");
        if (p != -1) {
            try {
                String name = line.substring(0, p);
                String value = line.substring(p + 1);
                Class cv = v.getClass();

                int q = name.indexOf("[");
                if (q != -1) {

                    Field a = cv.getField(name.substring(0, q));
                    String type = a.getType().getName();
                    //System.out.println(name + "," + type);
                    int r = name.indexOf("]");
                    if (r != -1) {
                        String sn = name.substring(q + 1, r);
                        int i = Integer.parseInt(sn);
                        Object[] array = (Object[]) a.get(v);
                        if (i < array.length) {
                            if (type.indexOf("java.lang.String") != -1) {
                                array[i] = value;
                                //System.out.println("read: " + name + " = " + value + " = [" + type + "]");
                            } else if (type.indexOf("int") != -1) {
                                int[] ar;
                                ar = (int[]) a.get(v);
                                ar[i] = Integer.parseInt(value);
                            } else if (type.indexOf("long") != -1) {
                                long[] ar;
                                ar = (long[]) a.get(v);
                                ar[i] = Long.parseLong(value);
                            } else if (type.indexOf("double") != -1) {
                                double[] ar;
                                ar = (double[]) a.get(v);
                                ar[i] = Double.parseDouble(value);
                            }
                        }
                    }
                } else {

                    Field a = cv.getField(name);
                    String type = a.getType().getName();
                    if (type.equals("int")) {
                        a.setInt(v, Integer.parseInt(value));
                    } else if (type.equals("long")) {
                        a.setLong(v, Long.parseLong(value));
                    } else if (type.equals("double")) {
                        a.setDouble(v, Double.parseDouble(value));
                    } else if (type.equals("boolean")) {
                        a.setBoolean(v, value.equals("true"));
                    } else if (type.equals("java.lang.String")) {
                        a.set(v, value);
                    } else {
                        setObject(a, v, value);
                    }
                }
            } catch (Exception e) {
                e.printStackTrace(System.out);
            }
        }
    }

    private void setObject(Field a, ConfigValues v, String value) {
        //System.out.println("setobject: " + value);
        int p = value.indexOf("[");
        if (p >= 0) {
            String className = value.substring(0, p);
            String vals = value.substring(p + 1);
            try {
                Object o = a.get(v);
                int q = vals.indexOf("]");
                if (q >= 0) {
                    vals = vals.substring(0, q);
                    ArrayList<String> v1 = ArachComp.parseDelimLine(vals, ",");
                    Iterator<String> i = v1.iterator();
                    int r = 0, g = 0, b = 0;
                    while (i.hasNext()) {
                        String s = i.next();
                        ArrayList<String> v2 = ArachComp.parseDelimLine(s, "=");
                        if (v2.size() >= 2) {
                            String field = v2.get(0);
                            String val = v2.get(1);
                            //System.out.println(field + " = " + val);
                            if (o instanceof Color) {
                                int col = Integer.parseInt(val);
                                switch (field.charAt(0)) {
                                    case 'r':
                                        r = col;
                                        break;
                                    case 'g':
                                        g = col;
                                        break;
                                    case 'b':
                                        b = col;
                                        break;
                                }
                            } else {
                                Field f = o.getClass().getField(field);
                                try {
                                    f.setInt(o, Integer.parseInt(val));
                                } catch (Exception e) {
                                    f.setBoolean(o, val.equals("true"));
                                }
                            }
                        }
                    }
                    if (o instanceof Color) {
                        a.set(v, new Color(r, g, b));
                    }
                }
            } catch (Exception e) {
                //System.out.println("setObject error on " + a.getName() + " = " + value);
                e.printStackTrace(System.out);
            }
        }
    }
}
